/*
 * Decompiled with CFR 0.152.
 */
package packracer;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.TooManyListenersException;
import javafx.application.Platform;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;

public class Communicator
implements SerialPortEventListener {
    TextArea window = null;
    private TextField laneOnePlace;
    private TextField laneTwoPlace;
    private TextField laneThreePlace;
    private TextField laneFourPlace;
    private TextField racerOneTime;
    private TextField racerTwoTime;
    private TextField racerThreeTime;
    private TextField racerFourTime;
    private Button btnConnectToTimer;
    private Button btnAcceptTimes;
    private Button btnClearTimes;
    private ComboBox cboxPorts;
    private Enumeration ports = null;
    private HashMap portMap = new HashMap();
    private CommPortIdentifier selectedPortIdentifier = null;
    private SerialPort serialPort = null;
    private InputStream input = null;
    private OutputStream output = null;
    private boolean bConnected = false;
    static final int TIMEOUT = 2000;
    static final int SPACE_ASCII = 32;
    static final int DASH_ASCII = 45;
    static final int NEW_LINE_ASCII = 10;
    String logText = "";
    String test1 = "";
    int lanes = 4;
    int heat = 5;
    int count;
    int heat_count = 1;
    int[] intarray = new int[this.lanes];
    Double[] timearray = new Double[this.lanes];

    public Communicator(TextArea window, TextField laneOnePlace, TextField laneTwoPlace, TextField laneThreePlace, TextField laneFourPlace, TextField laneOneTime, TextField laneTwoTime, TextField laneThreeTime, TextField laneFourTime, Button btnConnectToTimer, Button btnAcceptTimes, Button btnClearTimes, ComboBox cboxPorts) {
        this.window = window;
        this.laneOnePlace = laneOnePlace;
        this.laneTwoPlace = laneTwoPlace;
        this.laneThreePlace = laneThreePlace;
        this.laneFourPlace = laneFourPlace;
        this.racerOneTime = laneOneTime;
        this.racerTwoTime = laneTwoTime;
        this.racerThreeTime = laneThreeTime;
        this.racerFourTime = laneFourTime;
        this.btnConnectToTimer = btnConnectToTimer;
        this.btnAcceptTimes = btnAcceptTimes;
        this.btnClearTimes = btnClearTimes;
        this.cboxPorts = cboxPorts;
    }

    public void searchForPorts() {
        this.ports = CommPortIdentifier.getPortIdentifiers();
        while (this.ports.hasMoreElements()) {
            CommPortIdentifier curPort = (CommPortIdentifier)this.ports.nextElement();
            if (curPort.getPortType() != 1) continue;
            this.cboxPorts.getItems().add((Object)curPort.getName());
            this.portMap.put(curPort.getName(), curPort);
        }
    }

    public void connect() {
        String selectedPort = this.cboxPorts.getValue().toString();
        this.selectedPortIdentifier = (CommPortIdentifier)this.portMap.get(selectedPort);
        CommPort commPort = null;
        try {
            commPort = this.selectedPortIdentifier.open("packracer", 2000);
            this.serialPort = (SerialPort)commPort;
            this.serialPort.setSerialPortParams(1200, 7, 2, 0);
            this.setConnected(true);
            this.logText = selectedPort + " opened successfully.";
            this.window.appendText(this.logText + "\n");
            this.btnConnectToTimer.setDisable(true);
        }
        catch (PortInUseException e) {
            this.logText = selectedPort + " is in use. (" + e.toString() + ")";
            this.window.appendText(this.logText + "\n");
        }
        catch (Exception e) {
            this.logText = "Failed to open " + selectedPort + "(" + e.toString() + ")";
            this.window.appendText(this.logText + "\n");
        }
    }

    public boolean initIOStream() {
        boolean successful = false;
        try {
            this.input = this.serialPort.getInputStream();
            this.output = this.serialPort.getOutputStream();
            this.writeData(0, 0);
            successful = true;
            return successful;
        }
        catch (IOException e) {
            this.logText = "I/O Streams failed to open. (" + e.toString() + ")";
            this.window.appendText(this.logText + "\n");
            return successful;
        }
    }

    public void initListener() {
        try {
            this.serialPort.addEventListener((SerialPortEventListener)this);
            this.serialPort.notifyOnDataAvailable(true);
        }
        catch (TooManyListenersException e) {
            this.logText = "Too many listeners. (" + e.toString() + ")";
            this.window.appendText(this.logText + "\n");
        }
    }

    public void disconnect() {
        try {
            this.writeData(0, 0);
            this.serialPort.removeEventListener();
            this.serialPort.close();
            this.input.close();
            this.output.close();
            this.setConnected(false);
            this.logText = "Disconnected.";
            this.window.appendText(this.logText + "\n");
        }
        catch (Exception e) {
            this.logText = "Failed to close " + this.serialPort.getName() + "(" + e.toString() + ")";
            this.window.appendText(this.logText + "\n");
        }
    }

    public final boolean getConnected() {
        return this.bConnected;
    }

    public void setConnected(boolean bConnected) {
        this.bConnected = bConnected;
    }

    public void serialEvent(SerialPortEvent evt) {
        if (evt.getEventType() == 1) {
            try {
                byte singleData = (byte)this.input.read();
                if (singleData != 10) {
                    this.logText = new String(new byte[]{singleData});
                    this.test1 = this.test1.concat(this.logText);
                } else {
                    System.out.println("Heat# " + this.heat_count);
                    Platform.runLater(() -> this.window.appendText(this.test1 + "\n"));
                    System.out.println(this.test1);
                    if (Character.isDigit(this.test1.charAt(0))) {
                        this.count = 0;
                        while (this.count < this.lanes) {
                            this.intarray[this.count] = 0;
                            this.intarray[this.count] = Character.getNumericValue(this.test1.charAt(this.count * 10));
                            this.timearray[this.count] = 0.0;
                            this.timearray[this.count] = Double.parseDouble(this.test1.substring(this.count * 10 + 2, this.count * 10 + 2 + 6));
                            System.out.println("Place-" + (this.count + 1) + " Lane-" + this.intarray[this.count] + " Time-" + this.timearray[this.count]);
                            if (this.intarray[this.count] == 1) {
                                int place1 = this.count + 1;
                                Double time1 = this.timearray[this.count];
                                Platform.runLater(() -> this.laneOnePlace.setText(Integer.toString(place1)));
                                Platform.runLater(() -> this.racerOneTime.setText(Double.toString(time1)));
                            }
                            if (this.intarray[this.count] == 2) {
                                int place2 = this.count + 1;
                                Double time2 = this.timearray[this.count];
                                Platform.runLater(() -> this.laneTwoPlace.setText(Integer.toString(place2)));
                                Platform.runLater(() -> this.racerTwoTime.setText(Double.toString(time2)));
                            }
                            if (this.intarray[this.count] == 3) {
                                int place3 = this.count + 1;
                                Double time3 = this.timearray[this.count];
                                Platform.runLater(() -> this.laneThreePlace.setText(Integer.toString(place3)));
                                Platform.runLater(() -> this.racerThreeTime.setText(Double.toString(time3)));
                            }
                            if (this.intarray[this.count] == 4) {
                                int place4 = this.count + 1;
                                Double time4 = this.timearray[this.count];
                                Platform.runLater(() -> this.laneFourPlace.setText(Integer.toString(place4)));
                                Platform.runLater(() -> this.racerFourTime.setText(Double.toString(time4)));
                            }
                            ++this.count;
                        }
                        this.btnAcceptTimes.setDisable(false);
                        this.btnClearTimes.setDisable(false);
                        ++this.heat_count;
                    }
                    this.test1 = "";
                }
            }
            catch (Exception e) {
                this.logText = "Failed to read data. (" + e.toString() + ")";
                Platform.runLater(() -> this.window.appendText(this.logText + "\n"));
            }
        }
    }

    public void writeData(int leftThrottle, int rightThrottle) {
        try {
            this.output.write(leftThrottle);
            this.output.flush();
            this.output.write(45);
            this.output.flush();
            this.output.write(rightThrottle);
            this.output.flush();
            this.output.write(32);
            this.output.flush();
        }
        catch (Exception e) {
            this.logText = "Failed to write data. (" + e.toString() + ")";
            this.window.appendText(this.logText + "\n");
        }
    }
}

