/*
 * Decompiled with CFR 0.152.
 */
package packracer;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Tab;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.util.Callback;
import packracer.Communicator;
import packracer.PackRacer;
import packracer.addDialog;
import packracer.carNameDialog;
import packracer.eventNameDialog;
import packracer.heatSheet;
import packracer.results;
import ro.nextreports.engine.Report;
import ro.nextreports.engine.ReportRunner;
import ro.nextreports.engine.util.ReportUtil;

public class FXMLDocumentController
implements Initializable {
    Communicator communicator = null;
    private ObservableList<ObservableList> data;
    @FXML
    private TableView tblEvents;
    private ObservableList<ObservableList> datatblEvents;
    public String selectedEvent = "";
    @FXML
    private Label racerOne;
    @FXML
    private Label racerTwo;
    @FXML
    private Label racerThree;
    @FXML
    private Label racerFour;
    @FXML
    private Label currHeat;
    @FXML
    private ComboBox eventType;
    @FXML
    private RadioButton yesGroupings;
    @FXML
    private ToggleGroup groupings;
    @FXML
    private RadioButton noGroupings;
    @FXML
    private TextField numberOfLanes;
    @FXML
    private ComboBox timerSettings;
    @FXML
    private Button createEvent;
    @FXML
    private TextField eventName1;
    @FXML
    private TextArea eventArea;
    @FXML
    private TextArea carEventArea;
    @FXML
    private Tab tabAddRacer;
    @FXML
    private Tab tabHeatSheet;
    @FXML
    private TextField deleteEventName;
    @FXML
    private TextArea heatSheet;
    @FXML
    private Button deleteEventButton;
    @FXML
    private ComboBox searchEvent;
    @FXML
    private TextArea txtCode;
    @FXML
    private TextField editOriginalName;
    @FXML
    private ComboBox editEventType;
    @FXML
    private TextField editLanes;
    @FXML
    private ComboBox editTimerSettings;
    @FXML
    private Button updateEvent;
    @FXML
    private TextField editEventName;
    @FXML
    private RadioButton editYesGroup;
    @FXML
    private ToggleGroup editGroup;
    @FXML
    private ComboBox showCarBox;
    @FXML
    private Button showCarButton;
    @FXML
    private RadioButton editNoGroup;
    @FXML
    private TableView tblRacers;
    private ObservableList<ObservableList> datatblRacers;
    public String selectedRacer = "";
    @FXML
    private TextField newRacerName;
    @FXML
    private TextField newCarID;
    @FXML
    private ComboBox newGroupID;
    @FXML
    private Tab tabTimed;
    @FXML
    private TableView tblTimed;
    private ObservableList<ObservableList> datatblTimed;
    @FXML
    private ComboBox cboxPorts;
    @FXML
    private TextField laneOnePlace;
    @FXML
    private TextField laneTwoPlace;
    @FXML
    private TextField laneThreePlace;
    @FXML
    private TextField laneFourPlace;
    @FXML
    private TextField racerOneTime;
    @FXML
    private TextField racerTwoTime;
    @FXML
    private TextField racerThreeTime;
    @FXML
    private TextField racerFourTime;
    @FXML
    public Button btnConnectToTimer;
    @FXML
    public Button btnAcceptTimes;
    @FXML
    public Button btnClearTimes;
    @FXML
    private Tab tabElimin;
    @FXML
    private TableView tblElimin;
    private ObservableList<ObservableList> datatblElimin;
    @FXML
    private Tab tabReview;
    @FXML
    private TableView tblResults;
    private ObservableList<ObservableList> datatblResults;
    public String selectedResult = "";
    @FXML
    private TextField heat;
    @FXML
    private TextField lane;
    @FXML
    private TextField car;
    @FXML
    private TextField time;
    @FXML
    private TextField place;
    @FXML
    private CheckBox win = new CheckBox();
    @FXML
    private Button btnReviewSave;
    @FXML
    private Button btnReviewEdit;
    @FXML
    private Button btnReviewCancel;
    @FXML
    private Tab tabResults;
    @FXML
    private ComboBox ResultsEvents;
    @FXML
    private TextArea rptresults;
    @FXML
    public Button btnButton;
    final ObservableList<String> listItems = FXCollections.observableArrayList();

    @FXML
    private void printHeatSheet(ActionEvent event) throws IOException, Exception {
        this.printReport(this.selectedEvent, "HeatSheet.report");
    }

    @FXML
    private void printResults(ActionEvent event) throws IOException, Exception {
        this.printReport(this.selectedEvent, "Results.report");
        this.printReport(this.selectedEvent, "Results-Group.report");
        this.printReport(this.selectedEvent, "Results-All.report");
    }

    private void printReport(String eventName, String reportName) throws IOException, Exception {
        String connection_url = "jdbc:sqlite:test.db";
        try {
            FileOutputStream stream = new FileOutputStream(reportName + "." + eventName + ".pdf");
            String report_url = "reports\\" + reportName;
            Report rep_HeatSheet = ReportUtil.loadReport((InputStream)new FileInputStream(report_url));
            Connection connect_testdb = DriverManager.getConnection(connection_url);
            HashMap<String, String> parameterValue = new HashMap<String, String>();
            parameterValue.put("Event", eventName);
            ReportRunner runner = new ReportRunner();
            runner.setConnection(connect_testdb);
            runner.setReport(rep_HeatSheet);
            runner.setParameterValues(parameterValue);
            runner.setQueryTimeout(60);
            runner.setFormat("PDF");
            runner.run((OutputStream)stream);
        }
        catch (SQLException err) {
            System.out.println(err.getMessage());
        }
    }

    @FXML
    private void heatSheetShow(ActionEvent event) throws IOException {
        new heatSheet(this.selectedEvent, this.heatSheet);
    }

    @FXML
    private void resultsShow(ActionEvent event) throws IOException {
        new results(this.selectedEvent, this.rptresults);
    }

    @FXML
    private void deleteCar(ActionEvent event) throws IOException {
    }

    @FXML
    private void deleteRacer(ActionEvent event) throws IOException, SQLException, ClassNotFoundException {
        int selectedItem = this.tblRacers.getSelectionModel().getSelectedIndex();
        String selectedItem2 = this.tblRacers.getSelectionModel().getSelectedItem().toString();
        String racer = this.selectedRacer;
        Connection c = null;
        Statement stmt = null;
        Class.forName("org.sqlite.JDBC");
        c = DriverManager.getConnection("jdbc:sqlite:test.db");
        stmt = c.createStatement();
        String sql = "Delete from Cars Where EventName = '" + this.selectedEvent + "' AND RacerName ='" + racer + "'";
        stmt.executeUpdate(sql);
        this.searchCar();
    }

    @FXML
    private void clearTable(ActionEvent event) {
        this.racerOneTime.setText("");
        this.racerTwoTime.setText("");
        this.racerThreeTime.setText("");
        this.racerFourTime.setText("");
        this.laneOnePlace.setText("");
        this.laneTwoPlace.setText("");
        this.laneThreePlace.setText("");
        this.laneFourPlace.setText("");
    }

    @FXML
    private void acceptTimes(ActionEvent Event) {
        this.datatblTimed = FXCollections.observableArrayList();
        String racerOneId = "";
        String racerTwoId = "";
        String racerThreeId = "";
        String racerFourId = "";
        String racerOneName = this.racerOne.getText();
        String racerTwoName = this.racerTwo.getText();
        String racerThreeName = this.racerThree.getText();
        String racerFourName = this.racerFour.getText();
        String laneOneTime = this.racerOneTime.getText();
        String laneTwoTime = this.racerTwoTime.getText();
        String laneThreeTime = this.racerThreeTime.getText();
        String laneFourTime = this.racerFourTime.getText();
        String racerOnePlace = this.laneOnePlace.getText();
        String racerTwoPlace = this.laneTwoPlace.getText();
        String racerThreePlace = this.laneThreePlace.getText();
        String racerFourPlace = this.laneFourPlace.getText();
        String heatNum = this.currHeat.getText();
        String eventName = this.selectedEvent;
        boolean done = false;
        boolean foundHeat = false;
        Connection c = null;
        Statement stmt = null;
        try {
            Class.forName("org.sqlite.JDBC");
            c = DriverManager.getConnection("jdbc:sqlite:test.db");
            stmt = c.createStatement();
            String sql = "select * from Cars WHERE EventName = '" + eventName + "' AND CarID ='" + racerOneName + "'";
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                racerOneId = rs.getString("RacerName");
            }
            stmt = c.createStatement();
            sql = "select * from Cars WHERE EventName = '" + eventName + "' AND CarID ='" + racerTwoName + "'";
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                racerTwoId = rs.getString("RacerName");
            }
            stmt = c.createStatement();
            sql = "select * from Cars WHERE EventName = '" + eventName + "' AND CarID ='" + racerThreeName + "'";
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                racerThreeId = rs.getString("RacerName");
            }
            stmt = c.createStatement();
            sql = "select * from Cars WHERE EventName = '" + eventName + "' AND CarID ='" + racerFourName + "'";
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                racerFourId = rs.getString("RacerName");
            }
            if (laneOneTime.equals("") || laneTwoTime.equals("") || laneThreeTime.equals("") || laneFourTime.equals("")) {
                this.racerOneTime.setText("");
                this.racerTwoTime.setText("");
                this.racerThreeTime.setText("");
                this.racerFourTime.setText("");
                this.laneOnePlace.setText("");
                this.laneTwoPlace.setText("");
                this.laneThreePlace.setText("");
                this.laneFourPlace.setText("");
                return;
            }
            sql = "CREATE TABLE IF NOT EXISTS Results(EventName     character(100)    NOT NULL, CarID         character(100)    NOT NULL, Lane          integer           NOT NULL, Place         integer, Time          double, Heat          integer, WL            boolean)";
            stmt = c.createStatement();
            sql = "UPDATE Results SET Place = '" + racerOnePlace + "', Time ='" + laneOneTime + "'WHERE EventName ='" + eventName + "' AND CarID ='" + racerOneName + "' AND Heat = '" + heatNum + "'";
            stmt.executeUpdate(sql);
            stmt = c.createStatement();
            sql = "UPDATE Results SET Place = '" + racerTwoPlace + "', Time ='" + laneTwoTime + "'WHERE EventName ='" + eventName + "' AND CarID ='" + racerTwoName + "' AND Heat = '" + heatNum + "'";
            stmt.executeUpdate(sql);
            stmt = c.createStatement();
            sql = "UPDATE Results SET Place = '" + racerThreePlace + "', Time ='" + laneThreeTime + "'WHERE EventName ='" + eventName + "' AND CarID ='" + racerThreeName + "' AND Heat = '" + heatNum + "'";
            stmt.executeUpdate(sql);
            stmt = c.createStatement();
            sql = "UPDATE Results SET Place = '" + racerFourPlace + "', Time ='" + laneFourTime + "'WHERE EventName ='" + eventName + "' AND CarID ='" + racerFourName + "' AND Heat = '" + heatNum + "'";
            stmt.executeUpdate(sql);
            stmt = c.createStatement();
            sql = "Select * from Results Where EventName ='" + eventName + "' ORDER BY Heat;";
            rs = stmt.executeQuery(sql);
            int HeatNum = 0;
            while (rs.next()) {
                ObservableList row;
                Integer Time2;
                Integer Place;
                Integer Lane;
                String CarID;
                Double time = rs.getDouble("Time");
                if (time != 0.0) continue;
                Integer Heat = rs.getInt("Heat");
                if (!foundHeat) {
                    System.out.println("Got Here");
                    CarID = rs.getString("CarID");
                    HeatNum = Heat;
                    this.currHeat.setText(Integer.toString(HeatNum));
                    foundHeat = true;
                    Lane = rs.getInt("Lane");
                    Place = rs.getInt("Place");
                    Time2 = rs.getInt("Time");
                    row = FXCollections.observableArrayList();
                    row.addAll((Object[])new String[]{Integer.toString(HeatNum), Integer.toString(Lane), CarID, Integer.toString(Place), Integer.toString(Time2)});
                    this.datatblTimed.add((Object)row);
                    if (Lane == 1) {
                        this.racerOne.setText(CarID);
                    }
                    if (Lane == 2) {
                        this.racerTwo.setText(CarID);
                    }
                    if (Lane == 3) {
                        this.racerThree.setText(CarID);
                    }
                    if (Lane != 4) continue;
                    this.racerFour.setText(CarID);
                    continue;
                }
                if (HeatNum != Heat) continue;
                System.out.println("Got Here 2");
                CarID = rs.getString("CarID");
                Lane = rs.getInt("Lane");
                Place = rs.getInt("Place");
                Time2 = rs.getInt("Time");
                row = FXCollections.observableArrayList();
                row.addAll((Object[])new String[]{Integer.toString(HeatNum), Integer.toString(Lane), CarID, Integer.toString(Place), Integer.toString(Time2)});
                this.datatblTimed.add((Object)row);
                if (Lane == 1) {
                    this.racerOne.setText(CarID);
                }
                if (Lane == 2) {
                    this.racerTwo.setText(CarID);
                }
                if (Lane == 3) {
                    this.racerThree.setText(CarID);
                }
                if (Lane != 4) continue;
                this.racerFour.setText(CarID);
            }
            if (!foundHeat) {
                new addDialog(eventName);
                stmt = c.createStatement();
                sql = "UPDATE Events SET Complete = 'true' WHERE EventName ='" + eventName + "'";
                stmt.executeUpdate(sql);
            }
            this.racerOneTime.setText("");
            this.racerTwoTime.setText("");
            this.racerThreeTime.setText("");
            this.racerFourTime.setText("");
            this.laneOnePlace.setText("");
            this.laneTwoPlace.setText("");
            this.laneThreePlace.setText("");
            this.laneFourPlace.setText("");
            this.tblTimed.setItems(this.datatblTimed);
            rs.close();
            stmt.close();
            c.close();
        }
        catch (Exception e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
        }
    }

    @FXML
    private void readInData(ActionEvent Event) {
        if (this.btnConnectToTimer.getText().equals("Connect to Timer")) {
            this.communicator.connect();
            if (this.communicator.getConnected() && this.communicator.initIOStream()) {
                this.cboxPorts.setDisable(true);
                this.btnConnectToTimer.setText("Disconnect Timer");
                this.btnConnectToTimer.setDisable(false);
                this.communicator.initListener();
            }
        } else {
            this.communicator.disconnect();
            this.cboxPorts.setDisable(false);
            this.btnConnectToTimer.setText("Connect to Timer");
        }
    }

    private void createObjects() {
        this.communicator = new Communicator(this.txtCode, this.laneOnePlace, this.laneTwoPlace, this.laneThreePlace, this.laneFourPlace, this.racerOneTime, this.racerTwoTime, this.racerThreeTime, this.racerFourTime, this.btnConnectToTimer, this.btnAcceptTimes, this.btnClearTimes, this.cboxPorts);
    }

    @FXML
    private void searchCarButton(ActionEvent event) {
        this.searchCar();
    }

    @FXML
    private void reviewSave(ActionEvent event) throws IOException, SQLException, ClassNotFoundException, Exception {
        Connection c = null;
        Statement stmt = null;
        boolean winisSelected = this.win.isSelected();
        Class.forName("org.sqlite.JDBC");
        c = DriverManager.getConnection("jdbc:sqlite:test.db");
        stmt = c.createStatement();
        String sql = "UPDATE Results SET Place = '" + this.place.getText() + "', Time ='" + this.time.getText() + "', WL ='" + winisSelected + "' WHERE EventName ='" + this.selectedEvent + "' AND CarID ='" + this.car.getText() + "' AND Heat = '" + this.heat.getText() + "'";
        stmt.executeUpdate(sql);
        this.refreshResults("from-save-results");
        this.btnReviewSave.setDisable(true);
        this.btnReviewEdit.setDisable(false);
        this.btnReviewCancel.setDisable(true);
        this.heat.setText("");
        this.lane.setText("");
        this.car.setText("");
        this.place.setText("");
        this.time.setText("");
        this.win.setSelected(false);
    }

    @FXML
    private void editResults(ActionEvent event) throws IOException, SQLException, ClassNotFoundException, Exception {
        int selectedItem = this.tblResults.getSelectionModel().getSelectedIndex();
        String selectedItem2 = this.tblResults.getSelectionModel().getSelectedItem().toString();
        this.heat.setText(this.tblResults.getSelectionModel().getSelectedItem().toString().split(",")[0].substring(1));
        this.lane.setText(this.tblResults.getSelectionModel().getSelectedItem().toString().split(",")[1].substring(1));
        this.car.setText(this.tblResults.getSelectionModel().getSelectedItem().toString().split(",")[2].substring(1));
        this.place.setText(this.tblResults.getSelectionModel().getSelectedItem().toString().split(",")[3].substring(1));
        this.time.setText(this.tblResults.getSelectionModel().getSelectedItem().toString().split(",")[4].substring(1));
        if (this.tblResults.getSelectionModel().getSelectedItem().toString().split(",")[5].substring(1).equals("Win]")) {
            this.win.setSelected(true);
        } else {
            this.win.setSelected(false);
        }
        this.btnReviewSave.setDisable(false);
        this.btnReviewEdit.setDisable(true);
        this.btnReviewCancel.setDisable(false);
        System.out.println("Got selectedItem" + Integer.toString(selectedItem));
        System.out.println("Got selectedItem2" + selectedItem2);
    }

    @FXML
    private void canceleditResults(ActionEvent event) throws IOException, SQLException, ClassNotFoundException, Exception {
        int selectedItem = this.tblResults.getSelectionModel().getSelectedIndex();
        String selectedItem2 = this.tblResults.getSelectionModel().getSelectedItem().toString();
        this.heat.setText("");
        this.lane.setText("");
        this.car.setText("");
        this.place.setText("");
        this.time.setText("");
        this.win.setSelected(false);
        this.btnReviewSave.setDisable(true);
        this.btnReviewEdit.setDisable(false);
        this.btnReviewCancel.setDisable(true);
        System.out.println("Got selectedItem" + Integer.toString(selectedItem));
        System.out.println("Got selectedItem2" + selectedItem2);
    }

    private void searchCar() {
        this.data = FXCollections.observableArrayList();
        Connection c = null;
        Statement stmt = null;
        String groupings = "";
        try {
            Class.forName("org.sqlite.JDBC");
            c = DriverManager.getConnection("jdbc:sqlite:test.db");
            stmt = c.createStatement();
            String sql = "select * from Cars WHERE EventName = '" + this.selectedEvent + "'";
            ResultSet rs = stmt.executeQuery(sql);
            this.listItems.clear();
            this.refreshRacers("searchCar");
            while (rs.next()) {
                String name2 = rs.getString("RacerName");
                this.listItems.add((Object)name2);
            }
            stmt = c.createStatement();
            sql = "select * from Events WHERE EventName = '" + this.selectedEvent + "'";
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                groupings = rs.getString("Groupings");
            }
            this.newGroupID.getItems().clear();
            if (groupings.equals("Yes")) {
                this.newGroupID.getItems().addAll(new Object[]{"Tiger", "Wolf", "Bear", "Webelos 1", "Webelos 2", "Adults"});
            } else {
                this.newGroupID.getItems().addAll(new Object[]{"All"});
                this.newGroupID.setValue((Object)"All");
            }
            rs.close();
            stmt.close();
            c.close();
        }
        catch (Exception e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
        }
    }

    @FXML
    private void startRace(ActionEvent event) {
        String name = this.selectedEvent;
        Integer HeatNum = 0;
        boolean done = false;
        boolean foundHeat = false;
        Connection c = null;
        Statement stmt = null;
        try {
            Class.forName("org.sqlite.JDBC");
            c = DriverManager.getConnection("jdbc:sqlite:test.db");
            stmt = c.createStatement();
            String sql = "Select * from Events Where EventName ='" + name + "'";
            ResultSet rs = stmt.executeQuery(sql);
            rs.next();
            Boolean Completed = rs.getBoolean("Complete");
            if (Completed.booleanValue()) {
                new addDialog(name);
            } else {
                stmt = c.createStatement();
                sql = "Select Heat AS Heat, Lane AS Lane, CarID AS Racer, Time AS Time, Place AS Place from Results Where EventName ='" + name + "' ORDER BY Heat;";
                rs = stmt.executeQuery(sql);
                this.tblTimed.getColumns().clear();
                for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                    final int j = i;
                    TableColumn col = new TableColumn(rs.getMetaData().getColumnName(i + 1));
                    col.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ObservableList, String>, ObservableValue<String>>(){

                        public ObservableValue<String> call(TableColumn.CellDataFeatures<ObservableList, String> param) {
                            return new SimpleStringProperty(((ObservableList)param.getValue()).get(j).toString());
                        }
                    });
                    this.tblTimed.getColumns().addAll(new Object[]{col});
                }
                sql = "Select * from Results Where EventName ='" + name + "' ORDER BY Heat;";
                rs = stmt.executeQuery(sql);
                this.datatblTimed = FXCollections.observableArrayList();
                while (rs.next()) {
                    ObservableList row;
                    Integer Time2;
                    Integer Place;
                    Integer Lane;
                    String CarID;
                    Double time = rs.getDouble("Time");
                    if (time != 0.0) continue;
                    Integer Heat = rs.getInt("Heat");
                    if (!foundHeat) {
                        System.out.println("Got Here-start event");
                        CarID = rs.getString("CarID");
                        HeatNum = Heat;
                        this.currHeat.setText(Integer.toString(HeatNum));
                        foundHeat = true;
                        Lane = rs.getInt("Lane");
                        Place = rs.getInt("Place");
                        Time2 = rs.getInt("Time");
                        row = FXCollections.observableArrayList();
                        row.addAll((Object[])new String[]{Integer.toString(HeatNum), Integer.toString(Lane), CarID, Integer.toString(Place), Integer.toString(Time2)});
                        this.datatblTimed.add((Object)row);
                        if (Lane == 1) {
                            this.racerOne.setText(CarID);
                        }
                        if (Lane == 2) {
                            this.racerTwo.setText(CarID);
                        }
                        if (Lane == 3) {
                            this.racerThree.setText(CarID);
                        }
                        if (Lane != 4) continue;
                        this.racerFour.setText(CarID);
                        continue;
                    }
                    if (HeatNum != Heat) continue;
                    System.out.println("Got Here 2-start event");
                    CarID = rs.getString("CarID");
                    Lane = rs.getInt("Lane");
                    Place = rs.getInt("Place");
                    Time2 = rs.getInt("Time");
                    row = FXCollections.observableArrayList();
                    row.addAll((Object[])new String[]{Integer.toString(HeatNum), Integer.toString(Lane), CarID, Integer.toString(Place), Integer.toString(Time2)});
                    this.datatblTimed.add((Object)row);
                    if (Lane == 1) {
                        this.racerOne.setText(CarID);
                    }
                    if (Lane == 2) {
                        this.racerTwo.setText(CarID);
                    }
                    if (Lane == 3) {
                        this.racerThree.setText(CarID);
                    }
                    if (Lane != 4) continue;
                    this.racerFour.setText(CarID);
                }
            }
            this.tblTimed.setItems(this.datatblTimed);
            rs.close();
            stmt.close();
            c.close();
        }
        catch (Exception e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
        }
        this.btnConnectToTimer.setDisable(false);
    }

    @FXML
    private void addCarButton(ActionEvent event) {
        String eventName = this.selectedEvent;
        String carID = this.newCarID.getText();
        String groupID = this.newGroupID.getValue().toString();
        String racerName = this.newRacerName.getText();
        Connection c = null;
        Statement stmt = null;
        try {
            Class.forName("org.sqlite.JDBC");
            c = DriverManager.getConnection("jdbc:sqlite:test.db");
            stmt = c.createStatement();
            String sql = "INSERT INTO Cars VALUES('" + eventName + "','" + carID + "','" + racerName + "','" + groupID + "')";
            stmt.executeUpdate(sql);
            this.refreshRacers("addCarButton");
            this.searchCar();
            stmt.close();
            c.close();
        }
        catch (Exception e) {
            new carNameDialog();
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
        }
    }

    @FXML
    private void updateButton(ActionEvent event) {
        String nameOriginal = this.editOriginalName.getText();
        String newName = this.editEventName.getText();
        String type = this.editEventType.getValue().toString();
        String groupings = "No";
        if (this.editYesGroup.isSelected()) {
            groupings = "Yes";
        } else if (this.editNoGroup.isSelected()) {
            groupings = "No";
        }
        String lanes = this.editLanes.getText();
        Connection c = null;
        Statement stmt = null;
        try {
            Class.forName("org.sqlite.JDBC");
            c = DriverManager.getConnection("jdbc:sqlite:test.db");
            stmt = c.createStatement();
            String sql = "UPDATE Events SET EventName = '" + newName + "', EventType = '" + type + "', Groupings = '" + groupings + "', NumberOfLanes = '" + lanes + "' WHERE EventName ='" + nameOriginal + "';";
            stmt.executeUpdate(sql);
            stmt = c.createStatement();
            sql = "select * from Events GROUP BY EventName";
            ResultSet rs = stmt.executeQuery(sql);
            this.eventArea.clear();
            this.ResultsEvents.getItems().clear();
            this.searchEvent.getItems().clear();
            while (rs.next()) {
                String name2 = rs.getString("EventName");
                this.eventArea.appendText(name2 + "\n");
                this.ResultsEvents.getItems().add((Object)name2);
                this.searchEvent.getItems().add((Object)name2);
            }
            rs.close();
            stmt.close();
            c.close();
        }
        catch (Exception e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
        }
    }

    @FXML
    private void searchButton(ActionEvent event) {
        this.tabAddRacer.setDisable(false);
        this.tabHeatSheet.setDisable(false);
        this.tabTimed.setDisable(false);
        this.tabElimin.setDisable(false);
        this.tabReview.setDisable(false);
        this.tabResults.setDisable(false);
        int selectedItem = this.tblEvents.getSelectionModel().getSelectedIndex();
        String selectedItem2 = this.tblEvents.getSelectionModel().getSelectedItem().toString();
        String name = this.selectedEvent;
        Connection c = null;
        Statement stmt = null;
        try {
            Class.forName("org.sqlite.JDBC");
            c = DriverManager.getConnection("jdbc:sqlite:test.db");
            stmt = c.createStatement();
            String sql = "select * from Events WHERE EventName ='" + name + "'";
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String eventName = rs.getString("EventName");
                this.editEventName.setText(eventName);
                this.editOriginalName.setText(eventName);
                String eventType = rs.getString("EventType");
                this.editEventType.setValue((Object)eventType);
                String groupings = rs.getString("Groupings");
                String eventComplete = rs.getString("Complete");
                if (groupings.equals("Yes")) {
                    this.editYesGroup.setSelected(true);
                } else {
                    this.editNoGroup.setSelected(true);
                }
                Integer lanes = rs.getInt("NumberOfLanes");
                this.editLanes.setText(lanes.toString());
                if (eventComplete.equals("true")) {
                    this.tabAddRacer.setDisable(true);
                    this.tabHeatSheet.setDisable(true);
                    this.tabTimed.setDisable(true);
                    this.tabElimin.setDisable(true);
                    this.tabReview.setDisable(false);
                    this.tabResults.setDisable(false);
                    continue;
                }
                this.tabAddRacer.setDisable(false);
                this.tabHeatSheet.setDisable(false);
                this.tabTimed.setDisable(false);
                this.tabElimin.setDisable(false);
                this.tabReview.setDisable(true);
                this.tabResults.setDisable(true);
            }
            this.searchCar();
            this.refreshRacers("SearchButton");
            this.refreshResults("SearchButton");
            PackRacer.getStage().setTitle("Packracer Event: " + name);
            rs.close();
            stmt.close();
            c.close();
        }
        catch (Exception e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.tblEvents.setEditable(false);
        this.tblRacers.setEditable(false);
        this.tblResults.setEditable(false);
        this.tabAddRacer.setDisable(true);
        this.tabHeatSheet.setDisable(true);
        this.tabTimed.setDisable(true);
        this.btnConnectToTimer.setDisable(true);
        this.btnAcceptTimes.setDisable(true);
        this.btnClearTimes.setDisable(true);
        this.eventType.getItems().addAll(new Object[]{"Everyone, Best Time", "Everyone, Bracket", "Group, Best Time", "Group, Bracket"});
        this.editEventType.getItems().addAll(new Object[]{"Everyone, Best Time", "Everyone, Bracket", "Group, Best Time", "Group, Bracket"});
        this.eventArea.setPrefRowCount(20);
        Connection c = null;
        Statement stmt = null;
        try {
            Class.forName("org.sqlite.JDBC");
            c = DriverManager.getConnection("jdbc:sqlite:test.db");
            stmt = c.createStatement();
            String sql = "CREATE TABLE IF NOT EXISTS Events (EventName character(100) PRIMARY KEY     NOT NULL, EventType          character(100)    NOT NULL, Groupings          character(100)    NOT NULL, NumberOfLanes      integer           NOT NULL, Complete            boolean)";
            stmt.executeUpdate(sql);
            stmt = c.createStatement();
            sql = "CREATE TABLE IF NOT EXISTS Cars(EventName       character(100)    NOT NULL, CarID           character(100)    NOT NULL, RacerName       character(100)    NOT NULL, GroupID         integer           NOT NULL, CONSTRAINT carID_event_unique UNIQUE (EventName, CarID) )";
            stmt.executeUpdate(sql);
            stmt = c.createStatement();
            sql = "CREATE TABLE IF NOT EXISTS Results(EventName     character(100)    NOT NULL, CarID         character(100)    NOT NULL, Lane          integer           NOT NULL, Place         integer, Time          double, Heat          integer, WL            boolean)";
            stmt.executeUpdate(sql);
            stmt = c.createStatement();
            stmt.executeUpdate(sql);
            this.refreshTabs("initialize");
            this.tblEvents.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

                public void changed(ObservableValue observableValue, Object oldValue, Object newValue) {
                    if (FXMLDocumentController.this.tblEvents.getSelectionModel().getSelectedItem() != null) {
                        TableView.TableViewSelectionModel selectionModel = FXMLDocumentController.this.tblEvents.getSelectionModel();
                        ObservableList selectedCells = selectionModel.getSelectedCells();
                        TablePosition tablePosition = (TablePosition)selectedCells.get(0);
                        tablePosition.getTableView().getSelectionModel().getTableView().getId();
                        Object GetSinglevalue = tablePosition.getTableColumn().getCellData(newValue);
                        String getbothvalue = FXMLDocumentController.this.tblEvents.getSelectionModel().getSelectedItem().toString();
                        FXMLDocumentController.this.selectedEvent = getbothvalue.toString().split(",")[0].substring(1);
                    }
                }
            });
            this.tblRacers.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

                public void changed(ObservableValue observableValue, Object oldValue, Object newValue) {
                    if (FXMLDocumentController.this.tblRacers.getSelectionModel().getSelectedItem() != null) {
                        TableView.TableViewSelectionModel selectionModel = FXMLDocumentController.this.tblRacers.getSelectionModel();
                        ObservableList selectedCells = selectionModel.getSelectedCells();
                        TablePosition tablePosition = (TablePosition)selectedCells.get(0);
                        tablePosition.getTableView().getSelectionModel().getTableView().getId();
                        Object GetSinglevalue = tablePosition.getTableColumn().getCellData(newValue);
                        String getbothvalue = FXMLDocumentController.this.tblRacers.getSelectionModel().getSelectedItem().toString();
                        FXMLDocumentController.this.selectedRacer = getbothvalue.toString().split(",")[0].substring(1);
                    }
                }
            });
            this.tblResults.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

                public void changed(ObservableValue observableValue, Object oldValue, Object newValue) {
                    if (FXMLDocumentController.this.tblResults.getSelectionModel().getSelectedItem() != null) {
                        TableView.TableViewSelectionModel selectionModel = FXMLDocumentController.this.tblResults.getSelectionModel();
                        ObservableList selectedCells = selectionModel.getSelectedCells();
                        TablePosition tablePosition = (TablePosition)selectedCells.get(0);
                        tablePosition.getTableView().getSelectionModel().getTableView().getId();
                        Object GetSinglevalue = tablePosition.getTableColumn().getCellData(newValue);
                        String getbothvalue = FXMLDocumentController.this.tblResults.getSelectionModel().getSelectedItem().toString();
                        FXMLDocumentController.this.selectedResult = getbothvalue.toString().split(",")[0].substring(1);
                    }
                }
            });
            stmt.close();
            c.close();
        }
        catch (Exception e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
        }
        this.createObjects();
        this.communicator.searchForPorts();
    }

    private void refreshTabs(String args) throws Exception {
        Connection c = null;
        Statement stmt = null;
        this.datatblEvents = FXCollections.observableArrayList();
        try {
            Class.forName("org.sqlite.JDBC");
            c = DriverManager.getConnection("jdbc:sqlite:test.db");
            String status = null;
            stmt = c.createStatement();
            String sql = "select EventName, Complete AS Status from Events GROUP BY EventName";
            ResultSet rs = stmt.executeQuery(sql);
            for (int i = 0; i < 2; ++i) {
                final int j = i;
                TableColumn col = new TableColumn(rs.getMetaData().getColumnName(i + 1));
                col.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ObservableList, String>, ObservableValue<String>>(){

                    public ObservableValue<String> call(TableColumn.CellDataFeatures<ObservableList, String> param) {
                        return new SimpleStringProperty(((ObservableList)param.getValue()).get(j).toString());
                    }
                });
                this.tblEvents.getColumns().addAll(new Object[]{col});
            }
            while (rs.next()) {
                String name = rs.getString("EventName");
                String complete = rs.getString("Status");
                ObservableList row = FXCollections.observableArrayList();
                status = complete.equals("true") ? "Finished" : "Running";
                row.addAll((Object[])new String[]{rs.getString("EventName"), status});
                this.datatblEvents.add((Object)row);
                this.eventArea.appendText(name + "\n");
                if (complete.equals("true")) {
                    this.ResultsEvents.getItems().add((Object)name);
                }
                this.searchEvent.getItems().add((Object)name);
            }
            Set cells = this.tblEvents.lookupAll(".table-cell");
            cells.forEach(d -> d.setStyle("-fx-font-weight:lighter;-fx-font-style:italic;"));
            stmt = c.createStatement();
            sql = "select * from Results Group by EventName";
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String string = rs.getString("EventName");
            }
            rs.close();
            stmt.close();
            c.close();
            this.tblEvents.setItems(this.datatblEvents);
        }
        catch (Exception e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private void refreshRacers(String args) throws Exception {
        Connection c = null;
        Statement stmt = null;
        this.datatblRacers = FXCollections.observableArrayList();
        try {
            Class.forName("org.sqlite.JDBC");
            c = DriverManager.getConnection("jdbc:sqlite:test.db");
            Object status = null;
            stmt = c.createStatement();
            String sql = "select RacerName AS Racer, GroupID AS Grp, CarID AS ID from Cars WHERE EventName = '" + this.selectedEvent + "'";
            ResultSet rs = stmt.executeQuery(sql);
            this.tblRacers.getColumns().clear();
            for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                final int j = i;
                TableColumn col = new TableColumn(rs.getMetaData().getColumnName(i + 1));
                col.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ObservableList, String>, ObservableValue<String>>(){

                    public ObservableValue<String> call(TableColumn.CellDataFeatures<ObservableList, String> param) {
                        return new SimpleStringProperty(((ObservableList)param.getValue()).get(j).toString());
                    }
                });
                this.tblRacers.getColumns().addAll(new Object[]{col});
            }
            while (rs.next()) {
                String racer = rs.getString("Racer");
                String group = rs.getString("Grp");
                String id = rs.getString("ID");
                ObservableList row = FXCollections.observableArrayList();
                row.addAll((Object[])new String[]{racer, group, id});
                this.datatblRacers.add((Object)row);
            }
            stmt = c.createStatement();
            sql = "select * from Results Group by EventName";
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String racer = rs.getString("EventName");
            }
            rs.close();
            stmt.close();
            c.close();
            this.tblRacers.setItems(this.datatblRacers);
            Set cells = this.tblRacers.lookupAll(".table-cell");
            cells.forEach(d -> d.setStyle("-fx-font-weight:lighter;-fx-font-style:italic;-fx-font-size:60%;"));
        }
        catch (Exception e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private void refreshResults(String args) throws Exception {
        Connection c = null;
        Statement stmt = null;
        this.datatblResults = FXCollections.observableArrayList();
        try {
            Class.forName("org.sqlite.JDBC");
            c = DriverManager.getConnection("jdbc:sqlite:test.db");
            String status = null;
            stmt = c.createStatement();
            String sql = "select Heat AS Heat, Lane AS Lane, CarID AS ID, Place AS Place, Time AS Time, WL as WinLoss from Results WHERE EventName = '" + this.selectedEvent + "'";
            ResultSet rs = stmt.executeQuery(sql);
            this.tblResults.getColumns().clear();
            for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                final int j = i;
                TableColumn col = new TableColumn(rs.getMetaData().getColumnName(i + 1));
                col.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ObservableList, String>, ObservableValue<String>>(){

                    public ObservableValue<String> call(TableColumn.CellDataFeatures<ObservableList, String> param) {
                        return new SimpleStringProperty(((ObservableList)param.getValue()).get(j).toString());
                    }
                });
                col.setCellFactory(TextFieldTableCell.forTableColumn());
                this.tblResults.getColumns().addAll(new Object[]{col});
            }
            while (rs.next()) {
                String heat = rs.getString("Heat");
                String lane = rs.getString("Lane");
                String id = rs.getString("ID");
                String place = rs.getString("Place");
                String time = rs.getString("Time");
                String winloss = rs.getString("WinLoss");
                ObservableList row = FXCollections.observableArrayList();
                status = winloss.equals("True") || winloss.equals("true") ? "Win" : "Loss";
                row.addAll((Object[])new String[]{heat, lane, id, place, time, status});
                this.datatblResults.add((Object)row);
            }
            stmt = c.createStatement();
            sql = "select * from Results Group by EventName";
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String string = rs.getString("EventName");
            }
            rs.close();
            stmt.close();
            c.close();
            this.tblResults.setItems(this.datatblResults);
        }
        catch (Exception e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
        }
    }

    @FXML
    private void createEvent(ActionEvent event) {
        String name = this.eventName1.getText();
        String status = null;
        this.datatblEvents.clear();
        if (name == null || name == "" || name == " ") {
            return;
        }
        String type = this.eventType.getValue().toString();
        String groupings = "No";
        if (this.yesGroupings.isSelected()) {
            groupings = "Yes";
        } else if (this.noGroupings.isSelected()) {
            groupings = "No";
        }
        String numOfLanes = this.numberOfLanes.getText();
        Connection c = null;
        Statement stmt = null;
        try {
            Class.forName("org.sqlite.JDBC");
            c = DriverManager.getConnection("jdbc:sqlite:test.db");
            stmt = c.createStatement();
            String sql = "INSERT INTO Events (EventName,EventType,Groupings,NumberOfLanes,Complete) VALUES ( '" + name + "', '" + type + "', '" + groupings + "', '" + numOfLanes + "', 'false' );";
            stmt.executeUpdate(sql);
            stmt = c.createStatement();
            sql = "select EventName, Complete AS Status from Events GROUP BY EventName;";
            ResultSet rs = stmt.executeQuery(sql);
            this.eventArea.clear();
            this.searchEvent.getItems().clear();
            while (rs.next()) {
                String name2 = rs.getString("EventName");
                this.eventArea.appendText(name2 + "\n");
                this.searchEvent.getItems().add((Object)name2);
                String complete = rs.getString("Status");
                ObservableList row = FXCollections.observableArrayList();
                status = complete.equals("true") ? "Finished" : "Running";
                row.addAll((Object[])new String[]{rs.getString("EventName"), status});
                this.datatblEvents.add((Object)row);
            }
            rs.close();
            stmt.close();
            c.close();
        }
        catch (Exception e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
            new eventNameDialog();
        }
    }

    private class EventArray {
        public SimpleStringProperty eventId = new SimpleStringProperty();
        public SimpleStringProperty statusId = new SimpleStringProperty("<Name>");
        public int invoiceId;

        private EventArray() {
        }

        public String getEventId() {
            return this.eventId.get();
        }

        public String getstatusId() {
            return this.statusId.get();
        }
    }
}

