/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine;

import java.io.OutputStream;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import ro.nextreports.engine.Report;
import ro.nextreports.engine.ReportRunner;
import ro.nextreports.engine.ReportRunnerException;
import ro.nextreports.engine.exporter.Alert;
import ro.nextreports.engine.exporter.event.ExporterEventListener;
import ro.nextreports.engine.exporter.exception.NoDataFoundException;
import ro.nextreports.engine.queryexec.QueryResult;

public class FluentReportRunner {
    private ReportRunner reportRunner = new ReportRunner();

    private FluentReportRunner(Report report) {
        this.reportRunner.setReport(report);
    }

    public static FluentReportRunner report(Report report) {
        return new FluentReportRunner(report);
    }

    public FluentReportRunner connectTo(Connection connection) {
        this.reportRunner.setConnection(connection);
        return this;
    }

    public FluentReportRunner connectToCsv(Connection connection) {
        this.reportRunner.setConnection(connection, true);
        return this;
    }

    public FluentReportRunner withQueryTimeout(int queryTimeout) {
        this.reportRunner.setQueryTimeout(queryTimeout);
        return this;
    }

    public FluentReportRunner withParameterValues(Map<String, Object> parameterValues) {
        this.reportRunner.setParameterValues(parameterValues);
        return this;
    }

    public FluentReportRunner withChartImagePath(String path) {
        this.reportRunner.setChartImagePath(path);
        return this;
    }

    public FluentReportRunner withLanguage(String language) {
        this.reportRunner.setLanguage(language);
        return this;
    }

    public FluentReportRunner formatAs(String format) {
        this.reportRunner.setFormat(format);
        return this;
    }

    public FluentReportRunner withAlerts(List<Alert> alerts) {
        this.reportRunner.setAlerts(alerts);
        return this;
    }

    public FluentReportRunner computeCount(boolean count) {
        this.reportRunner.setCount(count);
        return this;
    }

    public FluentReportRunner registerListener(ExporterEventListener listener) {
        this.reportRunner.addExporterEventListener(listener);
        return this;
    }

    public FluentReportRunner unregisterListener(ExporterEventListener listener) {
        this.reportRunner.removeExporterEventListener(listener);
        return this;
    }

    public void run(OutputStream stream) throws ReportRunnerException, NoDataFoundException {
        this.reportRunner.run(stream);
    }

    public QueryResult executeQuery() throws ReportRunnerException, InterruptedException {
        return this.reportRunner.executeQuery();
    }

    public void stop() {
        if (this.reportRunner != null) {
            this.reportRunner.stop();
        }
    }

    public boolean isCancelled() {
        return this.reportRunner.isCancelled();
    }

    public Map<String, Object> getParameterValues() {
        return this.reportRunner.getParameterValues();
    }
}

