/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.nextreports.engine.ReportLayout;
import ro.nextreports.engine.persistence.TablePersistentObject;
import ro.nextreports.engine.querybuilder.MyRow;
import ro.nextreports.engine.querybuilder.sql.SelectQuery;
import ro.nextreports.engine.queryexec.QueryParameter;
import ro.nextreports.engine.util.EqualsUtil;

public class Report
implements Serializable {
    private static final long serialVersionUID = -3868225927478009576L;
    private int id;
    private String name;
    private SelectQuery query;
    private List<QueryParameter> parameters;
    private String sql;
    private List<TablePersistentObject> tables;
    private List<MyRow> rows;
    private ReportLayout layout;
    private String version;
    private transient Map<String, Object> generatedParamValues;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public String getBaseName() {
        if (this.name.endsWith(".report")) {
            return this.name.substring(0, this.name.length() - 7);
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SelectQuery getQuery() {
        return this.query;
    }

    public void setQuery(SelectQuery query) {
        this.query = query;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public List<QueryParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<QueryParameter> parameters) {
        this.parameters = parameters;
    }

    public List<TablePersistentObject> getTables() {
        return this.tables;
    }

    public void setTables(List<TablePersistentObject> tables) {
        this.tables = tables;
    }

    public List<MyRow> getRows() {
        return this.rows;
    }

    public void setRows(List<MyRow> rows) {
        this.rows = rows;
    }

    public ReportLayout getLayout() {
        return this.layout;
    }

    public void setLayout(ReportLayout layout) {
        this.layout = layout;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Map<String, Object> getGeneratedParamValues() {
        if (this.generatedParamValues == null) {
            this.generatedParamValues = new HashMap<String, Object>();
        }
        return this.generatedParamValues;
    }

    public String toString() {
        return "Report{id=" + this.id + ", name='" + this.name + '\'' + ", query=" + this.query + ", parameters=" + this.parameters + ", sql='" + this.sql + '\'' + ", tables=" + this.tables + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Report report = (Report)o;
        if (this.layout != null ? !this.layout.equals(report.layout) : report.layout != null) {
            return false;
        }
        if (this.parameters != null ? !this.parameters.equals(report.parameters) : report.parameters != null) {
            return false;
        }
        if (this.query != null ? !this.query.equals(report.query) : report.query != null) {
            return false;
        }
        if (!(this.rows == null || report.rows == null || this.rows.containsAll(report.rows) && report.rows.containsAll(this.rows))) {
            return false;
        }
        if (this.sql != null ? !this.sql.equals(report.sql) : report.sql != null) {
            return false;
        }
        return this.tables == null || report.tables == null || this.tables.containsAll(report.tables) && report.tables.containsAll(this.tables);
    }

    public int hashCode() {
        int result = this.query != null ? this.query.hashCode() : 0;
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        result = 31 * result + (this.sql != null ? this.sql.hashCode() : 0);
        result = 31 * result + (this.tables != null ? this.tables.hashCode() : 0);
        result = 31 * result + (this.rows != null ? EqualsUtil.hashCode(this.rows) : 0);
        result = 31 * result + (this.layout != null ? this.layout.hashCode() : 0);
        return result;
    }
}

