/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import ro.nextreports.engine.ReportGroup;
import ro.nextreports.engine.band.Band;
import ro.nextreports.engine.band.BandElement;
import ro.nextreports.engine.band.ChartBandElement;
import ro.nextreports.engine.band.FunctionBandElement;
import ro.nextreports.engine.band.Padding;
import ro.nextreports.engine.band.PaperSize;
import ro.nextreports.engine.band.ReportBandElement;
import ro.nextreports.engine.exporter.ResultExporter;
import ro.nextreports.engine.i18n.I18nLanguage;

public class ReportLayout
implements Serializable {
    public static final int HEADER_GROUP_MASK = 1;
    public static final int FOOTER_GROUP_MASK = 2;
    public static final int ALL_GROUP_MASK = 3;
    public static final String HEADER_BAND_NAME = "Header";
    public static final String PAGE_HEADER_BAND_NAME = "PageHeader";
    public static final String DETAIL_BAND_NAME = "Detail";
    public static final String FOOTER_BAND_NAME = "Footer";
    public static final String PAGE_FOOTER_BAND_NAME = "PageFooter";
    public static final String GROUP_HEADER_BAND_NAME_PREFIX = "Group_Header";
    public static final String GROUP_FOOTER_BAND_NAME_PREFIX = "Group_Footer";
    public static final String LETTER = "LETTER";
    public static final String A0 = "A0";
    public static final String A1 = "A1";
    public static final String A2 = "A2";
    public static final String A3 = "A3";
    public static final String A4 = "A4";
    public static final String LEGAL = "LEGAL";
    public static final String LEDGER = "LEDGER";
    public static final String TABLOID = "TABLOID";
    public static final String CUSTOM = "CUSTOM";
    private static final long serialVersionUID = -345768096451315236L;
    private List<ReportGroup> groups = new ArrayList<ReportGroup>();
    private List<Integer> columnsWidth;
    private boolean useSize;
    private Band headerBand = new Band("Header");
    private Band pageHeaderBand = new Band("PageHeader");
    private List<Band> groupHeaderBands;
    private Band detailBand = new Band("Detail");
    private List<Band> groupFooterBands;
    private Band pageFooterBand = new Band("PageFooter");
    private Band footerBand = new Band("Footer");
    private int orientation;
    private int reportType;
    private String pageFormat;
    private PaperSize paperSize;
    private Padding pagePadding;
    private String backgroundImage;
    private String templateName;
    private int templateSheet;
    private String sheetNames;
    private boolean headerOnEveryPage;
    private List<String> i18nkeys;
    private List<I18nLanguage> languages;

    public ReportLayout() {
        this.groupHeaderBands = new ArrayList<Band>();
        this.groupFooterBands = new ArrayList<Band>();
        this.columnsWidth = new ArrayList<Integer>();
    }

    public List<Integer> getColumnsWidth() {
        return this.columnsWidth;
    }

    public void setColumnsWidth(List<Integer> columnsWidth) {
        this.columnsWidth = columnsWidth;
    }

    public boolean isUseSize() {
        return this.useSize;
    }

    public void setUseSize(boolean useSize) {
        this.useSize = useSize;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public int getReportType() {
        return this.reportType;
    }

    public void setReportType(int reportType) {
        this.reportType = reportType;
    }

    public String getPageFormat() {
        if (this.pageFormat == null) {
            return A4;
        }
        return this.pageFormat;
    }

    public void setPageFormat(String pageFormat) {
        this.pageFormat = pageFormat;
    }

    public PaperSize getPaperSize() {
        if (this.paperSize == null) {
            return PaperSize.A4;
        }
        return this.paperSize;
    }

    public void setPaperSize(PaperSize paperSize) {
        this.paperSize = paperSize;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public int getTemplateSheet() {
        return this.templateSheet;
    }

    public void setTemplateSheet(int templateSheet) {
        this.templateSheet = templateSheet;
    }

    public String getSheetNames() {
        return this.sheetNames;
    }

    public void setSheetNames(String sheetNames) {
        this.sheetNames = sheetNames;
    }

    public String getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(String backgroundImage) {
        this.backgroundImage = backgroundImage;
    }

    public Padding getPagePadding() {
        if (this.pagePadding == null) {
            int m = ResultExporter.DEFAULT_PADDING_PIXELS;
            return new Padding(m, m, m, m);
        }
        return this.pagePadding;
    }

    public void setPagePadding(Padding pagePadding) {
        this.pagePadding = pagePadding;
    }

    public boolean isHeaderOnEveryPage() {
        return this.headerOnEveryPage;
    }

    public void setHeaderOnEveryPage(boolean headerOnEveryPage) {
        this.headerOnEveryPage = headerOnEveryPage;
    }

    public Band getDetailBand() {
        return this.detailBand;
    }

    public Band getFooterBand() {
        return this.footerBand;
    }

    public Band getHeaderBand() {
        return this.headerBand;
    }

    public Band getPageFooterBand() {
        if (this.pageFooterBand == null) {
            this.pageFooterBand = new Band(PAGE_FOOTER_BAND_NAME);
        }
        return this.pageFooterBand;
    }

    public Band getPageHeaderBand() {
        if (this.pageHeaderBand == null) {
            this.pageHeaderBand = new Band(PAGE_HEADER_BAND_NAME);
        }
        return this.pageHeaderBand;
    }

    public List<Band> getGroupHeaderBands() {
        return this.groupHeaderBands;
    }

    public List<Band> getGroupFooterBands() {
        return this.groupFooterBands;
    }

    public List<ReportGroup> getGroups() {
        return this.groups;
    }

    public Band getBand(String name) {
        for (Band band : this.getBands()) {
            if (!name.equals(band.getName())) continue;
            return band;
        }
        return null;
    }

    public int getBandIndex(String bandName) {
        List<Band> bands = this.getBands();
        for (int i = 0; i < bands.size(); ++i) {
            if (!bandName.equals(bands.get(i).getName())) continue;
            return i;
        }
        return -1;
    }

    public List<String> getBandNamesAfter(String bandName) {
        return this.getBandNamesAfter(this.getBandIndex(bandName));
    }

    public List<String> getBandNamesAfter(int index) {
        List<Band> bandAfters = this.getBandsAfter(index);
        ArrayList<String> bandNamesAfter = new ArrayList<String>();
        for (Band band : bandAfters) {
            bandNamesAfter.add(band.getName());
        }
        return bandNamesAfter;
    }

    public List<Band> getBandsAfter(String bandName) {
        return this.getBandsAfter(this.getBandIndex(bandName));
    }

    public List<Band> getBandsAfter(int index) {
        if (index == -1) {
            return new ArrayList<Band>();
        }
        List<Band> bands = this.getBands();
        ArrayList<Band> bandsAfter = new ArrayList<Band>();
        for (int i = index + 1; i < bands.size(); ++i) {
            bandsAfter.add(bands.get(i));
        }
        return bandsAfter;
    }

    public int getGridRow(String bandName, int bandRow) {
        int gridRow = 0;
        for (Band band : this.getBands()) {
            if (!band.getName().equals(bandName)) {
                gridRow += band.getRowCount();
                continue;
            }
            gridRow += bandRow;
            break;
        }
        return gridRow;
    }

    public void addGroup(ReportGroup group, int groupMask) {
        this.groupHeaderBands.add(new Band(GROUP_HEADER_BAND_NAME_PREFIX + group.getName()));
        this.groupFooterBands.add(0, new Band(GROUP_FOOTER_BAND_NAME_PREFIX + group.getName()));
        if (this.groups == null) {
            this.groups = new ArrayList<ReportGroup>();
        }
        this.groups.add(group);
    }

    public void removeGroup(String groupName) {
        Band band;
        Iterator<Serializable> it = this.groups.iterator();
        while (it.hasNext()) {
            ReportGroup group = it.next();
            if (!group.getName().equals(groupName)) continue;
            it.remove();
        }
        it = this.groupHeaderBands.iterator();
        while (it.hasNext()) {
            band = (Band)it.next();
            if (!band.getName().substring(GROUP_HEADER_BAND_NAME_PREFIX.length()).equals(groupName)) continue;
            it.remove();
            break;
        }
        it = this.groupFooterBands.iterator();
        while (it.hasNext()) {
            band = (Band)it.next();
            if (!band.getName().substring(GROUP_FOOTER_BAND_NAME_PREFIX.length()).equals(groupName)) continue;
            it.remove();
            break;
        }
    }

    public void editGroup(String groupName, String newColumnName, boolean headerOnEveryPage, boolean newPageAfter) {
        for (ReportGroup group : this.groups) {
            if (!group.getName().equals(groupName)) continue;
            group.setColumn(newColumnName);
            group.setHeaderOnEveryPage(headerOnEveryPage);
            group.setNewPageAfter(newPageAfter);
        }
    }

    public ReportGroup getGroup(String groupName) {
        for (ReportGroup group : this.groups) {
            if (!group.getName().equals(groupName)) continue;
            return group;
        }
        return null;
    }

    public List<Band> getBands() {
        ArrayList<Band> bands = new ArrayList<Band>();
        bands.add(this.getPageHeaderBand());
        bands.add(this.headerBand);
        bands.addAll(this.groupHeaderBands);
        bands.add(this.detailBand);
        bands.addAll(this.groupFooterBands);
        bands.add(this.footerBand);
        bands.add(this.getPageFooterBand());
        return bands;
    }

    public List<Band> getDocumentBands() {
        ArrayList<Band> bands = new ArrayList<Band>();
        bands.add(this.headerBand);
        bands.addAll(this.groupHeaderBands);
        bands.add(this.detailBand);
        bands.addAll(this.groupFooterBands);
        bands.add(this.footerBand);
        return bands;
    }

    public List<Band> getNotEmptyBands() {
        ArrayList<Band> bands = new ArrayList<Band>();
        List<Band> allBands = this.getBands();
        for (Band band : allBands) {
            if (band.getRowCount() <= 0) continue;
            bands.add(band);
        }
        return bands;
    }

    public int getRowCount() {
        int rowCount = 0;
        for (Band band : this.getBands()) {
            rowCount += band.getRowCount();
        }
        return rowCount;
    }

    public int getColumnCount() {
        for (Band band : this.getBands()) {
            int count = band.getColumnCount();
            if (count <= 0) continue;
            return count;
        }
        return 0;
    }

    public void clear() {
        this.headerBand.clear();
        this.pageHeaderBand.clear();
        this.detailBand.clear();
        this.pageFooterBand.clear();
        this.footerBand.clear();
        for (Band band : this.groupHeaderBands) {
            band.clear();
        }
        for (Band band : this.groupFooterBands) {
            band.clear();
        }
        if (this.groups != null) {
            this.groups.clear();
        }
    }

    public void initBandsListenerList() {
        for (Band band : this.getBands()) {
            band.initListenerList();
        }
    }

    public static String[] getPageFormats() {
        return new String[]{A4, A3, A2, A1, A0, LETTER, LEGAL, LEDGER, TABLOID, CUSTOM};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportLayout that = (ReportLayout)o;
        if (this.headerOnEveryPage != that.headerOnEveryPage) {
            return false;
        }
        if (this.orientation != that.orientation) {
            return false;
        }
        if (this.reportType != that.reportType) {
            return false;
        }
        if (this.useSize != that.useSize) {
            return false;
        }
        if (this.columnsWidth != null ? !this.columnsWidth.equals(that.columnsWidth) : that.columnsWidth != null) {
            return false;
        }
        if (this.detailBand != null ? !this.detailBand.equals(that.detailBand) : that.detailBand != null) {
            return false;
        }
        if (this.footerBand != null ? !this.footerBand.equals(that.footerBand) : that.footerBand != null) {
            return false;
        }
        if (this.groupFooterBands != null ? !this.groupFooterBands.equals(that.groupFooterBands) : that.groupFooterBands != null) {
            return false;
        }
        if (this.groupHeaderBands != null ? !this.groupHeaderBands.equals(that.groupHeaderBands) : that.groupHeaderBands != null) {
            return false;
        }
        if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) {
            return false;
        }
        if (this.headerBand != null ? !this.headerBand.equals(that.headerBand) : that.headerBand != null) {
            return false;
        }
        if (this.pageHeaderBand != null ? !this.pageHeaderBand.equals(that.pageHeaderBand) : that.pageHeaderBand != null) {
            return false;
        }
        if (this.pageFooterBand != null ? !this.pageFooterBand.equals(that.pageFooterBand) : that.pageFooterBand != null) {
            return false;
        }
        if (this.pageFormat != null ? !this.pageFormat.equals(that.pageFormat) : that.pageFormat != null) {
            return false;
        }
        if (this.templateName != null ? !this.templateName.equals(that.templateName) : that.templateName != null) {
            return false;
        }
        if (this.templateSheet != that.templateSheet) {
            return false;
        }
        if (this.sheetNames != null ? !this.sheetNames.equals(that.sheetNames) : that.sheetNames != null) {
            return false;
        }
        if (this.pagePadding != null ? !this.pagePadding.equals(that.pagePadding) : that.pagePadding != null) {
            return false;
        }
        if (this.backgroundImage != null ? !this.backgroundImage.equals(that.backgroundImage) : that.backgroundImage != null) {
            return false;
        }
        if (this.paperSize != null ? !this.paperSize.equals(that.paperSize) : that.paperSize != null) {
            return false;
        }
        if (!(this.i18nkeys == null || that.i18nkeys == null || this.i18nkeys.containsAll(that.i18nkeys) && that.i18nkeys.containsAll(this.i18nkeys))) {
            return false;
        }
        return this.languages == null || that.languages == null || this.languages.containsAll(that.languages) && that.languages.containsAll(this.languages);
    }

    public int hashCode() {
        int result = this.groups != null ? this.groups.hashCode() : 0;
        result = 31 * result + (this.columnsWidth != null ? this.columnsWidth.hashCode() : 0);
        result = 31 * result + (this.useSize ? 1 : 0);
        result = 31 * result + (this.headerBand != null ? this.headerBand.hashCode() : 0);
        result = 31 * result + (this.pageHeaderBand != null ? this.pageHeaderBand.hashCode() : 0);
        result = 31 * result + (this.pageFooterBand != null ? this.pageFooterBand.hashCode() : 0);
        result = 31 * result + (this.groupHeaderBands != null ? this.groupHeaderBands.hashCode() : 0);
        result = 31 * result + (this.detailBand != null ? this.detailBand.hashCode() : 0);
        result = 31 * result + (this.groupFooterBands != null ? this.groupFooterBands.hashCode() : 0);
        result = 31 * result + (this.footerBand != null ? this.footerBand.hashCode() : 0);
        result = 31 * result + this.orientation;
        result = 31 * result + this.reportType;
        result = 31 * result + (this.pageFormat != null ? this.pageFormat.hashCode() : 0);
        result = 31 * result + (this.templateName != null ? this.templateName.hashCode() : 0);
        result = 31 * result + this.templateSheet;
        result = 31 * result + (this.sheetNames != null ? this.sheetNames.hashCode() : 0);
        result = 31 * result + (this.headerOnEveryPage ? 1 : 0);
        result = 31 * result + (this.pagePadding != null ? this.pagePadding.hashCode() : 0);
        result = 31 * result + (this.backgroundImage != null ? this.backgroundImage.hashCode() : 0);
        result = 31 * result + (this.paperSize != null ? this.paperSize.hashCode() : 0);
        result = 31 * result + (this.i18nkeys != null ? this.i18nkeys.hashCode() : 0);
        result = 31 * result + (this.languages != null ? this.languages.hashCode() : 0);
        return result;
    }

    public Set<String> getFunctions() {
        HashSet<String> functions = new HashSet<String>();
        List<Band> bands = this.getBands();
        for (Band band : bands) {
            int rows = band.getRowCount();
            for (int i = 0; i < rows; ++i) {
                int cols = band.getColumnCount();
                for (int j = 0; j < cols; ++j) {
                    BandElement be = band.getElementAt(i, j);
                    if (!(be instanceof FunctionBandElement)) continue;
                    FunctionBandElement fbe = (FunctionBandElement)be;
                    functions.add(fbe.getFunction() + "_" + fbe.getColumn());
                }
            }
        }
        return functions;
    }

    public Set<String> getFunctions(String bandName) {
        HashSet<String> functions = new HashSet<String>();
        List<Band> bands = this.getBands();
        for (Band band : bands) {
            if (!band.getName().equals(bandName)) continue;
            int rows = band.getRowCount();
            for (int i = 0; i < rows; ++i) {
                int cols = band.getColumnCount();
                for (int j = 0; j < cols; ++j) {
                    BandElement be = band.getElementAt(i, j);
                    if (!(be instanceof FunctionBandElement)) continue;
                    FunctionBandElement fbe = (FunctionBandElement)be;
                    functions.add(fbe.getFunction() + "_" + fbe.getColumn());
                }
            }
        }
        return functions;
    }

    public ReportBandElement getReportBandElement(String reportName) {
        List<Band> bands = this.getDocumentBands();
        for (Band band : bands) {
            for (int i = 0; i < band.getRowCount(); ++i) {
                for (int j = 0; j < band.getColumnCount(); ++j) {
                    ReportBandElement rbe;
                    String text;
                    BandElement be = band.getElementAt(i, j);
                    String string = text = be == null ? "" : be.getText();
                    if (!(be instanceof ReportBandElement) || !(rbe = (ReportBandElement)be).getReport().getName().equals(reportName)) continue;
                    return rbe;
                }
            }
        }
        return null;
    }

    public ChartBandElement getChartBandElement(String chartName) {
        List<Band> bands = this.getDocumentBands();
        for (Band band : bands) {
            for (int i = 0; i < band.getRowCount(); ++i) {
                for (int j = 0; j < band.getColumnCount(); ++j) {
                    ChartBandElement cbe;
                    BandElement be = band.getElementAt(i, j);
                    if (!(be instanceof ChartBandElement) || !(cbe = (ChartBandElement)be).getChart().getName().equals(chartName)) continue;
                    return cbe;
                }
            }
        }
        return null;
    }

    public List<String> getI18nkeys() {
        Collections.sort(this.i18nkeys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Collator.getInstance().compare(o1, o2);
            }
        });
        return this.i18nkeys;
    }

    public void setI18nkeys(List<String> i18nkeys) {
        this.i18nkeys = i18nkeys;
    }

    public List<I18nLanguage> getLanguages() {
        return this.languages;
    }

    public void setLanguages(List<I18nLanguage> languages) {
        this.languages = languages;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.i18nkeys == null) {
            this.i18nkeys = new ArrayList<String>();
        }
        if (this.languages == null) {
            this.languages = new ArrayList<I18nLanguage>();
        }
        return this;
    }
}

