/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ro.nextreports.engine.Report;
import ro.nextreports.engine.ReportLayout;
import ro.nextreports.engine.ReportRunnerException;
import ro.nextreports.engine.Runner;
import ro.nextreports.engine.TableExporter;
import ro.nextreports.engine.exporter.AlarmExporter;
import ro.nextreports.engine.exporter.Alert;
import ro.nextreports.engine.exporter.CsvExporter;
import ro.nextreports.engine.exporter.DisplayExporter;
import ro.nextreports.engine.exporter.DocxExporter;
import ro.nextreports.engine.exporter.ExporterBean;
import ro.nextreports.engine.exporter.HtmlExporter;
import ro.nextreports.engine.exporter.IndicatorExporter;
import ro.nextreports.engine.exporter.PdfExporter;
import ro.nextreports.engine.exporter.ReportTableExporter;
import ro.nextreports.engine.exporter.ResultExporter;
import ro.nextreports.engine.exporter.RtfExporter;
import ro.nextreports.engine.exporter.TsvExporter;
import ro.nextreports.engine.exporter.TxtExporter;
import ro.nextreports.engine.exporter.XlsExporter;
import ro.nextreports.engine.exporter.XlsxExporter;
import ro.nextreports.engine.exporter.XmlExporter;
import ro.nextreports.engine.exporter.event.ExporterEventListener;
import ro.nextreports.engine.exporter.exception.NoDataFoundException;
import ro.nextreports.engine.exporter.util.AlarmData;
import ro.nextreports.engine.exporter.util.DisplayData;
import ro.nextreports.engine.exporter.util.IndicatorData;
import ro.nextreports.engine.exporter.util.ParametersBean;
import ro.nextreports.engine.exporter.util.TableData;
import ro.nextreports.engine.querybuilder.sql.dialect.Dialect;
import ro.nextreports.engine.queryexec.Query;
import ro.nextreports.engine.queryexec.QueryExecutor;
import ro.nextreports.engine.queryexec.QueryParameter;
import ro.nextreports.engine.queryexec.QueryResult;
import ro.nextreports.engine.util.DialectUtil;
import ro.nextreports.engine.util.QueryUtil;
import ro.nextreports.engine.util.ReportUtil;

public class ReportRunner
implements Runner {
    public static final String PDF_FORMAT = "PDF";
    public static final String EXCEL_FORMAT = "EXCEL";
    public static final String EXCEL_XLSX_FORMAT = "EXCELX";
    public static final String HTML_FORMAT = "HTML";
    public static final String RTF_FORMAT = "RTF";
    public static final String DOCX_FORMAT = "DOCX";
    public static final String CSV_FORMAT = "CSV";
    public static final String TSV_FORMAT = "TSV";
    public static final String TXT_FORMAT = "TXT";
    public static final String XML_FORMAT = "XML";
    public static final String[] FORMATS = new String[]{"PDF", "EXCEL", "EXCELX", "HTML", "DOCX", "RTF", "CSV", "TSV", "TXT", "XML"};
    public static final String TABLE_FORMAT = "TABLE";
    public static final String ALARM_FORMAT = "ALARM";
    public static final String INDICATOR_FORMAT = "INDICATOR";
    public static final String DISPLAY_FORMAT = "DISPLAY";
    private Connection connection;
    private Dialect dialect;
    private Report report;
    private Map<String, Object> parameterValues = new HashMap<String, Object>();
    private String format;
    private int queryTimeout = 600;
    private ResultExporter exporter;
    private boolean cancelled = false;
    private boolean count = false;
    private List<ExporterEventListener> listenerList = new ArrayList<ExporterEventListener>();
    private String chartImagePath;
    private List<Alert> alerts;
    private boolean csv = false;
    private String templateName;
    private int sheetNumber;
    private boolean tableRawData = false;
    private String language;

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.setConnection(connection, false);
    }

    public void setConnection(Connection connection, boolean csv) {
        this.connection = connection;
        this.csv = csv;
        try {
            this.dialect = DialectUtil.getDialect(connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.report != null && this.report.getQuery() != null) {
            this.report.getQuery().setDialect(this.dialect);
        }
    }

    public Report getReport() {
        return this.report;
    }

    public void setReport(Report report) {
        this.report = report;
        if (this.report.getQuery() != null) {
            this.report.getQuery().setDialect(this.dialect);
        }
    }

    public Map<String, Object> getParameterValues() {
        return this.parameterValues;
    }

    public void setParameterValues(Map<String, Object> parameterValues) {
        this.parameterValues = parameterValues;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public boolean isCount() {
        return this.count;
    }

    public void setCount(boolean count) {
        this.count = count;
    }

    public void setAlerts(List<Alert> alerts) {
        if (this.format == null) {
            throw new IllegalStateException("You have to use setFormat with a valid output format before using setAlert!");
        }
        if (!(ALARM_FORMAT.equals(this.format) || INDICATOR_FORMAT.equals(this.format) || DISPLAY_FORMAT.equals(this.format))) {
            throw new IllegalStateException("You can use setAlert only for ALARM, INDICATOR or DISPLAY output formats!");
        }
        this.alerts = alerts;
    }

    @Override
    public boolean run() throws ReportRunnerException, NoDataFoundException {
        return this.run(null);
    }

    @Override
    public QueryResult executeQuery() throws ReportRunnerException, InterruptedException {
        if (this.connection == null) {
            throw new ReportRunnerException("Connection is null!");
        }
        if (this.report == null) {
            throw new ReportRunnerException("Report is null!");
        }
        String sql = this.getSql();
        Map<String, QueryParameter> parameters = this.getReportParameters();
        if (QueryUtil.restrictQueryExecution(sql)) {
            throw new ReportRunnerException("You are not allowed to execute queries that modify the database!");
        }
        if (QueryUtil.isProcedureCall(sql) && !QueryUtil.isValidProcedureCall(sql, this.dialect)) {
            throw new ReportRunnerException("Invalid procedure call! Must be of form 'call (${P1}, ?)'");
        }
        QueryResult queryResult = null;
        try {
            Query query = this.getQuery(sql);
            QueryExecutor executor = new QueryExecutor(query, parameters, this.parameterValues, this.connection, this.count, true, this.csv);
            executor.setMaxRows(0);
            executor.setTimeout(this.queryTimeout);
            queryResult = executor.execute();
            return queryResult;
        }
        catch (Exception e) {
            throw new ReportRunnerException(e);
        }
    }

    @Override
    public boolean run(OutputStream stream) throws ReportRunnerException, NoDataFoundException {
        if (!(stream != null || TABLE_FORMAT.equals(this.format) || ALARM_FORMAT.equals(this.format) || INDICATOR_FORMAT.equals(this.format) || DISPLAY_FORMAT.equals(this.format))) {
            throw new ReportRunnerException("OutputStream cannot be null!");
        }
        if (stream != null && TABLE_FORMAT.equals(this.format)) {
            throw new ReportRunnerException("TABLE FORMAT does not need an output stream. Use run() method instead.");
        }
        if (stream != null && ALARM_FORMAT.equals(this.format)) {
            throw new ReportRunnerException("ALARM FORMAT does not need an output stream. Use run() method instead.");
        }
        if (stream != null && INDICATOR_FORMAT.equals(this.format)) {
            throw new ReportRunnerException("INDICATOR FORMAT does not need an output stream. Use run() method instead.");
        }
        if (stream != null && DISPLAY_FORMAT.equals(this.format)) {
            throw new ReportRunnerException("DISPLAY FORMAT does not need an output stream. Use run() method instead.");
        }
        if (!this.formatAllowed(this.format)) {
            throw new ReportRunnerException("Unsupported format : " + this.format + " !");
        }
        try (QueryResult queryResult = null;){
            queryResult = this.executeQuery();
            String sql = this.getSql();
            ParametersBean bean = new ParametersBean(this.getQuery(sql), this.getReportParameters(), this.parameterValues);
            ReportLayout convertedLayout = ReportUtil.getDynamicReportLayout(this.connection, this.report.getLayout(), bean);
            boolean isProcedure = QueryUtil.isProcedureCall(sql);
            ExporterBean eb = new ExporterBean(this.connection, this.queryTimeout, queryResult, stream, convertedLayout, bean, this.report.getBaseName(), false, this.alerts, isProcedure);
            if (this.language != null) {
                eb.setLanguage(this.language);
            }
            this.createExporter(eb);
            boolean bl = this.exporter.export();
            return bl;
        }
    }

    private String getSql() throws ReportRunnerException {
        String sql = this.report.getSql();
        if (sql == null) {
            sql = this.report.getQuery().toString();
        }
        if (sql == null) {
            throw new ReportRunnerException("Report sql expression not found");
        }
        return sql;
    }

    private Query getQuery(String sql) {
        return new Query(sql);
    }

    private Map<String, QueryParameter> getReportParameters() {
        LinkedHashMap<String, QueryParameter> parameters = new LinkedHashMap<String, QueryParameter>();
        List<QueryParameter> parameterList = this.report.getParameters();
        if (parameterList != null) {
            for (QueryParameter param : parameterList) {
                parameters.put(param.getName(), param);
            }
        }
        return parameters;
    }

    private boolean formatAllowed(String format) {
        if (TABLE_FORMAT.equals(format) || ALARM_FORMAT.equals(format) || INDICATOR_FORMAT.equals(format) || DISPLAY_FORMAT.equals(format)) {
            return true;
        }
        for (String f : FORMATS) {
            if (!f.equals(format)) continue;
            return true;
        }
        return false;
    }

    private void createExporter(ExporterBean bean) {
        bean.setLanguage(this.language);
        if (TABLE_FORMAT.equals(this.format)) {
            bean.setConnection(null);
            bean.setQueryTimeout(0);
            bean.setOut(new ByteArrayOutputStream());
            bean.setReportTableExporterRawData(this.tableRawData);
            this.exporter = new ReportTableExporter(bean);
        } else if (ALARM_FORMAT.equals(this.format)) {
            bean.setConnection(null);
            bean.setQueryTimeout(0);
            bean.setOut(new ByteArrayOutputStream());
            this.exporter = new AlarmExporter(bean);
        } else if (INDICATOR_FORMAT.equals(this.format)) {
            bean.setConnection(null);
            bean.setQueryTimeout(0);
            bean.setOut(new ByteArrayOutputStream());
            this.exporter = new IndicatorExporter(bean);
        } else if (DISPLAY_FORMAT.equals(this.format)) {
            bean.setConnection(null);
            bean.setQueryTimeout(0);
            bean.setOut(new ByteArrayOutputStream());
            this.exporter = new DisplayExporter(bean);
        } else {
            this.exporter = PDF_FORMAT.equals(this.format) ? new PdfExporter(bean) : (DOCX_FORMAT.equals(this.format) ? new DocxExporter(bean) : (CSV_FORMAT.equals(this.format) ? new CsvExporter(bean) : (TSV_FORMAT.equals(this.format) ? new TsvExporter(bean) : (TXT_FORMAT.equals(this.format) ? new TxtExporter(bean) : (EXCEL_FORMAT.equals(this.format) ? new XlsExporter(bean) : (EXCEL_XLSX_FORMAT.equals(this.format) ? new XlsxExporter(bean) : (RTF_FORMAT.equals(this.format) ? new RtfExporter(bean) : (XML_FORMAT.equals(this.format) ? new XmlExporter(bean) : new HtmlExporter(bean)))))))));
        }
        this.exporter.setDocumentTitle(this.report.getBaseName());
        for (ExporterEventListener listener : this.listenerList) {
            this.exporter.addExporterEventListener(listener);
        }
        this.exporter.setImageChartPath(this.getChartImagePath());
    }

    public void stop() {
        if (this.exporter != null) {
            this.cancelled = true;
            this.exporter.setStopExport(true);
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void addExporterEventListener(ExporterEventListener listener) {
        this.listenerList.add(listener);
    }

    public void removeExporterEventListener(ExporterEventListener listener) {
        this.listenerList.remove(listener);
        if (this.exporter != null) {
            this.exporter.removeExporterEventListener(listener);
        }
    }

    @Override
    public TableData getTableData() {
        if (TABLE_FORMAT.equals(this.format)) {
            TableExporter tableExporter = (TableExporter)((Object)this.exporter);
            return tableExporter.getTableData();
        }
        return new TableData();
    }

    @Override
    public AlarmData getAlarmData() {
        if (ALARM_FORMAT.equals(this.format)) {
            AlarmExporter alarmExporter = (AlarmExporter)this.exporter;
            return alarmExporter.getData();
        }
        return new AlarmData();
    }

    @Override
    public IndicatorData getIndicatorData() {
        if (INDICATOR_FORMAT.equals(this.format)) {
            IndicatorExporter ie = (IndicatorExporter)this.exporter;
            return ie.getData();
        }
        return new IndicatorData();
    }

    public DisplayData getDisplayData() {
        if (DISPLAY_FORMAT.equals(this.format)) {
            DisplayExporter de = (DisplayExporter)this.exporter;
            return de.getData();
        }
        return new DisplayData();
    }

    public String getChartImagePath() {
        return this.chartImagePath;
    }

    public void setChartImagePath(String chartImagePath) {
        this.chartImagePath = chartImagePath;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public int getSheetNumber() {
        return this.sheetNumber;
    }

    public void setSheetNumber(int sheetNumber) {
        this.sheetNumber = sheetNumber;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public boolean isTableRawData() {
        return this.tableRawData;
    }

    public void setTableRawData(boolean tableRawData) {
        this.tableRawData = tableRawData;
    }
}

