/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.awt.Color;
import java.awt.Font;
import ro.nextreports.engine.Report;
import ro.nextreports.engine.ReportGroup;
import ro.nextreports.engine.band.Band;
import ro.nextreports.engine.band.BandElement;
import ro.nextreports.engine.band.BarcodeBandElement;
import ro.nextreports.engine.band.Border;
import ro.nextreports.engine.band.ChartBandElement;
import ro.nextreports.engine.band.ColumnBandElement;
import ro.nextreports.engine.band.ExpressionBandElement;
import ro.nextreports.engine.band.ForReportBandElement;
import ro.nextreports.engine.band.FunctionBandElement;
import ro.nextreports.engine.band.HyperlinkBandElement;
import ro.nextreports.engine.band.ImageBandElement;
import ro.nextreports.engine.band.ImageColumnBandElement;
import ro.nextreports.engine.band.ParameterBandElement;
import ro.nextreports.engine.band.ReportBandElement;
import ro.nextreports.engine.band.RowElement;
import ro.nextreports.engine.band.VariableBandElement;
import ro.nextreports.engine.chart.Chart;
import ro.nextreports.engine.chart.ChartTitle;
import ro.nextreports.engine.chart.ChartType;
import ro.nextreports.engine.condition.BandElementCondition;
import ro.nextreports.engine.i18n.I18nLanguage;
import ro.nextreports.engine.i18n.I18nString;
import ro.nextreports.engine.persistence.TablePersistentObject;
import ro.nextreports.engine.querybuilder.MyRow;
import ro.nextreports.engine.querybuilder.sql.Column;
import ro.nextreports.engine.querybuilder.sql.ExpressionColumn;
import ro.nextreports.engine.querybuilder.sql.GroupByFunctionColumn;
import ro.nextreports.engine.querybuilder.sql.JoinCriteria;
import ro.nextreports.engine.querybuilder.sql.MatchCriteria;
import ro.nextreports.engine.querybuilder.sql.Order;
import ro.nextreports.engine.querybuilder.sql.WildCardColumn;
import ro.nextreports.engine.queryexec.QueryParameter;
import ro.nextreports.engine.template.ChartTemplate;
import ro.nextreports.engine.template.ReportTemplate;
import ro.nextreports.engine.util.xstream.FontConverter;

public class XStreamFactory {
    public static XStream createXStream() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        xstream.setMode(1001);
        xstream.registerConverter((Converter)new FontConverter());
        xstream.alias("report", Report.class);
        xstream.alias("chart", Chart.class);
        xstream.useAttributeFor(Report.class, "version");
        xstream.useAttributeFor(Chart.class, "version");
        xstream = XStreamFactory.createQueryXStream(xstream);
        xstream = XStreamFactory.createReportXStream(xstream);
        xstream = XStreamFactory.createChartXStream(xstream);
        return xstream;
    }

    public static XStream createTemplateXStream() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        xstream.setMode(1001);
        xstream.registerConverter((Converter)new FontConverter());
        xstream.alias("template", ReportTemplate.class);
        xstream.useAttributeFor(ReportTemplate.class, "version");
        xstream.alias("band-element", BandElement.class);
        xstream.alias("column-band-element", ColumnBandElement.class);
        return xstream;
    }

    public static XStream createChartTemplateXStream() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        xstream.setMode(1001);
        xstream.registerConverter((Converter)new FontConverter());
        xstream.alias("chart-template", ChartTemplate.class);
        xstream.useAttributeFor(ChartTemplate.class, "version");
        xstream.alias("color", Color.class);
        return xstream;
    }

    private static XStream createQueryXStream(XStream xstream) {
        xstream.alias("column", Column.class);
        xstream.alias("join-criteria", JoinCriteria.class);
        xstream.alias("match-criteria", MatchCriteria.class);
        xstream.alias("parameter", QueryParameter.class);
        xstream.alias("designer-table", TablePersistentObject.class);
        xstream.alias("order", Order.class);
        xstream.alias("row", MyRow.class);
        xstream.alias("group-by-column", GroupByFunctionColumn.class);
        xstream.alias("expression-column", ExpressionColumn.class);
        xstream.alias("wildcard-column", WildCardColumn.class);
        return xstream;
    }

    private static XStream createReportXStream(XStream xstream) {
        xstream.alias("band-element", BandElement.class);
        xstream.alias("row-element", RowElement.class);
        xstream.alias("var-band-element", VariableBandElement.class);
        xstream.alias("param-band-element", ParameterBandElement.class);
        xstream.alias("col-band-element", ColumnBandElement.class);
        xstream.alias("exp-band-element", ExpressionBandElement.class);
        xstream.alias("func-band-element", FunctionBandElement.class);
        xstream.alias("image-band-element", ImageBandElement.class);
        xstream.alias("image-col-band-element", ImageColumnBandElement.class);
        xstream.alias("chart-band-element", ChartBandElement.class);
        xstream.alias("report-band-element", ReportBandElement.class);
        xstream.alias("for-report-band-element", ForReportBandElement.class);
        xstream.alias("hyperlink-band-element", HyperlinkBandElement.class);
        xstream.alias("barcode-band-element", BarcodeBandElement.class);
        xstream.alias("condition", BandElementCondition.class);
        xstream.alias("border", Border.class);
        xstream.alias("font", Font.class);
        xstream.alias("color", Color.class);
        xstream.alias("group", ReportGroup.class);
        xstream.alias("band", Band.class);
        xstream.alias("language", I18nLanguage.class);
        xstream.alias("i18nstring", I18nString.class);
        return xstream;
    }

    private static XStream createChartXStream(XStream xstream) {
        xstream.alias("chart-title", ChartTitle.class);
        xstream.alias("chart-type", ChartType.class);
        return xstream;
    }
}

