/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.band;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import ro.nextreports.engine.band.BandElement;
import ro.nextreports.engine.band.RowElement;
import ro.nextreports.engine.event.BandEvent;
import ro.nextreports.engine.event.BandListener;

public class Band
implements Serializable {
    private static final long serialVersionUID = 8698695353980903707L;
    protected String name;
    protected Vector<RowElement> rows;
    protected transient EventListenerList listenerList;

    public Band(String name) {
        this(name, 0, 0);
    }

    public Band(String name, int rowNo, int columnNo) {
        this.name = name;
        this.initListenerList();
        this.rows = new Vector();
        this.rows.setSize(rowNo);
        for (RowElement row : this.rows) {
            row.getElements().setSize(columnNo);
        }
    }

    public void initListenerList() {
        this.listenerList = new EventListenerList();
    }

    public String getName() {
        return this.name;
    }

    public List<RowElement> getElements() {
        return new ArrayList<RowElement>(this.rows);
    }

    public void setElements(List<List<BandElement>> elements) {
        if (elements == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        this.rows = new Vector();
        for (List<BandElement> row : elements) {
            this.rows.add(new RowElement(row));
        }
        this.fireBandChanged();
    }

    public int getColumnCount() {
        return this.getRowCount() == 0 ? 0 : this.getRow(0).size();
    }

    public void setColumnCount(int columnCount) {
        for (RowElement row : this.rows) {
            row.getElements().setSize(columnCount);
        }
    }

    public int getRowCount() {
        return this.rows == null ? 0 : this.rows.size();
    }

    public List<BandElement> getRow(int index) {
        return this.rows.get(index).getElements();
    }

    public void insertRow(int index) {
        Vector<BandElement> row = new Vector<BandElement>();
        row.setSize(this.getColumnCount());
        this.insertRow(index, row);
    }

    public void insertFirstRow(int index, int cols) {
        Vector<BandElement> row = new Vector<BandElement>();
        row.setSize(cols);
        this.insertRow(index, row);
    }

    public void insertRow(int index, List<BandElement> row) {
        this.rows.add(index, new RowElement(row));
    }

    public void removeRow(int index) {
        this.rows.remove(index);
    }

    public List<BandElement> getColumn(int index) {
        ArrayList<BandElement> column = new ArrayList<BandElement>();
        for (RowElement row : this.rows) {
            column.add(row.getElements().get(index));
        }
        return column;
    }

    public void insertColumn(int index) {
        Vector<BandElement> column = new Vector<BandElement>();
        column.setSize(this.getRowCount());
        this.insertColumn(index, column);
    }

    public void insertColumn(int index, List<BandElement> column) {
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.getRow(i).add(index, column.get(i));
        }
    }

    public void removeColumn(int index) {
        for (RowElement row : this.rows) {
            row.getElements().remove(index);
        }
    }

    public BandElement getElementAt(int row, int column) {
        return this.getRow(row).get(column);
    }

    public void setElementAt(BandElement element, int row, int column) {
        this.getRow(row).set(column, element);
        this.fireBandChanged(new BandEvent(this, row, column));
    }

    public void clear() {
        this.setElements(new ArrayList<List<BandElement>>());
    }

    public void addBandListener(BandListener listener) {
        this.listenerList.add(BandListener.class, listener);
    }

    public void removeBandListener(BandListener listener) {
        this.listenerList.remove(BandListener.class, listener);
    }

    public BandListener[] getBandListeners() {
        return (BandListener[])this.listenerList.getListeners(BandListener.class);
    }

    public void fireBandChanged() {
        this.fireBandChanged(new BandEvent(this, -1, -2, 1));
    }

    protected void fireBandChanged(BandEvent event) {
        BandListener[] list = this.getBandListeners();
        for (int i = 0; i < list.length; ++i) {
            BandListener listener = list[i];
            listener.bandChanged(event);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Band band = (Band)o;
        if (this.rows != null ? !this.rows.equals(band.rows) : band.rows != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(band.name) : band.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.rows != null ? this.rows.hashCode() : 0);
        return result;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.rows == null) {
            this.rows = new Vector();
        }
        if (this.listenerList == null) {
            this.initListenerList();
        }
        return this;
    }
}

