/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.band;

import ro.nextreports.engine.band.ImageBandElement;

public class BarcodeBandElement
extends ImageBandElement {
    public static int EAN13 = 1;
    public static int EAN8 = 2;
    public static int UPCA = 3;
    public static int UPCE = 4;
    public static int SUPP2 = 5;
    public static int SUPP5 = 6;
    public static int CODE128 = 9;
    public static int CODE128_RAW = 11;
    public static int INTER25 = 100;
    public static int CODE39 = 105;
    public static int CODE39EXT = 106;
    public static int CODABAR = 110;
    public static int PDF417 = 120;
    public static int DATAMATRIX = 125;
    public static int QRCODE = 130;
    private int barcodeType;
    private String value;
    private boolean isColumn;

    public BarcodeBandElement(int barcodeType, String value, boolean isColumn) {
        super("");
        this.text = "$B(" + value + ")";
        this.barcodeType = barcodeType;
        this.value = value;
        this.isColumn = isColumn;
    }

    public int getBarcodeType() {
        return this.barcodeType;
    }

    public void setBarcodeType(int barcodeType) {
        this.barcodeType = barcodeType;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        this.setText("$B(" + value + ")");
    }

    public boolean isColumn() {
        return this.isColumn;
    }

    public void setColumn(boolean isColumn) {
        this.isColumn = isColumn;
    }

    @Override
    public void setImage(String image) {
        this.image = image;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.barcodeType;
        result = 31 * result + (this.isColumn ? 1231 : 1237);
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BarcodeBandElement other = (BarcodeBandElement)obj;
        if (this.barcodeType != other.barcodeType) {
            return false;
        }
        if (this.isColumn != other.isColumn) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public static boolean isEANFamily(int type) {
        return type == EAN13 || type == EAN8 || type == UPCA || type == UPCE || type == SUPP2 || type == SUPP5;
    }
}

