/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.band;

import java.io.Serializable;

public class PaperSize
implements Serializable {
    private static final long serialVersionUID = 1213104593379132110L;
    public static final String UNIT_IN = "in";
    public static final String UNIT_CM = "cm";
    public static final PaperSize A4 = new PaperSize("cm", 21.0f, 29.7f);
    private String unit;
    private float width;
    private float height;

    public PaperSize(String unit, float width, float height) {
        this.unit = unit;
        this.width = width;
        this.height = height;
    }

    public String getUnit() {
        return this.unit;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.height);
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        result = 31 * result + Float.floatToIntBits(this.width);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PaperSize other = (PaperSize)obj;
        if (Float.floatToIntBits(this.height) != Float.floatToIntBits(other.height)) {
            return false;
        }
        if (this.unit == null ? other.unit != null : !this.unit.equals(other.unit)) {
            return false;
        }
        return Float.floatToIntBits(this.width) == Float.floatToIntBits(other.width);
    }

    public String toString() {
        return this.width + " x " + this.height + " (" + this.unit + ")";
    }

    public int getWidthPoints() {
        return this.getPoints(this.width);
    }

    public int getHeightPoints() {
        return this.getPoints(this.height);
    }

    private int getPoints(float dim) {
        int points = UNIT_CM.equals(this.unit) ? (int)((double)(dim * 72.0f) / 2.54) : (int)(dim * 72.0f);
        return points;
    }
}

