/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.chart;

import java.awt.Color;
import java.awt.Font;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import ro.nextreports.engine.Report;
import ro.nextreports.engine.chart.ChartTitle;
import ro.nextreports.engine.chart.ChartType;
import ro.nextreports.engine.i18n.I18nLanguage;

public class Chart
implements Serializable {
    private static final long serialVersionUID = -3455484134680121149L;
    public static final transient byte HORIZONTAL = 1;
    public static final transient byte VERTICAL = 2;
    public static final transient byte DIAGONAL = 3;
    public static final transient byte HALF_DIAGONAL = 4;
    public static final transient byte NONE_TRANSPARENCY = 1;
    public static final transient byte LOW_TRANSPARENCY = 2;
    public static final transient byte AVG_TRANSPARENCY = 3;
    public static final transient byte HIGH_TRANSPARENCY = 4;
    public static final transient byte LINE_STYLE_LINE = 1;
    public static final transient byte LINE_STYLE_DOT = 2;
    public static final transient byte LINE_STYLE_DASH = 3;
    private String name;
    private String version;
    private ChartTitle title = new ChartTitle("");
    private ChartType type;
    private Report report;
    private Color background;
    private List<Color> foregrounds;
    private String xColumn;
    private List<String> yColumns;
    private List<String> yColumnsLegends;
    private String yColumnQuery;
    private byte xorientation = 1;
    private String xPattern;
    private Color xColor;
    private Color yColor;
    private Color xAxisColor;
    private Color yAxisColor;
    private byte transparency;
    private ChartTitle xLegend = new ChartTitle("");
    private ChartTitle yLegend = new ChartTitle("");
    private ChartTitle yDualLegend = new ChartTitle("");
    private String yFunction;
    private Color xGridColor;
    private Color yGridColor;
    private Boolean xShowGrid;
    private Boolean yShowGrid;
    private Boolean xShowLabel;
    private Boolean yShowLabel;
    private Boolean startingFromZero;
    private Boolean showYValuesOnChart;
    private Boolean showDualAxis;
    private Integer y2SeriesCount = 1;
    private String yTooltipPattern;
    private String tooltipMessage;
    private Font font;
    private Font xLabelFont;
    private Font yLabelFont;
    private List<String> i18nkeys;
    private List<I18nLanguage> languages;
    private byte styleGridX = 1;
    private byte styleGridY = 1;
    public static transient Color[] COLORS = new Color[]{new Color(0, 0, 204), Color.RED, new Color(0, 204, 102), new Color(153, 0, 153), new Color(255, 200, 50), new Color(0, 200, 200), new Color(240, 240, 17), new Color(131, 76, 20), new Color(120, 128, 13), new Color(230, 80, 200)};

    public Chart() {
        this.background = Color.WHITE;
        this.foregrounds = new ArrayList<Color>();
        this.transparency = (byte)3;
        this.xColor = Color.BLACK;
        this.yColor = Color.BLACK;
        this.xAxisColor = Color.BLACK;
        this.yAxisColor = Color.BLACK;
        this.xShowGrid = Boolean.TRUE;
        this.yShowGrid = Boolean.TRUE;
        this.xShowLabel = Boolean.TRUE;
        this.yShowLabel = Boolean.TRUE;
        this.showYValuesOnChart = Boolean.FALSE;
        this.showDualAxis = Boolean.FALSE;
        this.startingFromZero = Boolean.FALSE;
        this.foregrounds.addAll(Arrays.asList(COLORS));
        this.setType(new ChartType(1, 10));
    }

    public Chart(ChartType type, Report report) {
        this();
        this.setType(type);
        this.setReport(report);
    }

    public ChartType getType() {
        return this.type;
    }

    public void setType(ChartType type) {
        if (type == null) {
            throw new IllegalArgumentException("Chart type cannot be null.");
        }
        this.type = type;
    }

    public Report getReport() {
        return this.report;
    }

    public void setReport(Report report) {
        if (report == null) {
            throw new IllegalArgumentException("Report cannot be null.");
        }
        this.report = report;
    }

    public ChartTitle getTitle() {
        return this.title;
    }

    public void setTitle(ChartTitle title) {
        this.title = title;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public List<Color> getForegrounds() {
        if (this.foregrounds.size() == 6) {
            this.foregrounds.add(new Color(240, 240, 17));
            this.foregrounds.add(new Color(131, 76, 20));
            this.foregrounds.add(new Color(120, 128, 13));
            this.foregrounds.add(new Color(230, 80, 200));
        }
        return this.foregrounds;
    }

    public void setForegrounds(List<Color> foregrounds) {
        this.foregrounds = foregrounds;
    }

    public String getXColumn() {
        return this.xColumn;
    }

    public void setXColumn(String xColumn) {
        this.xColumn = xColumn;
    }

    public List<String> getYColumns() {
        if (this.yColumns == null) {
            this.yColumns = new ArrayList<String>();
        }
        return this.yColumns;
    }

    public void setYColumns(List<String> yColumns) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : yColumns) {
            if (s == null) continue;
            list.add(s);
        }
        this.yColumns = list;
    }

    public String getYColumnQuery() {
        return this.yColumnQuery;
    }

    public void setYColumnQuery(String yColumnQuery) {
        this.yColumnQuery = yColumnQuery;
    }

    public List<String> getYColumnsLegends() {
        if (this.yColumnsLegends == null) {
            this.yColumnsLegends = new ArrayList<String>();
        }
        return this.yColumnsLegends;
    }

    public void setYColumnsLegends(List<String> yColumnsLegends) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : yColumnsLegends) {
            if (s == null) continue;
            list.add(s);
        }
        this.yColumnsLegends = list;
    }

    public String getName() {
        return this.name;
    }

    public String getBaseName() {
        if (this.name.endsWith(".chart")) {
            return this.name.substring(0, this.name.length() - 6);
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public byte getXorientation() {
        return this.xorientation;
    }

    public void setXorientation(byte xorientation) {
        this.xorientation = xorientation;
    }

    public Color getXColor() {
        return this.xColor;
    }

    public void setXColor(Color xColor) {
        this.xColor = xColor;
    }

    public Color getYColor() {
        return this.yColor;
    }

    public void setYColor(Color yColor) {
        this.yColor = yColor;
    }

    public Color getxAxisColor() {
        if (this.xAxisColor == null) {
            this.xAxisColor = Color.BLACK;
        }
        return this.xAxisColor;
    }

    public void setxAxisColor(Color xAxisColor) {
        this.xAxisColor = xAxisColor;
    }

    public Color getyAxisColor() {
        if (this.yAxisColor == null) {
            this.yAxisColor = Color.BLACK;
        }
        return this.yAxisColor;
    }

    public void setyAxisColor(Color yAxisColor) {
        this.yAxisColor = yAxisColor;
    }

    public byte getTransparency() {
        return this.transparency;
    }

    public void setTransparency(byte transparency) {
        this.transparency = transparency;
    }

    public String getTooltipMessage() {
        return this.tooltipMessage;
    }

    public void setTooltipMessage(String tooltipMessage) {
        this.tooltipMessage = tooltipMessage;
    }

    public ChartTitle getXLegend() {
        return this.xLegend;
    }

    public void setXLegend(ChartTitle xLegend) {
        this.xLegend = xLegend;
    }

    public ChartTitle getYLegend() {
        return this.yLegend;
    }

    public void setYLegend(ChartTitle yLegend) {
        this.yLegend = yLegend;
    }

    public ChartTitle getyDualLegend() {
        return this.yDualLegend;
    }

    public void setyDualLegend(ChartTitle yDualLegend) {
        this.yDualLegend = yDualLegend;
    }

    public String getYFunction() {
        return this.yFunction;
    }

    public void setYFunction(String yFunction) {
        this.yFunction = yFunction;
    }

    public String getXPattern() {
        return this.xPattern;
    }

    public void setXPattern(String xPattern) {
        this.xPattern = xPattern;
    }

    public Color getXGridColor() {
        return this.xGridColor;
    }

    public void setXGridColor(Color xGridColor) {
        this.xGridColor = xGridColor;
    }

    public Color getYGridColor() {
        return this.yGridColor;
    }

    public void setYGridColor(Color yGridColor) {
        this.yGridColor = yGridColor;
    }

    public Boolean getXShowGrid() {
        return this.xShowGrid;
    }

    public void setXShowGrid(Boolean xShowGrid) {
        this.xShowGrid = xShowGrid;
    }

    public Boolean getYShowGrid() {
        return this.yShowGrid;
    }

    public void setYShowGrid(Boolean yShowGrid) {
        this.yShowGrid = yShowGrid;
    }

    public Boolean getXShowLabel() {
        return this.xShowLabel;
    }

    public void setXShowLabel(Boolean xShowLabel) {
        this.xShowLabel = xShowLabel;
    }

    public Boolean getYShowLabel() {
        return this.yShowLabel;
    }

    public void setYShowLabel(Boolean yShowLabel) {
        this.yShowLabel = yShowLabel;
    }

    public Boolean getShowYValuesOnChart() {
        return this.showYValuesOnChart;
    }

    public void setShowYValuesOnChart(Boolean showYValuesOnChart) {
        this.showYValuesOnChart = showYValuesOnChart;
    }

    public Boolean getShowDualAxis() {
        return this.showDualAxis;
    }

    public void setShowDualAxis(Boolean showDualAxis) {
        this.showDualAxis = showDualAxis;
    }

    public Integer getY2SeriesCount() {
        return this.y2SeriesCount;
    }

    public void setY2SeriesCount(Integer y2SeriesCount) {
        this.y2SeriesCount = y2SeriesCount;
    }

    public byte getStyleGridX() {
        return this.styleGridX;
    }

    public void setStyleGridX(byte styleGridX) {
        this.styleGridX = styleGridX;
    }

    public byte getStyleGridY() {
        return this.styleGridY;
    }

    public void setStyleGridY(byte styleGridY) {
        this.styleGridY = styleGridY;
    }

    public Boolean getStartingFromZero() {
        return this.startingFromZero;
    }

    public void setStartingFromZero(Boolean startingFromZero) {
        this.startingFromZero = startingFromZero;
    }

    public String getYTooltipPattern() {
        return this.yTooltipPattern;
    }

    public void setYTooltipPattern(String yTooltipPattern) {
        this.yTooltipPattern = yTooltipPattern;
    }

    public Font getFont() {
        if (this.font == null) {
            return this.getDefaultFont();
        }
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getXLabelFont() {
        if (this.xLabelFont == null) {
            return this.getDefaultFont();
        }
        return this.xLabelFont;
    }

    public void setXLabelFont(Font xLabelFont) {
        this.xLabelFont = xLabelFont;
    }

    public Font getYLabelFont() {
        if (this.yLabelFont == null) {
            return this.getDefaultFont();
        }
        return this.yLabelFont;
    }

    public void setYLabelFont(Font yLabelFont) {
        this.yLabelFont = yLabelFont;
    }

    private Font getDefaultFont() {
        return new Font("SansSerif", 0, 12);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Chart chart = (Chart)o;
        if (this.transparency != chart.transparency) {
            return false;
        }
        if (this.xorientation != chart.xorientation) {
            return false;
        }
        if (this.background != null ? !this.background.equals(chart.background) : chart.background != null) {
            return false;
        }
        if (this.foregrounds != null ? !this.foregrounds.equals(chart.foregrounds) : chart.foregrounds != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(chart.name) : chart.name != null) {
            return false;
        }
        if (this.report != null ? !this.report.equals(chart.report) : chart.report != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(chart.title) : chart.title != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(chart.type) : chart.type != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(chart.version) : chart.version != null) {
            return false;
        }
        if (this.xColor != null ? !this.xColor.equals(chart.xColor) : chart.xColor != null) {
            return false;
        }
        if (this.xColumn != null ? !this.xColumn.equals(chart.xColumn) : chart.xColumn != null) {
            return false;
        }
        if (this.xGridColor != null ? !this.xGridColor.equals(chart.xGridColor) : chart.xGridColor != null) {
            return false;
        }
        if (this.xLegend != null ? !this.xLegend.equals(chart.xLegend) : chart.xLegend != null) {
            return false;
        }
        if (this.xPattern != null ? !this.xPattern.equals(chart.xPattern) : chart.xPattern != null) {
            return false;
        }
        if (this.xShowGrid != null ? !this.xShowGrid.equals(chart.xShowGrid) : chart.xShowGrid != null) {
            return false;
        }
        if (this.xShowLabel != null ? !this.xShowLabel.equals(chart.xShowLabel) : chart.xShowLabel != null) {
            return false;
        }
        if (this.startingFromZero != null ? !this.startingFromZero.equals(chart.startingFromZero) : chart.startingFromZero != null) {
            return false;
        }
        if (this.yColor != null ? !this.yColor.equals(chart.yColor) : chart.yColor != null) {
            return false;
        }
        if (this.yColumns != null ? !this.yColumns.equals(chart.yColumns) : chart.yColumns != null) {
            return false;
        }
        if (this.yColumnsLegends != null ? !this.yColumnsLegends.equals(chart.yColumnsLegends) : chart.yColumnsLegends != null) {
            return false;
        }
        if (this.yColumnQuery != null ? !this.yColumnQuery.equals(chart.yColumnQuery) : chart.yColumnQuery != null) {
            return false;
        }
        if (this.yFunction != null ? !this.yFunction.equals(chart.yFunction) : chart.yFunction != null) {
            return false;
        }
        if (this.yGridColor != null ? !this.yGridColor.equals(chart.yGridColor) : chart.yGridColor != null) {
            return false;
        }
        if (this.yLegend != null ? !this.yLegend.equals(chart.yLegend) : chart.yLegend != null) {
            return false;
        }
        if (this.yDualLegend != null ? !this.yDualLegend.equals(chart.yDualLegend) : chart.yDualLegend != null) {
            return false;
        }
        if (this.yShowGrid != null ? !this.yShowGrid.equals(chart.yShowGrid) : chart.yShowGrid != null) {
            return false;
        }
        if (this.yShowLabel != null ? !this.yShowLabel.equals(chart.yShowLabel) : chart.yShowLabel != null) {
            return false;
        }
        if (this.showYValuesOnChart != null ? !this.showYValuesOnChart.equals(chart.showYValuesOnChart) : chart.showYValuesOnChart != null) {
            return false;
        }
        if (this.showDualAxis != null ? !this.showDualAxis.equals(chart.showDualAxis) : chart.showDualAxis != null) {
            return false;
        }
        if (this.y2SeriesCount != null ? !this.y2SeriesCount.equals(chart.y2SeriesCount) : chart.y2SeriesCount != null) {
            return false;
        }
        if (this.yTooltipPattern != null ? !this.yTooltipPattern.equals(chart.yTooltipPattern) : chart.yTooltipPattern != null) {
            return false;
        }
        if (this.font != null ? !this.font.equals(chart.font) : chart.font != null) {
            return false;
        }
        if (this.xLabelFont != null ? !this.xLabelFont.equals(chart.xLabelFont) : chart.xLabelFont != null) {
            return false;
        }
        if (this.yLabelFont != null ? !this.yLabelFont.equals(chart.yLabelFont) : chart.yLabelFont != null) {
            return false;
        }
        if (this.xAxisColor != null ? !this.xAxisColor.equals(chart.xAxisColor) : chart.xAxisColor != null) {
            return false;
        }
        if (this.yAxisColor != null ? !this.yAxisColor.equals(chart.yAxisColor) : chart.yAxisColor != null) {
            return false;
        }
        if (this.tooltipMessage != null ? !this.tooltipMessage.equals(chart.tooltipMessage) : chart.tooltipMessage != null) {
            return false;
        }
        if (this.i18nkeys != null ? !this.i18nkeys.equals(chart.i18nkeys) : chart.i18nkeys != null) {
            return false;
        }
        if (this.languages != null ? !this.languages.equals(chart.languages) : chart.languages != null) {
            return false;
        }
        if (this.styleGridX != chart.styleGridX) {
            return false;
        }
        return this.styleGridY == chart.styleGridY;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.report != null ? this.report.hashCode() : 0);
        result = 31 * result + (this.background != null ? this.background.hashCode() : 0);
        result = 31 * result + (this.foregrounds != null ? this.foregrounds.hashCode() : 0);
        result = 31 * result + (this.xColumn != null ? this.xColumn.hashCode() : 0);
        result = 31 * result + (this.yColumns != null ? this.yColumns.hashCode() : 0);
        result = 31 * result + (this.yColumnsLegends != null ? this.yColumnsLegends.hashCode() : 0);
        result = 31 * result + (this.yColumnQuery != null ? this.yColumnQuery.hashCode() : 0);
        result = 31 * result + this.xorientation;
        result = 31 * result + (this.xPattern != null ? this.xPattern.hashCode() : 0);
        result = 31 * result + (this.xColor != null ? this.xColor.hashCode() : 0);
        result = 31 * result + (this.yColor != null ? this.yColor.hashCode() : 0);
        result = 31 * result + (this.xAxisColor != null ? this.xAxisColor.hashCode() : 0);
        result = 31 * result + (this.yAxisColor != null ? this.yAxisColor.hashCode() : 0);
        result = 31 * result + this.transparency;
        result = 31 * result + (this.xLegend != null ? this.xLegend.hashCode() : 0);
        result = 31 * result + (this.yLegend != null ? this.yLegend.hashCode() : 0);
        result = 31 * result + (this.yDualLegend != null ? this.yDualLegend.hashCode() : 0);
        result = 31 * result + (this.yFunction != null ? this.yFunction.hashCode() : 0);
        result = 31 * result + (this.xGridColor != null ? this.xGridColor.hashCode() : 0);
        result = 31 * result + (this.yGridColor != null ? this.yGridColor.hashCode() : 0);
        result = 31 * result + (this.xShowGrid != null ? this.xShowGrid.hashCode() : 0);
        result = 31 * result + (this.startingFromZero != null ? this.startingFromZero.hashCode() : 0);
        result = 31 * result + (this.yShowGrid != null ? this.yShowGrid.hashCode() : 0);
        result = 31 * result + (this.xShowLabel != null ? this.xShowLabel.hashCode() : 0);
        result = 31 * result + (this.yShowLabel != null ? this.yShowLabel.hashCode() : 0);
        result = 31 * result + (this.showYValuesOnChart != null ? this.showYValuesOnChart.hashCode() : 0);
        result = 31 * result + (this.showDualAxis != null ? this.showDualAxis.hashCode() : 0);
        result = 31 * result + (this.y2SeriesCount != null ? this.y2SeriesCount.hashCode() : 0);
        result = 31 * result + (this.yTooltipPattern != null ? this.yTooltipPattern.hashCode() : 0);
        result = 31 * result + (this.font != null ? this.font.hashCode() : 0);
        result = 31 * result + (this.xLabelFont != null ? this.xLabelFont.hashCode() : 0);
        result = 31 * result + (this.yLabelFont != null ? this.yLabelFont.hashCode() : 0);
        result = 31 * result + (this.tooltipMessage != null ? this.tooltipMessage.hashCode() : 0);
        result = 31 * result + (this.i18nkeys != null ? this.i18nkeys.hashCode() : 0);
        result = 31 * result + (this.languages != null ? this.languages.hashCode() : 0);
        result = 31 * result + this.styleGridX;
        result = 31 * result + this.styleGridY;
        return result;
    }

    public String toString() {
        return "Chart{name='" + this.name + '\'' + ", version='" + this.version + '\'' + ", title=" + this.title + ", type=" + this.type + ", report=" + this.report + ", background=" + this.background + ", foregrounds=" + this.foregrounds + ", xColumn='" + this.xColumn + '\'' + ", yColumns='" + this.yColumns + '\'' + ", yColumnsLegends='" + this.yColumnsLegends + '\'' + ", yColumnQuery='" + this.yColumnQuery + '\'' + ", xorientation=" + this.xorientation + ", xPattern='" + this.xPattern + '\'' + ", xColor=" + this.xColor + ", yColor=" + this.yColor + ", xAxisColor=" + this.xAxisColor + ", yAxisColor=" + this.yAxisColor + ", transparency=" + this.transparency + ", xLegend=" + this.xLegend + ", yLegend=" + this.yLegend + ", yDualLegend=" + this.yDualLegend + ", yFunction='" + this.yFunction + '\'' + ", xGridColor=" + this.xGridColor + ", yGridColor=" + this.yGridColor + ", xShowGrid=" + this.xShowGrid + ", yShowGrid=" + this.yShowGrid + ", xShowLabel=" + this.xShowLabel + ", yShowLabel=" + this.yShowLabel + ", styleGridX=" + this.styleGridX + ", styleGridY=" + this.styleGridY + ", showYValuesOnChart=" + this.showYValuesOnChart + ", showDualAxis=" + this.showDualAxis + ", y2SeriesCount=" + this.y2SeriesCount + ", tooltipMessage=" + this.tooltipMessage + ", yTooltipPattern=" + this.yTooltipPattern + ", startingFromZero=" + this.startingFromZero + ", font=" + this.font + ", xLabelFont=" + this.xLabelFont + ", yLabelFont=" + this.yLabelFont + ", i18nkeys='" + this.i18nkeys + '\'' + ", languages='" + this.languages + '\'' + '}';
    }

    public List<String> getI18nkeys() {
        if (this.i18nkeys == null) {
            return new ArrayList<String>();
        }
        Collections.sort(this.i18nkeys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Collator.getInstance().compare(o1, o2);
            }
        });
        return this.i18nkeys;
    }

    public void setI18nkeys(List<String> i18nkeys) {
        this.i18nkeys = i18nkeys;
    }

    public List<I18nLanguage> getLanguages() {
        return this.languages;
    }

    public void setLanguages(List<I18nLanguage> languages) {
        this.languages = languages;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.i18nkeys == null) {
            this.i18nkeys = new ArrayList<String>();
        }
        if (this.languages == null) {
            this.languages = new ArrayList<I18nLanguage>();
        }
        return this;
    }
}

