/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.chart;

import java.io.OutputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ro.nextreports.engine.Report;
import ro.nextreports.engine.ReportRunnerException;
import ro.nextreports.engine.Runner;
import ro.nextreports.engine.TableExporter;
import ro.nextreports.engine.chart.Chart;
import ro.nextreports.engine.chart.ChartExporter;
import ro.nextreports.engine.chart.ChartTableExporter;
import ro.nextreports.engine.chart.JFreeChartExporter;
import ro.nextreports.engine.chart.JsonExporter;
import ro.nextreports.engine.chart.JsonHTML5Exporter;
import ro.nextreports.engine.exporter.exception.NoDataFoundException;
import ro.nextreports.engine.exporter.util.AlarmData;
import ro.nextreports.engine.exporter.util.IndicatorData;
import ro.nextreports.engine.exporter.util.TableData;
import ro.nextreports.engine.querybuilder.sql.dialect.Dialect;
import ro.nextreports.engine.queryexec.Query;
import ro.nextreports.engine.queryexec.QueryExecutor;
import ro.nextreports.engine.queryexec.QueryParameter;
import ro.nextreports.engine.queryexec.QueryResult;
import ro.nextreports.engine.util.DialectUtil;
import ro.nextreports.engine.util.NameType;
import ro.nextreports.engine.util.QueryUtil;

public class ChartRunner
implements Runner {
    public static final String GRAPHIC_FORMAT = "GRAPHIC";
    public static final String TABLE_FORMAT = "TABLE";
    public static final String IMAGE_FORMAT = "IMAGE";
    public static final byte NO_TYPE = 0;
    public static final byte FLASH_TYPE = 1;
    public static final byte HTML5_TYPE = 2;
    private String format = "GRAPHIC";
    private byte graphicType = 1;
    private Connection connection;
    private Dialect dialect;
    private Chart chart;
    private Map<String, Object> parameterValues = new HashMap<String, Object>();
    private int queryTimeout = 600;
    private ChartExporter exporter;
    private String drillFunction;
    private String imagePath;
    private String imageName;
    private int imageWidth;
    private int imageHeight;
    private boolean csv = false;
    private String language;

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.setConnection(connection, false);
    }

    public void setConnection(Connection connection, boolean csv) {
        this.connection = connection;
        this.csv = csv;
        try {
            this.dialect = DialectUtil.getDialect(connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.chart != null && this.chart.getReport().getQuery() != null) {
            this.chart.getReport().getQuery().setDialect(this.dialect);
        }
    }

    public Chart getChart() {
        return this.chart;
    }

    public void setChart(Chart chart) {
        this.chart = chart;
        if (this.chart.getReport().getQuery() != null) {
            this.chart.getReport().getQuery().setDialect(this.dialect);
        }
    }

    private void setDynamicColumns() throws Exception {
        if (this.chart.getYColumnQuery() != null) {
            QueryUtil qu = new QueryUtil(this.connection, DialectUtil.getDialect(this.connection));
            List<NameType> list = qu.executeQueryForDynamicColumn(this.chart.getYColumnQuery());
            LinkedList<String> columns = new LinkedList<String>();
            LinkedList<String> legends = new LinkedList<String>();
            for (NameType nt : list) {
                columns.add(nt.getName());
                legends.add(nt.getType());
            }
            this.chart.setYColumns(columns);
            this.chart.setYColumnsLegends(legends);
        }
    }

    private void resetStaticColumnsAfterRun() {
        if (this.chart.getYColumnQuery() != null) {
            this.chart.setYColumns(new ArrayList<String>());
            this.chart.setYColumnsLegends(new ArrayList<String>());
        }
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public byte getGraphicType() {
        return this.graphicType;
    }

    public void setGraphicType(byte graphicType) {
        this.graphicType = graphicType;
    }

    public Map<String, Object> getParameterValues() {
        return this.parameterValues;
    }

    public void setParameterValues(Map<String, Object> parameterValues) {
        this.parameterValues = parameterValues;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public void setDrillFunction(String drillFunction) {
        this.drillFunction = drillFunction;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    @Override
    public boolean run() throws ReportRunnerException, NoDataFoundException, InterruptedException {
        return this.run(null);
    }

    @Override
    public QueryResult executeQuery() throws ReportRunnerException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean run(OutputStream stream) throws ReportRunnerException, NoDataFoundException, InterruptedException {
        if (stream == null && GRAPHIC_FORMAT.equals(this.format)) {
            throw new ReportRunnerException("OutputStream cannot be null!");
        }
        if (stream != null && TABLE_FORMAT.equals(this.format)) {
            throw new ReportRunnerException("TABLE FORMAT does not need an output stream. Use run() method instead.");
        }
        if (this.connection == null) {
            throw new ReportRunnerException("Connection is null!");
        }
        if (this.chart == null) {
            throw new ReportRunnerException("Chart is null!");
        }
        Report report = this.chart.getReport();
        String sql = report.getSql();
        if (sql == null) {
            sql = report.getQuery().toString();
        }
        if (sql == null) {
            throw new ReportRunnerException("Report sql expression not found");
        }
        try {
            this.setDynamicColumns();
        }
        catch (Exception e1) {
            throw new ReportRunnerException(e1);
        }
        HashMap<String, QueryParameter> parameters = new HashMap<String, QueryParameter>();
        List<QueryParameter> parameterList = report.getParameters();
        if (parameterList != null) {
            for (QueryParameter param : parameterList) {
                parameters.put(param.getName(), param);
            }
        }
        if (QueryUtil.restrictQueryExecution(sql)) {
            throw new ReportRunnerException("You are not allowed to execute queries that modify the database!");
        }
        if (QueryUtil.isProcedureCall(sql)) {
            Dialect dialect = null;
            try {
                dialect = DialectUtil.getDialect(this.connection);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!QueryUtil.isValidProcedureCall(sql, dialect)) {
                throw new ReportRunnerException("Invalid procedure call! Must be of form 'call (${P1}, ?)'");
            }
        }
        QueryResult queryResult = null;
        try {
            Query query = new Query(sql);
            QueryExecutor executor = new QueryExecutor(query, parameters, this.parameterValues, this.connection, true, true, this.csv);
            executor.setMaxRows(0);
            executor.setTimeout(this.queryTimeout);
            queryResult = executor.execute();
            this.createExporter(query, parameters, this.parameterValues, queryResult, stream);
            boolean bl = this.exporter.export();
            return bl;
        }
        catch (NoDataFoundException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ReportRunnerException(e);
        }
        finally {
            this.resetStaticColumnsAfterRun();
            if (queryResult != null) {
                queryResult.close();
            }
        }
    }

    private void createExporter(Query query, Map<String, QueryParameter> parameters, Map<String, Object> parameterValues, QueryResult qr, OutputStream stream) {
        if (TABLE_FORMAT.equals(this.format)) {
            this.exporter = new ChartTableExporter(qr, this.chart, this.language);
            ((ChartTableExporter)this.exporter).setShowStrings(true);
        } else if (IMAGE_FORMAT.equals(this.format)) {
            if (this.imagePath == null) {
                this.imagePath = ".";
            }
            this.exporter = new JFreeChartExporter(parameterValues, qr, this.chart, this.imagePath, this.imageName, this.imageWidth, this.imageHeight, this.language);
        } else {
            this.exporter = this.graphicType == 2 ? new JsonHTML5Exporter(parameterValues, qr, stream, this.chart, this.drillFunction, this.language) : new JsonExporter(parameterValues, qr, stream, this.chart, this.drillFunction, this.language);
        }
    }

    @Override
    public TableData getTableData() {
        if (TABLE_FORMAT.equals(this.format)) {
            TableExporter tableExporter = (TableExporter)((Object)this.exporter);
            return tableExporter.getTableData();
        }
        TableData data = new TableData();
        data.setStyle(null);
        return data;
    }

    @Override
    public AlarmData getAlarmData() {
        return new AlarmData();
    }

    @Override
    public IndicatorData getIndicatorData() {
        return new IndicatorData();
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public void setImageName(String imageName) {
        if (imageName != null && !imageName.endsWith(".jpg")) {
            throw new IllegalArgumentException("Image must be a jpeg file.");
        }
        this.imageName = imageName;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public void setImageHeight(int imageHeight) {
        this.imageHeight = imageHeight;
    }

    public String getChartImageName() {
        if (this.exporter instanceof JFreeChartExporter) {
            return ((JFreeChartExporter)this.exporter).getChartImageName();
        }
        return null;
    }

    public String getChartImageAbsolutePath() {
        if (this.exporter instanceof JFreeChartExporter) {
            return ((JFreeChartExporter)this.exporter).getChartImageAbsolutePath();
        }
        return null;
    }
}

