/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.chart;

import java.util.ArrayList;
import ro.nextreports.engine.TableExporter;
import ro.nextreports.engine.chart.Chart;
import ro.nextreports.engine.chart.ChartExporter;
import ro.nextreports.engine.exporter.exception.NoDataFoundException;
import ro.nextreports.engine.exporter.util.TableData;
import ro.nextreports.engine.exporter.util.function.FunctionFactory;
import ro.nextreports.engine.exporter.util.function.FunctionUtil;
import ro.nextreports.engine.exporter.util.function.GFunction;
import ro.nextreports.engine.i18n.I18nUtil;
import ro.nextreports.engine.queryexec.QueryException;
import ro.nextreports.engine.queryexec.QueryResult;
import ro.nextreports.engine.util.StringUtil;

public class ChartTableExporter
implements ChartExporter,
TableExporter {
    private QueryResult result;
    private Chart chart;
    private TableData data;
    private String language;
    private boolean showStrings;

    public ChartTableExporter(QueryResult result, Chart chart, String language) {
        this.result = result;
        this.chart = chart;
        this.language = language;
        this.data = new TableData();
        this.data.setStyle(null);
    }

    public boolean isShowStrings() {
        return this.showStrings;
    }

    public void setShowStrings(boolean showStrings) {
        this.showStrings = showStrings;
    }

    @Override
    public boolean export() throws QueryException, NoDataFoundException {
        this.testForData();
        this.createData();
        return true;
    }

    private void testForData() throws QueryException, NoDataFoundException {
        if (this.result == null || this.result.getColumnCount() <= 0 || this.result.getRowCount() == 0) {
            throw new NoDataFoundException();
        }
    }

    private void createData() throws QueryException {
        Number value;
        String xColumn = this.chart.getXColumn();
        String xPattern = this.chart.getXPattern();
        Object previous = null;
        String lastXValue = "";
        int row = 0;
        int chartsNo = this.chart.getYColumns().size();
        GFunction[] functions = new GFunction[chartsNo];
        this.data.getHeader().add(this.chart.getXColumn());
        for (int i = 0; i < chartsNo; ++i) {
            functions[i] = FunctionFactory.getFunction(this.chart.getYFunction());
            String column = this.chart.getYColumns().get(i);
            if (!"NOOP".equals(functions[i].getName())) {
                column = functions[i].getName() + "(" + column + ")";
            }
            this.data.getHeader().add(column);
        }
        while (this.result.hasNext()) {
            int i;
            Object xValue;
            Object[] objects = new Object[chartsNo];
            Number[] computedValues = new Number[chartsNo];
            for (int i2 = 0; i2 < chartsNo; ++i2) {
                if (this.chart.getYColumns().get(i2) == null) continue;
                objects[i2] = this.result.nextValue(this.chart.getYColumns().get(i2));
                value = null;
                value = objects[i2] instanceof Number ? (Number)((Number)objects[i2]) : (Number)1;
                if (value == null) {
                    value = 0;
                }
                computedValues[i2] = value;
            }
            if (row == 0) {
                xValue = this.result.nextValue(xColumn);
                lastXValue = this.getStringValue(xColumn, xPattern);
            } else {
                xValue = previous;
            }
            Object newXValue = this.result.nextValue(xColumn);
            boolean add = false;
            if ("NOOP".equals(functions[0].getName())) {
                lastXValue = this.getStringValue(xColumn, xPattern);
                add = true;
            } else {
                boolean equals = FunctionUtil.parameterEquals(xValue, newXValue);
                if (equals) {
                    for (i = 0; i < chartsNo; ++i) {
                        functions[i].compute(objects[i]);
                    }
                } else {
                    for (i = 0; i < chartsNo; ++i) {
                        add = true;
                        computedValues[i] = (Number)functions[i].getComputedValue();
                        functions[i].reset();
                        functions[i].compute(objects[i]);
                    }
                }
            }
            if (add) {
                ArrayList<Object> rowData = new ArrayList<Object>();
                this.data.getData().add(rowData);
                rowData.add(lastXValue);
                for (i = 0; i < chartsNo; ++i) {
                    if (this.showStrings && !(objects[i] instanceof Number)) {
                        rowData.add(objects[i]);
                        continue;
                    }
                    rowData.add(computedValues[i]);
                }
                lastXValue = this.getStringValue(xColumn, xPattern);
            }
            ++row;
            previous = newXValue;
        }
        if (!"NOOP".equals(functions[0].getName())) {
            Integer sum = 0;
            ArrayList<Object> rowData = new ArrayList<Object>();
            this.data.getData().add(rowData);
            rowData.add(lastXValue);
            for (int i = 0; i < chartsNo; ++i) {
                value = (Number)functions[i].getComputedValue();
                rowData.add(value);
            }
        }
    }

    private String getStringValue(String column, String pattern) throws QueryException {
        Object xObject = this.result.nextValue(column);
        return StringUtil.getValueAsString(xObject, pattern, I18nUtil.getLanguageByName(this.chart, this.language));
    }

    @Override
    public TableData getTableData() {
        return this.data;
    }
}

