/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.chart;

import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;

public class ChartTitle
implements Serializable {
    private static final long serialVersionUID = -2640868420524350873L;
    public static final transient byte LEFT_ALIGNMENT = 1;
    public static final transient byte CENTRAL_ALIGNMENT = 2;
    public static final transient byte RIGHT_ALIGNMENT = 3;
    private String title;
    private Font font;
    private Color color;
    private byte alignment;

    public ChartTitle(String title) {
        this.setTitle(title);
        this.font = this.getDefaultFont();
        this.color = this.getDefaultColor();
        this.alignment = this.getDefaultAlignment();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (title == null) {
            throw new IllegalArgumentException("Title cannot be null.");
        }
        this.title = title;
    }

    public Font getFont() {
        if (this.font == null) {
            return this.getDefaultFont();
        }
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getColor() {
        if (this.color == null) {
            return this.getDefaultColor();
        }
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public byte getAlignment() {
        if (this.alignment != 1 && this.alignment != 2 && this.alignment != 3) {
            return 1;
        }
        return this.alignment;
    }

    public void setAlignment(byte alignment) {
        this.alignment = alignment;
    }

    private Font getDefaultFont() {
        return new Font("SansSerif", 1, 18);
    }

    private Color getDefaultColor() {
        return Color.BLACK;
    }

    private byte getDefaultAlignment() {
        return 2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChartTitle that = (ChartTitle)o;
        if (this.alignment != that.alignment) {
            return false;
        }
        if (this.color != null ? !this.color.equals(that.color) : that.color != null) {
            return false;
        }
        if (this.font != null ? !this.font.equals(that.font) : that.font != null) {
            return false;
        }
        return this.title.equals(that.title);
    }

    public int hashCode() {
        int result = this.title.hashCode();
        result = 31 * result + (this.font != null ? this.font.hashCode() : 0);
        result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
        result = 31 * result + this.alignment;
        return result;
    }

    public String toString() {
        return "ChartTitle{title='" + this.title + '\'' + ", font=" + this.font + ", color=" + this.color + ", alignment=" + this.alignment + '}';
    }
}

