/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.chart;

import java.io.Serializable;

public class ChartType
implements Serializable {
    private static final long serialVersionUID = 4477633348941387500L;
    public static final transient byte NONE = 0;
    public static final transient byte BAR = 1;
    public static final transient byte HORIZONTAL_BAR = 2;
    public static final transient byte STACKED_BAR = 5;
    public static final transient byte HORIZONTAL_STACKED_BAR = 6;
    public static final transient byte PIE = 10;
    public static final transient byte LINE = 20;
    public static final transient byte AREA = 50;
    public static final transient byte BAR_COMBO = 60;
    public static final transient byte STACKED_BAR_COMBO = 61;
    public static final transient byte BUBBLE = 70;
    public static final transient byte NEGATIVE_BAR = 80;
    public static final transient byte STYLE_NORMAL = 1;
    public static final transient byte STYLE_BAR_GLASS = 10;
    public static final transient byte STYLE_BAR_CYLINDER = 11;
    public static final transient byte STYLE_BAR_PARALLELIPIPED = 12;
    public static final transient byte STYLE_BAR_DOME = 13;
    public static final transient byte STYLE_LINE_DOT_ANCHOR = 20;
    public static final transient byte STYLE_LINE_DOT_STAR = 21;
    public static final transient byte STYLE_LINE_DOT_BOW = 22;
    public static final transient byte STYLE_LINE_DOT_SOLID = 23;
    public static final transient byte STYLE_LINE_DOT_HOLLOW = 24;
    private byte type;
    private byte style;

    public ChartType(byte type) {
        this(type, 1);
    }

    public ChartType(byte type, byte style) {
        this.type = type;
        this.style = style;
    }

    public byte getType() {
        return this.type;
    }

    public byte getStyle() {
        return this.style;
    }

    public void setStyle(byte style) {
        this.style = style;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChartType chartType = (ChartType)o;
        if (this.style != chartType.style) {
            return false;
        }
        return this.type == chartType.type;
    }

    public boolean isLine() {
        return this.type == 20;
    }

    public boolean isPie() {
        return this.type == 10;
    }

    public boolean isBubble() {
        return this.type == 70;
    }

    public boolean isHorizontal() {
        return this.type == 2 || this.type == 6;
    }

    public boolean isStacked() {
        return this.type == 5 || this.type == 6 || this.type == 61;
    }

    public boolean isHorizontalStacked() {
        return this.type == 6;
    }

    public static boolean isCombo(byte type) {
        return type == 60 || type == 61;
    }

    public static boolean hasNoFlashSupport(byte type) {
        return type == 6 || ChartType.isCombo(type) || type == 70;
    }

    public int hashCode() {
        int result = this.type;
        result = 31 * result + this.style;
        return result;
    }

    public String toString() {
        return "ChartType{type=" + this.type + ", style=" + this.style + '}';
    }
}

