/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.chart;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.labels.StandardXYItemLabelGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.AreaRenderer;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.DefaultXYZDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.data.xy.XYZDataset;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.util.PublicCloneable;
import ro.nextreports.engine.chart.Chart;
import ro.nextreports.engine.chart.ChartExporter;
import ro.nextreports.engine.chart.XYZList;
import ro.nextreports.engine.chart.YRange;
import ro.nextreports.engine.exporter.exception.NoDataFoundException;
import ro.nextreports.engine.exporter.util.function.FunctionFactory;
import ro.nextreports.engine.exporter.util.function.FunctionUtil;
import ro.nextreports.engine.exporter.util.function.GFunction;
import ro.nextreports.engine.i18n.I18nUtil;
import ro.nextreports.engine.queryexec.QueryException;
import ro.nextreports.engine.queryexec.QueryResult;
import ro.nextreports.engine.util.StringUtil;
import ro.nextreports.engine.util.chart.CylinderRenderer;
import ro.nextreports.engine.util.chart.Star;

public class JFreeChartExporter
implements ChartExporter {
    private QueryResult result;
    private Chart chart;
    private String chartImageName;
    private Object lastXObjValue = null;
    private boolean integerXValue = true;
    private DefaultCategoryDataset barDataset;
    private DefaultPieDataset pieDataset;
    private DefaultCategoryDataset lineBarDataset;
    private DefaultXYZDataset bubbleDataset;
    private Map<String, XYZList> bubbleData = new LinkedHashMap<String, XYZList>();
    private String path;
    private int width;
    private int height;
    private Map<String, Object> parameterValues;
    private final String DEFAULT_LEGEND_PREFIX = "_L_";
    private static final int DEFAULT_WIDTH = 500;
    private static final int DEFAULT_HEIGHT = 300;
    private Map<String, Integer> xValueSerie = new HashMap<String, Integer>();
    private float transparency = 0.7f;
    private boolean isLineCombo = false;
    private String language;

    public JFreeChartExporter(Map<String, Object> parameterValues, QueryResult result, Chart chart, String language) {
        this(parameterValues, result, chart, ".", 500, 300, language);
    }

    public JFreeChartExporter(Map<String, Object> parameterValues, QueryResult result, Chart chart, String path, String language) {
        this(parameterValues, result, chart, path, 500, 300, language);
    }

    public JFreeChartExporter(Map<String, Object> parameterValues, QueryResult result, Chart chart, String path, int width, int height, String language) {
        this(parameterValues, result, chart, path, null, width, height, language);
    }

    public JFreeChartExporter(Map<String, Object> parameterValues, QueryResult result, Chart chart, String path, String imageName, int width, int height, String language) {
        if (width <= 0) {
            width = 500;
        }
        if (height <= 0) {
            height = 300;
        }
        this.parameterValues = parameterValues;
        this.result = result;
        this.chart = chart;
        this.path = path;
        this.chartImageName = imageName;
        this.width = width;
        this.height = height;
        this.language = language;
    }

    @Override
    public boolean export() throws QueryException, NoDataFoundException {
        this.testForData();
        this.createImage();
        return true;
    }

    private void testForData() throws QueryException, NoDataFoundException {
        if (this.result == null || this.result.getColumnCount() <= 0 || this.result.getRowCount() == 0) {
            throw new NoDataFoundException();
        }
    }

    private void createImage() throws QueryException {
        byte type = this.chart.getType().getType();
        JFreeChart jfreechart = null;
        if (20 == type) {
            jfreechart = this.createLineChart();
        } else if (1 == type || 80 == type) {
            jfreechart = this.createBarChart(false, false);
        } else if (60 == type) {
            jfreechart = this.createBarChart(false, false, true);
        } else if (2 == type) {
            jfreechart = this.createBarChart(true, false);
        } else if (5 == type) {
            jfreechart = this.createBarChart(false, true);
        } else if (61 == type) {
            jfreechart = this.createBarChart(false, true, true);
        } else if (6 == type) {
            jfreechart = this.createBarChart(true, true);
        } else if (10 == type) {
            jfreechart = this.createPieChart();
        } else if (70 == type) {
            jfreechart = this.createBubbleChart();
        } else if (50 == type) {
            jfreechart = this.createAreaChart();
        }
        try {
            if (this.chartImageName == null || "".equals(this.chartImageName.trim())) {
                this.chartImageName = "chart_" + System.currentTimeMillis() + ".jpg";
            }
            ChartUtilities.saveChartAsJPEG((File)new File(this.path + File.separator + this.chartImageName), (JFreeChart)jfreechart, (int)this.width, (int)this.height);
        }
        catch (IOException e) {
            System.err.println("Problem occurred creating chart.");
        }
    }

    private JFreeChart createLineChart() throws QueryException {
        DecimalFormat percentageFormat;
        DecimalFormat decimalFormat;
        boolean showValues;
        XYSeriesCollection dataset = new XYSeriesCollection();
        String chartTitle = this.replaceParameters(this.chart.getTitle().getTitle());
        chartTitle = StringUtil.getI18nString(chartTitle, I18nUtil.getLanguageByName(this.chart, this.language));
        Object[] charts = new Object[this.chart.getYColumns().size()];
        List<String> legends = this.chart.getYColumnsLegends();
        boolean hasLegend = false;
        for (int i = 0; i < charts.length; ++i) {
            String legend = "";
            try {
                legend = this.replaceParameters(legends.get(i));
                legend = StringUtil.getI18nString(legend, I18nUtil.getLanguageByName(this.chart, this.language));
            }
            catch (IndexOutOfBoundsException ex) {
                // empty catch block
            }
            if (legend != null && !"".equals(legend.trim())) {
                hasLegend = true;
            }
            XYSeries lineChart = new XYSeries((Comparable)((Object)legend));
            charts[i] = lineChart;
            dataset.addSeries(lineChart);
        }
        String xLegend = StringUtil.getI18nString(this.replaceParameters(this.chart.getXLegend().getTitle()), I18nUtil.getLanguageByName(this.chart, this.language));
        String yLegend = StringUtil.getI18nString(this.replaceParameters(this.chart.getYLegend().getTitle()), I18nUtil.getLanguageByName(this.chart, this.language));
        JFreeChart jfreechart = ChartFactory.createXYLineChart((String)chartTitle, (String)this.replaceParameters(xLegend), (String)this.replaceParameters(yLegend), (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        if (!hasLegend) {
            jfreechart.removeLegend();
        }
        jfreechart.setBorderVisible(false);
        this.setTitle(jfreechart);
        boolean bl = showValues = this.chart.getShowYValuesOnChart() == null ? false : this.chart.getShowYValuesOnChart();
        if (this.chart.getYTooltipPattern() == null) {
            decimalFormat = new DecimalFormat("#");
            percentageFormat = new DecimalFormat("0.00%");
        } else {
            percentageFormat = decimalFormat = new DecimalFormat(this.chart.getYTooltipPattern());
        }
        XYPlot plot = (XYPlot)jfreechart.getPlot();
        for (int i = 0; i < charts.length; ++i) {
            plot.getRenderer().setSeriesPaint(i, (Paint)this.chart.getForegrounds().get(i));
            if (!showValues) continue;
            plot.getRenderer().setSeriesItemLabelsVisible(i, true);
            plot.getRenderer().setSeriesItemLabelGenerator(i, (XYItemLabelGenerator)new StandardXYItemLabelGenerator("{2}", (NumberFormat)decimalFormat, (NumberFormat)percentageFormat));
        }
        if (showValues) {
            plot.getRangeAxis().setUpperMargin(0.2);
        }
        if (this.chart.getXShowGrid() != null && !this.chart.getXShowGrid().booleanValue()) {
            plot.setDomainGridlinesVisible(false);
        } else if (this.chart.getXGridColor() != null) {
            plot.setDomainGridlinePaint((Paint)this.chart.getXGridColor());
        } else {
            plot.setDomainGridlinePaint((Paint)Color.BLACK);
        }
        if (this.chart.getYShowGrid() != null && !this.chart.getYShowGrid().booleanValue()) {
            plot.setRangeGridlinesVisible(false);
        } else if (this.chart.getYGridColor() != null) {
            plot.setRangeGridlinePaint((Paint)this.chart.getYGridColor());
        } else {
            plot.setRangeGridlinePaint((Paint)Color.BLACK);
        }
        plot.setBackgroundPaint((Paint)this.chart.getBackground());
        plot.getDomainAxis().setTickLabelPaint((Paint)this.chart.getXColor());
        plot.getRangeAxis().setTickLabelPaint((Paint)this.chart.getYColor());
        plot.getDomainAxis().setLabelPaint((Paint)this.chart.getXLegend().getColor());
        plot.getRangeAxis().setLabelPaint((Paint)this.chart.getYLegend().getColor());
        plot.getDomainAxis().setLabelFont(this.chart.getXLegend().getFont());
        plot.getRangeAxis().setLabelFont(this.chart.getYLegend().getFont());
        if (this.chart.getXShowLabel() != null && !this.chart.getXShowLabel().booleanValue()) {
            plot.getDomainAxis().setTickLabelsVisible(false);
            plot.getDomainAxis().setTickMarksVisible(false);
        }
        if (this.chart.getYShowLabel() != null && !this.chart.getYShowLabel().booleanValue()) {
            plot.getRangeAxis().setTickLabelsVisible(false);
            plot.getRangeAxis().setTickMarksVisible(false);
        }
        if (this.chart.getXorientation() == 2) {
            plot.getDomainAxis().setVerticalTickLabels(true);
        }
        plot.getDomainAxis().setTickLabelFont(this.chart.getXLabelFont());
        plot.getRangeAxis().setTickLabelFont(this.chart.getYLabelFont());
        Shape pointShape = null;
        byte style = this.chart.getType().getStyle();
        switch (style) {
            case 23: 
            case 24: {
                pointShape = new Ellipse2D.Float(-3.0f, -3.0f, 6.0f, 6.0f);
                break;
            }
            case 20: {
                GeneralPath s5 = new GeneralPath();
                s5.moveTo(0.0f, -3.0f);
                s5.lineTo(3.0f, 3.0f);
                s5.lineTo(-3.0f, 3.0f);
                s5.closePath();
                pointShape = s5;
                break;
            }
            case 22: {
                GeneralPath s4 = new GeneralPath();
                s4.moveTo(-3.0f, -3.0f);
                s4.lineTo(3.0f, -3.0f);
                s4.lineTo(-3.0f, 3.0f);
                s4.lineTo(3.0f, 3.0f);
                s4.closePath();
                pointShape = s4;
                break;
            }
            case 21: {
                pointShape = new Star(-3.0f, 0.0f).getShape();
                break;
            }
        }
        if (pointShape != null) {
            XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)plot.getRenderer();
            renderer.setUseFillPaint(true);
            for (int i = 0; i < charts.length; ++i) {
                renderer.setSeriesShapesVisible(i, true);
                if (style != 23) {
                    renderer.setSeriesFillPaint(i, (Paint)this.chart.getBackground());
                } else {
                    renderer.setSeriesFillPaint(i, (Paint)this.chart.getForegrounds().get(i));
                }
                renderer.setSeriesShape(i, pointShape);
            }
        }
        final HashMap<String, String> formatValues = this.createChart(plot.getRangeAxis(), charts);
        if (!this.integerXValue) {
            ((NumberAxis)plot.getDomainAxis()).setTickUnit(new NumberTickUnit(1.0));
            ((NumberAxis)plot.getDomainAxis()).setNumberFormatOverride((NumberFormat)new DecimalFormat(){

                @Override
                public StringBuffer format(double number, StringBuffer result, FieldPosition fieldPosition) {
                    String s = (String)formatValues.get(String.valueOf(Math.round(number)));
                    if (s == null) {
                        s = "";
                    }
                    return result.append(s);
                }
            });
        }
        NumberAxis rangeAxis = (NumberAxis)plot.getDomainAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return jfreechart;
    }

    private JFreeChart createBarChart(boolean horizontal, boolean stacked) throws QueryException {
        return this.createBarChart(horizontal, stacked, false);
    }

    private JFreeChart createBarChart(boolean horizontal, boolean stacked, boolean isCombo) throws QueryException {
        DecimalFormat percentageFormat;
        DecimalFormat decimalformat;
        JFreeChart jfreechart;
        PlotOrientation plotOrientation;
        List<String> legends;
        Object[] charts;
        this.barDataset = new DefaultCategoryDataset();
        String chartTitle = this.replaceParameters(this.chart.getTitle().getTitle());
        chartTitle = StringUtil.getI18nString(chartTitle, I18nUtil.getLanguageByName(this.chart, this.language));
        Object[] lineCharts = null;
        String lineLegend = null;
        if (isCombo) {
            lineCharts = new Object[1];
            lineLegend = this.chart.getYColumnsLegends().size() < this.chart.getYColumns().size() ? "" : this.chart.getYColumnsLegends().get(this.chart.getYColumns().size() - 1);
            charts = new Object[this.chart.getYColumns().size() - 1];
            legends = this.chart.getYColumnsLegends().subList(0, this.chart.getYColumns().size() - 1);
        } else {
            charts = new Object[this.chart.getYColumns().size()];
            legends = this.chart.getYColumnsLegends();
        }
        boolean hasLegend = false;
        for (int i = 0; i < charts.length; ++i) {
            String legend = "";
            try {
                legend = this.replaceParameters(legends.get(i));
                legend = StringUtil.getI18nString(legend, I18nUtil.getLanguageByName(this.chart, this.language));
            }
            catch (IndexOutOfBoundsException ex) {
                // empty catch block
            }
            if (legend == null || "".equals(legend.trim())) {
                legend = "_L_" + String.valueOf(i + 1);
            } else {
                hasLegend = true;
            }
            charts[i] = legend;
        }
        if (isCombo) {
            String leg = "";
            if (lineLegend != null) {
                leg = this.replaceParameters(lineLegend);
            }
            lineCharts[0] = leg;
        }
        byte style = this.chart.getType().getStyle();
        String xLegend = StringUtil.getI18nString(this.replaceParameters(this.chart.getXLegend().getTitle()), I18nUtil.getLanguageByName(this.chart, this.language));
        String yLegend = StringUtil.getI18nString(this.replaceParameters(this.chart.getYLegend().getTitle()), I18nUtil.getLanguageByName(this.chart, this.language));
        PlotOrientation plotOrientation2 = plotOrientation = horizontal ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL;
        if (stacked) {
            jfreechart = ChartFactory.createStackedBarChart((String)chartTitle, (String)xLegend, (String)yLegend, (CategoryDataset)this.barDataset, (PlotOrientation)plotOrientation, (boolean)true, (boolean)true, (boolean)false);
        } else {
            switch (style) {
                case 11: 
                case 12: {
                    jfreechart = ChartFactory.createBarChart3D((String)chartTitle, (String)xLegend, (String)yLegend, (CategoryDataset)this.barDataset, (PlotOrientation)plotOrientation, (boolean)true, (boolean)true, (boolean)false);
                    break;
                }
                default: {
                    jfreechart = ChartFactory.createBarChart((String)chartTitle, (String)xLegend, (String)yLegend, (CategoryDataset)this.barDataset, (PlotOrientation)plotOrientation, (boolean)true, (boolean)true, (boolean)false);
                }
            }
        }
        if (style == 11) {
            ((CategoryPlot)jfreechart.getPlot()).setRenderer((CategoryItemRenderer)new CylinderRenderer());
        }
        if (!hasLegend) {
            jfreechart.removeLegend();
        }
        jfreechart.setBorderVisible(false);
        this.setTitle(jfreechart);
        boolean showValues = this.chart.getShowYValuesOnChart() == null ? false : this.chart.getShowYValuesOnChart();
        CategoryPlot plot = (CategoryPlot)jfreechart.getPlot();
        plot.setForegroundAlpha(this.transparency);
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setDrawBarOutline(false);
        renderer.setItemMargin(0.0);
        if (this.chart.getYTooltipPattern() == null) {
            decimalformat = new DecimalFormat("#");
            percentageFormat = new DecimalFormat("0.00%");
        } else {
            percentageFormat = decimalformat = new DecimalFormat(this.chart.getYTooltipPattern());
        }
        for (int i = 0; i < charts.length; ++i) {
            renderer.setSeriesPaint(i, (Paint)this.chart.getForegrounds().get(i));
            if (!showValues) continue;
            renderer.setSeriesItemLabelsVisible(i, true);
            renderer.setSeriesItemLabelGenerator(i, (CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator("{2}", (NumberFormat)decimalformat, (NumberFormat)percentageFormat));
        }
        if (showValues) {
            plot.getRangeAxis().setUpperMargin(0.2);
        }
        if (this.chart.getXShowGrid() != null && !this.chart.getXShowGrid().booleanValue()) {
            plot.setDomainGridlinesVisible(false);
        } else if (this.chart.getXGridColor() != null) {
            plot.setDomainGridlinePaint((Paint)this.chart.getXGridColor());
        } else {
            plot.setDomainGridlinePaint((Paint)Color.BLACK);
        }
        if (this.chart.getYShowGrid() != null && !this.chart.getYShowGrid().booleanValue()) {
            plot.setRangeGridlinesVisible(false);
        } else if (this.chart.getYGridColor() != null) {
            plot.setRangeGridlinePaint((Paint)this.chart.getYGridColor());
        } else {
            plot.setRangeGridlinePaint((Paint)Color.BLACK);
        }
        plot.setBackgroundPaint((Paint)this.chart.getBackground());
        plot.getDomainAxis().setTickLabelPaint((Paint)this.chart.getXColor());
        plot.getRangeAxis().setTickLabelPaint((Paint)this.chart.getYColor());
        plot.getDomainAxis().setLabelPaint((Paint)this.chart.getXLegend().getColor());
        plot.getRangeAxis().setLabelPaint((Paint)this.chart.getYLegend().getColor());
        plot.getDomainAxis().setLabelFont(this.chart.getXLegend().getFont());
        plot.getRangeAxis().setLabelFont(this.chart.getYLegend().getFont());
        plot.getDomainAxis().setAxisLinePaint((Paint)this.chart.getxAxisColor());
        plot.getRangeAxis().setAxisLinePaint((Paint)this.chart.getyAxisColor());
        if (this.chart.getXShowLabel() != null && !this.chart.getXShowLabel().booleanValue()) {
            plot.getDomainAxis().setTickLabelsVisible(false);
            plot.getDomainAxis().setTickMarksVisible(false);
        }
        if (this.chart.getYShowLabel() != null && !this.chart.getYShowLabel().booleanValue()) {
            plot.getRangeAxis().setTickLabelsVisible(false);
            plot.getRangeAxis().setTickMarksVisible(false);
        }
        if (this.chart.getType().getStyle() == 1) {
            renderer.setShadowVisible(false);
            renderer.setBarPainter((BarPainter)new StandardBarPainter());
        }
        CategoryAxis domainAxis = plot.getDomainAxis();
        if (this.chart.getXorientation() == 2) {
            domainAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)1.5707963267948966));
        } else if (this.chart.getXorientation() == 3) {
            domainAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)0.7853981633974483));
        } else if (this.chart.getXorientation() == 4) {
            domainAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)0.39269908169872414));
        }
        domainAxis.setTickLabelFont(this.chart.getXLabelFont());
        plot.getRangeAxis().setTickLabelFont(this.chart.getYLabelFont());
        this.createChart(plot.getRangeAxis(), charts);
        if (isCombo) {
            this.addLineChartOverBar(jfreechart, lineCharts, lineLegend);
        }
        return jfreechart;
    }

    private JFreeChart addLineChartOverBar(JFreeChart jfreechart, Object[] lineCharts, String lineLegend) throws QueryException {
        DecimalFormat percentageFormat;
        DecimalFormat decimalFormat;
        boolean showValues;
        try {
            this.result.getResultSet().beforeFirst();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.isLineCombo = true;
        this.lineBarDataset = new DefaultCategoryDataset();
        boolean hasLegend = false;
        for (int i = 0; i < lineCharts.length; ++i) {
            String legend = "";
            try {
                legend = this.replaceParameters(lineLegend);
            }
            catch (IndexOutOfBoundsException ex) {
                // empty catch block
            }
            if (legend != null && !"".equals(legend.trim())) {
                hasLegend = true;
            }
            lineCharts[i] = legend;
        }
        int index = this.chart.getYColumns().size() - 1;
        CategoryPlot plot = jfreechart.getCategoryPlot();
        LineAndShapeRenderer renderer2 = new LineAndShapeRenderer();
        plot.setRenderer(1, (CategoryItemRenderer)renderer2);
        renderer2.setSeriesPaint(0, (Paint)this.chart.getForegrounds().get(index));
        NumberAxis axis2 = new NumberAxis("");
        plot.setRangeAxis(1, (ValueAxis)axis2);
        plot.setDataset(1, (CategoryDataset)this.lineBarDataset);
        plot.mapDatasetToRangeAxis(1, 1);
        plot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        boolean bl = showValues = this.chart.getShowYValuesOnChart() == null ? false : this.chart.getShowYValuesOnChart();
        if (this.chart.getYTooltipPattern() == null) {
            decimalFormat = new DecimalFormat("#");
            percentageFormat = new DecimalFormat("0.00%");
        } else {
            percentageFormat = decimalFormat = new DecimalFormat(this.chart.getYTooltipPattern());
        }
        if (showValues) {
            renderer2.setSeriesItemLabelsVisible(0, true);
            renderer2.setSeriesItemLabelGenerator(0, (CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator("{2}", (NumberFormat)decimalFormat, (NumberFormat)percentageFormat));
            plot.getRangeAxis(1).setUpperMargin(0.2);
        }
        HashMap<String, String> formatValues = this.createChart(this.chart.getYColumns().subList(index, index + 1), plot.getRangeAxis(1), lineCharts);
        this.isLineCombo = false;
        return jfreechart;
    }

    private JFreeChart createAreaChart() throws QueryException {
        DecimalFormat percentageFormat;
        DecimalFormat decimalformat;
        this.barDataset = new DefaultCategoryDataset();
        String chartTitle = this.replaceParameters(this.chart.getTitle().getTitle());
        chartTitle = StringUtil.getI18nString(chartTitle, I18nUtil.getLanguageByName(this.chart, this.language));
        Object[] charts = new Object[this.chart.getYColumns().size()];
        List<String> legends = this.chart.getYColumnsLegends();
        boolean hasLegend = false;
        for (int i = 0; i < charts.length; ++i) {
            String legend = "";
            try {
                legend = this.replaceParameters(legends.get(i));
                legend = StringUtil.getI18nString(legend, I18nUtil.getLanguageByName(this.chart, this.language));
            }
            catch (IndexOutOfBoundsException ex) {
                // empty catch block
            }
            if (legend == null || "".equals(legend.trim())) {
                legend = "_L_" + String.valueOf(i + 1);
            } else {
                hasLegend = true;
            }
            charts[i] = legend;
        }
        String xLegend = StringUtil.getI18nString(this.replaceParameters(this.chart.getXLegend().getTitle()), I18nUtil.getLanguageByName(this.chart, this.language));
        String yLegend = StringUtil.getI18nString(this.replaceParameters(this.chart.getYLegend().getTitle()), I18nUtil.getLanguageByName(this.chart, this.language));
        byte style = this.chart.getType().getStyle();
        JFreeChart jfreechart = ChartFactory.createAreaChart((String)"Area Chart", (String)xLegend, (String)yLegend, (CategoryDataset)this.barDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        if (!hasLegend) {
            jfreechart.removeLegend();
        }
        jfreechart.setBorderVisible(false);
        this.setTitle(jfreechart);
        boolean showValues = this.chart.getShowYValuesOnChart() == null ? false : this.chart.getShowYValuesOnChart();
        CategoryPlot plot = (CategoryPlot)jfreechart.getPlot();
        plot.setForegroundAlpha(this.transparency);
        AreaRenderer renderer = (AreaRenderer)plot.getRenderer();
        if (this.chart.getYTooltipPattern() == null) {
            decimalformat = new DecimalFormat("#");
            percentageFormat = new DecimalFormat("0.00%");
        } else {
            percentageFormat = decimalformat = new DecimalFormat(this.chart.getYTooltipPattern());
        }
        for (int i = 0; i < charts.length; ++i) {
            renderer.setSeriesPaint(i, (Paint)this.chart.getForegrounds().get(i));
            if (!showValues) continue;
            renderer.setSeriesItemLabelsVisible(i, true);
            renderer.setSeriesItemLabelGenerator(i, (CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator("{2}", (NumberFormat)decimalformat, (NumberFormat)percentageFormat));
        }
        if (showValues) {
            plot.getRangeAxis().setUpperMargin(0.2);
        }
        if (this.chart.getXShowGrid() != null && !this.chart.getXShowGrid().booleanValue()) {
            plot.setDomainGridlinesVisible(false);
        } else if (this.chart.getXGridColor() != null) {
            plot.setDomainGridlinePaint((Paint)this.chart.getXGridColor());
        } else {
            plot.setDomainGridlinePaint((Paint)Color.BLACK);
        }
        if (this.chart.getYShowGrid() != null && !this.chart.getYShowGrid().booleanValue()) {
            plot.setRangeGridlinesVisible(false);
        } else if (this.chart.getYGridColor() != null) {
            plot.setRangeGridlinePaint((Paint)this.chart.getYGridColor());
        } else {
            plot.setRangeGridlinePaint((Paint)Color.BLACK);
        }
        plot.setBackgroundPaint((Paint)this.chart.getBackground());
        plot.getDomainAxis().setTickLabelPaint((Paint)this.chart.getXColor());
        plot.getRangeAxis().setTickLabelPaint((Paint)this.chart.getYColor());
        plot.getDomainAxis().setLabelPaint((Paint)this.chart.getXLegend().getColor());
        plot.getRangeAxis().setLabelPaint((Paint)this.chart.getYLegend().getColor());
        plot.getDomainAxis().setLabelFont(this.chart.getXLegend().getFont());
        plot.getRangeAxis().setLabelFont(this.chart.getYLegend().getFont());
        plot.getDomainAxis().setAxisLinePaint((Paint)this.chart.getxAxisColor());
        plot.getRangeAxis().setAxisLinePaint((Paint)this.chart.getyAxisColor());
        if (this.chart.getXShowLabel() != null && !this.chart.getXShowLabel().booleanValue()) {
            plot.getDomainAxis().setTickLabelsVisible(false);
            plot.getDomainAxis().setTickMarksVisible(false);
        }
        if (this.chart.getYShowLabel() != null && !this.chart.getYShowLabel().booleanValue()) {
            plot.getRangeAxis().setTickLabelsVisible(false);
            plot.getRangeAxis().setTickMarksVisible(false);
        }
        CategoryAxis domainAxis = plot.getDomainAxis();
        if (this.chart.getXorientation() == 2) {
            domainAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)1.5707963267948966));
        } else if (this.chart.getXorientation() == 3) {
            domainAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)0.7853981633974483));
        } else if (this.chart.getXorientation() == 4) {
            domainAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)0.39269908169872414));
        }
        plot.getDomainAxis().setTickLabelFont(this.chart.getXLabelFont());
        plot.getRangeAxis().setTickLabelFont(this.chart.getYLabelFont());
        this.createChart(plot.getRangeAxis(), charts);
        return jfreechart;
    }

    private JFreeChart createPieChart() throws QueryException {
        boolean showValues;
        DecimalFormat percentageFormat;
        DecimalFormat decimalformat;
        this.pieDataset = new DefaultPieDataset();
        String chartTitle = this.replaceParameters(this.chart.getTitle().getTitle());
        chartTitle = StringUtil.getI18nString(chartTitle, I18nUtil.getLanguageByName(this.chart, this.language));
        JFreeChart jfreechart = ChartFactory.createPieChart((String)chartTitle, (PieDataset)this.pieDataset, (boolean)true, (boolean)true, (boolean)false);
        jfreechart.setBorderVisible(false);
        this.setTitle(jfreechart);
        PiePlot plot = (PiePlot)jfreechart.getPlot();
        plot.setForegroundAlpha(this.transparency);
        plot.setStartAngle(330.0);
        plot.setLegendLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0} = {1}"));
        plot.setShadowXOffset(0.0);
        plot.setShadowYOffset(0.0);
        if (this.chart.getYTooltipPattern() == null) {
            decimalformat = new DecimalFormat("#");
            percentageFormat = new DecimalFormat("0.00%");
        } else {
            percentageFormat = decimalformat = new DecimalFormat(this.chart.getYTooltipPattern());
        }
        boolean bl = showValues = this.chart.getShowYValuesOnChart() == null ? false : this.chart.getShowYValuesOnChart();
        if (showValues) {
            plot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0} ({2})", (NumberFormat)decimalformat, (NumberFormat)percentageFormat));
        }
        plot.setBackgroundPaint((Paint)this.chart.getBackground());
        this.createChart(null, new Object[1]);
        List keys = this.pieDataset.getKeys();
        List<Color> colors = this.chart.getForegrounds();
        int size = colors.size();
        for (int i = 0; i < keys.size(); ++i) {
            plot.setSectionPaint((Comparable)keys.get(i), (Paint)colors.get(i % size));
            plot.setLabelFont(this.chart.getFont());
        }
        return jfreechart;
    }

    private JFreeChart createBubbleChart() throws QueryException {
        DecimalFormat percentageFormat;
        DecimalFormat decimalformat;
        this.bubbleDataset = new DefaultXYZDataset();
        String chartTitle = this.replaceParameters(this.chart.getTitle().getTitle());
        chartTitle = StringUtil.getI18nString(chartTitle, I18nUtil.getLanguageByName(this.chart, this.language));
        String xLegend = StringUtil.getI18nString(this.replaceParameters(this.chart.getYLegend().getTitle()), I18nUtil.getLanguageByName(this.chart, this.language));
        String yLegend = StringUtil.getI18nString(this.replaceParameters(this.chart.getXLegend().getTitle()), I18nUtil.getLanguageByName(this.chart, this.language));
        JFreeChart jfreechart = ChartFactory.createBubbleChart((String)chartTitle, (String)xLegend, (String)yLegend, (XYZDataset)this.bubbleDataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)true, (boolean)false);
        jfreechart.setBorderVisible(false);
        this.setTitle(jfreechart);
        boolean showValues = this.chart.getShowYValuesOnChart() == null ? false : this.chart.getShowYValuesOnChart();
        XYPlot xyplot = (XYPlot)jfreechart.getPlot();
        xyplot.setForegroundAlpha(this.transparency);
        XYItemRenderer xyitemrenderer = xyplot.getRenderer();
        if (this.chart.getYTooltipPattern() == null) {
            decimalformat = new DecimalFormat("#");
            percentageFormat = new DecimalFormat("0.00%");
        } else {
            percentageFormat = decimalformat = new DecimalFormat(this.chart.getYTooltipPattern());
        }
        if (showValues) {
            xyplot.getRangeAxis().setUpperMargin(0.2);
        }
        if (this.chart.getXShowGrid() != null && !this.chart.getXShowGrid().booleanValue()) {
            xyplot.setDomainGridlinesVisible(false);
        } else if (this.chart.getXGridColor() != null) {
            xyplot.setDomainGridlinePaint((Paint)this.chart.getXGridColor());
        } else {
            xyplot.setDomainGridlinePaint((Paint)Color.BLACK);
        }
        if (this.chart.getYShowGrid() != null && !this.chart.getYShowGrid().booleanValue()) {
            xyplot.setRangeGridlinesVisible(false);
        } else if (this.chart.getYGridColor() != null) {
            xyplot.setRangeGridlinePaint((Paint)this.chart.getYGridColor());
        } else {
            xyplot.setRangeGridlinePaint((Paint)Color.BLACK);
        }
        xyplot.setBackgroundPaint((Paint)this.chart.getBackground());
        xyplot.getDomainAxis().setTickLabelPaint((Paint)this.chart.getXColor());
        xyplot.getRangeAxis().setTickLabelPaint((Paint)this.chart.getYColor());
        xyplot.getDomainAxis().setLabelPaint((Paint)this.chart.getXLegend().getColor());
        xyplot.getRangeAxis().setLabelPaint((Paint)this.chart.getYLegend().getColor());
        xyplot.getDomainAxis().setLabelFont(this.chart.getXLegend().getFont());
        xyplot.getRangeAxis().setLabelFont(this.chart.getYLegend().getFont());
        xyplot.getDomainAxis().setAxisLinePaint((Paint)this.chart.getxAxisColor());
        xyplot.getRangeAxis().setAxisLinePaint((Paint)this.chart.getyAxisColor());
        if (this.chart.getXShowLabel() != null && !this.chart.getXShowLabel().booleanValue()) {
            xyplot.getDomainAxis().setTickLabelsVisible(false);
            xyplot.getDomainAxis().setTickMarksVisible(false);
        }
        if (this.chart.getYShowLabel() != null && !this.chart.getYShowLabel().booleanValue()) {
            xyplot.getRangeAxis().setTickLabelsVisible(false);
            xyplot.getRangeAxis().setTickMarksVisible(false);
        }
        ValueAxis domainAxis = xyplot.getDomainAxis();
        if (this.chart.getXorientation() == 2) {
            domainAxis.setLabelAngle(1.5707963267948966);
        } else if (this.chart.getXorientation() == 3) {
            domainAxis.setLabelAngle(0.7853981633974483);
        } else if (this.chart.getXorientation() == 4) {
            domainAxis.setLabelAngle(0.39269908169872414);
        }
        xyplot.getDomainAxis().setTickLabelFont(this.chart.getXLabelFont());
        xyplot.getRangeAxis().setTickLabelFont(this.chart.getYLabelFont());
        this.createChart(xyplot.getRangeAxis(), new Object[4]);
        double minX = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double minY = Double.MAX_VALUE;
        double maxY = Double.MIN_VALUE;
        double maxZ = Double.MIN_VALUE;
        for (String serie : this.bubbleData.keySet()) {
            XYZList xyzList = this.bubbleData.get(serie);
            List<Number> yList = xyzList.getyList();
            for (Number n : yList) {
                minY = Math.min(minY, n.doubleValue());
                maxY = Math.max(maxY, n.doubleValue());
            }
            List<Number> xList = xyzList.getxList();
            for (Number n : xList) {
                minX = Math.min(minX, n.doubleValue());
                maxX = Math.max(maxX, n.doubleValue());
            }
            List<Number> zList = xyzList.getzList();
            for (Number n : zList) {
                maxZ = Math.max(maxZ, n.doubleValue());
            }
        }
        double tu = Math.floor((maxX - minX) / 5.0 + 0.5);
        NumberTickUnit rUnit = new NumberTickUnit(tu);
        ((NumberAxis)xyplot.getRangeAxis()).setTickUnit(rUnit);
        xyplot.getDomainAxis().setUpperMargin(0.2);
        xyplot.getDomainAxis().setLowerMargin(0.2);
        for (String serie : this.bubbleData.keySet()) {
            XYZList xyzList = this.bubbleData.get(serie);
            double[][] data = new double[][]{this.getDoubleArray(xyzList.getyList()), this.getDoubleArray(xyzList.getxList()), this.getZDoubleArray(xyzList.getzList(), tu, maxZ)};
            this.bubbleDataset.addSeries((Comparable)((Object)serie), (double[][])data);
        }
        int series = this.bubbleData.keySet().size();
        for (int i = 0; i < series; ++i) {
            xyitemrenderer.setSeriesPaint(i, (Paint)this.chart.getForegrounds().get(i));
            if (!showValues) continue;
            xyitemrenderer.setSeriesItemLabelsVisible(i, true);
            xyitemrenderer.setSeriesItemLabelGenerator(i, (XYItemLabelGenerator)new StandardXYItemLabelGenerator("{2}", (NumberFormat)decimalformat, (NumberFormat)percentageFormat));
        }
        xyitemrenderer.setBaseItemLabelsVisible(true);
        xyitemrenderer.setBaseItemLabelGenerator((XYItemLabelGenerator)new LegendXYItemLabelGenerator());
        return jfreechart;
    }

    private void setTitle(JFreeChart jfreechart) {
        TextTitle title = new TextTitle(StringUtil.getI18nString(this.replaceParameters(this.chart.getTitle().getTitle()), I18nUtil.getLanguageByName(this.chart, this.language)));
        title.setFont(this.chart.getTitle().getFont());
        title.setPaint((Paint)this.chart.getTitle().getColor());
        if (this.chart.getTitle().getAlignment() == 1) {
            title.setHorizontalAlignment(HorizontalAlignment.LEFT);
        } else if (this.chart.getTitle().getAlignment() == 3) {
            title.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        } else {
            title.setHorizontalAlignment(HorizontalAlignment.CENTER);
        }
        jfreechart.setTitle(title);
    }

    private HashMap<String, String> createChart(ValueAxis rangeAxis, Object[] charts) throws QueryException {
        return this.createChart(this.chart.getYColumns(), rangeAxis, charts);
    }

    private HashMap<String, String> createChart(List<String> yColumns, ValueAxis rangeAxis, Object[] charts) throws QueryException {
        int row = 0;
        Object previous = null;
        String xColumn = this.chart.getXColumn();
        String xPattern = this.chart.getXPattern();
        String lastXValue = "";
        HashMap<String, String> formatValues = new HashMap<String, String>();
        Number min = Double.MAX_VALUE;
        Double max = Double.MIN_VALUE;
        int chartsNo = charts.length;
        int[] index = new int[chartsNo];
        GFunction[] functions = new GFunction[chartsNo];
        for (int i = 0; i < chartsNo; ++i) {
            functions[i] = FunctionFactory.getFunction(this.chart.getYFunction());
            index[i] = 1;
        }
        boolean isStacked = this.chart.getType().isStacked();
        while (this.result.hasNext()) {
            Object[] objects = new Object[chartsNo];
            Number[] computedValues = new Number[chartsNo];
            String currentCategory = null;
            for (int i = 0; i < chartsNo; ++i) {
                if (yColumns.get(i) == null) continue;
                objects[i] = this.result.nextValue(yColumns.get(i));
                Number value = null;
                String sv = null;
                if (objects[i] instanceof Number) {
                    value = (Number)objects[i];
                } else if (objects[i] != null) {
                    if (70 == this.chart.getType().getType()) {
                        sv = (String)objects[i];
                    }
                    value = 1;
                    this.integerXValue = false;
                } else {
                    value = 0;
                }
                computedValues[i] = value;
                if (sv == null) continue;
                currentCategory = sv;
            }
            Object xValue = null;
            if (row == 0) {
                this.lastXObjValue = xValue = this.result.nextValue(xColumn);
                lastXValue = this.getStringValue(xColumn, xPattern);
            } else {
                xValue = previous;
            }
            Object newXValue = this.result.nextValue(xColumn);
            boolean add = false;
            int position = 0;
            if ("NOOP".equals(functions[0].getName())) {
                lastXValue = this.getStringValue(xColumn, xPattern);
                add = true;
            } else {
                boolean equals = FunctionUtil.parameterEquals(xValue, newXValue);
                if (equals) {
                    for (int i = 0; i < chartsNo; ++i) {
                        functions[i].compute(objects[i]);
                    }
                } else {
                    for (int i = 0; i < chartsNo; ++i) {
                        position = i;
                        add = true;
                        computedValues[i] = (Number)functions[i].getComputedValue();
                        functions[i].reset();
                        functions[i].compute(objects[i]);
                    }
                }
            }
            if (add) {
                Number n;
                Number sum = 0;
                if (xValue instanceof Number) {
                    n = (Number)newXValue;
                } else {
                    this.integerXValue = false;
                    int n2 = position;
                    int n3 = index[n2];
                    index[n2] = n3 + 1;
                    n = n3;
                }
                if (this.chart.getType().isBubble()) {
                    XYZList xyzList = this.bubbleData.get(currentCategory);
                    if (xyzList == null) {
                        xyzList = new XYZList();
                        this.bubbleData.put(currentCategory, xyzList);
                    }
                    xyzList.getxList().add(computedValues[0]);
                    xyzList.getyList().add(computedValues[1]);
                    xyzList.getzList().add(computedValues[2]);
                    min = Math.min(min.doubleValue(), computedValues[0].doubleValue());
                    max = Math.max(max, computedValues[0].doubleValue());
                } else {
                    for (int i = 0; i < chartsNo; ++i) {
                        this.addValue(charts[i], n, lastXValue, computedValues[i], formatValues, chartsNo);
                        if (!isStacked) {
                            min = Math.min(min.doubleValue(), computedValues[i].doubleValue());
                            max = Math.max(max, computedValues[i].doubleValue());
                            continue;
                        }
                        sum = ((Number)sum).doubleValue() + computedValues[i].doubleValue();
                    }
                }
                if (this.chart.getStartingFromZero() != null && this.chart.getStartingFromZero().booleanValue() && min.intValue() > 0) {
                    min = 0;
                }
                if (isStacked) {
                    min = 0;
                    max = Math.max(max, ((Number)sum).doubleValue());
                }
                lastXValue = this.getStringValue(xColumn, xPattern);
                if (70 == this.chart.getType().getType()) {
                    XYZList xyzList = this.bubbleData.get(currentCategory);
                    xyzList.getLabels().add(lastXValue);
                }
            }
            ++row;
            previous = newXValue;
        }
        if (!"NOOP".equals(functions[0].getName())) {
            Number n;
            Number sum = 0;
            if (this.lastXObjValue instanceof Number) {
                n = (Number)this.lastXObjValue;
            } else {
                this.integerXValue = false;
                int n4 = chartsNo - 1;
                int n5 = index[n4];
                index[n4] = n5 + 1;
                n = n5;
            }
            for (int i = 0; i < chartsNo; ++i) {
                Number value = (Number)functions[i].getComputedValue();
                this.addValue(charts[i], n, lastXValue, value, formatValues, chartsNo);
                if (!isStacked) {
                    min = Math.min(min.doubleValue(), value.doubleValue());
                    max = Math.max(max, value.doubleValue());
                    continue;
                }
                sum = ((Number)sum).doubleValue() + value.doubleValue();
            }
            if (this.chart.getStartingFromZero() != null && this.chart.getStartingFromZero().booleanValue() && min.intValue() > 0) {
                min = 0;
            }
            if (isStacked) {
                min = 0;
                max = Math.max(max, ((Number)sum).doubleValue());
            }
        }
        this.setAxisRange(rangeAxis, min, max);
        return formatValues;
    }

    private void addValue(Object chartSerie, Number x, String lastXValue, Number y, HashMap<String, String> formatValues, int chartsNo) {
        if (this.chart.getType().isLine()) {
            ((XYSeries)chartSerie).add(x, y);
        } else if (this.isLineCombo) {
            this.lineBarDataset.addValue(y, (Comparable)((Object)((String)chartSerie)), (Comparable)((Object)lastXValue));
        } else if (!this.chart.getType().isPie()) {
            GFunction function = FunctionFactory.getFunction(this.chart.getYFunction());
            if (!"NOOP".equals(function.getName()) || chartsNo > 1) {
                this.barDataset.setValue(y, (Comparable)((Object)((String)chartSerie)), (Comparable)((Object)lastXValue));
            } else {
                int serie = 0;
                Integer i = this.xValueSerie.get(lastXValue);
                if (i != null) {
                    serie = i + 1;
                    this.xValueSerie.put(lastXValue, serie);
                    this.barDataset.setValue(y, (Comparable)((Object)((String)chartSerie)), (Comparable)((Object)(lastXValue + " (" + serie + ")")));
                } else {
                    this.barDataset.setValue(y, (Comparable)((Object)((String)chartSerie)), (Comparable)((Object)lastXValue));
                    this.xValueSerie.put(lastXValue, 0);
                }
            }
        } else if (this.chart.getType().isPie()) {
            if ("NOOP".equals(this.chart.getYFunction())) {
                int serie = 0;
                Integer i = this.xValueSerie.get(lastXValue);
                if (i != null) {
                    serie = i + 1;
                    this.xValueSerie.put(lastXValue, serie);
                    this.pieDataset.setValue((Comparable)((Object)(lastXValue + " (" + serie + ")")), y);
                } else {
                    this.pieDataset.setValue((Comparable)((Object)lastXValue), y);
                    this.xValueSerie.put(lastXValue, 0);
                }
            } else {
                this.pieDataset.setValue((Comparable)((Object)lastXValue), y);
            }
        }
        formatValues.put(x.toString(), lastXValue);
    }

    private String getStringValue(String column, String pattern) throws QueryException {
        Object xObject;
        this.lastXObjValue = xObject = this.result.nextValue(column);
        return StringUtil.getValueAsString(xObject, pattern);
    }

    public String getChartImageName() {
        return this.chartImageName;
    }

    public String getChartImageAbsolutePath() {
        File file = new File(this.path + File.separator + this.chartImageName);
        return file.getAbsolutePath();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private String replaceParameters(String text) {
        if (text == null) {
            return null;
        }
        for (String param : this.parameterValues.keySet()) {
            text = StringUtil.replace(text, "\\$P\\{" + param + "\\}", StringUtil.getValueAsString(this.parameterValues.get(param), null, I18nUtil.getLanguageByName(this.chart, this.language)));
        }
        return text;
    }

    private void setAxisRange(ValueAxis rangeAxis, Number min, Number max) {
        if (rangeAxis == null) {
            return;
        }
        YRange yRange = new YRange(min, max);
        yRange = yRange.update();
        rangeAxis.setRange(new Range(yRange.getMin().doubleValue(), yRange.getMax().doubleValue()));
    }

    private double[] getDoubleArray(List<Number> list) {
        double[] result = new double[list.size()];
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            result[i] = list.get(i).doubleValue();
        }
        return result;
    }

    private double[] getZDoubleArray(List<Number> zList, double tu, double maxZ) {
        double[] result = new double[zList.size()];
        int size = zList.size();
        for (int i = 0; i < size; ++i) {
            result[i] = zList.get(i).doubleValue();
        }
        double minR = tu / 12.0;
        int size2 = zList.size();
        for (int i = 0; i < size2; ++i) {
            result[i] = result[i] * tu / maxZ;
            if (!(result[i] < minR)) continue;
            result[i] = minR;
        }
        return result;
    }

    public class LegendXYItemLabelGenerator
    extends StandardXYItemLabelGenerator
    implements XYItemLabelGenerator,
    Cloneable,
    PublicCloneable,
    Serializable {
        public String generateLabel(XYDataset dataset, int series, int item) {
            String[] keys = new String[JFreeChartExporter.this.bubbleData.size()];
            JFreeChartExporter.this.bubbleData.keySet().toArray(keys);
            String legend = ((XYZList)JFreeChartExporter.this.bubbleData.get(keys[series])).getLabels().get(item);
            legend = StringUtil.getI18nString(legend, I18nUtil.getLanguageByName(JFreeChartExporter.this.chart, JFreeChartExporter.this.language));
            return legend;
        }
    }
}

