/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.chart;

import java.awt.Color;
import java.awt.Font;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import ro.nextreports.engine.chart.Chart;
import ro.nextreports.engine.chart.ChartExporter;
import ro.nextreports.engine.chart.ChartTitle;
import ro.nextreports.engine.chart.YRange;
import ro.nextreports.engine.exporter.exception.NoDataFoundException;
import ro.nextreports.engine.exporter.util.function.FunctionFactory;
import ro.nextreports.engine.exporter.util.function.FunctionUtil;
import ro.nextreports.engine.exporter.util.function.GFunction;
import ro.nextreports.engine.i18n.I18nUtil;
import ro.nextreports.engine.queryexec.QueryException;
import ro.nextreports.engine.queryexec.QueryResult;
import ro.nextreports.engine.util.StringUtil;
import ro.nextreports.jofc2.model.Text;
import ro.nextreports.jofc2.model.axis.Axis;
import ro.nextreports.jofc2.model.axis.Label;
import ro.nextreports.jofc2.model.axis.XAxis;
import ro.nextreports.jofc2.model.axis.YAxis;
import ro.nextreports.jofc2.model.axis.YLabel;
import ro.nextreports.jofc2.model.elements.AnimatedElement;
import ro.nextreports.jofc2.model.elements.AreaLineChart;
import ro.nextreports.jofc2.model.elements.BarChart;
import ro.nextreports.jofc2.model.elements.Element;
import ro.nextreports.jofc2.model.elements.HorizontalBarChart;
import ro.nextreports.jofc2.model.elements.LineChart;
import ro.nextreports.jofc2.model.elements.PieChart;
import ro.nextreports.jofc2.model.elements.StackedBarChart;
import ro.nextreports.jofc2.model.elements.Tooltip;

public class JsonExporter
implements ChartExporter {
    private OutputStream out;
    private QueryResult result;
    private Chart chart;
    private PrintStream stream;
    private final Color DEFAULT_BACKGROUND = new Color(248, 248, 216);
    private Map<String, Object> parameterValues;
    private String drillFunction;
    private static final String X_KEY = "X_VALUE";
    public static final String X_VALUE = "${X_VALUE}";
    private String POP = "pop";
    private String POP_UP = "pop-up";
    private String DROP = "drop";
    private String FADE_IN = "fade-in";
    private String GROW_UP = "grow-up";
    private String GROW_DOWN = "grow-down";
    private String EXPLODE = "explode";
    private String MID_SLIDE = "mid-slide";
    private String SHRINK_IN = "shrink-in";
    private String language;

    public JsonExporter(Map<String, Object> parameterValues, QueryResult result, OutputStream out, Chart chart, String drillFunction, String language) {
        this.parameterValues = parameterValues;
        this.result = result;
        this.out = out;
        this.chart = chart;
        this.drillFunction = drillFunction;
        this.language = language;
    }

    @Override
    public boolean export() throws QueryException, NoDataFoundException {
        this.testForData();
        this.initExport();
        String json = this.createFlashChart().toString();
        this.stream.print(json);
        return true;
    }

    private void testForData() throws QueryException, NoDataFoundException {
        if (this.out == null || this.result == null || this.result.getColumnCount() <= 0 || this.result.getRowCount() == 0) {
            throw new NoDataFoundException();
        }
    }

    protected void initExport() throws QueryException {
        this.stream = this.createPrintStream();
    }

    protected PrintStream createPrintStream() throws QueryException {
        try {
            return new PrintStream(this.out, false, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new QueryException(e);
        }
    }

    private String getStyle(ChartTitle chartTitle) {
        byte align;
        StringBuffer titleStyle = new StringBuffer();
        Font font = chartTitle.getFont();
        titleStyle.append('{');
        titleStyle.append("font-size: ").append(font.getSize()).append("px;");
        titleStyle.append("color: ").append(this.getHexColor(chartTitle.getColor())).append(";");
        titleStyle.append("font-family: ").append(font.getFamily()).append(";");
        if (font.isBold()) {
            titleStyle.append("font-weight: bold;");
        }
        if (font.isItalic()) {
            titleStyle.append("font-style: italic;");
        }
        if ((align = chartTitle.getAlignment()) == 1) {
            titleStyle.append("text-align: left;");
        } else if (align == 2) {
            titleStyle.append("text-align: center;");
        } else if (align == 3) {
            titleStyle.append("text-align: right;");
        }
        titleStyle.append('}');
        return titleStyle.toString();
    }

    private ro.nextreports.jofc2.model.Chart createFlashChart() throws QueryException {
        ChartTitle chartTitle = this.chart.getTitle();
        String title = this.replaceParameters(chartTitle.getTitle());
        title = StringUtil.getI18nString(title, I18nUtil.getLanguageByName(this.chart, this.language));
        String titleStyle = this.getStyle(chartTitle);
        ro.nextreports.jofc2.model.Chart flashChart = new ro.nextreports.jofc2.model.Chart(title, titleStyle);
        XAxis xAxis = new XAxis();
        xAxis.setColour(this.getHexColor(this.chart.getxAxisColor()));
        flashChart.setXAxis(xAxis);
        YAxis yAxis = new YAxis();
        yAxis.setColour(this.getHexColor(this.chart.getyAxisColor()));
        flashChart.setYAxis(yAxis);
        this.setBackground(flashChart);
        this.setGridAxisColors(flashChart, xAxis, yAxis);
        this.setLegends(flashChart);
        this.setTooltip(flashChart);
        boolean showXLabel = this.chart.getXShowLabel() == null ? false : this.chart.getXShowLabel();
        boolean showYLabel = this.chart.getYShowLabel() == null ? false : this.chart.getYShowLabel();
        this.setTicks(xAxis, yAxis, showXLabel, showYLabel);
        this.setElements(flashChart, xAxis, yAxis, showXLabel, showYLabel);
        String yTooltipPattern = this.chart.getYTooltipPattern();
        if (yTooltipPattern != null) {
            DecimalFormat df = new DecimalFormat(yTooltipPattern);
            int numDecimals = df.getMinimumFractionDigits();
            char decimalSEparator = df.getDecimalFormatSymbols().getDecimalSeparator();
            flashChart.setNumDecimals(numDecimals);
            flashChart.setDecimalSeparatorIsComma(',' == decimalSEparator);
            flashChart.setThousandSeparatorDisabled(false);
        }
        return flashChart;
    }

    private Element[] createBarChart(XAxis xAxis, YAxis yAxis, boolean showXLabel, boolean showYLabel) throws QueryException {
        Element[] charts = new Element[this.chart.getYColumns().size()];
        for (int i = 0; i < charts.length; ++i) {
            BarChart barChart;
            byte style = this.chart.getType().getStyle();
            switch (style) {
                case 10: {
                    barChart = new BarChart(BarChart.Style.GLASS);
                    break;
                }
                case 11: {
                    barChart = new BarChart(BarChart.Style.CYLINDER);
                    break;
                }
                case 12: {
                    barChart = new BarChart(BarChart.Style.THREED);
                    break;
                }
                case 13: {
                    barChart = new BarChart(BarChart.Style.DOME);
                    break;
                }
                default: {
                    barChart = new BarChart();
                }
            }
            barChart.setColour(this.getHexColor(this.chart.getForegrounds().get(i)));
            barChart.setAlpha(Float.valueOf(this.getAlpha(this.chart.getTransparency())));
            barChart.setTooltip("#val#");
            barChart.setFontSize(Integer.valueOf(this.chart.getFont().getSize()));
            barChart.setOnShow(new AnimatedElement.OnShow(this.DROP, 0, 1));
            charts[i] = barChart;
        }
        this.createChart(xAxis, yAxis, showXLabel, showYLabel, charts);
        return charts;
    }

    private Element[] createHorizontalBarChart(XAxis xAxis, YAxis yAxis, boolean showXLabel, boolean showYLabel) throws QueryException {
        Element[] charts = new Element[this.chart.getYColumns().size()];
        for (int i = 0; i < charts.length; ++i) {
            HorizontalBarChart barChart = new HorizontalBarChart();
            barChart.setColour(this.getHexColor(this.chart.getForegrounds().get(i)));
            barChart.setAlpha(Float.valueOf(this.getAlpha(this.chart.getTransparency())));
            barChart.setTooltip("#val#");
            charts[i] = barChart;
        }
        this.createChart(xAxis, yAxis, showXLabel, showYLabel, charts);
        return charts;
    }

    private Element[] createPieChart(boolean showXLabel, boolean showYLabel) throws QueryException {
        Element[] charts = new Element[1];
        PieChart pieChart = new PieChart();
        pieChart.setAnimate(true);
        pieChart.setStartAngle(Integer.valueOf(35));
        pieChart.setBorder(Integer.valueOf(2));
        ArrayList<Object> animations = new ArrayList<Object>();
        animations.add(new PieChart.AnimationPie.Fade());
        animations.add(new PieChart.AnimationPie.Bounce(Integer.valueOf(10)));
        pieChart.addAnimations(animations);
        pieChart.setGradientFill(Boolean.valueOf(true));
        pieChart.setAlpha(Float.valueOf(this.getAlpha(this.chart.getTransparency())));
        ArrayList<String> colors = new ArrayList<String>();
        for (Color color : this.chart.getForegrounds()) {
            colors.add(this.getHexColor(color));
        }
        pieChart.setColours(colors.toArray(new String[10]));
        pieChart.setTooltip("#val# of #total#<br>#percent# of 100%");
        pieChart.setFontSize(Integer.valueOf(this.chart.getFont().getSize()));
        charts[0] = pieChart;
        this.createChart(null, null, showXLabel, showYLabel, new Element[]{pieChart});
        return charts;
    }

    private Element[] createStackedBarChart(XAxis xAxis, YAxis yAxis, boolean showXLabel, boolean showYLabel) throws QueryException {
        Element[] charts = new Element[this.chart.getYColumns().size()];
        StackedBarChart barChart = new StackedBarChart();
        barChart.setAlpha(Float.valueOf(this.getAlpha(this.chart.getTransparency())));
        barChart.setTooltip("#val#");
        barChart.setFontSize(Integer.valueOf(this.chart.getFont().getSize()));
        for (int i = 0; i < charts.length; ++i) {
            charts[i] = barChart;
        }
        this.createChart(xAxis, yAxis, showXLabel, showYLabel, charts);
        return charts;
    }

    private Element[] createLineChart(XAxis xAxis, YAxis yAxis, boolean showXLabel, boolean showYLabel) throws QueryException {
        Element[] charts = new Element[this.chart.getYColumns().size()];
        for (int i = 0; i < charts.length; ++i) {
            LineChart.Style.Type type;
            LineChart lineChart = new LineChart();
            lineChart.setWidth(Integer.valueOf(4));
            lineChart.setColour(this.getHexColor(this.chart.getForegrounds().get(i)));
            lineChart.setAlpha(Float.valueOf(this.getAlpha(this.chart.getTransparency())));
            lineChart.setDotSize(Integer.valueOf(5));
            byte style = this.chart.getType().getStyle();
            switch (style) {
                case 23: {
                    type = LineChart.Style.Type.SOLID_DOT;
                    break;
                }
                case 24: {
                    type = LineChart.Style.Type.HALLOW_DOT;
                    break;
                }
                case 20: {
                    type = LineChart.Style.Type.ANCHOR;
                    break;
                }
                case 22: {
                    type = LineChart.Style.Type.BOW;
                    break;
                }
                case 21: {
                    type = LineChart.Style.Type.STAR;
                    break;
                }
                default: {
                    type = LineChart.Style.Type.DOT;
                }
            }
            lineChart.setDotStyle(new LineChart.Style(type, "#111111", Integer.valueOf(4), Integer.valueOf(4)).setRotation(Integer.valueOf(90)));
            lineChart.setFontSize(Integer.valueOf(this.chart.getFont().getSize()));
            lineChart.setOnShow(new AnimatedElement.OnShow(this.EXPLODE));
            charts[i] = lineChart;
        }
        this.createChart(xAxis, yAxis, showXLabel, showYLabel, charts);
        return charts;
    }

    private Element[] createAreaChart(XAxis xAxis, YAxis yAxis, boolean showXLabel, boolean showYLabel) throws QueryException {
        Element[] charts = new Element[this.chart.getYColumns().size()];
        for (int i = 0; i < charts.length; ++i) {
            AreaLineChart areaChart = new AreaLineChart();
            areaChart.setWidth(Integer.valueOf(4));
            areaChart.setColour(this.getHexColor(this.chart.getForegrounds().get(i)));
            areaChart.setAlpha(Float.valueOf(this.getAlpha(this.chart.getTransparency())));
            areaChart.setDotSize(Integer.valueOf(5));
            areaChart.setFontSize(Integer.valueOf(this.chart.getFont().getSize()));
            areaChart.setOnShow(new AnimatedElement.OnShow(this.MID_SLIDE));
            charts[i] = areaChart;
        }
        this.createChart(xAxis, yAxis, showXLabel, showYLabel, charts);
        return charts;
    }

    private void createChart(XAxis xAxis, YAxis yAxis, boolean showXLabel, boolean showYLabel, Element[] elementChart) throws QueryException {
        Number min = Double.MAX_VALUE;
        Double max = Double.MIN_VALUE;
        int row = 0;
        Object previous = null;
        String xColumn = this.chart.getXColumn();
        String xPattern = this.chart.getXPattern();
        String lastXValue = "";
        boolean isPie = elementChart[0] instanceof PieChart;
        boolean isHorizontal = elementChart[0] instanceof HorizontalBarChart;
        boolean isStacked = elementChart[0] instanceof StackedBarChart;
        int chartsNo = elementChart.length;
        GFunction[] functions = new GFunction[chartsNo];
        ArrayList<StackedBarChart.Key> keys = new ArrayList<StackedBarChart.Key>();
        for (int i = 0; i < chartsNo; ++i) {
            functions[i] = FunctionFactory.getFunction(this.chart.getYFunction());
            if (this.chart.getYColumnsLegends() == null || i >= this.chart.getYColumnsLegends().size() || this.chart.getYColumnsLegends().get(i) == null) continue;
            if (isStacked) {
                StackedBarChart.Key key = new StackedBarChart.Key(this.getHexColor(this.chart.getForegrounds().get(i)), StringUtil.getI18nString(this.replaceParameters(this.chart.getYColumnsLegends().get(i)), I18nUtil.getLanguageByName(this.chart, this.language)), Integer.valueOf(12));
                keys.add(key);
                continue;
            }
            elementChart[i].setText(StringUtil.getI18nString(this.replaceParameters(this.chart.getYColumnsLegends().get(i)), I18nUtil.getLanguageByName(this.chart, this.language)));
        }
        if (isStacked) {
            ((StackedBarChart)elementChart[0]).addKeys(keys);
        }
        int groups = 1;
        HashMap<Integer, String> infoLabels = new HashMap<Integer, String>();
        while (this.result.hasNext()) {
            int i;
            Object xValue;
            Object[] objects = new Object[chartsNo];
            Number[] computedValues = new Number[chartsNo];
            for (int i2 = 0; i2 < chartsNo; ++i2) {
                if (this.chart.getYColumns().get(i2) == null) continue;
                objects[i2] = this.result.nextValue(this.chart.getYColumns().get(i2));
                Number value = null;
                if (objects[i2] instanceof Number) {
                    value = (Number)objects[i2];
                } else if (objects[i2] != null) {
                    value = 1;
                }
                if (value == null) {
                    value = 0;
                }
                computedValues[i2] = value.doubleValue();
            }
            if (row == 0) {
                xValue = this.result.nextValue(xColumn);
                lastXValue = this.getStringValue(xColumn, xPattern);
            } else {
                xValue = previous;
            }
            Object newXValue = this.result.nextValue(xColumn);
            boolean add = false;
            if ("NOOP".equals(functions[0].getName())) {
                lastXValue = this.getStringValue(xColumn, xPattern);
                add = true;
            } else {
                boolean equals = FunctionUtil.parameterEquals(xValue, newXValue);
                if (equals) {
                    for (i = 0; i < chartsNo; ++i) {
                        functions[i].compute(objects[i]);
                    }
                } else {
                    for (i = 0; i < chartsNo; ++i) {
                        add = true;
                        computedValues[i] = (Number)functions[i].getComputedValue();
                        functions[i].reset();
                        functions[i].compute(objects[i]);
                    }
                }
            }
            if (add) {
                Number sum = 0;
                for (i = 0; i < chartsNo; ++i) {
                    this.addValue(computedValues[i], lastXValue, elementChart[i], i);
                    if (!isStacked) {
                        min = Math.min(min.doubleValue(), computedValues[i].doubleValue());
                        max = Math.max(max, computedValues[i].doubleValue());
                        continue;
                    }
                    sum = ((Number)sum).doubleValue() + computedValues[i].doubleValue();
                }
                if (this.chart.getStartingFromZero() != null && this.chart.getStartingFromZero().booleanValue() && min.intValue() > 0) {
                    min = 0;
                }
                if (isStacked) {
                    min = 0;
                    max = Math.max(max, ((Number)sum).doubleValue());
                }
                infoLabels.put(groups, lastXValue);
                ++groups;
                lastXValue = this.getStringValue(xColumn, xPattern);
            }
            ++row;
            previous = newXValue;
        }
        if (!"NOOP".equals(functions[0].getName())) {
            Number sum = 0;
            for (int i = 0; i < chartsNo; ++i) {
                Number value = (Number)functions[i].getComputedValue();
                this.addValue(value, lastXValue, elementChart[i], i);
                if (!isStacked) {
                    min = Math.min(min.doubleValue(), value.doubleValue());
                    max = Math.max(max, value.doubleValue());
                    continue;
                }
                sum = ((Number)sum).doubleValue() + value.doubleValue();
            }
            if (this.chart.getStartingFromZero() != null && this.chart.getStartingFromZero().booleanValue() && min.intValue() > 0) {
                min = 0;
            }
            if (isStacked) {
                min = 0;
                max = Math.max(max, ((Number)sum).doubleValue());
            }
            infoLabels.put(groups, lastXValue);
        } else {
            --groups;
        }
        if (!isPie) {
            if (isHorizontal) {
                int factor = groups < 2 ? 0 : (groups - 2) / 10;
                YRange range = this.setAxisRange((Axis)yAxis, 1, (double)groups - 0.5);
                for (int i = groups; i > 0; --i) {
                    String text = (String)infoLabels.get(i);
                    if (!showXLabel) {
                        text = "";
                    }
                    this.addYLabel(yAxis, text, groups - i + factor + 1);
                    for (int j = 1; j < chartsNo; ++j) {
                        this.addYLabel(yAxis, "", groups - i + factor + 1);
                    }
                }
            } else {
                for (int i = 1; i <= groups; ++i) {
                    String text = (String)infoLabels.get(i);
                    if (!showXLabel) {
                        text = "";
                    }
                    this.addXLabel(xAxis, text);
                }
            }
        }
        if (!isPie) {
            if (isHorizontal) {
                this.addXLabels(xAxis, min, max, showYLabel);
            } else {
                this.addYLabels(yAxis, min, max, showYLabel);
            }
        }
    }

    private void addXLabel(XAxis xAxis, String text) {
        Label label = new Label(text);
        label.setRotation(this.getRotation(this.chart.getXorientation()));
        label.setColour(this.getHexColor(this.chart.getXColor()));
        label.setSize(Integer.valueOf(this.chart.getXLabelFont().getSize()));
        xAxis.addLabels(new Label[]{label});
    }

    private void addYLabels(YAxis yAxis, Number min, Number max, boolean showYLabels) {
        YRange v = this.setAxisRange((Axis)yAxis, min, max);
        for (int n = v.getMin().intValue(); n <= v.getMax().intValue(); n += v.getStep()) {
            String text = String.valueOf(n);
            if (!showYLabels) {
                text = "";
            }
            YLabel yLabel = new YLabel(text, Integer.valueOf(n));
            yLabel.setColour(this.getHexColor(this.chart.getYColor()));
            yAxis.addLabels(new Label[]{yLabel});
            yLabel.setSize(Integer.valueOf(this.chart.getYLabelFont().getSize()));
        }
    }

    private void addYLabel(YAxis yAxis, String text, int n) {
        YLabel label = new YLabel(text, Integer.valueOf(n));
        label.setRotation(this.getRotation(this.chart.getXorientation()));
        label.setColour(this.getHexColor(this.chart.getXColor()));
        label.setSize(Integer.valueOf(this.chart.getYLabelFont().getSize()));
        yAxis.addLabels(new Label[]{label});
    }

    private void addXLabels(XAxis xAxis, Number min, Number max, boolean showYLabels) {
        xAxis.setOffset(Boolean.valueOf(false));
        YRange v = this.setAxisRange((Axis)xAxis, 0, max);
        if (!showYLabels) {
            xAxis.setLabels(new String[]{""});
        } else {
            xAxis.getLabels().setColour(this.getHexColor(this.chart.getYColor()));
        }
    }

    private void addValue(Number value, String text, Element chart, int position) {
        String function = null;
        if (this.drillFunction != null) {
            try {
                text = URLEncoder.encode(text, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            function = StringUtil.replace(this.drillFunction, "\\$\\{X_VALUE\\}", text);
        }
        if (chart instanceof BarChart) {
            BarChart.Bar bar = new BarChart.Bar(value);
            if (function != null) {
                bar.setOnClick(function);
            }
            ((BarChart)chart).addBars(new BarChart.Bar[]{bar});
        } else if (chart instanceof HorizontalBarChart) {
            HorizontalBarChart.Bar bar = new HorizontalBarChart.Bar((Number)0, value);
            bar.setTooltip(this.getStringValue(value));
            ((HorizontalBarChart)chart).addBars(new HorizontalBarChart.Bar[]{bar});
        } else if (chart instanceof AreaLineChart) {
            LineChart.Dot dot = new LineChart.Dot(value);
            if (function != null) {
                dot.setOnClick(function);
            }
            ((AreaLineChart)chart).addDots(new LineChart.Dot[]{dot});
        } else if (chart instanceof LineChart) {
            LineChart.Dot dot = new LineChart.Dot(value);
            if (function != null) {
                dot.setOnClick(function);
            }
            ((LineChart)chart).addDots(new LineChart.Dot[]{dot});
        } else if (chart instanceof PieChart) {
            PieChart.Slice slice = new PieChart.Slice(value, text);
            if (function != null) {
                slice.setOnClick(function);
            }
            ((PieChart)chart).addSlices(new PieChart.Slice[]{slice});
        } else if (chart instanceof StackedBarChart) {
            StackedBarChart.Stack stack;
            StackedBarChart sbChart = (StackedBarChart)chart;
            if (position == 0) {
                stack = new StackedBarChart.Stack();
                sbChart.addStack(new StackedBarChart.Stack[]{stack});
            } else {
                stack = sbChart.lastStack();
            }
            StackedBarChart.StackValue stackValue = new StackedBarChart.StackValue(value);
            stackValue.setColour(this.getHexColor(this.chart.getForegrounds().get(position)));
            stack.addStackValues(new StackedBarChart.StackValue[]{stackValue});
        }
    }

    private YRange setAxisRange(Axis axis, Number min, Number max) {
        YRange yRange = new YRange(min, max);
        yRange = yRange.update();
        axis.setRange(yRange.getMin(), yRange.getMax(), (Number)yRange.getStep());
        return yRange;
    }

    private void setBackground(ro.nextreports.jofc2.model.Chart flashChart) {
        if (this.chart.getBackground() != null) {
            flashChart.setBackgroundColour(this.getHexColor(this.chart.getBackground()));
        }
    }

    private void setGridAxisColors(ro.nextreports.jofc2.model.Chart flashChart, XAxis xAxis, YAxis yAxis) {
        boolean isHorizontal = this.chart.getType().isHorizontal();
        Color xGridColor = this.chart.getXGridColor();
        Color yGridColor = this.chart.getYGridColor();
        if (xGridColor != null) {
            this.getXAxis(xAxis, yAxis, isHorizontal).setGridColour(this.getHexColor(xGridColor));
        }
        if (this.chart.getXShowGrid() != null && !this.chart.getXShowGrid().booleanValue()) {
            if (flashChart.getBackgroundColour() == null) {
                this.getXAxis(xAxis, yAxis, isHorizontal).setGridColour(this.getHexColor(this.DEFAULT_BACKGROUND));
            } else {
                this.getXAxis(xAxis, yAxis, isHorizontal).setGridColour(flashChart.getBackgroundColour());
            }
        }
        if (yGridColor != null) {
            this.getYAxis(xAxis, yAxis, isHorizontal).setGridColour(this.getHexColor(yGridColor));
        }
        if (this.chart.getYShowGrid() != null && !this.chart.getYShowGrid().booleanValue()) {
            if (flashChart.getBackgroundColour() == null) {
                this.getYAxis(xAxis, yAxis, isHorizontal).setGridColour(this.getHexColor(this.DEFAULT_BACKGROUND));
            } else {
                this.getYAxis(xAxis, yAxis, isHorizontal).setGridColour(flashChart.getBackgroundColour());
            }
        }
    }

    private Axis getXAxis(XAxis xAxis, YAxis yAxis, boolean isHorizontal) {
        if (!isHorizontal) {
            return xAxis;
        }
        return yAxis;
    }

    private Axis getYAxis(XAxis xAxis, YAxis yAxis, boolean isHorizontal) {
        if (!isHorizontal) {
            return yAxis;
        }
        return xAxis;
    }

    private void setTicks(XAxis xAxis, YAxis yAxis, boolean showXLabel, boolean showYLabel) {
        boolean isHorizontal = this.chart.getType().isHorizontal();
        if (!showXLabel && !isHorizontal || !showYLabel && isHorizontal) {
            xAxis.setTickHeight(Integer.valueOf(0));
        }
        if (!showYLabel && !isHorizontal || !showXLabel && isHorizontal) {
            yAxis.setTickLength(Integer.valueOf(0));
        }
    }

    private void setTooltip(ro.nextreports.jofc2.model.Chart flashChart) {
        Tooltip tooltip = new Tooltip();
        tooltip.setHover();
        flashChart.setTooltip(tooltip);
    }

    private void setLegends(ro.nextreports.jofc2.model.Chart flashChart) {
        boolean isHorizontal = this.chart.getType().isHorizontal();
        String xLegend = StringUtil.getI18nString(this.replaceParameters(this.chart.getXLegend().getTitle()), I18nUtil.getLanguageByName(this.chart, this.language));
        String yLegend = StringUtil.getI18nString(this.replaceParameters(this.chart.getYLegend().getTitle()), I18nUtil.getLanguageByName(this.chart, this.language));
        Text xText = new Text(xLegend, this.getStyle(this.chart.getXLegend()));
        Text yText = new Text(yLegend, this.getStyle(this.chart.getYLegend()));
        if (!isHorizontal) {
            flashChart.setXLegend(xText);
            flashChart.setYLegend(yText);
        } else {
            flashChart.setXLegend(yText);
            flashChart.setYLegend(xText);
        }
    }

    private void setElements(ro.nextreports.jofc2.model.Chart flashChart, XAxis xAxis, YAxis yAxis, boolean showXLabel, boolean showYLabel) throws QueryException {
        byte type = this.chart.getType().getType();
        Element[] charts = new Element[]{};
        if (1 == type || 80 == type) {
            charts = this.createBarChart(xAxis, yAxis, showXLabel, showYLabel);
        } else if (2 == type) {
            charts = this.createHorizontalBarChart(xAxis, yAxis, showXLabel, showYLabel);
        } else if (5 == type) {
            charts = this.createStackedBarChart(xAxis, yAxis, showXLabel, showYLabel);
        } else if (10 == type) {
            charts = this.createPieChart(showXLabel, showYLabel);
        } else if (20 == type) {
            charts = this.createLineChart(xAxis, yAxis, showXLabel, showYLabel);
        } else if (50 == type) {
            charts = this.createAreaChart(xAxis, yAxis, showXLabel, showYLabel);
        }
        for (Element element : charts) {
            flashChart.addElements(new Element[]{element});
        }
    }

    private String getStringValue(String column, String pattern) throws QueryException {
        Object xObject = this.result.nextValue(column);
        return StringUtil.getValueAsString(xObject, pattern);
    }

    private String getStringValue(Number number) {
        if (number == null) {
            return "";
        }
        if ((double)number.intValue() == number.doubleValue()) {
            return String.valueOf(number.intValue());
        }
        return String.valueOf(number.doubleValue());
    }

    private String getHexColor(Color color) {
        String rgb = Integer.toHexString(color.getRGB());
        rgb = rgb.substring(2, rgb.length());
        return rgb;
    }

    private Label.Rotation getRotation(byte rotation) {
        if (2 == rotation) {
            return Label.Rotation.VERTICAL;
        }
        if (3 == rotation) {
            return Label.Rotation.DIAGONAL;
        }
        if (4 == rotation) {
            return Label.Rotation.HALF_DIAGONAL;
        }
        return Label.Rotation.HORIZONTAL;
    }

    private float getAlpha(byte transparency) {
        switch (transparency) {
            case 2: {
                return 0.75f;
            }
            case 3: {
                return 0.5f;
            }
            case 4: {
                return 0.25f;
            }
        }
        return 1.0f;
    }

    private String replaceParameters(String text) {
        for (String param : this.parameterValues.keySet()) {
            text = StringUtil.replace(text, "\\$P\\{" + param + "\\}", StringUtil.getValueAsString(this.parameterValues.get(param), null, I18nUtil.getLanguageByName(this.chart, this.language)));
        }
        return text;
    }
}

