/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.chart;

import java.awt.Color;
import java.awt.Font;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.nextreports.engine.chart.Chart;
import ro.nextreports.engine.chart.ChartExporter;
import ro.nextreports.engine.chart.ChartTitle;
import ro.nextreports.engine.chart.ChartType;
import ro.nextreports.engine.chart.NextChart;
import ro.nextreports.engine.chart.NextChartAxis;
import ro.nextreports.engine.chart.NextChartFont;
import ro.nextreports.engine.chart.NextChartLegend;
import ro.nextreports.engine.chart.NextChartTitle;
import ro.nextreports.engine.chart.NextNumberFormat;
import ro.nextreports.engine.exporter.exception.NoDataFoundException;
import ro.nextreports.engine.exporter.util.function.FunctionFactory;
import ro.nextreports.engine.exporter.util.function.FunctionUtil;
import ro.nextreports.engine.exporter.util.function.GFunction;
import ro.nextreports.engine.i18n.I18nUtil;
import ro.nextreports.engine.queryexec.QueryException;
import ro.nextreports.engine.queryexec.QueryResult;
import ro.nextreports.engine.util.ColorUtil;
import ro.nextreports.engine.util.ObjectCloner;
import ro.nextreports.engine.util.StringUtil;

public class JsonHTML5Exporter
implements ChartExporter {
    private OutputStream out;
    private QueryResult result;
    private Chart chart;
    private PrintStream stream;
    private final Color DEFAULT_BACKGROUND = new Color(248, 248, 216);
    private Map<String, Object> parameterValues;
    private String drillFunction;
    private NextChart nc;
    private String language;
    private static final String CLICKED_VALUE = "#val";

    public JsonHTML5Exporter(Map<String, Object> parameterValues, QueryResult result, OutputStream out, Chart chart, String drillFunction, String language) {
        this.parameterValues = parameterValues;
        this.result = result;
        this.out = out;
        this.chart = chart;
        this.drillFunction = drillFunction;
        this.language = language;
        this.nc = new NextChart();
    }

    @Override
    public boolean export() throws QueryException, NoDataFoundException {
        this.testForData();
        this.initExport();
        String json = this.createHTML5Chart();
        System.out.println(json);
        this.stream.print(json);
        return true;
    }

    private void testForData() throws QueryException, NoDataFoundException {
        if (this.out == null || this.result == null || this.result.getColumnCount() <= 0 || this.result.getRowCount() == 0) {
            throw new NoDataFoundException();
        }
    }

    protected void initExport() throws QueryException {
        this.stream = this.createPrintStream();
    }

    protected PrintStream createPrintStream() throws QueryException {
        try {
            return new PrintStream(this.out, false, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new QueryException(e);
        }
    }

    private NextChartTitle createTitle(ChartTitle chartTitle) {
        NextChartTitle nct = new NextChartTitle(StringUtil.getI18nString(chartTitle.getTitle(), I18nUtil.getLanguageByName(this.chart, this.language)));
        Font font = chartTitle.getFont();
        if (chartTitle.getColor() != null) {
            nct.setColor(ColorUtil.getHexColor(chartTitle.getColor()));
        }
        nct.setFont(this.createFont(font));
        byte align = chartTitle.getAlignment();
        if (align == 1) {
            nct.setAlignment(NextChart.Alignment.left);
        } else if (align == 2) {
            nct.setAlignment(NextChart.Alignment.center);
        } else if (align == 3) {
            nct.setAlignment(NextChart.Alignment.right);
        }
        return nct;
    }

    private NextChartFont createFont(Font font) {
        String weight = "normal";
        if (font.isBold()) {
            weight = "bold";
        }
        if (font.isItalic()) {
            weight = weight + " italic";
        }
        return new NextChartFont(weight, font.getSize(), font.getFamily());
    }

    private String createHTML5Chart() throws QueryException {
        String yTooltipPattern;
        this.setType();
        this.setStyle();
        this.setBackground();
        this.setLabelOrientation(this.chart.getXorientation());
        this.setTitle();
        if (this.drillFunction != null) {
            this.nc.setOnClick(this.drillFunction);
        }
        this.nc.setAlpha(Float.valueOf(this.getAlpha(this.chart.getTransparency())));
        this.setGridStyle();
        if (this.chart.getxAxisColor() != null) {
            this.nc.setColorXaxis(ColorUtil.getHexColor(this.chart.getxAxisColor()));
        }
        if (this.chart.getyAxisColor() != null) {
            this.nc.setColorYaxis(ColorUtil.getHexColor(this.chart.getyAxisColor()));
        }
        boolean showGridX = this.chart.getXShowGrid() == null ? false : this.chart.getXShowGrid();
        boolean showGridY = this.chart.getYShowGrid() == null ? false : this.chart.getYShowGrid();
        this.nc.setShowGridX(showGridX);
        this.nc.setShowGridY(showGridY);
        if (this.chart.getXGridColor() != null) {
            this.nc.setColorGridX(ColorUtil.getHexColor(this.chart.getXGridColor()));
        }
        if (this.chart.getYGridColor() != null) {
            this.nc.setColorGridY(ColorUtil.getHexColor(this.chart.getYGridColor()));
        }
        if (this.chart.getShowDualAxis() != null) {
            this.nc.setDualYaxis(this.chart.getShowDualAxis());
            if (this.chart.getY2SeriesCount() != null) {
                this.nc.setY2Count(this.chart.getY2SeriesCount());
            }
        }
        this.nc.setTickCount(5);
        if (this.chart.getTooltipMessage() != null && !this.chart.getTooltipMessage().trim().isEmpty()) {
            String msg = StringUtil.getI18nStringMultiple(this.chart.getTooltipMessage(), I18nUtil.getLanguageByName(this.chart, this.language));
            this.nc.setMessage(msg);
        }
        boolean startingFromZero = this.chart.getStartingFromZero() == null ? false : this.chart.getStartingFromZero();
        this.nc.setStartingFromZero(startingFromZero);
        boolean showXLabel = this.chart.getXShowLabel() == null ? false : this.chart.getXShowLabel();
        boolean showYLabel = this.chart.getYShowLabel() == null ? false : this.chart.getYShowLabel();
        this.nc.setShowTicks(showYLabel);
        if (showXLabel) {
            NextChartAxis xData = new NextChartAxis();
            xData.setColor(ColorUtil.getHexColor(this.chart.getXColor()));
            xData.setFont(this.createFont(this.chart.getXLabelFont()));
            this.nc.setxData(xData);
        }
        if (showYLabel) {
            NextChartAxis yData = new NextChartAxis();
            yData.setColor(ColorUtil.getHexColor(this.chart.getYColor()));
            yData.setFont(this.createFont(this.chart.getYLabelFont()));
            this.nc.setyData(yData);
        }
        if ((yTooltipPattern = this.chart.getYTooltipPattern()) != null) {
            DecimalFormat df = new DecimalFormat(yTooltipPattern);
            int decimals = df.getMinimumFractionDigits();
            char decimalSeparator = df.getDecimalFormatSymbols().getDecimalSeparator();
            char thousandSeparator = df.getDecimalFormatSymbols().getGroupingSeparator();
            NextNumberFormat tooltipPattern = new NextNumberFormat();
            tooltipPattern.setDecimals(decimals);
            tooltipPattern.setDecimalSeparator(String.valueOf(decimalSeparator));
            tooltipPattern.setThousandSeparator(String.valueOf(thousandSeparator));
            this.nc.setTooltipPattern(tooltipPattern);
        }
        boolean isCombo = ChartType.isCombo(this.chart.getType().getType());
        this.setLegends(isCombo);
        this.setColors(isCombo);
        ArrayList<List<Number>> dataList = new ArrayList<List<Number>>();
        int size = this.chart.getYColumns().size();
        if (isCombo) {
            size = this.chart.getYColumns().size() - 1;
            if (size > 0) {
                ArrayList<List<Number>> lineDataList = new ArrayList<List<Number>>();
                lineDataList.add(new ArrayList());
                this.nc.setLineData(lineDataList);
            } else {
                dataList.add(new ArrayList());
            }
        }
        for (int i = 0; i < size; ++i) {
            dataList.add(new ArrayList());
        }
        this.nc.setData(dataList);
        this.nc.setLabels(new ArrayList<String>());
        this.createChart(showXLabel, showYLabel);
        return this.nc.toJson();
    }

    private String convertGridStyleFromByte(byte style) {
        String styleGrid = "line";
        switch (style) {
            case 2: {
                styleGrid = "dot";
                break;
            }
            case 3: {
                styleGrid = "dash";
                break;
            }
            default: {
                styleGrid = "line";
            }
        }
        return styleGrid;
    }

    private void setGridStyle() {
        this.nc.setStyleGridX(this.convertGridStyleFromByte(this.chart.getStyleGridX()));
        this.nc.setStyleGridY(this.convertGridStyleFromByte(this.chart.getStyleGridY()));
    }

    private void createChart(boolean showXLabel, boolean showYLabel) throws QueryException {
        Number min = Double.MAX_VALUE;
        Double max = Double.MIN_VALUE;
        int row = 0;
        Object previous = null;
        String xColumn = this.chart.getXColumn();
        String xPattern = this.chart.getXPattern();
        String lastXValue = "";
        int chartsNo = this.chart.getYColumns().size();
        boolean isStacked = this.nc.getType().equals((Object)NextChart.Type.stackedbar) || this.nc.getType().equals((Object)NextChart.Type.hstackedbar);
        GFunction[] functions = new GFunction[chartsNo];
        for (int i = 0; i < chartsNo; ++i) {
            functions[i] = FunctionFactory.getFunction(this.chart.getYFunction());
        }
        int groups = 1;
        HashMap<Integer, String> infoLabels = new HashMap<Integer, String>();
        ArrayList<String> categories = new ArrayList<String>();
        while (this.result.hasNext()) {
            int i;
            Object xValue;
            Object[] objects = new Object[chartsNo];
            Number[] computedValues = new Number[chartsNo];
            for (int i2 = 0; i2 < chartsNo; ++i2) {
                if (this.chart.getYColumns().get(i2) == null) continue;
                objects[i2] = this.result.nextValue(this.chart.getYColumns().get(i2));
                Number value = null;
                String sv = null;
                if (objects[i2] instanceof Number) {
                    value = (Number)objects[i2];
                } else if (objects[i2] != null) {
                    if (70 == this.chart.getType().getType()) {
                        sv = (String)objects[i2];
                    }
                    value = 1;
                }
                if (value == null) {
                    value = 0;
                }
                computedValues[i2] = value.doubleValue();
                if (sv == null) continue;
                categories.add(sv);
            }
            if (row == 0) {
                xValue = this.result.nextValue(xColumn);
                lastXValue = this.getStringValue(xColumn, xPattern);
            } else {
                xValue = previous;
            }
            Object newXValue = this.result.nextValue(xColumn);
            boolean add = false;
            if ("NOOP".equals(functions[0].getName())) {
                lastXValue = this.getStringValue(xColumn, xPattern);
                add = true;
            } else {
                boolean equals = FunctionUtil.parameterEquals(xValue, newXValue);
                if (equals) {
                    for (i = 0; i < chartsNo; ++i) {
                        functions[i].compute(objects[i]);
                    }
                } else {
                    for (i = 0; i < chartsNo; ++i) {
                        add = true;
                        computedValues[i] = (Number)functions[i].getComputedValue();
                        functions[i].reset();
                        functions[i].compute(objects[i]);
                    }
                }
            }
            if (add) {
                Number sum = 0;
                for (i = 0; i < chartsNo; ++i) {
                    this.addValue(computedValues[i], lastXValue, i);
                    if (!isStacked) {
                        min = Math.min(min.doubleValue(), computedValues[i].doubleValue());
                        max = Math.max(max, computedValues[i].doubleValue());
                        continue;
                    }
                    sum = ((Number)sum).doubleValue() + computedValues[i].doubleValue();
                }
                if (isStacked) {
                    min = 0;
                    max = Math.max(max, ((Number)sum).doubleValue());
                }
                infoLabels.put(groups, lastXValue);
                ++groups;
                lastXValue = this.getStringValue(xColumn, xPattern);
            }
            ++row;
            previous = newXValue;
        }
        if (!"NOOP".equals(functions[0].getName())) {
            Number sum = 0;
            for (int i = 0; i < chartsNo; ++i) {
                Number value = (Number)functions[i].getComputedValue();
                this.addValue(value, lastXValue, i);
                if (!isStacked) {
                    min = Math.min(min.doubleValue(), value.doubleValue());
                    max = Math.max(max, value.doubleValue());
                    continue;
                }
                sum = ((Number)sum).doubleValue() + value.doubleValue();
            }
            if (isStacked) {
                min = 0;
                max = Math.max(max, ((Number)sum).doubleValue());
            }
            infoLabels.put(groups, lastXValue);
        } else {
            --groups;
        }
        for (int i = 1; i <= groups; ++i) {
            String text = (String)infoLabels.get(i);
            this.nc.getLabels().add(text);
            this.nc.setShowLabels(showXLabel);
        }
        if (!categories.isEmpty()) {
            this.nc.setCategories(categories);
        }
    }

    private void addValue(Number value, String text, int position) {
        if (ChartType.isCombo(this.chart.getType().getType())) {
            if (position == this.nc.getData().size() && this.nc.getData().size() > 1) {
                this.nc.getLineData().get(0).add(value);
            } else {
                this.nc.getData().get(position).add(value);
            }
        } else {
            this.nc.getData().get(position).add(value);
        }
    }

    private void setTitle() {
        ChartTitle chartTitle = ObjectCloner.silenceDeepCopy(this.chart.getTitle());
        String title = this.replaceParameters(chartTitle.getTitle());
        chartTitle.setTitle(title);
        if (!this.isEmpty(title)) {
            this.nc.setTitle(this.createTitle(chartTitle));
        }
    }

    private void setBackground() {
        if (this.chart.getBackground() != null) {
            this.nc.setBackground(ColorUtil.getHexColor(this.chart.getBackground()));
        }
    }

    private void setColors(boolean isCombo) {
        ArrayList<String> colors = new ArrayList<String>();
        if (10 == this.chart.getType().getType()) {
            for (Color color : this.chart.getForegrounds()) {
                if (color == null) continue;
                colors.add(ColorUtil.getHexColor(color));
            }
        } else {
            int size = this.chart.getYColumns().size();
            if (isCombo && size > 1) {
                ArrayList<String> lineColorList = new ArrayList<String>();
                lineColorList.add(ColorUtil.getHexColor(this.chart.getForegrounds().get(--size)));
                this.nc.setLineColor(lineColorList);
            }
            for (int i = 0; i < size; ++i) {
                colors.add(ColorUtil.getHexColor(this.chart.getForegrounds().get(i)));
            }
        }
        this.nc.setColor(colors);
    }

    private void setType() {
        byte type = this.chart.getType().getType();
        if (1 == type || 60 == type) {
            this.nc.setType(NextChart.Type.bar);
        } else if (80 == type) {
            this.nc.setType(NextChart.Type.nbar);
        } else if (2 == type) {
            this.nc.setType(NextChart.Type.hbar);
        } else if (5 == type || 61 == type) {
            this.nc.setType(NextChart.Type.stackedbar);
        } else if (6 == type) {
            this.nc.setType(NextChart.Type.hstackedbar);
        } else if (10 == type) {
            this.nc.setType(NextChart.Type.pie);
        } else if (20 == type) {
            this.nc.setType(NextChart.Type.line);
        } else if (50 == type) {
            this.nc.setType(NextChart.Type.area);
        } else if (70 == type) {
            this.nc.setType(NextChart.Type.bubble);
        }
    }

    private void setStyle() {
        byte style = this.chart.getType().getStyle();
        switch (style) {
            case 10: {
                this.nc.setStyle(NextChart.Style.glass);
                break;
            }
            case 11: {
                this.nc.setStyle(NextChart.Style.cylinder);
                break;
            }
            case 12: {
                this.nc.setStyle(NextChart.Style.parallelepiped);
                break;
            }
            case 13: {
                this.nc.setStyle(NextChart.Style.dome);
                break;
            }
            case 23: {
                this.nc.setStyle(NextChart.Style.soliddot);
                break;
            }
            case 24: {
                this.nc.setStyle(NextChart.Style.hollowdot);
                break;
            }
            case 20: {
                this.nc.setStyle(NextChart.Style.anchordot);
                break;
            }
            case 22: {
                this.nc.setStyle(NextChart.Style.bowdot);
                break;
            }
            case 21: {
                this.nc.setStyle(NextChart.Style.stardot);
                break;
            }
            default: {
                this.nc.setStyle(NextChart.Style.normal);
            }
        }
    }

    private void setLegends(boolean isCombo) {
        String yLeg;
        if (this.chart.getYColumnsLegends() != null && this.chart.getYColumnsLegends().size() > 0 && !this.isEmpty(this.chart.getYColumnsLegends().get(0))) {
            ArrayList<String> list = new ArrayList<String>();
            int size = this.chart.getYColumnsLegends().size();
            if (this.chart.getYColumnsLegends().size() > this.chart.getYColumns().size()) {
                size = this.chart.getYColumns().size();
            }
            if (isCombo && size > 1) {
                ArrayList<String> lineList = new ArrayList<String>();
                lineList.add(StringUtil.getI18nString(this.replaceParameters(this.chart.getYColumnsLegends().get(--size)), I18nUtil.getLanguageByName(this.chart, this.language)));
                this.nc.setLineLegend(lineList);
            }
            for (int i = 0; i < size; ++i) {
                String s = this.chart.getYColumnsLegends().get(i);
                list.add(StringUtil.getI18nString(this.replaceParameters(s), I18nUtil.getLanguageByName(this.chart, this.language)));
            }
            this.nc.setLegend(list);
        }
        if (this.chart.getXLegend() != null && !this.isEmpty(this.chart.getXLegend().getTitle())) {
            String xLeg = StringUtil.getI18nString(this.replaceParameters(this.chart.getXLegend().getTitle()), I18nUtil.getLanguageByName(this.chart, this.language));
            NextChartLegend xLegend = new NextChartLegend(xLeg);
            xLegend.setColor(ColorUtil.getHexColor(this.chart.getXLegend().getColor()));
            xLegend.setFont(this.createFont(this.chart.getXLegend().getFont()));
            this.nc.setxLegend(xLegend);
        }
        if (this.chart.getYLegend() != null && !this.isEmpty(this.chart.getYLegend().getTitle())) {
            yLeg = StringUtil.getI18nString(this.replaceParameters(this.chart.getYLegend().getTitle()), I18nUtil.getLanguageByName(this.chart, this.language));
            NextChartLegend yLegend = new NextChartLegend(yLeg);
            yLegend.setColor(ColorUtil.getHexColor(this.chart.getYLegend().getColor()));
            yLegend.setFont(this.createFont(this.chart.getYLegend().getFont()));
            this.nc.setyLegend(yLegend);
        }
        if (this.chart.getyDualLegend() != null && !this.isEmpty(this.chart.getyDualLegend().getTitle())) {
            yLeg = StringUtil.getI18nString(this.replaceParameters(this.chart.getyDualLegend().getTitle()), I18nUtil.getLanguageByName(this.chart, this.language));
            NextChartLegend yLegend = new NextChartLegend(yLeg);
            yLegend.setColor(ColorUtil.getHexColor(this.chart.getyDualLegend().getColor()));
            yLegend.setFont(this.createFont(this.chart.getyDualLegend().getFont()));
            this.nc.setY2Legend(yLegend);
        }
    }

    private String getStringValue(String column, String pattern) throws QueryException {
        Object xObject = this.result.nextValue(column);
        return StringUtil.getValueAsString(xObject, pattern);
    }

    private String getStringValue(Number number) {
        if (number == null) {
            return "";
        }
        if ((double)number.intValue() == number.doubleValue()) {
            return String.valueOf(number.intValue());
        }
        return String.valueOf(number.doubleValue());
    }

    private void setLabelOrientation(byte rotation) {
        if (2 == rotation) {
            this.nc.setLabelOrientation(NextChart.Orientation.vertical);
        } else if (3 == rotation) {
            this.nc.setLabelOrientation(NextChart.Orientation.diagonal);
        } else if (4 == rotation) {
            this.nc.setLabelOrientation(NextChart.Orientation.halfdiagonal);
        } else {
            this.nc.setLabelOrientation(NextChart.Orientation.horizontal);
        }
    }

    private float getAlpha(byte transparency) {
        switch (transparency) {
            case 2: {
                return 0.75f;
            }
            case 3: {
                return 0.5f;
            }
            case 4: {
                return 0.25f;
            }
        }
        return 1.0f;
    }

    private String replaceParameters(String text) {
        for (String param : this.parameterValues.keySet()) {
            text = StringUtil.replace(text, "\\$P\\{" + param + "\\}", StringUtil.getValueAsString(this.parameterValues.get(param), null, I18nUtil.getLanguageByName(this.chart, this.language)));
        }
        return text;
    }

    private boolean isEmpty(String s) {
        return s == null || "".equals(s.trim());
    }
}

