/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.chart;

class YRange {
    private Number min;
    private Number max;
    private int step;

    public YRange(Number min, Number max) {
        this.min = min;
        this.max = max;
    }

    private YRange(Number min, Number max, int step) {
        this.min = min;
        this.max = max;
        this.step = step;
    }

    public Number getMin() {
        return this.min;
    }

    public Number getMax() {
        return this.max;
    }

    public int getStep() {
        return this.step;
    }

    private int getStep(Number min, Number max) {
        int step = !min.equals(max) ? (int)Math.ceil((max.doubleValue() - min.doubleValue()) / 10.0) : (int)(max.doubleValue() / 10.0);
        if (step == 0) {
            step = 1;
        }
        if (step > 10) {
            step = (int)Math.ceil((double)step / 10.0) * 10;
        }
        return step;
    }

    private double getDelta(Number min, Number max, int step) {
        double delta;
        if (max.doubleValue() - min.doubleValue() > (double)step) {
            delta = step;
        } else if (max.doubleValue() - min.doubleValue() > 0.0) {
            delta = max.doubleValue() - min.doubleValue();
            if (delta < 0.13) {
                delta = 0.13;
            }
        } else {
            delta = 1.0;
        }
        return delta;
    }

    public YRange update() {
        Number min = this.min;
        Number max = this.max;
        int step = this.getStep(min, max);
        double delta = this.getDelta(min, max, step);
        double minAbs = Math.abs(min.doubleValue());
        min = minAbs > delta ? (Number)(min.doubleValue() - delta) : (Number)0;
        max = max.doubleValue() + delta;
        return new YRange(min, max, step);
    }
}

