/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.condition;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import ro.nextreports.engine.condition.ConditionalOperator;
import ro.nextreports.engine.condition.exception.ConditionalException;

public class ConditionalExpression
implements Serializable {
    public static DateFormat DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy");
    protected transient Serializable leftOperand;
    protected transient String operator;
    protected transient Serializable rightOperand;
    protected transient Serializable rightOperand2;
    private String text;

    public ConditionalExpression(String operator) {
        this.operator = operator;
        this.setText();
    }

    public void setLeftOperand(Serializable leftOperand) {
        this.leftOperand = leftOperand;
    }

    public void setRightOperand(Serializable rightOperand) {
        this.rightOperand = rightOperand;
        this.setText();
    }

    public void setRightOperand2(Serializable rightOperand2) {
        this.rightOperand2 = rightOperand2;
        this.setText();
    }

    public Serializable getLeftOperand() {
        return this.leftOperand;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
        this.setText();
    }

    public Serializable getRightOperand() {
        return this.rightOperand;
    }

    public Serializable getRightOperand2() {
        return this.rightOperand2;
    }

    public void setText() {
        String right = "";
        String right2 = "";
        if (this.rightOperand != null) {
            right = this.rightOperand instanceof Date ? DATE_FORMAT.format(this.rightOperand) : this.rightOperand.toString();
            if (this.rightOperand2 != null) {
                right2 = this.rightOperand2 instanceof Date ? DATE_FORMAT.format(this.rightOperand2) : this.rightOperand2.toString();
            }
        }
        this.text = "${val} " + this.operator + " " + right + " " + right2;
    }

    public String getText() {
        return this.text;
    }

    private void parse(String text) {
        if (text != null) {
            String[] elements = text.split(" ");
            if (text.contains("[]")) {
                this.operator = elements[1];
                this.rightOperand = this.getOperand(elements[2]);
                this.rightOperand2 = this.getOperand(elements[3]);
            } else {
                if (elements.length > 3) {
                    for (int i = 3; i < elements.length; ++i) {
                        elements[2] = elements[2] + " " + elements[i];
                    }
                }
                this.operator = elements[1];
                this.rightOperand = this.getOperand(elements[2]);
            }
        }
    }

    public Serializable getOperand(String operand) {
        if (operand == null) {
            return null;
        }
        Object result = null;
        if (operand.contains("/")) {
            try {
                result = DATE_FORMAT.parse(operand);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        } else if (operand.equals("true")) {
            result = Boolean.TRUE;
        } else if (operand.equals("false")) {
            result = Boolean.FALSE;
        } else {
            try {
                result = Double.parseDouble(operand);
            }
            catch (NumberFormatException ex) {
                result = operand;
            }
        }
        return result;
    }

    public boolean evaluate() throws ConditionalException {
        if (!ConditionalOperator.isValid(this.operator)) {
            throw new ConditionalException("Invalid operator : " + this.operator);
        }
        if (!this.isValidOperands(this.leftOperand, this.rightOperand)) {
            throw new ConditionalException("Invalid operands left= " + this.leftOperand + " right=" + this.rightOperand);
        }
        if (this.leftOperand instanceof Boolean && !ConditionalOperator.isBoolean(this.operator)) {
            throw new ConditionalException("Invalid operator : " + this.operator + " for Boolean operands.");
        }
        if (this.leftOperand instanceof String && !ConditionalOperator.isString(this.operator)) {
            throw new ConditionalException("Invalid operator : " + this.operator + " for String operands.");
        }
        if ("=".equals(this.operator)) {
            if (this.leftOperand instanceof Number) {
                return ((Number)this.leftOperand).doubleValue() == ((Number)this.rightOperand).doubleValue();
            }
            return this.leftOperand.equals(this.rightOperand);
        }
        if ("!=".equals(this.operator)) {
            if (this.leftOperand instanceof Number) {
                return ((Number)this.leftOperand).doubleValue() != ((Number)this.rightOperand).doubleValue();
            }
            return !this.leftOperand.equals(this.rightOperand);
        }
        if (">".equals(this.operator)) {
            if (this.leftOperand instanceof Number) {
                return ((Number)this.leftOperand).doubleValue() > ((Number)this.rightOperand).doubleValue();
            }
            if (this.leftOperand instanceof Date) {
                return ((Date)this.leftOperand).compareTo((Date)this.rightOperand) > 0;
            }
        } else if (">=".equals(this.operator)) {
            if (this.leftOperand instanceof Number) {
                return ((Number)this.leftOperand).doubleValue() >= ((Number)this.rightOperand).doubleValue();
            }
            if (this.leftOperand instanceof Date) {
                return ((Date)this.leftOperand).compareTo((Date)this.rightOperand) >= 0;
            }
        } else if ("<".equals(this.operator)) {
            if (this.leftOperand instanceof Number) {
                return ((Number)this.leftOperand).doubleValue() < ((Number)this.rightOperand).doubleValue();
            }
            if (this.leftOperand instanceof Date) {
                return ((Date)this.leftOperand).compareTo((Date)this.rightOperand) < 0;
            }
        } else if ("<=".equals(this.operator)) {
            if (this.leftOperand instanceof Number) {
                return ((Number)this.leftOperand).doubleValue() <= ((Number)this.rightOperand).doubleValue();
            }
            if (this.leftOperand instanceof Date) {
                return ((Date)this.leftOperand).compareTo((Date)this.rightOperand) <= 0;
            }
        } else if ("[]".equals(this.operator)) {
            if (this.leftOperand instanceof Number) {
                return ((Number)this.leftOperand).doubleValue() >= ((Number)this.rightOperand).doubleValue() && ((Number)this.leftOperand).doubleValue() <= ((Number)this.rightOperand2).doubleValue();
            }
            if (this.leftOperand instanceof Date) {
                return ((Date)this.leftOperand).compareTo((Date)this.rightOperand) >= 0 && ((Date)this.leftOperand).compareTo((Date)this.rightOperand2) <= 0;
            }
        }
        throw new ConditionalException("Invalid condition : " + this.toString());
    }

    private boolean isValidOperands(Serializable leftOperand, Serializable rightOperand) {
        return leftOperand instanceof Number && rightOperand instanceof Number || leftOperand instanceof String && rightOperand instanceof String || leftOperand instanceof Boolean && rightOperand instanceof Boolean || leftOperand instanceof Date && rightOperand instanceof Date;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConditionalExpression that = (ConditionalExpression)o;
        return !(this.text != null ? !this.text.equals(that.text) : that.text != null);
    }

    public int hashCode() {
        return this.text != null ? this.text.hashCode() : 0;
    }

    public String toString() {
        return "ConditionalExpression{text='" + this.text + '\'' + '}';
    }

    private Object readResolve() throws ObjectStreamException {
        this.parse(this.text);
        return this;
    }
}

