/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.exporter;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.nextreports.engine.band.Band;
import ro.nextreports.engine.band.BandElement;
import ro.nextreports.engine.exporter.Alert;
import ro.nextreports.engine.exporter.CellElement;
import ro.nextreports.engine.exporter.ExporterBean;
import ro.nextreports.engine.exporter.ResultExporter;
import ro.nextreports.engine.exporter.util.AlarmData;
import ro.nextreports.engine.queryexec.QueryException;
import ro.nextreports.engine.util.ColorUtil;

public class AlarmExporter
extends ResultExporter {
    private AlarmData data;
    private List<Object> alertValues = new ArrayList<Object>();

    public AlarmExporter(ExporterBean bean) {
        super(bean);
        this.data = new AlarmData();
    }

    @Override
    protected void exportCell(String bandName, BandElement bandElement, Object value, int gridRow, int row, int column, int cols, int rowSpan, int colSpan, boolean isImage) {
        int rows = this.getDetailRows();
        Map<String, Object> style = this.buildCellStyleMap(bandElement, value, gridRow, column, colSpan);
        if ("Detail".equals(bandName)) {
            if (rows == 1) {
                if (column == 0) {
                    this.data.setColor(ColorUtil.getHexColor(bandElement.getBackground()));
                    if (style.containsKey("bg_color")) {
                        this.data.setColor(ColorUtil.getHexColor((Color)style.get("bg_color")));
                    }
                    for (Alert alert : this.alerts) {
                        if (this.isAlert(alert, value)) {
                            this.alertValues.add(value);
                            continue;
                        }
                        this.alertValues.add(null);
                    }
                } else if (column == 1) {
                    if (value == null) {
                        this.data.setText("");
                    } else {
                        this.data.setText(value.toString());
                    }
                    int size = this.alertValues.size();
                    for (int i = 0; i < size; ++i) {
                        Object alertValue = this.alertValues.get(i);
                        if (alertValue == null) continue;
                        this.executeAlert((Alert)this.alerts.get(i), alertValue, value.toString());
                    }
                } else if (column == 2) {
                    this.data.setShadow(Boolean.parseBoolean(bandElement.getText()));
                }
            }
            return;
        }
    }

    @Override
    protected void flush() {
    }

    @Override
    protected void flushNow() {
    }

    @Override
    protected void initExport() throws QueryException {
    }

    @Override
    protected void finishExport() {
    }

    @Override
    protected Set<CellElement> getIgnoredCells(Band band) {
        return new HashSet<CellElement>();
    }

    @Override
    protected void afterRowExport() {
    }

    @Override
    protected void close() {
    }

    @Override
    protected String getNullElement() {
        return "";
    }

    public AlarmData getData() {
        return this.data;
    }
}

