/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.exporter;

import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Set;
import ro.nextreports.engine.Report;
import ro.nextreports.engine.band.Band;
import ro.nextreports.engine.band.BandElement;
import ro.nextreports.engine.band.Hyperlink;
import ro.nextreports.engine.band.HyperlinkBandElement;
import ro.nextreports.engine.band.ReportBandElement;
import ro.nextreports.engine.exporter.CellElement;
import ro.nextreports.engine.exporter.ExporterBean;
import ro.nextreports.engine.exporter.ResultExporter;
import ro.nextreports.engine.queryexec.QueryException;
import ro.nextreports.engine.util.StringUtil;

public class CsvExporter
extends ResultExporter {
    private PrintStream stream;
    private char separator = (char)44;
    private char quote = (char)34;
    private static final String lineSeparator = " \r\n";
    private boolean wasPreviousField = false;
    private int quoteLevel = 1;
    private final boolean trim = true;

    public CsvExporter(ExporterBean bean) {
        super(bean);
    }

    public CsvExporter(ExporterBean bean, char delimiter) {
        super(bean);
        this.separator = delimiter;
    }

    @Override
    protected void initExport() throws QueryException {
        this.stream = this.createPrintStream();
    }

    @Override
    protected void finishExport() {
        this.stream.flush();
        if (!this.bean.isSubreport()) {
            this.stream.close();
        }
    }

    @Override
    protected void close() {
        if (!this.bean.isSubreport()) {
            this.stream.close();
        }
    }

    @Override
    protected void flush() {
        if (this.resultSetRow % 7500 == 0) {
            this.flushNow();
        }
    }

    @Override
    protected void flushNow() {
        this.stream.flush();
    }

    @Override
    protected Set<CellElement> getIgnoredCells(Band band) {
        return new HashSet<CellElement>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void exportCell(String bandName, BandElement bandElement, Object value, int gridRow, int row, int column, int cols, int rowSpan, int colSpan, boolean isImage) {
        if (bandElement instanceof HyperlinkBandElement) {
            Hyperlink hyperlink = ((HyperlinkBandElement)bandElement).getHyperlink();
            value = hyperlink.getText();
        } else if (bandElement instanceof ReportBandElement) {
            Report report = ((ReportBandElement)bandElement).getReport();
            ExporterBean eb = null;
            try {
                eb = this.getSubreportExporterBean(report);
                CsvExporter subExporter = new CsvExporter(eb);
                subExporter.export();
                value = subExporter.getSubreportData();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (eb != null && eb.getResult() != null) {
                    eb.getResult().close();
                }
            }
        }
        this.put(this.stream, StringUtil.getValueAsString(value, this.getPattern(bandElement), this.getReportLanguage()));
        if (column == cols - 1) {
            this.nl(this.stream);
        }
    }

    @Override
    protected void afterRowExport() {
    }

    @Override
    protected String getNullElement() {
        return null;
    }

    private void put(PrintStream p, String s) {
        if (s == null) {
            this.put(p, " ");
            return;
        }
        if (this.wasPreviousField) {
            p.print(this.separator);
        }
        if ((s = s.trim()).indexOf(this.quote) >= 0) {
            p.print(this.quote);
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == this.quote) {
                    p.print(this.quote);
                    p.print(this.quote);
                    continue;
                }
                p.print(c);
            }
            p.print(this.quote);
        } else if (this.quoteLevel == 2 || this.quoteLevel == 1 && s.indexOf(32) >= 0 || s.indexOf(this.separator) >= 0) {
            p.print(this.quote);
            p.print(s);
            p.print(this.quote);
        } else {
            p.print(s);
        }
        this.wasPreviousField = true;
    }

    public void nl(PrintStream p) {
        p.print(lineSeparator);
        this.wasPreviousField = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSubreportData() {
        try {
            String string = this.subreportStream.toString("UTF-8");
            return string;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            String string = "";
            return string;
        }
        finally {
            this.stream.close();
        }
    }
}

