/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.exporter;

import java.awt.Color;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ro.nextreports.engine.band.Band;
import ro.nextreports.engine.band.BandElement;
import ro.nextreports.engine.band.ColumnBandElement;
import ro.nextreports.engine.exporter.Alert;
import ro.nextreports.engine.exporter.CellElement;
import ro.nextreports.engine.exporter.ExporterBean;
import ro.nextreports.engine.exporter.ResultExporter;
import ro.nextreports.engine.exporter.util.DisplayData;
import ro.nextreports.engine.queryexec.QueryException;
import ro.nextreports.engine.util.ColorUtil;
import ro.nextreports.engine.util.StringUtil;

public class DisplayExporter
extends ResultExporter {
    private DisplayData data = new DisplayData();

    public DisplayExporter(ExporterBean bean) {
        super(bean);
    }

    @Override
    protected void exportCell(String bandName, BandElement bandElement, Object value, int gridRow, int row, int column, int cols, int rowSpan, int colSpan, boolean isImage) {
        int headerRows = this.getHeaderRows();
        int detailRows = this.getDetailRows();
        Map<String, Object> style = this.buildCellStyleMap(bandElement, value, gridRow, column, colSpan);
        if ("Header".equals(bandName)) {
            if (headerRows == 1 && row == 0) {
                switch (column) {
                    case 0: {
                        this.data.setTitle(this.replaceParameters(this.getBandElementValueAsString(bandElement)));
                        if (bandElement.getHorizontalAlign() == 0) {
                            this.data.setTitleAlignment("center");
                        } else {
                            this.data.setTitleAlignment("alignToValue");
                        }
                        this.data.setBackground(ColorUtil.getHexColor(bandElement.getBackground()));
                        if (style.containsKey("bg_color")) {
                            this.data.setBackground(ColorUtil.getHexColor((Color)style.get("bg_color")));
                        }
                        this.data.setTitleColor(ColorUtil.getHexColor(bandElement.getForeground()));
                        if (!style.containsKey("font_color")) break;
                        this.data.setTitleColor(ColorUtil.getHexColor((Color)style.get("font_color")));
                        break;
                    }
                    case 1: {
                        this.data.setShouldRise(Boolean.parseBoolean(bandElement.getText()));
                        break;
                    }
                    case 2: {
                        this.data.setShadow(Boolean.parseBoolean(bandElement.getText()));
                    }
                }
            }
        } else if ("Detail".equals(bandName)) {
            if (detailRows == 1) {
                if (column == 0) {
                    this.data.setValueColor(ColorUtil.getHexColor(bandElement.getForeground()));
                    if (style.containsKey("font_color")) {
                        this.data.setValueColor(ColorUtil.getHexColor((Color)style.get("font_color")));
                    }
                    this.data.setValue(StringUtil.getValueAsString(value, ((ColumnBandElement)bandElement).getPattern()));
                    for (Alert alert : this.alerts) {
                        if (!this.isAlert(alert, value)) continue;
                        this.executeAlert(alert, value, "");
                    }
                } else if (column == 1) {
                    this.data.setPreviousColor(ColorUtil.getHexColor(bandElement.getForeground()));
                    if (style.containsKey("font_color")) {
                        this.data.setPreviousColor(ColorUtil.getHexColor((Color)style.get("font_color")));
                    }
                    this.data.setPrevious(StringUtil.getValueAsString(value, ((ColumnBandElement)bandElement).getPattern()));
                } else if (column == 2) {
                    this.data.setUp((Boolean)value);
                } else if (column == 3) {
                    String prev = this.getBandElementValueAsString(bandElement);
                    if (prev != null && !prev.endsWith("%")) {
                        prev = prev + "%";
                    }
                    this.data.setPrevious(prev);
                }
            }
            return;
        }
    }

    private String replaceParameters(String text) {
        Map<String, Object> params = this.bean.getParametersBean().getParamValues();
        for (String param : params.keySet()) {
            text = StringUtil.replace(text, "\\$P\\{" + param + "\\}", StringUtil.getValueAsString(params.get(param), null));
        }
        return text;
    }

    @Override
    protected void flush() {
    }

    @Override
    protected void flushNow() {
    }

    @Override
    protected void initExport() throws QueryException {
    }

    @Override
    protected void finishExport() {
    }

    @Override
    protected Set<CellElement> getIgnoredCells(Band band) {
        return new HashSet<CellElement>();
    }

    @Override
    protected void afterRowExport() {
    }

    @Override
    protected void close() {
    }

    @Override
    protected String getNullElement() {
        return "";
    }

    public DisplayData getData() {
        return this.data;
    }
}

