/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.exporter;

import java.awt.Color;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.docProps.core.CoreProperties;
import org.docx4j.docProps.core.dc.elements.ObjectFactory;
import org.docx4j.docProps.core.dc.elements.SimpleLiteral;
import org.docx4j.jaxb.Context;
import org.docx4j.model.structure.PageDimensions;
import org.docx4j.model.structure.PageSizePaper;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.DocPropsCorePart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.AltChunkType;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.vml.CTBackground;
import org.docx4j.vml.CTFill;
import org.docx4j.vml.STFillType;
import org.docx4j.vml.STTrueFalse;
import org.docx4j.vml.officedrawing.STBWMode;
import org.docx4j.wml.Body;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.Br;
import org.docx4j.wml.CTBorder;
import org.docx4j.wml.CTShd;
import org.docx4j.wml.CTSimpleField;
import org.docx4j.wml.CTVerticalJc;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.Document;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.FooterReference;
import org.docx4j.wml.Ftr;
import org.docx4j.wml.Hdr;
import org.docx4j.wml.HdrFtrRef;
import org.docx4j.wml.HeaderReference;
import org.docx4j.wml.HpsMeasure;
import org.docx4j.wml.Jc;
import org.docx4j.wml.JcEnumeration;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.R;
import org.docx4j.wml.RFonts;
import org.docx4j.wml.RPr;
import org.docx4j.wml.RStyle;
import org.docx4j.wml.STBorder;
import org.docx4j.wml.STBrType;
import org.docx4j.wml.STVerticalJc;
import org.docx4j.wml.SectPr;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblPr;
import org.docx4j.wml.TblWidth;
import org.docx4j.wml.Tc;
import org.docx4j.wml.TcMar;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.TcPrInner;
import org.docx4j.wml.Text;
import org.docx4j.wml.TextDirection;
import org.docx4j.wml.Tr;
import org.docx4j.wml.TrPr;
import org.docx4j.wml.U;
import org.docx4j.wml.UnderlineEnumeration;
import ro.nextreports.engine.ReleaseInfoAdapter;
import ro.nextreports.engine.Report;
import ro.nextreports.engine.band.Band;
import ro.nextreports.engine.band.BandElement;
import ro.nextreports.engine.band.ExpressionBandElement;
import ro.nextreports.engine.band.Hyperlink;
import ro.nextreports.engine.band.HyperlinkBandElement;
import ro.nextreports.engine.band.ImageBandElement;
import ro.nextreports.engine.band.ImageColumnBandElement;
import ro.nextreports.engine.band.Padding;
import ro.nextreports.engine.band.ReportBandElement;
import ro.nextreports.engine.band.VariableBandElement;
import ro.nextreports.engine.exporter.CellElement;
import ro.nextreports.engine.exporter.ExporterBean;
import ro.nextreports.engine.exporter.ResultExporter;
import ro.nextreports.engine.exporter.util.variable.PageNoVariable;
import ro.nextreports.engine.exporter.util.variable.VariableFactory;
import ro.nextreports.engine.queryexec.QueryException;
import ro.nextreports.engine.util.ColorUtil;
import ro.nextreports.engine.util.StringUtil;

public class DocxExporter
extends ResultExporter {
    private WordprocessingMLPackage wordMLPackage;
    private org.docx4j.wml.ObjectFactory factory;
    private Tbl table;
    private Tbl tableHeader;
    private Tbl tableFooter;
    private Tr tableRow;
    private int fragmentsize = 15000;
    private int[] headerwidths;
    private int A4_PORTRAIT_DXA = 11906;
    private int A4_LANDSCAPE_DXA = 16838;
    private int rowNo = 0;
    private int currentWidth = -1;
    private boolean hasPageNoHeader = false;
    private boolean hasPageNoFooter = false;
    private Map<Integer, Integer> rowSpanForColumn = new HashMap<Integer, Integer>();

    public DocxExporter(ExporterBean bean) {
        super(bean);
    }

    public DocxExporter(ExporterBean bean, int currentWidth) {
        super(bean);
        this.currentWidth = currentWidth;
    }

    @Override
    protected void exportCell(String bandName, BandElement bandElement, Object value, int gridRow, int row, int column, int cols, int rowSpan, int colSpan, boolean isImage) {
        if (this.newRow) {
            ++this.rowNo;
            if (!"PageHeader".equals(bandName) && !"PageFooter".equals(bandName) || this.rowNo > 1) {
                if (this.tableRow != null) {
                    if ("PageHeader".equals(bandName)) {
                        this.tableHeader.getContent().add(this.tableRow);
                    } else if ("PageFooter".equals(bandName)) {
                        this.tableFooter.getContent().add(this.tableRow);
                    } else {
                        this.table.getContent().add(this.tableRow);
                    }
                }
                this.tableRow = this.factory.createTr();
            }
            if (this.bean.getReportLayout().isHeaderOnEveryPage() && "Header".equals(bandName)) {
                TrPr rowProperties = new TrPr();
                BooleanDefaultTrue bdt = Context.getWmlObjectFactory().createBooleanDefaultTrue();
                rowProperties.getCnfStyleOrDivIdOrGridBefore().add(Context.getWmlObjectFactory().createCTTrPrBaseTblHeader(bdt));
                this.tableRow.setTrPr(rowProperties);
            }
        }
        this.renderDocxCell(bandName, bandElement, value, gridRow, rowSpan, colSpan, isImage, column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderDocxCell(String bandName, BandElement bandElement, Object value, int gridRow, int rowSpan, int colSpan, boolean image, int column) {
        block32: {
            Map<String, Object> style = this.buildCellStyleMap(bandElement, value, gridRow, column, colSpan);
            String verticalMergedVal = null;
            if (rowSpan > 1) {
                verticalMergedVal = "restart";
                this.rowSpanForColumn.put(column, rowSpan);
            } else {
                int span = this.rowSpanForColumn.get(column);
                if (span > 1) {
                    this.rowSpanForColumn.put(column, span - 1);
                    verticalMergedVal = span == 2 ? "close" : "";
                }
            }
            int width = this.headerwidths[column];
            if (colSpan > 1) {
                for (int i = 1; i < colSpan; ++i) {
                    width += this.headerwidths[column + i];
                }
            }
            if (image) {
                if (value == null) {
                    this.addTableCell(this.tableRow, bandElement, "", width, style, colSpan, verticalMergedVal);
                } else {
                    ImageBandElement ibe = (ImageBandElement)bandElement;
                    try {
                        byte[] imageD = this.getImage((String)value);
                        byte[] imageBytes = this.getImage(imageD, ibe.getWidth(), ibe.getHeight());
                        int imageW = ibe.getWidth() == null ? this.getRealImageSize(imageBytes)[0] : ibe.getWidth();
                        P pImage = this.newImage(this.wordMLPackage, imageBytes, null, null, 0, 1, this.pixelsToDxa(imageW));
                        this.addTableCell(this.tableRow, bandElement, pImage, width, style, colSpan, verticalMergedVal, true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else if (bandElement instanceof HyperlinkBandElement) {
                Hyperlink hyperlink = ((HyperlinkBandElement)bandElement).getHyperlink();
                this.addHyperlinkTableCell(this.tableRow, bandElement, hyperlink, width, style, colSpan, verticalMergedVal);
            } else if (bandElement instanceof ReportBandElement) {
                Report report = ((ReportBandElement)bandElement).getReport();
                ExporterBean eb = null;
                try {
                    eb = this.getSubreportExporterBean(report);
                    DocxExporter subExporter = new DocxExporter(eb, width);
                    subExporter.export();
                    Tbl innerTable = subExporter.getTable();
                    this.addSubreportTableCell(this.tableRow, bandElement, innerTable, width, style, colSpan, verticalMergedVal);
                }
                catch (Exception e) {
                    this.addTableCell(this.tableRow, bandElement, "", width, style, colSpan, verticalMergedVal);
                    e.printStackTrace();
                }
                finally {
                    if (eb != null && eb.getResult() != null) {
                        eb.getResult().close();
                    }
                }
            } else if (bandElement instanceof VariableBandElement && VariableFactory.getVariable(((VariableBandElement)bandElement).getVariable()) instanceof PageNoVariable || bandElement instanceof ExpressionBandElement && ((ExpressionBandElement)bandElement).getExpression().contains("PAGE_NO")) {
                if ("PageHeader".equals(bandName)) {
                    this.hasPageNoHeader = true;
                } else if ("PageFooter".equals(bandName)) {
                    this.hasPageNoFooter = true;
                }
            } else if (bandElement instanceof ImageColumnBandElement) {
                try {
                    String v = StringUtil.getValueAsString(value, null);
                    if (StringUtil.BLOB.equals(v)) {
                        this.addTableCell(this.tableRow, bandElement, StringUtil.BLOB, width, style, colSpan, verticalMergedVal);
                        break block32;
                    }
                    ImageColumnBandElement icbe = (ImageColumnBandElement)bandElement;
                    byte[] imageD = StringUtil.decodeImage(v);
                    byte[] imageBytes = this.getImage(imageD, icbe.getWidth(), icbe.getHeight());
                    int imageW = icbe.getWidth() == null ? this.getRealImageSize(imageBytes)[0] : icbe.getWidth();
                    P pImage = this.newImage(this.wordMLPackage, imageBytes, null, null, 0, 1, this.pixelsToDxa(imageW));
                    this.addTableCell(this.tableRow, bandElement, pImage, width, style, colSpan, verticalMergedVal, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.addTableCell(this.tableRow, bandElement, IMAGE_NOT_LOADED, width, style, colSpan, verticalMergedVal);
                }
            } else {
                String stringValue = style.containsKey("pattern") ? StringUtil.getValueAsString(value, (String)style.get("pattern"), this.getReportLanguage()) : StringUtil.getValueAsString(value, null, this.getReportLanguage());
                if (stringValue == null) {
                    stringValue = "";
                }
                this.addTableCell(this.tableRow, bandElement, stringValue, width, style, colSpan, verticalMergedVal);
            }
        }
    }

    @Override
    protected void initExport() throws QueryException {
        try {
            this.factory = Context.getWmlObjectFactory();
            for (int i = 0; i < this.bean.getReportLayout().getColumnCount(); ++i) {
                this.rowSpanForColumn.put(i, 1);
            }
            if (!this.bean.isSubreport()) {
                boolean landscape = this.bean.getReportLayout().getOrientation() == 1;
                this.wordMLPackage = WordprocessingMLPackage.createPackage((PageSizePaper)PageSizePaper.A4, (boolean)landscape);
                this.setPageMargins();
                this.addMetadata();
            }
            this.table = this.createTable(0);
        }
        catch (InvalidFormatException e) {
            e.printStackTrace();
            throw new QueryException(e);
        }
    }

    @Override
    protected void finishExport() {
        if (this.table != null) {
            this.table.getContent().add(this.tableRow);
        }
        if (!this.bean.isSubreport()) {
            if (this.table != null) {
                this.wordMLPackage.getMainDocumentPart().addObject((Object)this.table);
            } else {
                this.wordMLPackage.getMainDocumentPart().addParagraphOfText("");
            }
            this.table = null;
            try {
                this.addPageHeaderFooter();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                this.wordMLPackage.save(this.getOut());
            }
            catch (Docx4JException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void close() {
    }

    @Override
    protected void flush() {
        if (!this.bean.isSubreport() && this.resultSetRow % this.fragmentsize == this.fragmentsize - 1) {
            this.flushNow();
        }
    }

    @Override
    protected void flushNow() {
        this.table.getContent().add(this.tableRow);
        if (!this.bean.isSubreport()) {
            this.wordMLPackage.getMainDocumentPart().addObject((Object)this.table);
            this.table = this.createTable(0);
            this.tableRow = null;
        }
    }

    @Override
    protected Set<CellElement> getIgnoredCells(Band band) {
        return this.getIgnoredCellElementsForColSpan(band);
    }

    @Override
    protected void afterRowExport() {
    }

    @Override
    protected String getNullElement() {
        return "";
    }

    @Override
    protected void newPage() {
        this.flushNow();
        Br objBr = new Br();
        objBr.setType(STBrType.PAGE);
        P para = this.createParagraph();
        para.getContent().add(objBr);
        this.wordMLPackage.getMainDocumentPart().getContent().add(para);
        if (this.bean.getReportLayout().isHeaderOnEveryPage()) {
            try {
                this.printHeaderBand();
                this.newRow = true;
            }
            catch (QueryException e) {
                e.printStackTrace();
            }
        }
    }

    private void setPageMargins() {
        try {
            Body body = ((Document)this.wordMLPackage.getMainDocumentPart().getContents()).getBody();
            Padding padding = this.bean.getReportLayout().getPagePadding();
            PageDimensions page = new PageDimensions();
            SectPr.PgMar pgMar = page.getPgMar();
            pgMar.setBottom(BigInteger.valueOf(this.pixelsToDxa(padding.getBottom())));
            pgMar.setTop(BigInteger.valueOf(this.pixelsToDxa(padding.getTop())));
            pgMar.setLeft(BigInteger.valueOf(this.pixelsToDxa(padding.getLeft())));
            pgMar.setRight(BigInteger.valueOf(this.pixelsToDxa(padding.getRight())));
            SectPr sectPr = this.factory.createSectPr();
            body.setSectPr(sectPr);
            sectPr.setPgMar(pgMar);
        }
        catch (Docx4JException e) {
            e.printStackTrace();
        }
    }

    private void addMetadata() {
        try {
            DocPropsCorePart docPropsCorePart = this.wordMLPackage.getDocPropsCorePart();
            CoreProperties coreProps = (CoreProperties)docPropsCorePart.getContents();
            org.docx4j.docProps.core.ObjectFactory CorePropsfactory = new org.docx4j.docProps.core.ObjectFactory();
            ObjectFactory dcElfactory = new ObjectFactory();
            SimpleLiteral desc = dcElfactory.createSimpleLiteral();
            desc.getContent().add("Created by NextReports Designer" + ReleaseInfoAdapter.getVersionNumber());
            coreProps.setDescription(dcElfactory.createDescription(desc));
            SimpleLiteral title = dcElfactory.createSimpleLiteral();
            title.getContent().add(this.getDocumentTitle());
            coreProps.setTitle(dcElfactory.createTitle(title));
            SimpleLiteral author = dcElfactory.createSimpleLiteral();
            author.getContent().add(ReleaseInfoAdapter.getCompany());
            coreProps.setCreator(author);
            SimpleLiteral subject = dcElfactory.createSimpleLiteral();
            subject.getContent().add("Created by NextReports Designer" + ReleaseInfoAdapter.getVersionNumber());
            coreProps.setSubject(subject);
            coreProps.setKeywords(ReleaseInfoAdapter.getHome());
        }
        catch (Docx4JException e) {
            e.printStackTrace();
        }
    }

    private Tbl createTable(int type) {
        this.rowNo = 0;
        List<Object> bands = new ArrayList<Band>();
        if (type == 1) {
            bands.add(this.getReportLayout().getPageHeaderBand());
        } else if (type == 2) {
            bands.add(this.getReportLayout().getPageFooterBand());
        } else {
            bands = this.getReportLayout().getDocumentBands();
        }
        int totalRows = 0;
        int totalColumns = 0;
        for (Band band : bands) {
            totalRows += band.getRowCount();
            int cols = band.getColumnCount();
            if (cols <= totalColumns) continue;
            totalColumns = cols;
        }
        if (totalColumns == 0) {
            return null;
        }
        this.headerwidths = new int[totalColumns];
        boolean landscape = this.bean.getReportLayout().getOrientation() == 1;
        Padding padding = this.bean.getReportLayout().getPagePadding();
        int margs = this.pixelsToDxa(padding.getLeft() + padding.getRight());
        if (this.currentWidth == -1) {
            this.currentWidth = landscape ? this.A4_LANDSCAPE_DXA - margs : this.A4_PORTRAIT_DXA - margs;
        }
        int colWidth = this.currentWidth / totalColumns;
        for (int i = 0; i < totalColumns; ++i) {
            this.headerwidths[i] = this.bean.getReportLayout().isUseSize() ? this.pixelsToDxa(this.bean.getReportLayout().getColumnsWidth().get(i)) : colWidth;
        }
        Tbl resultTable = this.factory.createTbl();
        TblPr tblPr = this.factory.createTblPr();
        TblWidth tblWidth = this.factory.createTblWidth();
        if (this.bean.getReportLayout().isUseSize()) {
            int sum = 0;
            for (int i = 0; i < totalColumns; ++i) {
                sum += this.headerwidths[i];
            }
            this.currentWidth = sum;
        }
        tblWidth.setW(BigInteger.valueOf(this.currentWidth));
        tblWidth.setType("dxa");
        tblPr.setTblW(tblWidth);
        resultTable.setTblPr(tblPr);
        return resultTable;
    }

    private void addHyperlinkTableCell(Tr tableRow, BandElement be, Hyperlink link, int width, Map<String, Object> style, int horizontalMergedCells, String verticalMergedVal) {
        P.Hyperlink hyp = this.newHyperlink(this.wordMLPackage.getMainDocumentPart(), link.getText(), link.getUrl());
        P paragraph = this.createParagraph();
        paragraph.getContent().add(hyp);
        this.addTableCell(tableRow, be, paragraph, width, style, horizontalMergedCells, verticalMergedVal, false);
    }

    private void addSubreportTableCell(Tr tableRow, BandElement be, Tbl table, int width, Map<String, Object> style, int horizontalMergedCells, String verticalMergedVal) {
        Tc tableCell = this.factory.createTc();
        tableCell.getContent().add(table);
        tableCell.getContent().add(this.wordMLPackage.getMainDocumentPart().createParagraphOfText(""));
        this.setCellWidth(tableCell, width);
        this.setCellVMerge(tableCell, verticalMergedVal);
        this.setCellHMerge(tableCell, horizontalMergedCells);
        tableRow.getContent().add(tableCell);
    }

    private void addTableCell(Tr tableRow, BandElement be, P paragraph, int width, Map<String, Object> style, int horizontalMergedCells, String verticalMergedVal, boolean isImage) {
        Tc tableCell = this.factory.createTc();
        if (isImage) {
            this.addImageCellStyle(tableCell, be, paragraph, style);
        } else {
            this.addHyperlinkCellStyle(tableCell, be, paragraph, style);
        }
        this.setCellWidth(tableCell, width);
        this.setCellVMerge(tableCell, verticalMergedVal);
        this.setCellHMerge(tableCell, horizontalMergedCells);
        if (!isImage && be != null && !be.isWrapText()) {
            this.setCellNoWrap(tableCell);
        }
        tableRow.getContent().add(tableCell);
    }

    private void addTableCell(Tr tableRow, BandElement be, String content, int width, Map<String, Object> style, int horizontalMergedCells, String verticalMergedVal) {
        Tc tableCell = this.factory.createTc();
        this.addCellStyle(tableCell, be, content, style);
        this.setCellWidth(tableCell, width);
        this.setCellVMerge(tableCell, verticalMergedVal);
        this.setCellHMerge(tableCell, horizontalMergedCells);
        if (be != null && !be.isWrapText()) {
            this.setCellNoWrap(tableCell);
        }
        tableRow.getContent().add(tableCell);
    }

    private void addTableCell(Tr tableRow, BandElement be, String content, P p, int width, Map<String, Object> style, int horizontalMergedCells, String verticalMergedVal) {
        Tc tableCell = this.factory.createTc();
        this.addCellStyle(tableCell, be, content, p, style);
        this.setCellWidth(tableCell, width);
        this.setCellVMerge(tableCell, verticalMergedVal);
        this.setCellHMerge(tableCell, horizontalMergedCells);
        if (be != null && !be.isWrapText()) {
            this.setCellNoWrap(tableCell);
        }
        tableRow.getContent().add(tableCell);
    }

    private void addImageCellStyle(Tc tableCell, BandElement be, P image, Map<String, Object> style) {
        this.setCellMargins(tableCell, style);
        this.setBackground(tableCell, style);
        this.setVerticalAlignment(tableCell, style);
        this.setHorizontalAlignment(image, style);
        this.setCellBorders(tableCell, style);
        tableCell.getContent().add(image);
    }

    private void addHyperlinkCellStyle(Tc tableCell, BandElement be, P hyperlink, Map<String, Object> style) {
        this.setCellMargins(tableCell, style);
        this.setBackground(tableCell, style);
        this.setVerticalAlignment(tableCell, style);
        this.setHorizontalAlignment(hyperlink, style);
        this.setCellBorders(tableCell, style);
        R run = (R)((P.Hyperlink)hyperlink.getContent().get(0)).getContent().get(0);
        RPr runProperties = run.getRPr();
        this.setFont(tableCell, style, runProperties);
        if (be != null) {
            this.setTextDirection(tableCell, be.getTextRotation());
        }
        tableCell.getContent().add(hyperlink);
    }

    private void addCellStyle(Tc tableCell, BandElement be, String content, Map<String, Object> style) {
        P paragraph = this.createParagraph();
        this.addCellStyle(tableCell, be, content, paragraph, style);
    }

    private void addCellStyle(Tc tableCell, BandElement be, String content, P paragraph, Map<String, Object> style) {
        if (style != null) {
            if (content.startsWith("<html>")) {
                try {
                    this.wordMLPackage.getMainDocumentPart().addAltChunk(AltChunkType.Html, content.getBytes(), (ContentAccessor)tableCell);
                    tableCell.getContent().add(paragraph);
                }
                catch (Docx4JException e) {
                    e.printStackTrace();
                }
                return;
            }
            Text text = this.factory.createText();
            text.setValue(content);
            R run = this.factory.createR();
            run.getContent().add(text);
            paragraph.getContent().add(run);
            this.setHorizontalAlignment(paragraph, style);
            RPr runProperties = this.factory.createRPr();
            this.setFont(tableCell, style, runProperties);
            this.setCellMargins(tableCell, style);
            this.setBackground(tableCell, style);
            this.setVerticalAlignment(tableCell, style);
            this.setCellBorders(tableCell, style);
            if (be != null) {
                this.setTextDirection(tableCell, be.getTextRotation());
            }
            run.setRPr(runProperties);
            tableCell.getContent().add(paragraph);
        }
    }

    private void setBackground(Tc tableCell, Map<String, Object> style) {
        if (this.bean.getReportLayout().getBackgroundImage() == null && style.containsKey("bg_color")) {
            Color val = (Color)style.get("bg_color");
            this.setCellColor(tableCell, ColorUtil.getHexColor(val).substring(1));
        }
    }

    private void setFont(Tc tableCell, Map<String, Object> style, RPr runProperties) {
        Object val;
        if (style.containsKey("font_family")) {
            val = (String)style.get("font_family");
            this.setFontFamily(runProperties, (String)val);
        }
        if (style.containsKey("font_size")) {
            val = (Float)style.get("font_size");
            this.setFontSize(runProperties, String.valueOf((int)(2.0f * ((Float)val).floatValue())));
        }
        if (style.containsKey("font_color")) {
            val = (Color)style.get("font_color");
            this.setFontColor(runProperties, ColorUtil.getHexColor((Color)val).substring(1));
        }
        if (style.containsKey("font_style_key")) {
            if ("font_style_bold".equals(style.get("font_style_key"))) {
                this.addBoldStyle(runProperties);
            }
            if ("font_style_italic".equals(style.get("font_style_key"))) {
                this.addItalicStyle(runProperties);
            }
            if ("font_style_bold_italic".equals(style.get("font_style_key"))) {
                this.addBoldStyle(runProperties);
                this.addItalicStyle(runProperties);
            }
        }
    }

    private void setTextDirection(Tc tableCell, short textRotation) {
        String dir = null;
        if (textRotation == 90) {
            dir = "btLr";
        } else if (textRotation == -90) {
            dir = "tbRl";
        }
        if (dir != null) {
            TcPr tableCellProperties = tableCell.getTcPr();
            if (tableCellProperties == null) {
                tableCellProperties = new TcPr();
                tableCell.setTcPr(tableCellProperties);
            }
            TextDirection td = new TextDirection();
            td.setVal(dir);
            tableCellProperties.setTextDirection(td);
        }
    }

    private void setCellBorders(Tc tableCell, Map<String, Object> style) {
        Color color;
        Float val;
        TcPr tableCellProperties = tableCell.getTcPr();
        if (tableCellProperties == null) {
            tableCellProperties = new TcPr();
            tableCell.setTcPr(tableCellProperties);
        }
        CTBorder border = new CTBorder();
        border.setSpace(new BigInteger("0"));
        border.setVal(STBorder.SINGLE);
        TcPrInner.TcBorders borders = new TcPrInner.TcBorders();
        if (style.containsKey("border_left")) {
            val = (Float)style.get("border_left");
            border.setSz(BigInteger.valueOf((long)(val.floatValue() / 2.0f)));
            color = (Color)style.get("border_left_color");
            border.setColor(ColorUtil.getHexColor(color).substring(1));
            borders.setLeft(border);
        }
        if (style.containsKey("border_right")) {
            val = (Float)style.get("border_right");
            border.setSz(BigInteger.valueOf((long)(val.floatValue() / 2.0f)));
            color = (Color)style.get("border_right_color");
            border.setColor(ColorUtil.getHexColor(color).substring(1));
            borders.setRight(border);
        }
        if (style.containsKey("border_top")) {
            val = (Float)style.get("border_top");
            border.setSz(BigInteger.valueOf((long)(val.floatValue() / 2.0f)));
            color = (Color)style.get("border_top_color");
            border.setColor(ColorUtil.getHexColor(color).substring(1));
            borders.setTop(border);
        }
        if (style.containsKey("border_bottom")) {
            val = (Float)style.get("border_bottom");
            border.setSz(BigInteger.valueOf((long)(val.floatValue() / 2.0f)));
            color = (Color)style.get("border_bottom_color");
            border.setColor(ColorUtil.getHexColor(color).substring(1));
            borders.setBottom(border);
        }
        tableCellProperties.setTcBorders(borders);
    }

    private void setCellWidth(Tc tableCell, int width) {
        if (width > 0) {
            TcPr tableCellProperties = tableCell.getTcPr();
            if (tableCellProperties == null) {
                tableCellProperties = new TcPr();
                tableCell.setTcPr(tableCellProperties);
            }
            TblWidth tableWidth = new TblWidth();
            tableWidth.setType("dxa");
            tableWidth.setW(BigInteger.valueOf(width));
            tableCellProperties.setTcW(tableWidth);
        }
    }

    private void setCellNoWrap(Tc tableCell) {
        TcPr tableCellProperties = tableCell.getTcPr();
        if (tableCellProperties == null) {
            tableCellProperties = new TcPr();
            tableCell.setTcPr(tableCellProperties);
        }
        BooleanDefaultTrue b = new BooleanDefaultTrue();
        b.setVal(Boolean.valueOf(true));
        tableCellProperties.setNoWrap(b);
    }

    private void setCellVMerge(Tc tableCell, String mergeVal) {
        if (mergeVal != null) {
            TcPr tableCellProperties = tableCell.getTcPr();
            if (tableCellProperties == null) {
                tableCellProperties = new TcPr();
                tableCell.setTcPr(tableCellProperties);
            }
            TcPrInner.VMerge merge = new TcPrInner.VMerge();
            if (!"close".equals(mergeVal)) {
                merge.setVal(mergeVal);
            }
            tableCellProperties.setVMerge(merge);
        }
    }

    private void setCellHMerge(Tc tableCell, int horizontalMergedCells) {
        if (horizontalMergedCells > 1) {
            TcPr tableCellProperties = tableCell.getTcPr();
            if (tableCellProperties == null) {
                tableCellProperties = new TcPr();
                tableCell.setTcPr(tableCellProperties);
            }
            TcPrInner.GridSpan gridSpan = new TcPrInner.GridSpan();
            gridSpan.setVal(new BigInteger(String.valueOf(horizontalMergedCells)));
            tableCellProperties.setGridSpan(gridSpan);
            tableCell.setTcPr(tableCellProperties);
        }
    }

    private void setCellColor(Tc tableCell, String color) {
        if (color != null) {
            TcPr tableCellProperties = tableCell.getTcPr();
            if (tableCellProperties == null) {
                tableCellProperties = new TcPr();
                tableCell.setTcPr(tableCellProperties);
            }
            CTShd shd = new CTShd();
            shd.setFill(color);
            tableCellProperties.setShd(shd);
        }
    }

    private void setCellMargins(Tc tableCell, Map<String, Object> style) {
        TcPr tableCellProperties;
        Float val;
        int top = 0;
        int left = 0;
        int bottom = 0;
        int right = 0;
        if (style.containsKey("padding_left")) {
            val = (Float)style.get("padding_left");
            left = val.intValue();
        }
        if (style.containsKey("padding_right")) {
            val = (Float)style.get("padding_right");
            right = val.intValue();
        }
        if (style.containsKey("padding_top")) {
            val = (Float)style.get("padding_top");
            top = val.intValue();
        }
        if (style.containsKey("padding_bottom")) {
            val = (Float)style.get("padding_bottom");
            bottom = val.intValue();
        }
        if ((tableCellProperties = tableCell.getTcPr()) == null) {
            tableCellProperties = new TcPr();
            tableCell.setTcPr(tableCellProperties);
        }
        TcMar margins = new TcMar();
        if (bottom > 0) {
            TblWidth bW = new TblWidth();
            bW.setType("dxa");
            bW.setW(BigInteger.valueOf(this.pixelsToDxa(bottom)));
            margins.setBottom(bW);
        }
        if (top > 0) {
            TblWidth tW = new TblWidth();
            tW.setType("dxa");
            tW.setW(BigInteger.valueOf(this.pixelsToDxa(top)));
            margins.setTop(tW);
        }
        if (left > 0) {
            TblWidth lW = new TblWidth();
            lW.setType("dxa");
            lW.setW(BigInteger.valueOf(this.pixelsToDxa(left)));
            margins.setLeft(lW);
        }
        if (right > 0) {
            TblWidth rW = new TblWidth();
            rW.setType("dxa");
            rW.setW(BigInteger.valueOf(this.pixelsToDxa(right)));
            margins.setRight(rW);
        }
        tableCellProperties.setTcMar(margins);
    }

    private void setVerticalAlignment(Tc tableCell, Map<String, Object> style) {
        if (style.containsKey("halign")) {
            if ("valign_top".equals(style.get("valign"))) {
                this.setVerticalAlignment(tableCell, STVerticalJc.TOP);
            }
            if ("valign_middle".equals(style.get("valign"))) {
                this.setVerticalAlignment(tableCell, STVerticalJc.CENTER);
            }
            if ("valign_bottom".equals(style.get("valign"))) {
                this.setVerticalAlignment(tableCell, STVerticalJc.BOTTOM);
            }
        }
    }

    private void setVerticalAlignment(Tc tableCell, STVerticalJc align) {
        if (align != null) {
            TcPr tableCellProperties = tableCell.getTcPr();
            if (tableCellProperties == null) {
                tableCellProperties = new TcPr();
                tableCell.setTcPr(tableCellProperties);
            }
            CTVerticalJc valign = new CTVerticalJc();
            valign.setVal(align);
            tableCellProperties.setVAlign(valign);
        }
    }

    private void setFontSize(RPr runProperties, String fontSize) {
        if (fontSize != null && !fontSize.isEmpty()) {
            HpsMeasure size = new HpsMeasure();
            size.setVal(new BigInteger(fontSize));
            runProperties.setSz(size);
            runProperties.setSzCs(size);
        }
    }

    private void setFontFamily(RPr runProperties, String fontFamily) {
        if (fontFamily != null) {
            RFonts rf = runProperties.getRFonts();
            if (rf == null) {
                rf = new RFonts();
                runProperties.setRFonts(rf);
            }
            rf.setAscii(fontFamily);
        }
    }

    private void setFontColor(RPr runProperties, String color) {
        if (color != null) {
            org.docx4j.wml.Color c = new org.docx4j.wml.Color();
            c.setVal(color);
            runProperties.setColor(c);
        }
    }

    private void setHorizontalAlignment(P paragraph, Map<String, Object> style) {
        if (style.containsKey("halign")) {
            if ("halign_left".equals(style.get("halign"))) {
                this.setHorizontalAlignment(paragraph, JcEnumeration.LEFT);
            }
            if ("halign_right".equals(style.get("halign"))) {
                this.setHorizontalAlignment(paragraph, JcEnumeration.RIGHT);
            }
            if ("halign_center".equals(style.get("halign"))) {
                this.setHorizontalAlignment(paragraph, JcEnumeration.CENTER);
            }
        }
    }

    private void setHorizontalAlignment(P paragraph, JcEnumeration hAlign) {
        if (hAlign != null) {
            PPr pprop = paragraph.getPPr();
            if (pprop == null) {
                pprop = new PPr();
                paragraph.setPPr(pprop);
            }
            Jc align = new Jc();
            align.setVal(hAlign);
            pprop.setJc(align);
            paragraph.setPPr(pprop);
        }
    }

    private void addBoldStyle(RPr runProperties) {
        BooleanDefaultTrue b = new BooleanDefaultTrue();
        b.setVal(Boolean.valueOf(true));
        runProperties.setB(b);
    }

    private void addItalicStyle(RPr runProperties) {
        BooleanDefaultTrue b = new BooleanDefaultTrue();
        b.setVal(Boolean.valueOf(true));
        runProperties.setI(b);
    }

    private void addUnderlineStyle(RPr runProperties) {
        U val = new U();
        val.setVal(UnderlineEnumeration.SINGLE);
        runProperties.setU(val);
    }

    public P newImage(WordprocessingMLPackage wordMLPackage, byte[] bytes, String filenameHint, String altText, int id1, int id2, long cx) throws Exception {
        BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart((WordprocessingMLPackage)wordMLPackage, (byte[])bytes);
        Inline inline = imagePart.createImageInline(filenameHint, altText, id1, id2, cx, false);
        org.docx4j.wml.ObjectFactory factory = Context.getWmlObjectFactory();
        P p = this.createParagraph();
        R run = factory.createR();
        p.getContent().add(run);
        Drawing drawing = factory.createDrawing();
        run.getContent().add(drawing);
        drawing.getAnchorOrInline().add(inline);
        return p;
    }

    public P.Hyperlink newHyperlink(MainDocumentPart mdp, String text, String url) {
        try {
            org.docx4j.relationships.ObjectFactory factory = new org.docx4j.relationships.ObjectFactory();
            Relationship rel = factory.createRelationship();
            rel.setType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink");
            rel.setTarget(url);
            rel.setTargetMode("External");
            mdp.getRelationshipsPart().addRelationship(rel);
            P.Hyperlink hyp = new P.Hyperlink();
            hyp.setId(rel.getId());
            R run = Context.getWmlObjectFactory().createR();
            hyp.getContent().add(run);
            RPr rpr = new RPr();
            RStyle rStyle = new RStyle();
            rStyle.setVal("Hyperlink");
            rpr.setRStyle(rStyle);
            run.setRPr(rpr);
            Text t = new Text();
            t.setValue(text);
            run.getContent().add(t);
            return hyp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private int pixelsToDxa(int pixels) {
        return 1440 * pixels / DocxExporter.getDPI();
    }

    private P createParagraph() {
        P paragraph = this.factory.createP();
        PPr pPr = this.factory.createPPr();
        PPrBase.Spacing spacing = new PPrBase.Spacing();
        spacing.setAfter(BigInteger.ZERO);
        pPr.setSpacing(spacing);
        paragraph.setPPr(pPr);
        return paragraph;
    }

    private Hdr getHdr(WordprocessingMLPackage wordprocessingMLPackage, Part sourcePart, Tbl table) throws Exception {
        Hdr hdr = this.factory.createHdr();
        if (this.hasPageNoHeader) {
            hdr.getContent().add(this.createPageNumParagraph());
        } else {
            hdr.getContent().add(table);
        }
        return hdr;
    }

    private void createHeaderReference(WordprocessingMLPackage wordprocessingMLPackage, Relationship relationship) throws InvalidFormatException {
        List sections = wordprocessingMLPackage.getDocumentModel().getSections();
        SectPr sectPr = ((SectionWrapper)sections.get(sections.size() - 1)).getSectPr();
        if (sectPr == null) {
            sectPr = this.factory.createSectPr();
            wordprocessingMLPackage.getMainDocumentPart().addObject((Object)sectPr);
            ((SectionWrapper)sections.get(sections.size() - 1)).setSectPr(sectPr);
        }
        HeaderReference headerReference = this.factory.createHeaderReference();
        headerReference.setId(relationship.getId());
        headerReference.setType(HdrFtrRef.DEFAULT);
        sectPr.getEGHdrFtrReferences().add(headerReference);
    }

    private Relationship createHeaderPart(WordprocessingMLPackage wordprocessingMLPackage, Tbl table) throws Exception {
        HeaderPart headerPart = new HeaderPart();
        Relationship rel = wordprocessingMLPackage.getMainDocumentPart().addTargetPart((Part)headerPart);
        headerPart.setJaxbElement((Object)this.getHdr(wordprocessingMLPackage, (Part)headerPart, table));
        return rel;
    }

    private Ftr getFtr(WordprocessingMLPackage wordprocessingMLPackage, Part sourcePart, Tbl table) throws Exception {
        Ftr ftr = this.factory.createFtr();
        if (this.hasPageNoFooter) {
            ftr.getContent().add(this.createPageNumParagraph());
        } else {
            ftr.getContent().add(table);
        }
        return ftr;
    }

    private void createFooterReference(WordprocessingMLPackage wordprocessingMLPackage, Relationship relationship) throws InvalidFormatException {
        List sections = wordprocessingMLPackage.getDocumentModel().getSections();
        SectPr sectPr = ((SectionWrapper)sections.get(sections.size() - 1)).getSectPr();
        if (sectPr == null) {
            sectPr = this.factory.createSectPr();
            wordprocessingMLPackage.getMainDocumentPart().addObject((Object)sectPr);
            ((SectionWrapper)sections.get(sections.size() - 1)).setSectPr(sectPr);
        }
        FooterReference footerReference = this.factory.createFooterReference();
        footerReference.setId(relationship.getId());
        footerReference.setType(HdrFtrRef.DEFAULT);
        sectPr.getEGHdrFtrReferences().add(footerReference);
    }

    private Relationship createFooterPart(WordprocessingMLPackage wordprocessingMLPackage, Tbl table) throws Exception {
        FooterPart footerPart = new FooterPart();
        Relationship rel = wordprocessingMLPackage.getMainDocumentPart().addTargetPart((Part)footerPart);
        footerPart.setJaxbElement((Object)this.getFtr(wordprocessingMLPackage, (Part)footerPart, table));
        return rel;
    }

    private void addPageHeaderFooter() throws Exception {
        this.tableHeader = this.createTable(1);
        if (this.tableHeader != null) {
            this.tableRow = this.factory.createTr();
            this.printPageHeaderBand();
            this.tableHeader.getContent().add(this.tableRow);
            Relationship headerRel = this.createHeaderPart(this.wordMLPackage, this.tableHeader);
            this.createHeaderReference(this.wordMLPackage, headerRel);
        }
        this.tableFooter = this.createTable(2);
        if (this.tableFooter != null) {
            this.tableRow = this.factory.createTr();
            this.printPageFooterBand();
            this.tableFooter.getContent().add(this.tableRow);
            Relationship footerRel = this.createFooterPart(this.wordMLPackage, this.tableFooter);
            this.createFooterReference(this.wordMLPackage, footerRel);
        }
    }

    private void addBackgroundImage() throws Exception {
        String image = this.bean.getReportLayout().getBackgroundImage();
        if (image != null) {
            byte[] imageBytes = this.getImage(image);
            MainDocumentPart mdp = this.wordMLPackage.getMainDocumentPart();
            BinaryPartAbstractImage imagePartBG = BinaryPartAbstractImage.createImagePart((WordprocessingMLPackage)this.wordMLPackage, (byte[])imageBytes);
            ((Document)mdp.getContents()).setBackground(this.createBackground(imagePartBG.getRelLast().getId()));
        }
    }

    private org.docx4j.wml.CTBackground createBackground(String rId) {
        org.docx4j.wml.ObjectFactory wmlObjectFactory = new org.docx4j.wml.ObjectFactory();
        org.docx4j.wml.CTBackground background = wmlObjectFactory.createCTBackground();
        background.setColor("FFFFFF");
        org.docx4j.vml.ObjectFactory vmlObjectFactory = new org.docx4j.vml.ObjectFactory();
        CTBackground background2 = vmlObjectFactory.createCTBackground();
        JAXBElement backgroundWrapped = vmlObjectFactory.createBackground(background2);
        background.getAnyAndAny().add(backgroundWrapped);
        background2.setTargetscreensize("1024,768");
        background2.setVmlId("_x0000_s1025");
        background2.setBwmode(STBWMode.WHITE);
        CTFill fill = vmlObjectFactory.createCTFill();
        background2.setFill(fill);
        fill.setTitle("Alien 1");
        fill.setId(rId);
        fill.setType(STFillType.FRAME);
        fill.setRecolor(STTrueFalse.T);
        return background;
    }

    private P createPageNumParagraph() {
        CTSimpleField pgnum = this.factory.createCTSimpleField();
        pgnum.setInstr(" PAGE \\* MERGEFORMAT ");
        RPr RPr2 = this.factory.createRPr();
        RPr2.setNoProof(new BooleanDefaultTrue());
        PPr ppr = this.factory.createPPr();
        Jc jc = this.factory.createJc();
        jc.setVal(JcEnumeration.CENTER);
        ppr.setJc(jc);
        PPrBase.Spacing pprbase = this.factory.createPPrBaseSpacing();
        pprbase.setBefore(BigInteger.valueOf(240L));
        pprbase.setAfter(BigInteger.valueOf(0L));
        ppr.setSpacing(pprbase);
        R run = this.factory.createR();
        run.getContent().add(RPr2);
        pgnum.getContent().add(run);
        JAXBElement fldSimple = this.factory.createPFldSimple(pgnum);
        P para = this.createParagraph();
        para.getContent().add(fldSimple);
        para.setPPr(ppr);
        return para;
    }

    public Tbl getTable() {
        return this.table;
    }
}

