/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.exporter;

import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.nextreports.engine.ReleaseInfoAdapter;
import ro.nextreports.engine.Report;
import ro.nextreports.engine.ReportLayout;
import ro.nextreports.engine.band.Band;
import ro.nextreports.engine.band.BandElement;
import ro.nextreports.engine.band.Hyperlink;
import ro.nextreports.engine.band.HyperlinkBandElement;
import ro.nextreports.engine.band.ImageBandElement;
import ro.nextreports.engine.band.ImageColumnBandElement;
import ro.nextreports.engine.band.ReportBandElement;
import ro.nextreports.engine.exporter.CellElement;
import ro.nextreports.engine.exporter.ExporterBean;
import ro.nextreports.engine.exporter.ResultExporter;
import ro.nextreports.engine.queryexec.QueryException;
import ro.nextreports.engine.util.HtmlUtil;
import ro.nextreports.engine.util.StringUtil;

public class HtmlExporter
extends ResultExporter {
    private PrintStream stream;

    public HtmlExporter(ExporterBean bean) {
        super(bean);
    }

    @Override
    protected void initExport() throws QueryException {
        this.stream = this.createPrintStream();
        if (!this.bean.isSubreport()) {
            String style = this.buildHtmlStyle(this.getReportLayout());
            this.stream.print("<html><head>\n");
            this.stream.print("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n");
            this.stream.print(this.getMetaData());
            this.stream.print("<title>");
            this.stream.print(this.getDocumentTitle());
            this.stream.print("</title>\n" + style + " \n</head> ");
            if (this.bean.getReportLayout().getBackgroundImage() != null) {
                this.stream.print("<body style=\"background-image:url(");
                this.stream.print(this.bean.getReportLayout().getBackgroundImage());
                this.stream.print(")\">\n");
            } else {
                this.stream.print("<body>\n");
            }
        }
        if (this.bean.getReportLayout().isUseSize()) {
            this.stream.print("<table>");
        } else {
            this.stream.print("<table style='width:100%'>");
        }
    }

    private String getMetaData() {
        StringBuilder sb = new StringBuilder();
        sb.append("<meta name=\"author\" content=\"").append(ReleaseInfoAdapter.getCompany()).append("\">\n");
        sb.append("<meta name=\"creator\" content=\"").append("NextReports ").append(ReleaseInfoAdapter.getVersionNumber()).append("\">\n");
        sb.append("<meta name=\"subject\" content=\"").append("Created by NextReports Designer ").append(ReleaseInfoAdapter.getVersionNumber()).append("\">\n");
        sb.append("<meta name=\"date\" content=\"").append(new Date()).append("\">\n");
        sb.append("<meta name=\"keywords\" content=\"").append(ReleaseInfoAdapter.getHome()).append("\">\n");
        return sb.toString();
    }

    @Override
    protected void finishExport() {
        this.stream.print("</table>\n");
        if (!this.bean.isSubreport()) {
            this.stream.print("</body></html>");
        }
        this.stream.flush();
        if (!this.bean.isSubreport()) {
            this.stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSubreportTable() {
        try {
            String string = this.subreportStream.toString("UTF-8");
            return string;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            String string = "";
            return string;
        }
        finally {
            this.stream.close();
        }
    }

    @Override
    protected void close() {
        if (!this.bean.isSubreport()) {
            this.stream.close();
        }
    }

    @Override
    protected void flush() {
        if (this.resultSetRow % 7500 == 0) {
            this.flushNow();
        }
    }

    @Override
    protected void flushNow() {
        this.stream.flush();
    }

    @Override
    protected Set<CellElement> getIgnoredCells(Band band) {
        return this.getIgnoredCellElements(band);
    }

    @Override
    protected void exportCell(String bandName, BandElement bandElement, Object value, int gridRow, int row, int column, int cols, int rowSpan, int colSpan, boolean isImage) {
        if (this.newRow) {
            this.stream.print("<tr>");
        }
        this.stream.print(this.getTd(bandName, gridRow, row, column, value, rowSpan, colSpan, bandElement, isImage));
        if (column + colSpan == cols) {
            this.stream.print("</tr>\n");
        }
        if (this.newRow && column + colSpan == cols) {
            for (int i = 0; i < this.newRowCount - 1; ++i) {
                this.stream.print("<tr></tr>\n");
            }
        }
    }

    @Override
    protected void afterRowExport() {
    }

    @Override
    protected String getNullElement() {
        return "&nbsp;";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTd(String bandName, int gridRow, int i, int j, Object value, int rowSpan, int colSpan, BandElement bandElement, boolean image) {
        StringBuilder sb = new StringBuilder();
        String val = image ? (String)value : this.getStringValue(value, this.getPattern(bandElement));
        sb.append("<td ");
        if (this.hasRenderConditions(bandElement, value) || this.hasRowRenderConditions(bandElement, gridRow, value)) {
            sb.append("style=\"");
            sb.append(this.renderCssCode(bandElement, value, gridRow, j, colSpan, true));
            sb.append("\"");
        } else {
            sb.append("class='");
            if (this.bean.isSubreport()) {
                sb.append(this.bean.getFileName()).append("_");
            }
            sb.append(bandName).append(i).append("_").append(j).append("'");
        }
        sb.append(" rowspan=").append(rowSpan).append(" colspan=").append(colSpan);
        if (this.bean.getReportLayout().isUseSize()) {
            sb.append(" width=").append("\"");
            sb.append(this.getColumnWidth(j, colSpan));
            sb.append("\"");
        }
        if (bandElement != null) {
            String scope;
            String id;
            String headers = bandElement.getHtmlAccHeaders();
            if (headers != null) {
                sb.append(" headers=\"").append(headers).append("\"");
            }
            if ((id = bandElement.getHtmlAccId()) != null) {
                sb.append(" id=\"").append(id).append("\"");
            }
            if ((scope = bandElement.getHtmlAccScope()) != null) {
                sb.append(" scope=\"").append(scope).append("\"");
            }
        }
        sb.append(">");
        if (image) {
            ImageBandElement ibe = (ImageBandElement)bandElement;
            sb.append("<img src=\"").append(ibe.getImage()).append("\"");
            if (ibe.isScaled()) {
                sb.append(" width=\"").append(ibe.getWidth()).append("\"");
                sb.append(" height=\"").append(ibe.getHeight()).append("\"");
            }
            sb.append(" alt=\"").append(IMAGE_NOT_LOADED).append("\"></img>");
        } else if (bandElement instanceof HyperlinkBandElement) {
            Hyperlink hyperlink = ((HyperlinkBandElement)bandElement).getHyperlink();
            sb.append("<a href=\"").append(hyperlink.getUrl()).append("\" target=\"_blank\">").append(hyperlink.getText()).append("</a>");
        } else if (bandElement instanceof ReportBandElement) {
            Report report = ((ReportBandElement)bandElement).getReport();
            ExporterBean eb = null;
            try {
                eb = this.getSubreportExporterBean(report);
                HtmlExporter subExporter = new HtmlExporter(eb);
                subExporter.export();
                sb.append(subExporter.getSubreportTable());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (eb != null && eb.getResult() != null) {
                    eb.getResult().close();
                }
            }
        } else if (bandElement instanceof ImageColumnBandElement) {
            String v = StringUtil.getValueAsString(value, null);
            if (StringUtil.BLOB.equals(v)) {
                sb.append(StringUtil.BLOB);
            } else {
                ImageColumnBandElement icbe = (ImageColumnBandElement)bandElement;
                byte[] imageBytes = StringUtil.decodeImage(v);
                sb.append("<img src=\"data:image/jpg;base64,").append(v).append("\"");
                if (icbe.isScaled()) {
                    sb.append(" width=\"").append(icbe.getWidth()).append("\"");
                    sb.append(" height=\"").append(icbe.getHeight()).append("\"");
                }
                sb.append(" alt=\"").append(IMAGE_NOT_LOADED).append("\"></img>");
            }
        } else {
            sb.append(val);
        }
        sb.append("</td>");
        return sb.toString();
    }

    private String renderCssCode(BandElement be, int gridRow, int gridColumn, int colSpan) {
        return this.renderCssCode(be, null, gridRow, gridColumn, colSpan, false);
    }

    private String renderCssCode(BandElement be, Object value, int gridRow, int gridColumn, int colSpan, boolean overwriteCellRenderCond) {
        Map<String, Object> style = null;
        style = this.buildCellStyleMap(be, value, gridRow, gridColumn, colSpan, overwriteCellRenderCond);
        if (this.bean.getReportLayout().getBackgroundImage() != null) {
            style.remove("bg_color");
        }
        return HtmlUtil.getCssCode(be, style);
    }

    private String buildHtmlStyle(ReportLayout reportLayout) {
        StringBuilder retval = new StringBuilder();
        retval.append("<style type=\"text/css\" > \n table{  border-collapse:collapse; } \n\t ");
        List<Band> bands = reportLayout.getDocumentBands();
        for (Band band : bands) {
            int rows = band.getRowCount();
            int cols = band.getColumnCount();
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    BandElement be = band.getElementAt(i, j);
                    int colSpan = be == null ? 1 : be.getColSpan();
                    retval.append(" .").append(band.getName()).append(i).append("_").append(j).append(" \n{").append(this.renderCssCode(be, i, j, colSpan)).append(" } \n");
                    if (!(be instanceof ReportBandElement)) continue;
                    retval.append(this.buildSubreportHtmlStyle((ReportBandElement)be));
                }
            }
        }
        retval.append("</style> \n");
        return retval.toString();
    }

    private String buildSubreportHtmlStyle(ReportBandElement rbe) {
        StringBuilder retval = new StringBuilder();
        ReportLayout layout = rbe.getReport().getLayout();
        List<Band> bands = layout.getDocumentBands();
        for (Band band : bands) {
            int rows = band.getRowCount();
            int cols = band.getColumnCount();
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    BandElement be = band.getElementAt(i, j);
                    int colSpan = be == null ? 1 : be.getColSpan();
                    retval.append(" .").append(rbe.getReport().getBaseName()).append("_");
                    retval.append(band.getName()).append(i).append("_").append(j).append(" \n{").append(this.renderCssCode(be, i, j, colSpan)).append(" } \n");
                    if (!(be instanceof ReportBandElement)) continue;
                    retval.append(this.buildSubreportHtmlStyle((ReportBandElement)be));
                }
            }
        }
        return retval.toString();
    }

    private String getStringValue(Object val, String pattern) {
        String v = StringUtil.getValueAsString(val, pattern, this.getReportLanguage());
        if (v == null) {
            return this.getNullElement();
        }
        return v;
    }

    @Override
    protected void newPage() {
        if (!this.bean.isSubreport()) {
            try {
                this.stream.print("</table>\n");
                this.stream.println("<p style=\"page-break-before: always\"></p>\n");
                if (this.bean.getReportLayout().isUseSize()) {
                    this.stream.print("<table>");
                } else {
                    this.stream.print("<table style='width:100%'>");
                }
                if (this.bean.getReportLayout().isHeaderOnEveryPage()) {
                    this.printHeaderBand();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

