/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.exporter;

import java.awt.Color;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ro.nextreports.engine.band.Band;
import ro.nextreports.engine.band.BandElement;
import ro.nextreports.engine.band.FieldBandElement;
import ro.nextreports.engine.exporter.Alert;
import ro.nextreports.engine.exporter.CellElement;
import ro.nextreports.engine.exporter.ExporterBean;
import ro.nextreports.engine.exporter.ResultExporter;
import ro.nextreports.engine.exporter.util.IndicatorData;
import ro.nextreports.engine.queryexec.QueryException;

public class IndicatorExporter
extends ResultExporter {
    private IndicatorData data = new IndicatorData();

    public IndicatorExporter(ExporterBean bean) {
        super(bean);
    }

    @Override
    protected void exportCell(String bandName, BandElement bandElement, Object value, int gridRow, int row, int column, int cols, int rowSpan, int colSpan, boolean isImage) {
        int headerRows = this.getHeaderRows();
        int detailRows = this.getDetailRows();
        Map<String, Object> style = this.buildCellStyleMap(bandElement, value, gridRow, column, colSpan);
        if ("Header".equals(bandName)) {
            if (headerRows == 2) {
                if (row == 0) {
                    switch (column) {
                        case 0: {
                            this.data.setTitle(this.getBandElementValueAsString(bandElement));
                            break;
                        }
                        case 1: {
                            this.data.setDescription(this.getBandElementValueAsString(bandElement));
                            break;
                        }
                        case 2: {
                            this.data.setUnit(bandElement.getText());
                            break;
                        }
                        case 3: {
                            this.data.setShadow(Boolean.parseBoolean(bandElement.getText()));
                        }
                    }
                } else if (row == 1) {
                    switch (column) {
                        case 0: {
                            this.data.setMin(Integer.parseInt(bandElement.getText()));
                            break;
                        }
                        case 1: {
                            this.data.setMax(Integer.parseInt(bandElement.getText()));
                            break;
                        }
                        case 2: {
                            this.data.setShowMinMax(Boolean.parseBoolean(bandElement.getText()));
                        }
                    }
                }
            }
        } else if ("Detail".equals(bandName)) {
            if (detailRows == 1 && column == 0) {
                this.data.setBackground(bandElement.getBackground());
                if (style.containsKey("bg_color")) {
                    this.data.setBackground((Color)style.get("bg_color"));
                }
                this.data.setColor(bandElement.getForeground());
                if (style.containsKey("font_color")) {
                    this.data.setColor((Color)style.get("font_color"));
                }
                if (value instanceof Integer) {
                    this.data.setValue(((Integer)value).intValue());
                } else if (value instanceof Long) {
                    this.data.setValue(((Long)value).longValue());
                } else if (value instanceof BigDecimal) {
                    this.data.setValue(((BigDecimal)value).doubleValue());
                } else {
                    this.data.setValue((Double)value);
                }
                if (bandElement instanceof FieldBandElement) {
                    this.data.setPattern(((FieldBandElement)bandElement).getPattern());
                }
                for (Alert alert : this.alerts) {
                    if (!this.isAlert(alert, value)) continue;
                    this.executeAlert(alert, value, "");
                }
            }
            return;
        }
    }

    @Override
    protected void flush() {
    }

    @Override
    protected void flushNow() {
    }

    @Override
    protected void initExport() throws QueryException {
    }

    @Override
    protected void finishExport() {
    }

    @Override
    protected Set<CellElement> getIgnoredCells(Band band) {
        return new HashSet<CellElement>();
    }

    @Override
    protected void afterRowExport() {
    }

    @Override
    protected void close() {
    }

    @Override
    protected String getNullElement() {
        return "";
    }

    public IndicatorData getData() {
        return this.data;
    }
}

