/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.exporter;

import com.itextpdf.text.Anchor;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.FontFactoryImp;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.html.simpleparser.HTMLWorker;
import com.itextpdf.text.html.simpleparser.StyleSheet;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPRow;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.nextreports.engine.ReleaseInfoAdapter;
import ro.nextreports.engine.Report;
import ro.nextreports.engine.band.Band;
import ro.nextreports.engine.band.BandElement;
import ro.nextreports.engine.band.Hyperlink;
import ro.nextreports.engine.band.HyperlinkBandElement;
import ro.nextreports.engine.band.ImageBandElement;
import ro.nextreports.engine.band.ImageColumnBandElement;
import ro.nextreports.engine.band.Padding;
import ro.nextreports.engine.band.PaperSize;
import ro.nextreports.engine.band.ReportBandElement;
import ro.nextreports.engine.band.VariableBandElement;
import ro.nextreports.engine.exporter.CellElement;
import ro.nextreports.engine.exporter.ExporterBean;
import ro.nextreports.engine.exporter.ResultExporter;
import ro.nextreports.engine.exporter.util.variable.TotalPageNoVariable;
import ro.nextreports.engine.exporter.util.variable.VariableFactory;
import ro.nextreports.engine.queryexec.QueryException;
import ro.nextreports.engine.util.StringUtil;

public class PdfExporter
extends ResultExporter {
    private PdfTemplate total;
    public static final String PDF_ENCODING_PROPERTY = "nextreports.pdf.encoding";
    public static final String PDF_FONT_PROPERTY = "nextreports.pdf.font";
    public static final String PDF_DIRECTION = "nextreports.pdf.direction";
    public static final String PDF_ARABIC_OPTIONS = "nextreports.pdf.arabicOptions";
    private final String encoding = System.getProperty("nextreports.pdf.encoding");
    private final String embeddedFont = System.getProperty("nextreports.pdf.font");
    private final int textDirection = Integer.getInteger("nextreports.pdf.direction", 0);
    private final int arabicOptions = Integer.getInteger("nextreports.pdf.arabicOptions", 0);
    private String fontName = "Times";
    private int fragmentsize = 15000;
    private Document document;
    private PdfPTable table;
    private PdfPTable header;
    private PdfPTable footer;
    private float percentage = 100.0f;
    private int[] headerwidths;
    private static final int MINIMUM_HEIGHT = 12;

    public PdfExporter(ExporterBean bean) {
        super(bean);
    }

    @Override
    protected void initExport() throws QueryException {
        Padding margins = this.bean.getReportLayout().getPagePadding();
        if (!this.bean.isSubreport()) {
            Rectangle rectangle;
            float footerHeight = this.computeFooterHeight();
            if ("CUSTOM".equals(this.bean.getReportLayout().getPageFormat())) {
                PaperSize customSize = this.bean.getReportLayout().getPaperSize();
                rectangle = new Rectangle((float)customSize.getWidthPoints(), (float)customSize.getHeightPoints());
            } else {
                rectangle = PageSize.getRectangle((String)this.bean.getReportLayout().getPageFormat());
            }
            this.document = new Document(rectangle, (float)this.getPoints(margins.getLeft()), (float)this.getPoints(margins.getRight()), (float)this.getPoints(margins.getTop()), (float)this.getPoints(margins.getBottom()) + footerHeight);
            if (this.bean.getReportLayout().getOrientation() == 1) {
                this.document.setPageSize(rectangle.rotate());
            }
        }
        PdfWriter wr = null;
        try {
            if (!this.bean.isSubreport()) {
                wr = PdfWriter.getInstance((Document)this.document, (OutputStream)this.getOut());
                wr.setPageEvent((com.itextpdf.text.pdf.PdfPageEvent)new PdfPageEvent());
                this.addMetaData();
                this.document.open();
            }
            this.table = this.buildPdfTable(0);
        }
        catch (DocumentException e) {
            e.printStackTrace();
            throw new QueryException(e);
        }
    }

    private void addMetaData() {
        this.document.addTitle(this.getDocumentTitle());
        this.document.addAuthor(ReleaseInfoAdapter.getCompany());
        this.document.addCreator("NextReports " + ReleaseInfoAdapter.getVersionNumber());
        this.document.addSubject("Created by NextReports Designer" + ReleaseInfoAdapter.getVersionNumber());
        this.document.addCreationDate();
        this.document.addKeywords(ReleaseInfoAdapter.getHome());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finishExport() {
        if (!this.bean.isSubreport()) {
            try {
                if (this.table != null) {
                    this.document.add((Element)this.table);
                } else {
                    this.document.add((Element)new Paragraph(" "));
                }
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
            finally {
                this.table = null;
                this.document.close();
            }
        }
    }

    @Override
    protected void close() {
        if (!this.bean.isSubreport()) {
            this.document.close();
        }
    }

    @Override
    protected void flush() {
        if (!this.bean.isSubreport() && this.resultSetRow % this.fragmentsize == this.fragmentsize - 1) {
            this.flushNow();
        }
    }

    @Override
    protected void flushNow() {
        if (!this.bean.isSubreport()) {
            try {
                this.document.add((Element)this.table);
                this.table.deleteBodyRows();
                this.table.setSkipFirstHeader(true);
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected Set<CellElement> getIgnoredCells(Band band) {
        return this.getIgnoredCellElements(band);
    }

    @Override
    protected void exportCell(String bandName, BandElement bandElement, Object value, int gridRow, int row, int column, int cols, int rowSpan, int colSpan, boolean isImage) {
        if (!this.bean.isSubreport()) {
            if ("PageHeader".equals(bandName)) {
                this.header.addCell(this.renderPdfCell(bandElement, value, gridRow, rowSpan, colSpan, isImage, column));
            } else if ("PageFooter".equals(bandName)) {
                this.footer.addCell(this.renderPdfCell(bandElement, value, gridRow, rowSpan, colSpan, isImage, column));
            } else {
                this.table.addCell(this.renderPdfCell(bandElement, value, gridRow, rowSpan, colSpan, isImage, column));
            }
        } else {
            this.table.addCell(this.renderPdfCell(bandElement, value, gridRow, rowSpan, colSpan, isImage, column));
        }
    }

    @Override
    protected void afterRowExport() {
    }

    @Override
    protected String getNullElement() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PdfPCell renderPdfCell(BandElement bandElement, Object value, int gridRow, int rowSpan, int colSpan, boolean image, int column) {
        PdfPCell cell;
        Font fnt;
        Map<String, Object> style;
        block57: {
            style = this.buildCellStyleMap(bandElement, value, gridRow, column, colSpan);
            FontFactoryImp fact = new FontFactoryImp();
            if (bandElement != null) {
                this.fontName = (String)style.get("font_name");
                int size = ((Float)style.get("font_size")).intValue();
                fnt = this.getFont(size);
            } else {
                fnt = this.getFont(10);
            }
            if (image) {
                if (value == null) {
                    cell = new PdfPCell(new Phrase(IMAGE_NOT_FOUND));
                } else {
                    ImageBandElement ibe = (ImageBandElement)bandElement;
                    try {
                        byte[] imageBytes = this.getImage((String)value);
                        cell = this.getImageCell(ibe, imageBytes, column, colSpan);
                    }
                    catch (Exception e) {
                        cell = new PdfPCell(new Phrase(IMAGE_NOT_LOADED));
                    }
                }
            } else if (bandElement instanceof HyperlinkBandElement) {
                Hyperlink hyperlink = ((HyperlinkBandElement)bandElement).getHyperlink();
                Anchor anchor = new Anchor(hyperlink.getText(), fnt);
                anchor.setReference(hyperlink.getUrl());
                Phrase ph = new Phrase();
                ph.add((Element)anchor);
                cell = new PdfPCell(ph);
            } else if (bandElement instanceof ReportBandElement) {
                Report report = ((ReportBandElement)bandElement).getReport();
                ExporterBean eb = null;
                try {
                    eb = this.getSubreportExporterBean(report);
                    PdfExporter subExporter = new PdfExporter(eb);
                    subExporter.export();
                    PdfPTable innerTable = subExporter.getTable();
                    cell = new PdfPCell(innerTable);
                }
                catch (Exception e) {
                    cell = new PdfPCell();
                    e.printStackTrace();
                }
                finally {
                    if (eb != null && eb.getResult() != null) {
                        eb.getResult().close();
                    }
                }
            } else if (bandElement instanceof VariableBandElement && VariableFactory.getVariable(((VariableBandElement)bandElement).getVariable()) instanceof TotalPageNoVariable) {
                try {
                    cell = new PdfPCell(Image.getInstance((PdfTemplate)this.total));
                }
                catch (BadElementException e) {
                    cell = new PdfPCell(new Phrase("NA"));
                }
            } else if (bandElement instanceof ImageColumnBandElement) {
                try {
                    String v = StringUtil.getValueAsString(value, null);
                    if (StringUtil.BLOB.equals(v)) {
                        cell = new PdfPCell(new Phrase(StringUtil.BLOB));
                        break block57;
                    }
                    byte[] bytes = StringUtil.decodeImage(v);
                    cell = this.getImageCell(bandElement, bytes, column, colSpan);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    cell = new PdfPCell(new Phrase(IMAGE_NOT_LOADED));
                }
            } else {
                String stringValue = style.containsKey("pattern") ? StringUtil.getValueAsString(value, (String)style.get("pattern"), this.getReportLanguage()) : StringUtil.getValueAsString(value, null, this.getReportLanguage());
                if (stringValue == null) {
                    stringValue = "";
                }
                if (stringValue.startsWith("<html>")) {
                    StringReader reader = new StringReader(stringValue);
                    List elems = new ArrayList();
                    try {
                        elems = HTMLWorker.parseToList((Reader)reader, (StyleSheet)new StyleSheet());
                        Phrase ph = new Phrase();
                        for (int i = 0; i < elems.size(); ++i) {
                            Element elem = (Element)elems.get(i);
                            ph.add(elem);
                        }
                        cell = new PdfPCell(ph);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        Phrase ph = new Phrase(stringValue, fnt);
                        cell = new PdfPCell(ph);
                    }
                } else {
                    Phrase ph = new Phrase(stringValue, fnt);
                    cell = new PdfPCell(ph);
                }
            }
        }
        cell.setArabicOptions(this.arabicOptions);
        cell.setRunDirection(this.textDirection);
        cell.setVerticalAlignment(5);
        cell.setUseDescender(true);
        cell.setMinimumHeight(12.0f);
        if (bandElement != null) {
            cell.setRotation((int)bandElement.getTextRotation());
        }
        if (colSpan > 1) {
            cell.setColspan(colSpan);
        }
        if (rowSpan > 1) {
            cell.setRowspan(rowSpan);
        }
        if (style != null) {
            Color color;
            Serializable val;
            this.updateFont(style, fnt);
            if (style.containsKey("bg_color")) {
                val = (Color)style.get("bg_color");
                cell.setBackgroundColor(new BaseColor((Color)val));
            }
            if (style.containsKey("halign")) {
                if ("halign_left".equals(style.get("halign"))) {
                    cell.setHorizontalAlignment(0);
                }
                if ("halign_right".equals(style.get("halign"))) {
                    cell.setHorizontalAlignment(2);
                }
                if ("halign_center".equals(style.get("halign"))) {
                    cell.setHorizontalAlignment(1);
                }
            }
            if (style.containsKey("valign")) {
                if ("valign_top".equals(style.get("valign"))) {
                    cell.setVerticalAlignment(4);
                }
                if ("valign_middle".equals(style.get("valign"))) {
                    cell.setVerticalAlignment(5);
                }
                if ("valign_bottom".equals(style.get("valign"))) {
                    cell.setVerticalAlignment(6);
                }
            }
            if (style.containsKey("padding_left")) {
                val = (Float)style.get("padding_left");
                cell.setPaddingLeft(((Float)val).floatValue());
            }
            if (style.containsKey("padding_right")) {
                val = (Float)style.get("padding_right");
                cell.setPaddingRight(((Float)val).floatValue());
            }
            if (style.containsKey("padding_top")) {
                val = (Float)style.get("padding_top");
                cell.setPaddingTop(((Float)val).floatValue());
            }
            if (style.containsKey("padding_bottom")) {
                val = (Float)style.get("padding_bottom");
                cell.setPaddingBottom(((Float)val).floatValue());
            }
            cell.setBorderWidth(0.0f);
            if (style.containsKey("border_left")) {
                val = (Float)style.get("border_left");
                cell.setBorderWidthLeft(((Float)val).floatValue() / 2.0f);
                color = (Color)style.get("border_left_color");
                cell.setBorderColorLeft(new BaseColor(color));
            }
            if (style.containsKey("border_right")) {
                val = (Float)style.get("border_right");
                cell.setBorderWidthRight(((Float)val).floatValue() / 2.0f);
                color = (Color)style.get("border_right_color");
                cell.setBorderColorRight(new BaseColor(color));
            }
            if (style.containsKey("border_top")) {
                val = (Float)style.get("border_top");
                cell.setBorderWidthTop(((Float)val).floatValue() / 2.0f);
                color = (Color)style.get("border_top_color");
                cell.setBorderColorTop(new BaseColor(color));
            }
            if (style.containsKey("border_bottom")) {
                val = (Float)style.get("border_bottom");
                cell.setBorderWidthBottom(((Float)val).floatValue() / 2.0f);
                color = (Color)style.get("border_bottom_color");
                cell.setBorderColorBottom(new BaseColor(color));
            }
            if (cell.getTable() == null) {
                cell.setNoWrap(true);
                if (bandElement != null && bandElement.isWrapText()) {
                    cell.setNoWrap(false);
                }
            }
            if (this.bean.getReportLayout().getBackgroundImage() != null) {
                cell.setBackgroundColor(null);
            }
        }
        return cell;
    }

    private void updateFont(Map<String, Object> style, Font fnt) {
        Object val;
        if (style.containsKey("font_family")) {
            val = (String)style.get("font_family");
            fnt.setFamily((String)val);
        }
        if (style.containsKey("font_size")) {
            val = (Float)style.get("font_size");
            fnt.setSize(((Float)val).floatValue());
        }
        if (style.containsKey("font_color")) {
            val = (Color)style.get("font_color");
            fnt.setColor(new BaseColor((Color)val));
        }
        if (style.containsKey("font_style_key")) {
            if ("font_stylet_normal".equals(style.get("font_style_key"))) {
                fnt.setStyle(0);
            }
            if ("font_style_bold".equals(style.get("font_style_key"))) {
                fnt.setStyle(1);
            }
            if ("font_style_italic".equals(style.get("font_style_key"))) {
                fnt.setStyle(2);
            }
            if ("font_style_bold_italic".equals(style.get("font_style_key"))) {
                fnt.setStyle(3);
            }
        }
    }

    private Font getFont(int size) {
        if (this.encoding == null) {
            return FontFactory.getFont((String)this.fontName, (float)size);
        }
        if (this.embeddedFont == null) {
            return FontFactory.getFont((String)this.fontName, (String)this.encoding, (float)size);
        }
        return FontFactory.getFont((String)this.embeddedFont, (String)this.encoding, (boolean)true, (float)size, (int)0);
    }

    private PdfPTable buildPdfTable(int type) throws QueryException {
        List<Object> bands = new ArrayList<Band>();
        if (type == 1) {
            bands.add(this.getReportLayout().getPageHeaderBand());
        } else if (type == 2) {
            bands.add(this.getReportLayout().getPageFooterBand());
        } else {
            bands = this.getReportLayout().getDocumentBands();
        }
        int totalRows = 0;
        int totalColumns = 0;
        for (Band band : bands) {
            totalRows += band.getRowCount();
            int cols = band.getColumnCount();
            if (cols <= totalColumns) continue;
            totalColumns = cols;
        }
        if (totalColumns == 0) {
            return null;
        }
        PdfPTable datatable = new PdfPTable(totalColumns);
        this.headerwidths = new int[totalColumns];
        int n = 100 / totalColumns;
        int totalWidth = 0;
        for (int i = 0; i < totalColumns; ++i) {
            this.headerwidths[i] = this.bean.getReportLayout().isUseSize() ? this.bean.getReportLayout().getColumnsWidth().get(i) : n;
            totalWidth += this.headerwidths[i];
        }
        try {
            if (this.bean.getReportLayout().isUseSize()) {
                float pixels = A4_PORTRAIT_PIXELS;
                if (this.bean.getReportLayout().getOrientation() == 1) {
                    pixels = A4_LANDSCAPE_PIXELS;
                }
                this.percentage = (float)(totalWidth * 100) / pixels;
                if (this.percentage > 100.0f) {
                    this.percentage = 100.0f;
                }
                if (!"CUSTOM".equals(this.bean.getReportLayout().getPageFormat())) {
                    datatable.setWidthPercentage(this.percentage);
                }
                datatable.setWidths(this.headerwidths);
            } else {
                datatable.setWidthPercentage(100.0f);
            }
        }
        catch (DocumentException e) {
            throw new QueryException(e);
        }
        if (type == 0) {
            this.writeHeader(datatable);
        }
        datatable.setSplitLate(false);
        return datatable;
    }

    private void writeHeader(PdfPTable datatable) {
        int headerNo;
        if (this.bean.getReportLayout().isHeaderOnEveryPage() && (headerNo = this.bean.getReportLayout().getHeaderBand().getRowCount()) > 0) {
            datatable.setHeaderRows(headerNo);
        }
    }

    @Override
    protected void newPage() {
        if (!this.bean.isSubreport()) {
            try {
                this.document.add((Element)this.table);
                this.document.newPage();
                this.table.deleteBodyRows();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private float computeFooterHeight() throws QueryException {
        this.footer = this.buildPdfTable(2);
        if (this.footer == null) {
            return 0.0f;
        }
        this.printPageFooterBand();
        float height = 0.0f;
        ArrayList rows = this.footer.getRows();
        for (int k = 0; k < rows.size(); ++k) {
            PdfPRow row = (PdfPRow)rows.get(k);
            PdfPCell[] cells = row.getCells();
            float rowHeight = 0.0f;
            for (PdfPCell cell : cells) {
                rowHeight = cell == null ? Math.max(rowHeight, 12.0f) : Math.max(rowHeight, cell.getMaxHeight());
            }
            height += rowHeight;
        }
        return height;
    }

    public PdfPTable getTable() {
        return this.table;
    }

    private PdfPCell getImageCell(BandElement bandElement, byte[] imageBytes, int column, int colSpan) {
        PdfPCell cell;
        try {
            Image pdfImage = Image.getInstance((byte[])imageBytes);
            Integer width = this.getImageWidth(bandElement);
            Integer height = this.getImageHeight(bandElement);
            if (this.isScaled(bandElement)) {
                float factor = 72.0f * this.percentage / (float)(PdfExporter.getDPI() * 100);
                pdfImage.scaleAbsolute((float)width.intValue() * factor, (float)height.intValue() * factor);
                int cellWidth = 0;
                for (int i = column; i < column + colSpan; ++i) {
                    cellWidth += this.headerwidths[i];
                }
                if (width >= cellWidth && this.bean.getReportLayout().isUseSize()) {
                    cell = new PdfPCell();
                    cell.setImage(pdfImage);
                } else {
                    cell = new PdfPCell(pdfImage);
                }
            } else {
                cell = new PdfPCell(pdfImage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            cell = new PdfPCell(new Phrase(IMAGE_NOT_LOADED));
        }
        return cell;
    }

    private int getImageWidth(BandElement be) {
        Integer width = null;
        width = be instanceof ImageBandElement ? ((ImageBandElement)be).getWidth() : ((ImageColumnBandElement)be).getWidth();
        if (width == null) {
            width = 0;
        }
        return width;
    }

    private int getImageHeight(BandElement be) {
        Integer height = null;
        height = be instanceof ImageBandElement ? ((ImageBandElement)be).getHeight() : ((ImageColumnBandElement)be).getHeight();
        if (height == null) {
            height = 0;
        }
        return height;
    }

    private boolean isScaled(BandElement be) {
        if (be instanceof ImageBandElement) {
            return ((ImageBandElement)be).isScaled();
        }
        return ((ImageColumnBandElement)be).isScaled();
    }

    private class PdfPageEvent
    extends PdfPageEventHelper {
        private PdfPageEvent() {
        }

        public void onStartPage(PdfWriter writer, Document document) {
            try {
                PdfExporter.this.header = PdfExporter.this.buildPdfTable(1);
                if (PdfExporter.this.header != null) {
                    PdfExporter.this.printPageHeaderBand();
                    document.add((Element)PdfExporter.this.header);
                }
            }
            catch (Exception e) {
                throw new ExceptionConverter(e);
            }
        }

        public void onEndPage(PdfWriter writer, Document document) {
            try {
                PdfExporter.this.footer = PdfExporter.this.buildPdfTable(2);
                if (PdfExporter.this.footer != null) {
                    PdfExporter.this.printPageFooterBand();
                    Rectangle page = document.getPageSize();
                    PdfExporter.this.footer.setTotalWidth(page.getWidth() - document.leftMargin() - document.rightMargin());
                    PdfExporter.this.footer.writeSelectedRows(0, -1, document.leftMargin(), document.bottomMargin(), writer.getDirectContent());
                    String image = PdfExporter.this.bean.getReportLayout().getBackgroundImage();
                    if (image != null) {
                        byte[] imageBytes = PdfExporter.this.getImage(image);
                        Image pdfImage = Image.getInstance((byte[])imageBytes);
                        pdfImage.setAbsolutePosition(0.0f, 0.0f);
                        writer.getDirectContentUnder().addImage(pdfImage);
                    }
                }
            }
            catch (Exception e) {
                throw new ExceptionConverter(e);
            }
            finally {
                PdfExporter.this.pageNo = writer.getPageNumber();
            }
        }

        public void onOpenDocument(PdfWriter writer, Document document) {
            int size = 10;
            if (PdfExporter.this.totalPageNoVbe != null) {
                Map<String, Object> style = PdfExporter.this.buildCellStyleMap(PdfExporter.this.totalPageNoVbe);
                size = ((Float)style.get("font_size")).intValue();
            }
            PdfExporter.this.total = writer.getDirectContent().createTemplate(30.0f, (float)size);
        }

        public void onCloseDocument(PdfWriter writer, Document document) {
            PdfExporter.this.totalPageNo = writer.getPageNumber() - 1;
            if (PdfExporter.this.totalPageNoVbe != null) {
                Map<String, Object> style = PdfExporter.this.buildCellStyleMap(PdfExporter.this.totalPageNoVbe);
                PdfExporter.this.fontName = (String)style.get("font_name");
                int size = ((Float)style.get("font_size")).intValue();
                Font fnt = PdfExporter.this.getFont(size);
                PdfExporter.this.updateFont(style, fnt);
                ColumnText.showTextAligned((PdfContentByte)PdfExporter.this.total, (int)0, (Phrase)new Phrase(String.valueOf(PdfExporter.this.totalPageNo), fnt), (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
    }
}

