/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.exporter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.nextreports.engine.TableExporter;
import ro.nextreports.engine.band.Band;
import ro.nextreports.engine.band.BandElement;
import ro.nextreports.engine.band.Hyperlink;
import ro.nextreports.engine.band.HyperlinkBandElement;
import ro.nextreports.engine.exporter.CellElement;
import ro.nextreports.engine.exporter.ExporterBean;
import ro.nextreports.engine.exporter.ResultExporter;
import ro.nextreports.engine.exporter.util.TableData;
import ro.nextreports.engine.i18n.I18nUtil;
import ro.nextreports.engine.queryexec.QueryException;
import ro.nextreports.engine.util.StringUtil;

public class ReportTableExporter
extends ResultExporter
implements TableExporter {
    private TableData data = new TableData();
    private boolean tableRawData;

    public ReportTableExporter(ExporterBean bean) {
        super(bean);
        this.data.setLanguage(I18nUtil.getLanguageByName(bean.getReportLayout(), bean.getLanguage()));
        this.tableRawData = bean.isReportTableExporterRawData();
    }

    @Override
    protected void exportCell(String bandName, BandElement bandElement, Object value, int gridRow, int row, int column, int cols, int rowSpan, int colSpan, boolean isImage) {
        List<Object> st;
        List<Object> rowData;
        int hRows = this.getHeaderRows();
        if (bandElement instanceof HyperlinkBandElement) {
            Hyperlink hyperlink = ((HyperlinkBandElement)bandElement).getHyperlink();
            value = hyperlink.getText();
        }
        String s = StringUtil.getValueAsString(value, this.getPattern(bandElement), I18nUtil.getLanguageByName(this.bean.getReportLayout(), this.bean.getLanguage()));
        if ("Header".equals(bandName)) {
            if (hRows == 1 || hRows == gridRow + 1) {
                this.data.getHeader().add(s);
                this.data.getPattern().add(null);
            }
            return;
        }
        if ("Detail".equals(bandName)) {
            this.data.getPattern().set(column, this.getPattern(bandElement));
        }
        Map<String, Object> style = this.buildCellStyleMap(bandElement, value, gridRow, column, colSpan);
        if (this.data.getData().size() + hRows <= this.exporterRow) {
            rowData = new ArrayList();
            this.data.getData().add(rowData);
            st = new ArrayList();
            this.data.getStyle().add(st);
        } else {
            rowData = this.data.getData().get(this.exporterRow - hRows);
            st = this.data.getStyle().get(this.exporterRow - hRows);
        }
        if (this.tableRawData) {
            rowData.add(value);
        } else {
            rowData.add(s);
        }
        st.add(style);
    }

    @Override
    protected void flush() {
        if (this.resultSetRow % 7500 == 0) {
            this.flushNow();
        }
    }

    @Override
    protected void flushNow() {
    }

    @Override
    protected void initExport() throws QueryException {
    }

    @Override
    protected void finishExport() {
    }

    @Override
    protected Set<CellElement> getIgnoredCells(Band band) {
        return new HashSet<CellElement>();
    }

    @Override
    protected void afterRowExport() {
    }

    @Override
    protected void close() {
    }

    @Override
    protected String getNullElement() {
        return "";
    }

    @Override
    public TableData getTableData() {
        return this.data;
    }
}

