/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.exporter;

import com.itextpdf.text.pdf.Barcode128;
import com.itextpdf.text.pdf.Barcode39;
import com.itextpdf.text.pdf.BarcodeCodabar;
import com.itextpdf.text.pdf.BarcodeDatamatrix;
import com.itextpdf.text.pdf.BarcodeEAN;
import com.itextpdf.text.pdf.BarcodeInter25;
import com.itextpdf.text.pdf.BarcodePDF417;
import com.itextpdf.text.pdf.BarcodeQRCode;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.event.EventListenerList;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.JexlException;
import org.apache.commons.jexl2.MapContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ro.nextreports.engine.EngineProperties;
import ro.nextreports.engine.FunctionCache;
import ro.nextreports.engine.GroupCache;
import ro.nextreports.engine.Report;
import ro.nextreports.engine.ReportGroup;
import ro.nextreports.engine.ReportLayout;
import ro.nextreports.engine.band.Band;
import ro.nextreports.engine.band.BandElement;
import ro.nextreports.engine.band.BarcodeBandElement;
import ro.nextreports.engine.band.Border;
import ro.nextreports.engine.band.ChartBandElement;
import ro.nextreports.engine.band.ColumnBandElement;
import ro.nextreports.engine.band.ExpressionBandElement;
import ro.nextreports.engine.band.ExpressionBean;
import ro.nextreports.engine.band.FieldBandElement;
import ro.nextreports.engine.band.FunctionBandElement;
import ro.nextreports.engine.band.HyperlinkBandElement;
import ro.nextreports.engine.band.ImageBandElement;
import ro.nextreports.engine.band.ImageColumnBandElement;
import ro.nextreports.engine.band.Padding;
import ro.nextreports.engine.band.ParameterBandElement;
import ro.nextreports.engine.band.RowElement;
import ro.nextreports.engine.band.VariableBandElement;
import ro.nextreports.engine.chart.Chart;
import ro.nextreports.engine.chart.ChartRunner;
import ro.nextreports.engine.condition.BandElementCondition;
import ro.nextreports.engine.condition.FormattingConditions;
import ro.nextreports.engine.condition.RowFormattingConditions;
import ro.nextreports.engine.condition.exception.ConditionalException;
import ro.nextreports.engine.exporter.Alert;
import ro.nextreports.engine.exporter.CellElement;
import ro.nextreports.engine.exporter.ExporterBean;
import ro.nextreports.engine.exporter.FirstCrossingExporter;
import ro.nextreports.engine.exporter.PdfExporter;
import ro.nextreports.engine.exporter.RtfExporter;
import ro.nextreports.engine.exporter.XlsExporter;
import ro.nextreports.engine.exporter.XlsxExporter;
import ro.nextreports.engine.exporter.event.ExporterEvent;
import ro.nextreports.engine.exporter.event.ExporterEventListener;
import ro.nextreports.engine.exporter.event.ExporterObject;
import ro.nextreports.engine.exporter.exception.NoDataFoundException;
import ro.nextreports.engine.exporter.util.function.FunctionFactory;
import ro.nextreports.engine.exporter.util.function.FunctionUtil;
import ro.nextreports.engine.exporter.util.function.GFunction;
import ro.nextreports.engine.exporter.util.variable.TotalPageNoVariable;
import ro.nextreports.engine.exporter.util.variable.Variable;
import ro.nextreports.engine.exporter.util.variable.VariableFactory;
import ro.nextreports.engine.i18n.I18nLanguage;
import ro.nextreports.engine.i18n.I18nUtil;
import ro.nextreports.engine.queryexec.IdName;
import ro.nextreports.engine.queryexec.Query;
import ro.nextreports.engine.queryexec.QueryException;
import ro.nextreports.engine.queryexec.QueryExecutor;
import ro.nextreports.engine.queryexec.QueryParameter;
import ro.nextreports.engine.queryexec.QueryResult;
import ro.nextreports.engine.util.PrefixSuffix;
import ro.nextreports.engine.util.QueryUtil;
import ro.nextreports.engine.util.ReportUtil;
import ro.nextreports.engine.util.StringUtil;

public abstract class ResultExporter {
    protected ExporterBean bean;
    protected boolean showNrCrt = false;
    public static final int PORTRAIT = 0;
    public static final int LANDSCAPE = 1;
    public static final int DEFAULT_TYPE = 0;
    public static final int ALARM_TYPE = 1;
    public static final int TABLE_TYPE = 2;
    public static final int INDICATOR_TYPE = 3;
    public static final int DISPLAY_TYPE = 4;
    public static final float A4_WIDTH = 8.27f;
    public static final float A4_HEIGHT = 11.69f;
    public static final int A4_PORTRAIT_PIXELS = (int)(8.27f * (float)ResultExporter.getDPI());
    public static final int A4_LANDSCAPE_PIXELS = (int)(11.69f * (float)ResultExporter.getDPI());
    public static final int DEFAULT_PADDING_PIXELS = (int)(0.5f * (float)ResultExporter.getDPI());
    public static final int FLUSH_ROWS = 7500;
    private Map<Long, Map<String, Object>> styleMap;
    private String title = "";
    protected final int BORDER_THIN_VALUE = 1;
    protected final int BORDER_MEDIUM_VALUE = 2;
    protected final int BORDER_THICK_VALUE = 3;
    private boolean stopExport = false;
    protected boolean isDetail;
    protected List<GroupCache> groupCache = new ArrayList<GroupCache>();
    protected List<FunctionCache> footerFunctionCache = new ArrayList<FunctionCache>();
    protected boolean newRow = false;
    protected int newRowCount = 1;
    protected int exporterRow = 0;
    protected int pageRow = 0;
    protected int headerRow = 0;
    protected int pageNo = 0;
    protected int totalPageNo = 0;
    protected VariableBandElement totalPageNoVbe;
    private boolean startNewPage = true;
    protected int resultSetRow = 0;
    private boolean start = false;
    protected int reportGroupRow = 1;
    private int barcodeIndex = 1;
    private int NO_VALUES = 30;
    private Object[] previousRow;
    private List<ExpressionBean> expressions;
    protected EventListenerList listenerList = new EventListenerList();
    private ExporterObject exporterObject = new ExporterObject(0, 0);
    protected static String IMAGE_NOT_FOUND = "<image not found>";
    protected static String IMAGE_NOT_LOADED = "<image not loaded>";
    public static String SPACE_REPLACEMENT = "_";
    private String currentBandName;
    private Map<Integer, RowElement> rowMap = null;
    protected boolean[][] modifiedStyle;
    private static Log LOG = LogFactory.getLog(ResultExporter.class);
    private JexlEngine jexl = new JexlEngine();
    private String imageChartPath;
    protected ByteArrayOutputStream subreportStream;
    protected List<Alert> alerts;
    protected Map<String, Object> templatesValues = new LinkedHashMap<String, Object>();
    private Map<String, String> groupTemplateKeys = new LinkedHashMap<String, String>();
    private Map<String, Object> groupValues = new LinkedHashMap<String, Object>();
    public static final int PRINT_DOCUMENT = 0;
    public static final int PRINT_PAGE_HEADER = 1;
    public static final int PRINT_PAGE_FOOTER = 2;

    public ResultExporter(ExporterBean bean) {
        this.bean = bean;
        this.expressions = ReportUtil.getExpressions(bean.getReportLayout());
        this.createGroupCache();
        this.modifiedStyle = new boolean[bean.getReportLayout().getRowCount()][bean.getReportLayout().getColumnCount()];
        this.totalPageNoVbe = this.getTotalPageNoVbe(bean.getReportLayout());
        this.alerts = bean.getAlerts();
        if (this.alerts == null) {
            this.alerts = new ArrayList<Alert>();
        }
    }

    public String getDocumentTitle() {
        return this.title;
    }

    public void setDocumentTitle(String title) {
        this.title = title;
    }

    public String getImageChartPath() {
        return this.imageChartPath;
    }

    public void setImageChartPath(String imageChartPath) {
        this.imageChartPath = imageChartPath;
    }

    public boolean export() throws QueryException, NoDataFoundException {
        this.start = true;
        this.testForData();
        if (this.needsFirstCrossing() && !(this instanceof FirstCrossingExporter)) {
            FirstCrossingExporter fe = new FirstCrossingExporter(this.bean);
            fe.export();
            this.templatesValues = fe.getTemplatesValues();
            this.groupTemplateKeys = fe.getGroupTemplateKeys();
        }
        this.initExport();
        this.printHeaderBand();
        if (!this.printContentBands()) {
            return false;
        }
        this.printFooterBand();
        this.finishExport();
        if (this.bean.getResult() != null && !(this instanceof FirstCrossingExporter)) {
            this.bean.getResult().close();
        }
        if (this instanceof FirstCrossingExporter) {
            try {
                this.bean.getResult().getResultSet().beforeFirst();
            }
            catch (SQLException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return true;
    }

    public OutputStream getOut() {
        return this.bean.getOut();
    }

    public void setOut(FileOutputStream out) {
        this.bean.setOut(out);
    }

    public QueryResult getResult() {
        return this.bean.getResult();
    }

    public void setResult(QueryResult result) {
        this.bean.setResult(result);
    }

    public boolean isStopExport() {
        return this.stopExport;
    }

    public void setStopExport(boolean stopExport) {
        this.stopExport = stopExport;
    }

    public Map<Long, Map<String, Object>> getStyleMap() {
        if (this.styleMap == null) {
            this.styleMap = new HashMap<Long, Map<String, Object>>();
        }
        return this.styleMap;
    }

    public void setStyleMap(Map<Long, Map<String, Object>> styleMap) {
        this.styleMap = styleMap;
    }

    public ReportLayout getReportLayout() {
        return this.bean.getReportLayout();
    }

    public void setReportLayout(ReportLayout reportLayout) {
        this.bean.setReportLayout(reportLayout);
        this.totalPageNoVbe = this.getTotalPageNoVbe(this.bean.getReportLayout());
    }

    protected Map<String, Object> buildCellStyleMap(BandElement bandElement) {
        HyperlinkBandElement hbe;
        FieldBandElement fbe;
        HashMap<String, Object> format = new HashMap<String, Object>();
        if (bandElement == null) {
            return format;
        }
        this.buildCellFont(format, bandElement.getFont());
        format.put("font_color", bandElement.getForeground());
        format.put("bg_color", bandElement.getBackground());
        this.buildCellHAllign(format, bandElement.getHorizontalAlign());
        this.buildCellVAllign(format, bandElement.getVerticalAlign());
        Padding padding = new Padding(0, 0, 0, 0);
        if (bandElement.getPadding() != null) {
            padding = bandElement.getPadding();
        }
        this.buildCellPadding(format, padding);
        format.put("border", new Float(1.0f));
        Border border = new Border(0, 0, 0, 0);
        if (bandElement.getBorder() != null) {
            border = bandElement.getBorder();
        }
        this.buildCellBorder(format, border);
        if (bandElement instanceof FieldBandElement && (fbe = (FieldBandElement)bandElement).getPattern() != null) {
            format.put("pattern", fbe.getPattern());
        }
        if (bandElement instanceof HyperlinkBandElement && (hbe = (HyperlinkBandElement)bandElement).getUrl() != null) {
            format.put("url", hbe.getUrl());
        }
        return format;
    }

    protected Map<String, Object> buildCellStyleMap(BandElement bandElement, Object value, int gridRow, int gridColumn, int colSpan) {
        return this.buildCellStyleMap(bandElement, value, gridRow, gridColumn, colSpan, true);
    }

    protected Map<String, Object> buildCellStyleMap(BandElement bandElement, Object value, int gridRow, int gridColumn, int colSpan, boolean overwriteCellRenderCond) {
        FormattingConditions renderConditions;
        RowFormattingConditions rfc;
        Map<String, Object> format = new HashMap<String, Object>();
        if (bandElement == null) {
            return format;
        }
        format = this.buildCellStyleMap(bandElement);
        RowElement rowEl = this.getRowElement(this.getReportLayout(), gridRow);
        if (rowEl != null && (rfc = rowEl.getFormattingConditions()) != null && rfc.getConditions().size() > 0) {
            try {
                Serializable rowEval = (Serializable)this.evaluateExpression("", rfc.getExpressionText(), this.currentBandName, null, null);
                RowFormattingConditions renderConditions2 = rowEl.getFormattingConditions();
                this.putFormattingConditions(format, renderConditions2, gridRow, gridColumn, rowEval, colSpan, true);
            }
            catch (QueryException e) {
                e.printStackTrace();
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (overwriteCellRenderCond && (renderConditions = bandElement.getFormattingConditions()) != null) {
            String cellExpressionText = renderConditions.getCellExpressionText();
            if (cellExpressionText == null) {
                this.putFormattingConditions(format, renderConditions, gridRow, gridColumn, (Serializable)value, colSpan, false);
            } else {
                try {
                    Serializable expEval = (Serializable)this.evaluateExpression("", cellExpressionText, this.getBand(this.getReportLayout(), gridRow).getName(), null, null);
                    this.putFormattingConditions(format, renderConditions, gridRow, gridColumn, expEval, colSpan, true);
                }
                catch (QueryException e) {
                    e.printStackTrace();
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return format;
    }

    private void putFormattingConditions(Map<String, Object> format, FormattingConditions renderConditions, int gridRow, int gridColumn, Serializable leftOperand, int colSpan, boolean rowLevel) {
        if (renderConditions != null && leftOperand != null) {
            try {
                for (BandElementCondition bec : renderConditions.getConditions()) {
                    bec.getExpression().setLeftOperand(leftOperand);
                    if (!bec.getExpression().evaluate()) continue;
                    this.modifiedStyle[gridRow][gridColumn] = true;
                    if (bec.getProperty() == 0) {
                        format.put("bg_color", bec.getPropertyValue());
                        continue;
                    }
                    if (bec.getProperty() == 1) {
                        format.put("font_color", bec.getPropertyValue());
                        continue;
                    }
                    if (bec.getProperty() == 3) {
                        Border b = (Border)bec.getPropertyValue();
                        if (rowLevel) {
                            Border rBorder = b.clone();
                            if (gridColumn == 0) {
                                rBorder.setRight(0);
                            } else if (gridColumn + colSpan - 1 == this.bean.getReportLayout().getColumnCount() - 1) {
                                rBorder.setLeft(0);
                            } else {
                                rBorder.setLeft(0);
                                rBorder.setRight(0);
                            }
                            this.buildCellBorder(format, rBorder);
                            continue;
                        }
                        this.buildCellBorder(format, b);
                        continue;
                    }
                    if (bec.getProperty() != 2) continue;
                    Font f = (Font)bec.getPropertyValue();
                    this.buildCellFont(format, f);
                }
            }
            catch (ConditionalException ex) {
                ex.printStackTrace();
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private void buildCellBorder(Map<String, Object> format, Border border) {
        if (border.getLeft() > 0) {
            format.put("border_left", new Float(border.getLeft()));
        }
        if (border.getRight() > 0) {
            format.put("border_right", new Float(border.getRight()));
        }
        if (border.getTop() > 0) {
            format.put("border_top", new Float(border.getTop()));
        }
        if (border.getBottom() > 0) {
            format.put("border_bottom", new Float(border.getBottom()));
        }
        format.put("border_left_color", border.getLeftColor());
        format.put("border_right_color", border.getRightColor());
        format.put("border_top_color", border.getTopColor());
        format.put("border_bottom_color", border.getBottomColor());
    }

    private void buildCellFont(Map<String, Object> format, Font font) {
        format.put("font_family", font.getFamily());
        format.put("font_name", font.getName());
        format.put("font_size", new Float(font.getSize()));
        if (0 == font.getStyle()) {
            format.put("font_style_key", "font_stylet_normal");
        }
        if (1 == font.getStyle()) {
            format.put("font_style_key", "font_style_bold");
        }
        if (2 == font.getStyle()) {
            format.put("font_style_key", "font_style_italic");
        }
        if (3 == font.getStyle()) {
            format.put("font_style_key", "font_style_bold_italic");
        }
    }

    private void buildCellPadding(Map<String, Object> format, Padding padding) {
        format.put("padding_left", new Float(padding.getLeft()));
        format.put("padding_right", new Float(padding.getRight()));
        format.put("padding_top", new Float(padding.getTop()));
        format.put("padding_bottom", new Float(padding.getBottom()));
    }

    private void buildCellHAllign(Map<String, Object> format, int hAllign) {
        if (0 == hAllign) {
            format.put("halign", "halign_center");
        }
        if (2 == hAllign) {
            format.put("halign", "halign_left");
        }
        if (4 == hAllign) {
            format.put("halign", "halign_right");
        }
    }

    private void buildCellVAllign(Map<String, Object> format, int vAllign) {
        if (0 == vAllign) {
            format.put("valign", "valign_middle");
        }
        if (1 == vAllign) {
            format.put("valign", "valign_top");
        }
        if (3 == vAllign) {
            format.put("valign", "valign_bottom");
        }
    }

    protected boolean hasRenderConditions(BandElement be, Object value) {
        if (be == null) {
            return false;
        }
        FormattingConditions rc = be.getFormattingConditions();
        return value != null && rc != null && rc.getConditions().size() > 0;
    }

    protected boolean hasRowRenderConditions(BandElement be, int gridRow, Object value) {
        if (be == null) {
            return false;
        }
        RowElement row = this.getRowElement(this.getReportLayout(), gridRow);
        if (row != null) {
            RowFormattingConditions rfc = row.getFormattingConditions();
            return value != null && rfc != null && rfc.getConditions().size() > 0;
        }
        return false;
    }

    protected Set<CellElement> getIgnoredCellElements(Band band) {
        HashSet<CellElement> result = new HashSet<CellElement>();
        int rows = band.getRowCount();
        int cols = band.getColumnCount();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                int k;
                BandElement element = band.getElementAt(i, j);
                if (element == null) continue;
                int rowSpan = element.getRowSpan();
                int colSpan = element.getColSpan();
                if (rowSpan > 1 && colSpan > 1) {
                    for (k = 0; k < rowSpan; ++k) {
                        for (int m = 0; m < colSpan; ++m) {
                            if (k == 0 && m == 0) continue;
                            result.add(new CellElement(i + k, j + m));
                        }
                    }
                    continue;
                }
                if (rowSpan > 1) {
                    for (k = 1; k < rowSpan; ++k) {
                        result.add(new CellElement(i + k, j));
                    }
                    continue;
                }
                if (colSpan <= 1) continue;
                for (k = 1; k < colSpan; ++k) {
                    result.add(new CellElement(i, j + k));
                }
            }
        }
        return result;
    }

    protected Set<CellElement> getIgnoredCellElementsForColSpan(Band band) {
        HashSet<CellElement> result = new HashSet<CellElement>();
        int rows = band.getRowCount();
        int cols = band.getColumnCount();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                int colSpan;
                BandElement element = band.getElementAt(i, j);
                if (element == null || (colSpan = element.getColSpan()) <= 1) continue;
                for (int k = 1; k < colSpan; ++k) {
                    result.add(new CellElement(i, j + k));
                }
            }
        }
        return result;
    }

    protected int getColumnWidth(int column, int colSpan) {
        int width = this.bean.getReportLayout().getColumnsWidth().get(column);
        for (int i = column + 1; i < column + colSpan; ++i) {
            width += this.bean.getReportLayout().getColumnsWidth().get(i).intValue();
        }
        return width;
    }

    private boolean findIgnoredCellElement(Set<CellElement> ignored, int i, int j) {
        return ignored.contains(new CellElement(i, j));
    }

    private void createGroupCache() {
        List<ReportGroup> groups = this.bean.getReportLayout().getGroups();
        if (groups == null) {
            groups = new ArrayList<ReportGroup>();
        }
        Collections.sort(groups, new Comparator<ReportGroup>(){

            @Override
            public int compare(ReportGroup o1, ReportGroup o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (ReportGroup reportGroup : groups) {
            GroupCache gc = new GroupCache();
            gc.setGroup(reportGroup);
            gc.setStart(true);
            gc.setHgBand(this.bean.getReportLayout().getBand("Group_Header" + reportGroup.getName()));
            Band fgBand = this.bean.getReportLayout().getBand("Group_Footer" + reportGroup.getName());
            gc.setFgBand(fgBand);
            ArrayList<FunctionCache> functionCache = new ArrayList<FunctionCache>();
            for (int i = 0; i < fgBand.getRowCount(); ++i) {
                for (int j = 0; j < fgBand.getColumnCount(); ++j) {
                    BandElement be = fgBand.getElementAt(i, j);
                    if (!(be instanceof FunctionBandElement)) continue;
                    FunctionBandElement fbe = (FunctionBandElement)be;
                    FunctionCache fc = new FunctionCache();
                    GFunction gFunction = FunctionFactory.getFunction(fbe.getFunction());
                    fc.setFunction(gFunction);
                    fc.setFunctionColumn(fbe.getColumn());
                    fc.setExpression(fbe.isExpression());
                    functionCache.add(fc);
                }
            }
            gc.setFuncCache(functionCache);
            this.groupCache.add(gc);
        }
        Band fBand = this.bean.getReportLayout().getBand("Footer");
        for (int i = 0; i < fBand.getRowCount(); ++i) {
            for (int j = 0; j < fBand.getColumnCount(); ++j) {
                BandElement be = fBand.getElementAt(i, j);
                if (!(be instanceof FunctionBandElement)) continue;
                FunctionBandElement fbe = (FunctionBandElement)be;
                FunctionCache fc = new FunctionCache();
                GFunction gFunction = FunctionFactory.getFunction(fbe.getFunction());
                fc.setFunction(gFunction);
                fc.setFunctionColumn(fbe.getColumn());
                fc.setExpression(fbe.isExpression());
                this.footerFunctionCache.add(fc);
            }
        }
    }

    private void resetFunctions(GroupCache gc) {
        for (FunctionCache fc : gc.getFuncCache()) {
            GFunction gFunction = fc.getFunction();
            gFunction.reset();
        }
    }

    protected String getPattern(BandElement be) {
        FieldBandElement fbe;
        if (be instanceof FieldBandElement && (fbe = (FieldBandElement)be).getPattern() != null) {
            return fbe.getPattern();
        }
        return null;
    }

    protected String getUrl(BandElement be) {
        HyperlinkBandElement hbe;
        if (be instanceof HyperlinkBandElement && (hbe = (HyperlinkBandElement)be).getUrl() != null) {
            return hbe.getUrl();
        }
        return null;
    }

    private void testForData() throws QueryException, NoDataFoundException {
        if (this.getOut() == null || this.getResult() == null || this.getResult().getColumnCount() <= 0 || this.getResult().getRowCount() == 0 || this.getResult().isEmpty()) {
            throw new NoDataFoundException();
        }
    }

    protected PrintStream createPrintStream() throws QueryException {
        try {
            PrintStream p;
            if (this.bean.isSubreport()) {
                this.subreportStream = new ByteArrayOutputStream();
                p = new PrintStream((OutputStream)this.subreportStream, false, "UTF-8");
            } else {
                p = new PrintStream(this.getOut(), false, "UTF-8");
            }
            return p;
        }
        catch (UnsupportedEncodingException e) {
            throw new QueryException(e);
        }
    }

    private String getStringValue(VariableBandElement bandElement, String bandName) {
        String pattern = this.getPattern(bandElement);
        Variable var = VariableFactory.getVariable(bandElement.getVariable());
        Object value = this.getValue(var, bandName);
        return StringUtil.getValueAsString(value, pattern);
    }

    private Object getValue(Variable var, String bandName) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if ("ROW".equals(var.getName())) {
            parameters.put("ROW", this.resultSetRow + 1);
        } else if ("GROUP_ROW".equals(var.getName())) {
            int groupRow = this.reportGroupRow;
            if (this.groupCache.size() == 0) {
                groupRow = this.resultSetRow + 1;
            } else {
                GroupCache gc = this.getOutterGroupCache(bandName);
                if (gc != null) {
                    groupRow = gc.getGroupRow();
                }
                if (bandName.startsWith("Group_Footer")) {
                    --groupRow;
                } else if (bandName.equals("Footer")) {
                    groupRow = 1;
                }
            }
            parameters.put("GROUP_ROW", groupRow);
        } else if ("PAGE_NO".equals(var.getName())) {
            parameters.put("PAGE_NO", this.getPageNo());
        } else if ("TOTAL_PAGE_NO".equals(var.getName())) {
            parameters.put("TOTAL_PAGE_NO", this.getTotalPageNo());
        } else if ("REPORT_NAME".equals(var.getName())) {
            parameters.put("REPORT_NAME", this.bean.getFileName());
        }
        return var.getCurrentValue(parameters);
    }

    private String getStringValue(ParameterBandElement bandElement) {
        String name = bandElement.getParameter();
        QueryParameter qp = this.bean.getParametersBean().getParams().get(name);
        Object object = this.bean.getParametersBean().getParamValues().get(name);
        if (qp == null) {
            return "";
        }
        if ("Multiple".equals(qp.getSelection())) {
            Object[] values = (Object[])object;
            if (values == null || values.length == 0) {
                return this.getNullElement();
            }
            StringBuilder sb = new StringBuilder();
            int size = values.length;
            for (int i = 0; i < size; ++i) {
                sb.append(StringUtil.getValueAsString(values[i], bandElement.getPattern()));
                if (i < size - 1) {
                    sb.append(" ; ");
                }
                if (i != this.NO_VALUES - 1) continue;
                if (i >= size - 1) break;
                sb.append(" ...");
                break;
            }
            return sb.toString();
        }
        return StringUtil.getValueAsString(object, bandElement.getPattern(), null, qp.getValueClassName());
    }

    private boolean printContentBands() throws QueryException, NoDataFoundException {
        int i;
        int cols = this.getResult().getColumnCount();
        List<String> expNames = ReportUtil.getExpressionsNames(this.bean.getReportLayout());
        int expNo = expNames.size();
        this.previousRow = new Object[cols + expNo];
        int k = 0;
        boolean isEmpty = true;
        while (this.getResult().hasNext()) {
            isEmpty = false;
            if (Thread.currentThread().isInterrupted() || this.isStopExport()) {
                this.close();
                this.setStopExport(false);
                return false;
            }
            if (++k == EngineProperties.getRecordsYield()) {
                k = 0;
                try {
                    Thread.sleep(EngineProperties.getMillisYield());
                }
                catch (InterruptedException e) {
                    this.close();
                    this.setStopExport(false);
                    return false;
                }
            }
            this.flush();
            if (this.bean.isRawPrint()) {
                this.printRawRecord();
            } else {
                if (this.resultSetRow > 0) {
                    this.printFooterGroupBands();
                }
                this.printHeaderGroupBands();
                this.printDetailBand();
            }
            ++this.resultSetRow;
            this.exporterObject.setRecord(this.resultSetRow);
            this.exporterObject.setRecordCount(this.bean.getResult().getRowCount());
            this.fireExporterEvent(new ExporterEvent(this.exporterObject));
            this.afterRowExport();
            for (i = 0; i < cols; ++i) {
                this.previousRow[i] = this.getResult().nextValue(i);
            }
            for (i = cols; i < cols + expNo; ++i) {
                this.previousRow[i] = this.evaluateExpression(this.expressions.get(i - cols), null);
            }
        }
        if (isEmpty) {
            throw new NoDataFoundException();
        }
        for (i = this.groupCache.size() - 1; i >= 0; --i) {
            GroupCache gc = this.groupCache.get(i);
            if (!gc.footerHasRows()) continue;
            this.printFooterGroupBand(gc, true);
        }
        return true;
    }

    private void printHeaderGroupBands() throws QueryException {
        for (GroupCache gc : this.groupCache) {
            if (!gc.isStart()) continue;
            this.groupStarted(gc);
        }
    }

    private void groupStarted(GroupCache gc) throws QueryException {
        this.groupValues.put("G" + gc.getGroup().getName(), this.getResult().nextValue(gc.getGroup().getColumn()));
        this.resetFunctions(gc);
        for (FunctionCache fc : gc.getFuncCache()) {
            String column = fc.getFunctionColumn();
            Object value = fc.isExpression() ? this.evaluateExpression(this.getExpressionBandElement(fc.getFunctionColumn()), this.currentBandName, gc) : this.getResult().nextValue(column);
            fc.getFunction().compute(value);
        }
        if (gc.headerHasRows()) {
            this.printHeaderGroupBand(gc);
        }
        gc.setStart(false);
        GroupCache outter = this.getOutterGroupCache(gc);
        if (outter == null) {
            ++this.reportGroupRow;
        } else {
            outter.incrementGroupRow();
        }
        gc.incrementGroupRow();
    }

    private boolean isGroupFinished(int groupIndex) throws QueryException {
        GroupCache gc = this.groupCache.get(groupIndex);
        String column = gc.getGroup().getColumn();
        Object value = this.resultSetRow == 0 ? this.getResult().nextValue(column) : this.previousRow[this.getResult().getColumnIndex(column)];
        Object newValue = this.getResult().nextValue(column);
        boolean equals = FunctionUtil.parameterEquals(value, newValue);
        return !equals;
    }

    private boolean isPreviousGroupFinished(int groupIndex) throws QueryException {
        for (int i = groupIndex; i >= 0; --i) {
            if (!this.isGroupFinished(i)) continue;
            return true;
        }
        return false;
    }

    private void printFooterGroupBands() throws QueryException {
        for (int i = this.groupCache.size() - 1; i >= 0; --i) {
            GroupCache gc = this.groupCache.get(i);
            if (!this.isGroupFinished(i)) {
                if (i > 0 && this.isPreviousGroupFinished(i - 1)) {
                    this.groupFinished(gc);
                    continue;
                }
                for (FunctionCache fc : gc.getFuncCache()) {
                    Object nv = fc.isExpression() ? this.evaluateExpression(this.getExpressionBandElement(fc.getFunctionColumn()), this.currentBandName, gc) : this.getResult().nextValue(fc.getFunctionColumn());
                    fc.getFunction().compute(nv);
                }
                if (!gc.getGroup().equals(this.getGroupCache(this.currentBandName).getGroup())) continue;
                gc.incrementGroupRow();
                continue;
            }
            this.groupFinished(gc);
        }
    }

    private void groupFinished(GroupCache gc) throws QueryException {
        if (gc.footerHasRows()) {
            this.printFooterGroupBand(gc);
        }
        gc.setStart(true);
        if (gc.getGroup().isNewPageAfter()) {
            this.createNewPage();
        }
        gc.resetGroupRow();
    }

    protected void printHeaderBand() throws QueryException {
        this.printBand(null, this.getReportLayout().getHeaderBand(), false);
    }

    private void printFooterBand() throws QueryException {
        this.printBand(null, this.getReportLayout().getFooterBand(), false);
    }

    protected void printPageHeaderBand() throws QueryException {
        this.printBand(null, this.getReportLayout().getPageHeaderBand(), false);
    }

    protected void printPageFooterBand() throws QueryException {
        this.printBand(null, this.getReportLayout().getPageFooterBand(), false);
    }

    private void printDetailBand() throws QueryException {
        this.printBand(null, null, false);
    }

    private void printHeaderGroupBand(GroupCache gc) throws QueryException {
        this.printBand(gc, null, false);
    }

    private void printFooterGroupBand(GroupCache gc) throws QueryException {
        this.printBand(gc, null, true, true);
    }

    private void printFooterGroupBand(GroupCache gc, boolean usePrevious) throws QueryException {
        this.printBand(gc, null, true, usePrevious);
    }

    private void printBand(GroupCache gc, Band staticBand, boolean hasFunction) throws QueryException {
        this.printBand(gc, staticBand, hasFunction, false);
    }

    private void printBand(GroupCache gc, Band staticBand, boolean hasFunction, boolean usePrevious) throws QueryException {
        Band band;
        List<FunctionCache> fCache = null;
        this.isDetail = false;
        boolean isPageHeaderFooter = false;
        if (gc == null) {
            if (staticBand != null) {
                band = staticBand;
                if ("PageHeader".equals(band.getName()) || "PageFooter".equals(band.getName())) {
                    isPageHeaderFooter = true;
                }
            } else {
                this.isDetail = true;
                band = this.getReportLayout().getDetailBand();
            }
        } else {
            fCache = gc.getFuncCache();
            band = hasFunction ? gc.getFgBand() : gc.getHgBand();
        }
        this.currentBandName = band.getName();
        int rows = band.getRowCount();
        int cols = band.getColumnCount();
        Set<CellElement> ignored = this.getIgnoredCells(band);
        int lastRow = -1;
        for (int i = 0; i < rows; ++i) {
            BandElement bandElement;
            int j;
            boolean[] hide = new boolean[cols];
            boolean hideAll = false;
            int count = 0;
            boolean rowWithHideExpression = false;
            for (j = 0; j < cols; ++j) {
                bandElement = band.getElementAt(i, j);
                if (bandElement == null || bandElement.getHideWhenExpression() == null) continue;
                rowWithHideExpression = true;
            }
            if (rowWithHideExpression) {
                for (j = 0; j < cols; ++j) {
                    bandElement = band.getElementAt(i, j);
                    if (bandElement != null && bandElement.getHideWhenExpression() != null) {
                        String expression = bandElement.getHideWhenExpression();
                        Boolean result = (Boolean)this.evaluateExpression("", expression, this.currentBandName, null, gc);
                        hide[j] = result;
                    } else {
                        boolean bl = hide[j] = bandElement == null || "".equals(bandElement.getText());
                    }
                    if (!hide[j]) continue;
                    ++count;
                }
                if (count == cols) {
                    hideAll = true;
                }
            }
            for (j = 0; j < cols; ++j) {
                if (this.findIgnoredCellElement(ignored, i, j)) continue;
                this.newRow = i > lastRow;
                bandElement = band.getElementAt(i, j);
                if (bandElement != null) {
                    this.newRowCount = Math.max(this.newRowCount, bandElement.getRowSpan());
                }
                if (this.newRow) {
                    int gridRow = this.getReportLayout().getGridRow(band.getName(), i);
                    RowElement re = this.getRowElement(this.getReportLayout(), gridRow);
                    if (re.isStartOnNewPage() && !this.start) {
                        if (!this.startNewPage) {
                            if (this.pageRow - this.headerRow > 0) {
                                this.createNewPage();
                            }
                        } else {
                            if (!"Group_Header1".equals(band.getName())) {
                                this.createNewPage();
                            }
                            this.startNewPage = false;
                        }
                    }
                }
                Object value = this.getBandElementValue(fCache, gc, staticBand, hasFunction, usePrevious, bandElement);
                if (!hideAll && hide[j]) {
                    value = null;
                }
                int rowSpan = 1;
                int colSpan = 1;
                if (bandElement != null) {
                    rowSpan = bandElement.getRowSpan();
                    colSpan = bandElement.getColSpan();
                }
                int gridRow = this.getReportLayout().getGridRow(band.getName(), i);
                boolean isImage = bandElement instanceof ImageBandElement;
                if (!this.bean.isSubreport() && this.isDetail) {
                    Map<String, QueryParameter> params = this.bean.getParametersBean().getSubreportParams();
                    if (params.size() == 0) {
                        List<Report> subreports = ReportUtil.getDetailSubreports(this.bean.getReportLayout());
                        for (Report subreport : subreports) {
                            this.bean.getParametersBean().addNotFoundSubreportParameters(subreport.getParameters());
                        }
                        List<Chart> charts = ReportUtil.getDetailCharts(this.bean.getReportLayout());
                        for (Chart chart : charts) {
                            this.bean.getParametersBean().addNotFoundSubreportParameters(chart.getReport().getParameters());
                        }
                    }
                    for (QueryParameter qp : params.values()) {
                        Object pValue = this.getResult().nextValue(qp.getName());
                        this.bean.getParametersBean().setParameterValue(qp.getName(), pValue);
                    }
                }
                if (!hideAll) {
                    this.exportCell(band.getName(), bandElement, value, gridRow, i, j, cols, rowSpan, colSpan, isImage);
                }
                lastRow = i;
                if (!this.newRow) continue;
                this.newRowCount = 1;
            }
            if (isPageHeaderFooter) continue;
            ++this.exporterRow;
            if (!hideAll) {
                if ("Header".equals(band.getName())) {
                    ++this.headerRow;
                }
                ++this.pageRow;
            }
            this.start = false;
        }
    }

    private Object getBandElementValue(List<FunctionCache> fCache, GroupCache gc, Band staticBand, boolean hasFunction, boolean usePrevious, BandElement bandElement) throws QueryException {
        Object value = null;
        String column = null;
        if (bandElement instanceof ColumnBandElement) {
            if (staticBand == null) {
                column = ((ColumnBandElement)bandElement).getColumn();
                value = usePrevious ? this.previousRow[this.getResult().getColumnIndex(column)] : (bandElement instanceof ImageColumnBandElement ? this.getResult().nextBlobValue(column) : this.getResult().nextValue(column));
                for (FunctionCache fc : this.footerFunctionCache) {
                    if (fc.isExpression() || !fc.getFunctionColumn().equals(column)) continue;
                    fc.getFunction().compute(value);
                }
                if (gc == null && !hasFunction && value != null && bandElement != null && bandElement.isRepeatedValue() && value.equals(this.previousRow[this.getResult().getColumnIndex(column)])) {
                    value = null;
                }
            } else {
                value = this.getStringValue(bandElement, null);
            }
        } else if (bandElement instanceof ExpressionBandElement) {
            if (staticBand == null) {
                value = usePrevious ? this.previousRow[this.getExpressionBandElementIndex((ExpressionBandElement)bandElement)] : this.evaluateExpression((ExpressionBandElement)bandElement, this.currentBandName, gc);
                for (FunctionCache fc : this.footerFunctionCache) {
                    if (!fc.isExpression() || !fc.getFunctionColumn().equals(((ExpressionBandElement)bandElement).getExpressionName())) continue;
                    fc.getFunction().compute(value);
                }
                if (gc == null && !hasFunction && value != null && bandElement != null && bandElement.isRepeatedValue() && value.equals(this.previousRow[this.getExpressionBandElementIndex((ExpressionBandElement)bandElement)])) {
                    value = null;
                }
            } else {
                value = this.evaluateExpression((ExpressionBandElement)bandElement, this.currentBandName, gc);
            }
        } else if (bandElement instanceof FunctionBandElement) {
            FunctionBandElement fbe = (FunctionBandElement)bandElement;
            if (staticBand != null) {
                for (FunctionCache fc : this.footerFunctionCache) {
                    if (!fc.getFunction().getName().equals(fbe.getFunction()) || !fc.getFunctionColumn().equals(fbe.getColumn())) continue;
                    value = fc.getFunction().getComputedValue();
                    if (!this.needsFirstCrossing()) break;
                    if (this instanceof FirstCrossingExporter) {
                        if (ReportUtil.foundFunctionInHeader(this.bean.getReportLayout())) {
                            this.templatesValues.put(this.getFunctionTemplate(gc, fbe, true), value);
                        }
                    } else {
                        value = this.getFunctionTemplate(gc, fbe, false);
                        if (this.templatesValues.containsKey(value)) {
                            value = this.templatesValues.get(value);
                        }
                    }
                    break;
                }
            } else if (hasFunction) {
                for (FunctionCache fc : fCache) {
                    if (!fc.getFunction().getName().equals(fbe.getFunction()) || !fc.getFunctionColumn().equals(fbe.getColumn())) continue;
                    value = fc.getFunction().getComputedValue();
                    if (this instanceof FirstCrossingExporter && ReportUtil.foundFunctionInGroupHeader(this.bean.getReportLayout(), gc.getGroup().getName())) {
                        this.templatesValues.put(this.getFunctionTemplate(gc, fbe, true), value);
                    }
                    break;
                }
            } else if (this instanceof FirstCrossingExporter) {
                value = this.getFunctionTemplate(gc, fbe, true);
            } else {
                value = this.getFunctionTemplate(gc, fbe, false);
                if (this.templatesValues.containsKey(value)) {
                    value = this.templatesValues.get(value);
                }
            }
        } else if (bandElement instanceof ImageBandElement) {
            if (bandElement instanceof ChartBandElement) {
                this.generateChartImage((ChartBandElement)bandElement);
            } else if (bandElement instanceof BarcodeBandElement) {
                this.generateBarcodeImage((BarcodeBandElement)bandElement);
            }
            value = ((ImageBandElement)bandElement).getImage();
        } else {
            value = bandElement instanceof VariableBandElement ? this.getStringValue((VariableBandElement)bandElement, this.currentBandName) : (bandElement instanceof ParameterBandElement ? this.getStringValue((ParameterBandElement)bandElement) : this.getStringValue(bandElement, null));
        }
        return value;
    }

    protected String getBandElementValueAsString(BandElement bandElement) {
        String pattern = this.getPattern(bandElement);
        if (bandElement instanceof ExpressionBandElement) {
            Object value = null;
            try {
                value = this.evaluateExpression((ExpressionBandElement)bandElement, this.currentBandName, null);
            }
            catch (QueryException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            I18nLanguage lang = I18nUtil.getLanguageByName(this.bean.getReportLayout(), this.bean.getLanguage());
            return StringUtil.getValueAsString(value, pattern, lang);
        }
        if (bandElement instanceof VariableBandElement) {
            return this.getStringValue((VariableBandElement)bandElement, this.currentBandName);
        }
        return this.getStringValue(bandElement, pattern);
    }

    protected Object evaluateExpression(ExpressionBean bean, GroupCache gc) throws QueryException {
        return this.evaluateExpression(bean.getBandElement().getExpressionName(), bean.getBandElement().getExpression(), bean.getBandName(), bean.getBandElement().getPattern(), gc);
    }

    protected Object evaluateExpression(ExpressionBandElement bandElement, String bandName, GroupCache gc) throws QueryException {
        return this.evaluateExpression(bandElement.getExpressionName(), bandElement.getExpression(), bandName, bandElement.getPattern(), gc);
    }

    private Object evaluateExpression(String expressionName, String expression, String bandName, String pattern, GroupCache gc) throws QueryException {
        Object value = null;
        Expression e = this.jexl.createExpression(expression);
        MapContext checkContext = new MapContext();
        for (Variable var : VariableFactory.getVariables()) {
            if ((this instanceof RtfExporter || this instanceof XlsExporter || this instanceof XlsxExporter) && "PAGE_NO".equals(var.getName())) {
                checkContext.set("$V_" + var.getName(), (Object)("$V_" + var.getName()));
                continue;
            }
            if (this instanceof PdfExporter && "TOTAL_PAGE_NO".equals(var.getName())) {
                checkContext.set("$V_" + var.getName(), (Object)("$V_" + var.getName()));
                continue;
            }
            checkContext.set("$V_" + var.getName(), this.getValue(var, bandName));
        }
        for (String paramName : this.bean.getParametersBean().getParamValues().keySet()) {
            Object obj = this.bean.getParametersBean().getParamValues().get(paramName);
            if (obj instanceof IdName) {
                obj = ((IdName)obj).toString();
            }
            checkContext.set("$P_" + paramName, obj);
        }
        if (expression.contains("$C")) {
            int size = this.getResult().getColumnCount();
            for (int k = 0; k < size; ++k) {
                String columnName = this.getResult().getColumnName(k);
                String col = columnName.replaceAll("\\s", SPACE_REPLACEMENT);
                checkContext.set("$C_" + col, this.getResult().nextValue(columnName));
            }
        }
        if (expression.contains("$F")) {
            for (String f : this.bean.getReportLayout().getFunctions()) {
                FunctionCache fc = this.findFunctionCache(f, bandName);
                Double fv = new Double(0.0);
                if (fc != null) {
                    fv = (Double)fc.getFunction().getComputedValue();
                }
                checkContext.set("$F_" + f, (Object)fv);
            }
            if (this.needsFirstCrossing() && !(this instanceof FirstCrossingExporter)) {
                for (FunctionBandElement fbe : ReportUtil.getFunctionsFromExpression(expression)) {
                    value = this.getFunctionTemplate(gc, fbe, false);
                    String template = (String)value;
                    if (this.templatesValues.containsKey(value)) {
                        value = this.templatesValues.get(value);
                    }
                    checkContext.set("$F_" + fbe.getFunction() + "_" + fbe.getColumn(), value);
                }
            }
        }
        try {
            value = e.evaluate((JexlContext)checkContext);
            if (value instanceof String) {
                I18nLanguage lang = I18nUtil.getLanguageByName(this.bean.getReportLayout(), this.bean.getLanguage());
                value = StringUtil.getI18nString((String)value, lang);
            }
        }
        catch (JexlException ex) {
            ex.printStackTrace();
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return value;
    }

    private FunctionCache findFunctionCache(String fexp, String bandName) {
        if (bandName.startsWith("Group_Footer")) {
            for (GroupCache gc : this.groupCache) {
                FunctionCache fc;
                if (!gc.getFgBand().getName().equals(bandName) || (fc = this.findFunctionCache(gc.getFuncCache(), fexp, bandName)) == null) continue;
                return fc;
            }
        } else {
            FunctionCache fc = this.findFunctionCache(this.footerFunctionCache, fexp, bandName);
            if (fc != null) {
                return fc;
            }
        }
        return null;
    }

    private FunctionCache findFunctionCache(List<FunctionCache> list, String fexp, String bandName) {
        for (FunctionCache fc : list) {
            String exp = fc.getFunction().getName() + "_" + fc.getFunctionColumn();
            if (!exp.equals(fexp)) continue;
            return fc;
        }
        return null;
    }

    private String getStringValue(BandElement bandElement, String pattern) {
        if (bandElement == null || bandElement.getText().trim().length() == 0) {
            return this.getNullElement();
        }
        I18nLanguage lang = I18nUtil.getLanguageByName(this.bean.getReportLayout(), this.bean.getLanguage());
        return StringUtil.getValueAsString(StringUtil.getI18nString(bandElement.getText(), lang), pattern);
    }

    protected abstract String getNullElement();

    protected abstract Set<CellElement> getIgnoredCells(Band var1);

    protected abstract void exportCell(String var1, BandElement var2, Object var3, int var4, int var5, int var6, int var7, int var8, int var9, boolean var10);

    protected abstract void afterRowExport();

    protected abstract void close();

    protected abstract void flush();

    protected abstract void flushNow();

    protected abstract void initExport() throws QueryException;

    protected abstract void finishExport();

    protected static int getDPI() {
        return GraphicsEnvironment.isHeadless() ? 96 : Toolkit.getDefaultToolkit().getScreenResolution();
    }

    public void addExporterEventListener(ExporterEventListener listener) {
        this.listenerList.add(ExporterEventListener.class, listener);
    }

    public void removeExporterEventListener(ExporterEventListener listener) {
        this.listenerList.remove(ExporterEventListener.class, listener);
    }

    void fireExporterEvent(ExporterEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ExporterEventListener.class) continue;
            ((ExporterEventListener)listeners[i + 1]).notify(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getImage(String image) throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/" + image);
        if (is == null) {
            LOG.error((Object)("Image '" + image + "' not found in classpath."));
            throw new IOException("Image '" + image + "' not found.");
        }
        ByteArrayOutputStream img_bytes = new ByteArrayOutputStream();
        try {
            int b;
            while ((b = is.read()) != -1) {
                img_bytes.write(b);
            }
        }
        finally {
            is.close();
        }
        return img_bytes.toByteArray();
    }

    protected int[] getRealImageSize(String image) {
        InputStream is = this.getClass().getResourceAsStream("/" + image);
        int[] result = new int[2];
        try {
            BufferedImage img = ImageIO.read(is);
            result[0] = img.getWidth();
            result[1] = img.getHeight();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    protected int[] getRealImageSize(byte[] image) {
        ByteArrayInputStream is = new ByteArrayInputStream(image);
        int[] result = new int[2];
        try {
            BufferedImage img = ImageIO.read(is);
            result[0] = img.getWidth();
            result[1] = img.getHeight();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    protected byte[] getScaledImage(String image, int width, int height) throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/" + image);
        if (is == null) {
            throw new IOException("Image '" + image + "' not found.");
        }
        return this.getScaledImage(is, image, width, height);
    }

    protected byte[] getScaledImage(byte[] image, int width, int height) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(image);
        return this.getScaledImage(is, " from db ", width, height);
    }

    protected byte[] getScaledImage(InputStream is, String name, int width, int height) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            BufferedImage img = ImageIO.read(is);
            if (img.getWidth() == width && img.getHeight() == height) {
                ImageIO.write((RenderedImage)img, "png", baos);
            } else {
                int type = img.getType() == 0 ? 2 : img.getType();
                BufferedImage scaledImg = new BufferedImage(width, height, type);
                Graphics2D gScaledImg = scaledImg.createGraphics();
                gScaledImg.setComposite(AlphaComposite.Src);
                gScaledImg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                gScaledImg.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                gScaledImg.drawImage(img, 0, 0, width, height, null);
                ImageIO.write((RenderedImage)scaledImg, "png", baos);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
            throw new IOException("Image '" + name + "' could not be scaled.");
        }
        finally {
            is.close();
        }
        return baos.toByteArray();
    }

    protected byte[] getImage(String image, Integer width, Integer height) throws IOException {
        byte[] imageBytes = width == null || width == 0 || height == null || height == 0 ? this.getImage(image) : this.getScaledImage(image, (int)width, (int)height);
        return imageBytes;
    }

    protected byte[] getImage(byte[] image, Integer width, Integer height) throws IOException {
        byte[] imageBytes = width == null || width == 0 || height == null || height == 0 ? image : this.getScaledImage(image, (int)width, (int)height);
        return imageBytes;
    }

    protected void printRawRecord() throws QueryException {
    }

    private void createNewPage() {
        this.pageRow = 0;
        this.headerRow = 0;
        this.newPage();
    }

    protected void newPage() {
    }

    protected int getPageNo() {
        return this.pageNo + 1;
    }

    protected int getTotalPageNo() {
        return this.totalPageNo;
    }

    protected int getHeaderRows() {
        return this.bean.getReportLayout().getBand("Header").getRowCount();
    }

    protected int getDetailRows() {
        return this.bean.getReportLayout().getBand("Detail").getRowCount();
    }

    protected int getFooterRows() {
        return this.bean.getReportLayout().getBand("Footer").getRowCount();
    }

    protected int getRowsCount() {
        int recordRows = this.getResult().getRowCount();
        if (recordRows == -1) {
            throw new UnsupportedOperationException("Must use true value for computeCount inside QueryExecutor in order to get rows count!");
        }
        return this.getHeaderRows() + this.getDetailRows() * recordRows + this.getFooterRows();
    }

    private ExpressionBandElement getExpressionBandElement(String name) {
        for (ExpressionBean bean : this.expressions) {
            ExpressionBandElement ebe = bean.getBandElement();
            if (!ebe.getExpressionName().equals(name)) continue;
            return ebe;
        }
        return null;
    }

    private int getExpressionBandElementIndex(ExpressionBandElement bandElement) {
        int size = this.expressions.size();
        for (int i = 0; i < size; ++i) {
            ExpressionBandElement ebe = this.expressions.get(i).getBandElement();
            if (!bandElement.getExpressionName().equals(ebe.getExpressionName())) continue;
            return i + this.getResult().getColumnCount();
        }
        return -1;
    }

    private int getGroupIndex(String bandName) {
        int groupIndex = -1;
        if (bandName.startsWith("Group_Header")) {
            groupIndex = Integer.parseInt(bandName.substring("Group_Header".length()));
        } else if (bandName.startsWith("Group_Footer")) {
            groupIndex = Integer.parseInt(bandName.substring("Group_Footer".length()));
        } else if ("Detail".equals(bandName) && this.groupCache.size() > 0) {
            groupIndex = this.groupCache.size();
        }
        return groupIndex;
    }

    private GroupCache getGroupCache(String bandName) {
        int groupIndex = this.getGroupIndex(bandName);
        GroupCache group = null;
        if (groupIndex != -1) {
            group = this.groupCache.get(groupIndex - 1);
        }
        return group;
    }

    private GroupCache getOutterGroupCache(String bandName) {
        int groupIndex = this.getGroupIndex(bandName);
        if (ReportUtil.isGroupBand(bandName)) {
            if (groupIndex > 1) {
                --groupIndex;
            } else if (groupIndex == 1) {
                groupIndex = -1;
            }
        }
        GroupCache group = null;
        if (groupIndex != -1) {
            group = this.groupCache.get(groupIndex - 1);
        }
        return group;
    }

    private GroupCache getOutterGroupCache(GroupCache gc) {
        int size = this.groupCache.size();
        for (int i = 0; i < size; ++i) {
            GroupCache outerGc = this.groupCache.get(i);
            if (!gc.getGroup().equals(outerGc.getGroup()) || i <= 0) continue;
            return this.groupCache.get(i - 1);
        }
        return null;
    }

    private void generateChartImage(ChartBandElement bandElement) {
        if (this.bean.getConnection() == null) {
            return;
        }
        String image = null;
        Chart chart = bandElement.getChart();
        ChartRunner runner = new ChartRunner();
        runner.setFormat("IMAGE");
        runner.setChart(chart);
        runner.setConnection(this.bean.getConnection());
        runner.setQueryTimeout(this.bean.getQueryTimeout());
        this.bean.getParametersBean().addSubreportParameters(chart.getReport().getParameters());
        runner.setParameterValues(this.bean.getParametersBean().getParamValues());
        runner.setImagePath(this.imageChartPath);
        I18nLanguage lang = I18nUtil.getLanguageByName(this.bean.getReportLayout(), this.bean.getLanguage());
        if (lang != null) {
            runner.setLanguage(lang.getName());
        }
        int width = bandElement.getWidth() == null ? 0 : bandElement.getWidth();
        int height = bandElement.getHeight() == null ? 0 : bandElement.getHeight();
        runner.setImageWidth(width);
        runner.setImageHeight(height);
        try {
            runner.run();
            image = runner.getChartImageName();
            bandElement.setImage(image);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void generateBarcodeImage(BarcodeBandElement bandElement) {
        if (this.bean.getConnection() == null) {
            return;
        }
        int width = bandElement.getWidth() == null ? 1 : bandElement.getWidth();
        int height = bandElement.getHeight() == null ? 1 : bandElement.getHeight();
        String value = bandElement.getValue();
        if (bandElement.isColumn()) {
            try {
                value = String.valueOf(this.getResult().nextValue(value));
            }
            catch (QueryException e) {
                e.printStackTrace();
            }
        }
        Image image = null;
        if (BarcodeBandElement.isEANFamily(bandElement.getBarcodeType())) {
            BarcodeEAN codeEAN = new BarcodeEAN();
            codeEAN.setCodeType(bandElement.getBarcodeType());
            codeEAN.setCode(value);
            image = codeEAN.createAwtImage(Color.BLACK, Color.WHITE);
        } else if (bandElement.getBarcodeType() == BarcodeBandElement.PDF417) {
            BarcodePDF417 barcode417 = new BarcodePDF417();
            barcode417.setText(value);
            image = barcode417.createAwtImage(Color.BLACK, Color.WHITE);
        } else if (bandElement.getBarcodeType() == BarcodeBandElement.DATAMATRIX) {
            BarcodeDatamatrix datamatrix = new BarcodeDatamatrix();
            try {
                datamatrix.generate(value);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            image = datamatrix.createAwtImage(Color.BLACK, Color.WHITE);
        } else if (bandElement.getBarcodeType() == BarcodeBandElement.QRCODE) {
            BarcodeQRCode qrcode = new BarcodeQRCode(value, width, height, null);
            image = qrcode.createAwtImage(Color.BLACK, Color.WHITE);
        } else {
            Barcode128 barcode = null;
            if (bandElement.getBarcodeType() == BarcodeBandElement.CODE128) {
                barcode = new Barcode128();
            } else if (bandElement.getBarcodeType() == BarcodeBandElement.CODE128_RAW) {
                barcode = new Barcode128();
                barcode.setCodeType(bandElement.getBarcodeType());
            } else if (bandElement.getBarcodeType() == BarcodeBandElement.INTER25) {
                barcode = new BarcodeInter25();
            } else if (bandElement.getBarcodeType() == BarcodeBandElement.CODE39) {
                barcode = new Barcode39();
            } else if (bandElement.getBarcodeType() == BarcodeBandElement.CODE39EXT) {
                barcode = new Barcode39();
                barcode.setStartStopText(false);
                barcode.setExtended(true);
            } else if (bandElement.getBarcodeType() == BarcodeBandElement.CODABAR) {
                barcode = new BarcodeCodabar();
            }
            barcode.setCode(value);
            image = barcode.createAwtImage(Color.BLACK, Color.WHITE);
        }
        String imageName = this.saveBarcode(bandElement, this.toBufferedImage(image), "png");
        bandElement.setImage(imageName);
    }

    private BufferedImage toBufferedImage(Image src) {
        int w = src.getWidth(null);
        int h = src.getHeight(null);
        int type = 1;
        BufferedImage dest = new BufferedImage(w, h, type);
        Graphics2D g2 = dest.createGraphics();
        g2.drawImage(src, 0, 0, null);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.dispose();
        return dest;
    }

    private String saveBarcode(BarcodeBandElement bandElement, BufferedImage image, String ext) {
        String fileName = "barcode_" + bandElement.getBarcodeType() + "_" + this.barcodeIndex + "." + ext;
        ++this.barcodeIndex;
        File file = new File(this.imageChartPath + File.separator + fileName);
        try {
            ImageIO.write((RenderedImage)image, ext, file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fileName;
    }

    public int getPoints(int pixels) {
        return (int)((float)pixels * 72.0f / (float)ResultExporter.getDPI());
    }

    protected PrefixSuffix interpretPageNo(BandElement bandElement) {
        String exp = "";
        try {
            String pattern = "";
            if (bandElement instanceof FieldBandElement) {
                pattern = ((FieldBandElement)bandElement).getPattern();
            }
            exp = StringUtil.getValueAsString(this.evaluateExpression((ExpressionBandElement)bandElement, "", null), pattern);
            String name = "$V_PAGE_NO";
            return StringUtil.parse(exp, name);
        }
        catch (QueryException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private RowElement getRowElement(ReportLayout layout, int gridRow) {
        if (this.rowMap == null) {
            this.rowMap = new HashMap<Integer, RowElement>();
            List<Band> bands = layout.getBands();
            boolean currentRow = false;
            for (Band band : bands) {
                int rows = band.getRowCount();
                for (int i = 0; i < rows; ++i) {
                    int gr = layout.getGridRow(band.getName(), i);
                    this.rowMap.put(gr, band.getElements().get(i));
                }
            }
        }
        return this.rowMap.get(gridRow);
    }

    protected ExporterBean getSubreportExporterBean(Report subreport) throws Exception {
        return this.getSubreportExporterBean(subreport, false);
    }

    protected ExporterBean getSubreportExporterBean(Report subreport, boolean rowCount) throws Exception {
        String sql = ReportUtil.getSql(subreport);
        Query query = new Query(sql);
        this.bean.getParametersBean().addSubreportParameters(subreport.getParameters());
        this.bean.getParametersBean().overwriteSubreportParametersValues(subreport.getGeneratedParamValues());
        QueryExecutor executor = new QueryExecutor(query, this.bean.getParametersBean().getParams(), this.bean.getParametersBean().getParamValues(), this.bean.getConnection(), rowCount);
        executor.setMaxRows(0);
        executor.setTimeout(this.bean.getQueryTimeout());
        QueryResult queryResult = executor.execute();
        boolean isProcedure = QueryUtil.isProcedureCall(sql);
        ExporterBean eb = new ExporterBean(this.bean.getConnection(), this.bean.getQueryTimeout(), queryResult, this.bean.getOut(), subreport.getLayout(), this.bean.getParametersBean(), subreport.getBaseName(), false, isProcedure);
        eb.setSubreport(true);
        return eb;
    }

    private VariableBandElement getTotalPageNoVbe(ReportLayout layout) {
        List<Band> bands = layout.getBands();
        for (Band band : bands) {
            int rows = band.getRowCount();
            for (int i = 0; i < rows; ++i) {
                List<BandElement> elements = band.getRow(i);
                for (BandElement be : elements) {
                    if (!(be instanceof VariableBandElement) || !(VariableFactory.getVariable(((VariableBandElement)be).getVariable()) instanceof TotalPageNoVariable)) continue;
                    return (VariableBandElement)be;
                }
            }
        }
        return null;
    }

    protected boolean isAlert(Alert alert, Object value) {
        return alert != null && alert.isActive(value);
    }

    private void alert(Alert alert, Object value, String message) {
        if (alert != null) {
            alert.run(value, message);
        }
    }

    protected void executeAlert(final Alert alert, final Object value, final String message) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ResultExporter.this.alert(alert, value, message);
            }
        };
        new Thread(r).start();
    }

    private String getFunctionTemplate(GroupCache gc, FunctionBandElement fbe, boolean previous) throws QueryException {
        StringBuilder templateKey = new StringBuilder();
        if (gc == null) {
            templateKey.append("F_").append(fbe.getFunction()).append("_").append(fbe.getColumn());
            return templateKey.toString();
        }
        String groupColumn = gc.getGroup().getColumn();
        Object groupValue = previous ? (this.resultSetRow == 0 ? this.getResult().nextValue(groupColumn) : this.previousRow[this.getResult().getColumnIndex(groupColumn)]) : this.getResult().nextValue(groupColumn);
        this.groupTemplateKeys.put("G" + gc.getGroup().getName(), "G" + gc.getGroup().getName() + "_" + this.previousRow[this.getResult().getColumnIndex(groupColumn)]);
        templateKey.append("G").append(gc.getGroup().getName()).append("_F_").append(fbe.getFunction()).append("_").append(fbe.getColumn()).append("_").append(groupValue);
        int group = Integer.parseInt(gc.getGroup().getName());
        StringBuilder result = new StringBuilder();
        for (int i = 1; i < group; ++i) {
            result.append(this.groupTemplateKeys.get("G" + i)).append("_");
        }
        result.append(templateKey.toString());
        return result.toString();
    }

    public Map<String, Object> getTemplatesValues() {
        return this.templatesValues;
    }

    public Map<String, String> getGroupTemplateKeys() {
        return this.groupTemplateKeys;
    }

    private boolean needsFirstCrossing() {
        return ReportUtil.foundFunctionInHeader(this.bean.getReportLayout()) || ReportUtil.foundFunctionInAnyGroupHeader(this.bean.getReportLayout());
    }

    private Band getBand(ReportLayout layout, int gridRow) {
        List<Band> bands = layout.getBands();
        int currentRow = 0;
        for (Band band : bands) {
            int rows = band.getRowCount();
            if (gridRow >= (currentRow += rows)) continue;
            return band;
        }
        return null;
    }

    protected String getSystemDefaultLanguage() {
        Locale locale = Locale.getDefault();
        return locale.getLanguage() + "_" + locale.getCountry();
    }

    protected I18nLanguage getReportLanguage() {
        if (this.bean.getLanguage() == null) {
            return I18nUtil.getDefaultLanguage(this.bean.getReportLayout());
        }
        return I18nUtil.getLanguageByName(this.bean.getReportLayout(), this.bean.getLanguage());
    }

    protected String getCurrentValueForGroup(String group) {
        Object obj = this.groupValues.get(group);
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }
}

