/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.exporter;

import com.lowagie.text.Anchor;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.FontFactoryImp;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Table;
import com.lowagie.text.html.simpleparser.HTMLWorker;
import com.lowagie.text.html.simpleparser.StyleSheet;
import com.lowagie.text.rtf.RtfWriter2;
import com.lowagie.text.rtf.field.RtfPageNumber;
import com.lowagie.text.rtf.headerfooter.RtfHeaderFooter;
import com.lowagie.text.rtf.headerfooter.RtfHeaderFooterGroup;
import com.lowagie.text.rtf.table.RtfBorderGroup;
import com.lowagie.text.rtf.table.RtfCell;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.nextreports.engine.ReleaseInfoAdapter;
import ro.nextreports.engine.Report;
import ro.nextreports.engine.band.Band;
import ro.nextreports.engine.band.BandElement;
import ro.nextreports.engine.band.ExpressionBandElement;
import ro.nextreports.engine.band.Hyperlink;
import ro.nextreports.engine.band.HyperlinkBandElement;
import ro.nextreports.engine.band.ImageBandElement;
import ro.nextreports.engine.band.ImageColumnBandElement;
import ro.nextreports.engine.band.Padding;
import ro.nextreports.engine.band.PaperSize;
import ro.nextreports.engine.band.ReportBandElement;
import ro.nextreports.engine.band.VariableBandElement;
import ro.nextreports.engine.exporter.CellElement;
import ro.nextreports.engine.exporter.ExporterBean;
import ro.nextreports.engine.exporter.ResultExporter;
import ro.nextreports.engine.exporter.util.variable.PageNoVariable;
import ro.nextreports.engine.exporter.util.variable.Variable;
import ro.nextreports.engine.exporter.util.variable.VariableFactory;
import ro.nextreports.engine.queryexec.QueryException;
import ro.nextreports.engine.util.PrefixSuffix;
import ro.nextreports.engine.util.StringUtil;

public class RtfExporter
extends ResultExporter {
    private int fragmentsize = 15000;
    private Document document;
    private Table table;
    private Table header;
    private Table footer;

    public RtfExporter(ExporterBean bean) {
        super(bean);
    }

    @Override
    protected void initExport() throws QueryException {
        if (!this.bean.isSubreport()) {
            Rectangle rectangle;
            Padding margins = this.bean.getReportLayout().getPagePadding();
            if ("CUSTOM".equals(this.bean.getReportLayout().getPageFormat())) {
                PaperSize customSize = this.bean.getReportLayout().getPaperSize();
                rectangle = new Rectangle((float)customSize.getWidthPoints(), (float)customSize.getHeightPoints());
            } else {
                rectangle = PageSize.getRectangle((String)this.getPageFormat());
            }
            this.document = new Document(rectangle, (float)this.getPoints(margins.getLeft()), (float)this.getPoints(margins.getRight()), (float)this.getPoints(margins.getTop()), (float)this.getPoints(margins.getBottom()));
            if (this.bean.getReportLayout().getOrientation() == 1) {
                this.document.setPageSize(rectangle.rotate());
            }
            RtfWriter2 rtfWriter2 = RtfWriter2.getInstance((Document)this.document, (OutputStream)this.getOut());
        }
        try {
            if (!this.bean.isSubreport()) {
                this.buildHeader();
                this.buildFooter();
                this.addMetaData();
                this.document.open();
            }
            this.table = this.buildRtfTable(0);
        }
        catch (DocumentException e) {
            e.printStackTrace();
            throw new QueryException(e);
        }
    }

    private void addMetaData() {
        this.document.addTitle(this.getDocumentTitle());
        this.document.addAuthor(ReleaseInfoAdapter.getCompany());
        this.document.addCreator("NextReports " + ReleaseInfoAdapter.getVersionNumber());
        this.document.addSubject("Created by NextReports Designer" + ReleaseInfoAdapter.getVersionNumber());
        this.document.addCreationDate();
        this.document.addKeywords(ReleaseInfoAdapter.getHome());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finishExport() {
        if (!this.bean.isSubreport()) {
            try {
                if (this.table != null) {
                    this.document.add((Element)this.table);
                }
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
            finally {
                this.table = null;
                this.document.close();
            }
        }
    }

    @Override
    protected void close() {
        if (!this.bean.isSubreport()) {
            this.document.close();
        }
    }

    @Override
    protected void flush() {
    }

    @Override
    protected void flushNow() {
    }

    @Override
    protected Set<CellElement> getIgnoredCells(Band band) {
        return this.getIgnoredCellElements(band);
    }

    @Override
    protected void exportCell(String bandName, BandElement bandElement, Object value, int gridRow, int row, int column, int cols, int rowSpan, int colSpan, boolean isImage) {
        if (!this.bean.isSubreport()) {
            if ("PageHeader".equals(bandName)) {
                this.header.addCell((Cell)this.renderRtfCell(bandElement, value, gridRow, column, rowSpan, colSpan, isImage));
            } else if ("PageFooter".equals(bandName)) {
                this.footer.addCell((Cell)this.renderRtfCell(bandElement, value, gridRow, column, rowSpan, colSpan, isImage));
            } else {
                this.table.addCell((Cell)this.renderRtfCell(bandElement, value, gridRow, column, rowSpan, colSpan, isImage));
            }
        } else {
            this.table.addCell((Cell)this.renderRtfCell(bandElement, value, gridRow, column, rowSpan, colSpan, isImage));
        }
    }

    @Override
    protected void afterRowExport() {
    }

    @Override
    protected String getNullElement() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RtfCell renderRtfCell(BandElement bandElement, Object value, int gridRow, int gridColumn, int rowSpan, int colSpan, boolean image) {
        Font fnt;
        Map<String, Object> style = this.buildCellStyleMap(bandElement, value, gridRow, gridColumn, colSpan);
        FontFactoryImp fact = new FontFactoryImp();
        if (bandElement != null) {
            String fontName = (String)style.get("font_name");
            int size = ((Float)style.get("font_size")).intValue();
            fnt = this.getFont(fontName, size);
        } else {
            fnt = this.getFont(10);
        }
        RtfCell cell = null;
        boolean specialCell = false;
        if (image) {
            try {
                if (value == null) {
                    cell = new RtfCell((Element)new Phrase(IMAGE_NOT_FOUND));
                } else {
                    ImageBandElement ibe = (ImageBandElement)bandElement;
                    byte[] imageBytes = this.getImage((String)value, ibe.getWidth(), ibe.getHeight());
                    cell = new RtfCell((Element)Image.getInstance((byte[])imageBytes));
                }
            }
            catch (Exception e) {
                cell = new RtfCell(IMAGE_NOT_LOADED);
            }
            specialCell = true;
        } else if (bandElement instanceof HyperlinkBandElement) {
            Hyperlink hyperlink = ((HyperlinkBandElement)bandElement).getHyperlink();
            Anchor anchor = new Anchor(hyperlink.getText(), fnt);
            anchor.setReference(hyperlink.getUrl());
            Phrase ph = new Phrase();
            ph.add((Object)anchor);
            try {
                cell = new RtfCell((Element)ph);
            }
            catch (BadElementException e) {
                e.printStackTrace();
                cell = new RtfCell(hyperlink.getText());
            }
            specialCell = true;
        } else if (bandElement instanceof ReportBandElement) {
            Report report = ((ReportBandElement)bandElement).getReport();
            ExporterBean eb = null;
            try {
                eb = this.getSubreportExporterBean(report);
                RtfExporter subExporter = new RtfExporter(eb);
                subExporter.export();
                Table innerTable = subExporter.getTable();
                cell = new RtfCell((Element)innerTable);
            }
            catch (Exception e) {
                cell = new RtfCell();
                e.printStackTrace();
            }
            finally {
                if (eb != null && eb.getResult() != null) {
                    eb.getResult().close();
                }
            }
            specialCell = true;
        } else if (bandElement instanceof VariableBandElement) {
            VariableBandElement vbe = (VariableBandElement)bandElement;
            Variable var = VariableFactory.getVariable(vbe.getVariable());
            if (var instanceof PageNoVariable) {
                cell = new RtfCell();
                cell.add((Object)new RtfPageNumber());
                cell.setBorderWidth(0.0f);
                specialCell = true;
            }
        } else if (bandElement instanceof ExpressionBandElement) {
            PrefixSuffix pf = this.interpretPageNo(bandElement);
            if (pf != null) {
                this.updateFont(fnt, style);
                cell = new RtfCell();
                if (!"".equals(pf.getPrefix())) {
                    cell.add((Object)new Phrase(pf.getPrefix(), fnt));
                }
                cell.add((Object)new RtfPageNumber(fnt));
                if (!"".equals(pf.getSuffix())) {
                    cell.add((Object)new Phrase(pf.getSuffix(), fnt));
                }
                specialCell = true;
            }
        } else if (bandElement instanceof ImageColumnBandElement) {
            try {
                String v = StringUtil.getValueAsString(value, null);
                if (StringUtil.BLOB.equals(v)) {
                    cell = new RtfCell((Element)new Phrase(StringUtil.BLOB));
                } else {
                    ImageColumnBandElement icbe = (ImageColumnBandElement)bandElement;
                    byte[] imageD = StringUtil.decodeImage(v);
                    byte[] imageBytes = this.getImage(imageD, icbe.getWidth(), icbe.getHeight());
                    cell = new RtfCell((Element)Image.getInstance((byte[])imageBytes));
                }
            }
            catch (Exception e) {
                cell = new RtfCell(IMAGE_NOT_LOADED);
            }
            specialCell = true;
        }
        if (!specialCell) {
            Phrase ph;
            String stringValue = style.containsKey("pattern") ? StringUtil.getValueAsString(value, (String)style.get("pattern"), this.getReportLanguage()) : StringUtil.getValueAsString(value, null, this.getReportLanguage());
            if (stringValue == null) {
                stringValue = "";
            }
            if (stringValue.startsWith("<html>")) {
                StringReader reader = new StringReader(stringValue);
                ArrayList elems = new ArrayList();
                try {
                    elems = HTMLWorker.parseToList((Reader)reader, (StyleSheet)new StyleSheet());
                    ph = new Phrase();
                    for (int i = 0; i < elems.size(); ++i) {
                        Element elem = (Element)elems.get(i);
                        ph.add((Object)elem);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    ph = new Phrase(stringValue, fnt);
                }
            } else {
                ph = new Phrase(stringValue, fnt);
            }
            try {
                cell = new RtfCell((Element)ph);
            }
            catch (BadElementException e) {
                e.printStackTrace();
                cell = new RtfCell(stringValue);
            }
        }
        cell.setVerticalAlignment(5);
        if (colSpan > 1) {
            cell.setColspan(colSpan);
        }
        if (rowSpan > 1) {
            cell.setRowspan(rowSpan);
        }
        this.setCellStyle(fnt, style, cell);
        return cell;
    }

    private void updateFont(Font fnt, Map<String, Object> style) {
        if (style != null) {
            Object val;
            if (style.containsKey("font_family")) {
                val = (String)style.get("font_family");
                fnt.setFamily((String)val);
            }
            if (style.containsKey("font_size")) {
                val = (Float)style.get("font_size");
                fnt.setSize(((Float)val).floatValue());
            }
            if (style.containsKey("font_color")) {
                val = (Color)style.get("font_color");
                fnt.setColor((Color)val);
            }
            if (style.containsKey("font_style_key")) {
                if ("font_stylet_normal".equals(style.get("font_style_key"))) {
                    fnt.setStyle(0);
                }
                if ("font_style_bold".equals(style.get("font_style_key"))) {
                    fnt.setStyle(1);
                }
                if ("font_style_italic".equals(style.get("font_style_key"))) {
                    fnt.setStyle(2);
                }
                if ("font_style_bold_italic".equals(style.get("font_style_key"))) {
                    fnt.setStyle(3);
                }
            }
        }
    }

    private void setCellStyle(Font fnt, Map<String, Object> style, RtfCell cell) {
        if (style != null) {
            Color color;
            Serializable val;
            this.updateFont(fnt, style);
            if (style.containsKey("bg_color")) {
                val = (Color)style.get("bg_color");
                cell.setBackgroundColor((Color)val);
            }
            if (style.containsKey("halign")) {
                if ("halign_left".equals(style.get("halign"))) {
                    cell.setHorizontalAlignment(0);
                }
                if ("halign_right".equals(style.get("halign"))) {
                    cell.setHorizontalAlignment(2);
                }
                if ("halign_center".equals(style.get("halign"))) {
                    cell.setHorizontalAlignment(1);
                }
            }
            if (style.containsKey("valign")) {
                if ("valign_top".equals(style.get("valign"))) {
                    cell.setVerticalAlignment(4);
                }
                if ("valign_middle".equals(style.get("valign"))) {
                    cell.setVerticalAlignment(5);
                }
                if ("valign_bottom".equals(style.get("valign"))) {
                    cell.setVerticalAlignment(6);
                }
            }
            cell.setBorderWidth(0.0f);
            val = Float.valueOf(1.0f);
            RtfBorderGroup bg = new RtfBorderGroup();
            if (style.containsKey("border_left")) {
                val = (Float)style.get("border_left");
                color = (Color)style.get("border_left_color");
                bg.addBorder(4, 1, ((Float)val).floatValue(), color);
            }
            if (style.containsKey("border_right")) {
                val = (Float)style.get("border_right");
                color = (Color)style.get("border_right_color");
                bg.addBorder(8, 1, ((Float)val).floatValue(), color);
            }
            if (style.containsKey("border_top")) {
                val = (Float)style.get("border_top");
                color = (Color)style.get("border_top_color");
                bg.addBorder(1, 1, ((Float)val).floatValue(), color);
            }
            if (style.containsKey("border_bottom")) {
                val = (Float)style.get("border_bottom");
                color = (Color)style.get("border_bottom_color");
                bg.addBorder(2, 1, ((Float)val).floatValue(), color);
            }
            cell.setBorders(bg);
        }
    }

    private Font getFont(String fontName, int size) {
        return FontFactory.getFont((String)fontName, (float)size);
    }

    private Font getFont(int size) {
        return FontFactory.getFont((String)"Times", (float)size);
    }

    private Table buildRtfTable(int type) throws DocumentException {
        List<Object> bands = new ArrayList<Band>();
        if (type == 1) {
            bands.add(this.getReportLayout().getPageHeaderBand());
        } else if (type == 2) {
            bands.add(this.getReportLayout().getPageFooterBand());
        } else {
            bands = this.getReportLayout().getDocumentBands();
        }
        int totalRows = 0;
        int totalColumns = 0;
        for (Band band : bands) {
            totalRows += band.getRowCount();
            int cols = band.getColumnCount();
            if (cols <= totalColumns) continue;
            totalColumns = cols;
        }
        if (totalColumns == 0) {
            return null;
        }
        Table datatable = new Table(totalColumns);
        int[] nArray = new int[totalColumns];
        int size = 100 / totalColumns;
        int totalWidth = 0;
        for (int i = 0; i < totalColumns; ++i) {
            nArray[i] = this.bean.getReportLayout().isUseSize() ? this.bean.getReportLayout().getColumnsWidth().get(i) : size;
            totalWidth += nArray[i];
        }
        if (this.bean.getReportLayout().isUseSize()) {
            float percentage;
            float pixels = A4_PORTRAIT_PIXELS;
            if (this.bean.getReportLayout().getOrientation() == 1) {
                pixels = A4_LANDSCAPE_PIXELS;
            }
            if ((percentage = (float)(totalWidth * 100) / pixels) > 100.0f) {
                percentage = 100.0f;
            }
            if (!"CUSTOM".equals(this.bean.getReportLayout().getPageFormat())) {
                datatable.setWidth(percentage);
            }
            datatable.setWidths(nArray);
        } else {
            datatable.setWidth(100.0f);
        }
        datatable.setPadding(2.0f);
        if (type == 0) {
            this.writeHeader(datatable);
        }
        return datatable;
    }

    private void writeHeader(Table datatable) {
        int headerNo;
        if (this.bean.getReportLayout().isHeaderOnEveryPage() && (headerNo = this.bean.getReportLayout().getHeaderBand().getRowCount()) > 0) {
            datatable.setLastHeaderRow(headerNo);
        }
    }

    private void buildHeader() throws DocumentException, QueryException {
        this.header = this.buildRtfTable(1);
        if (this.header == null) {
            return;
        }
        this.printPageHeaderBand();
        RtfHeaderFooter hf = new RtfHeaderFooter((Element)this.header);
        this.document.setHeader((HeaderFooter)hf);
    }

    private void buildFooter() throws DocumentException, QueryException {
        this.footer = this.buildRtfTable(2);
        if (this.footer == null) {
            return;
        }
        this.printPageFooterBand();
        RtfHeaderFooterGroup footerGroup = new RtfHeaderFooterGroup();
        RtfHeaderFooter hf = new RtfHeaderFooter((Element)this.footer);
        footerGroup.setHeaderFooter(hf, 1);
        this.document.setFooter((HeaderFooter)footerGroup);
    }

    @Override
    protected void newPage() {
        if (!this.bean.isSubreport()) {
            try {
                this.document.add((Element)this.table);
                this.document.newPage();
                this.table.deleteAllRows();
                if (this.bean.getReportLayout().isHeaderOnEveryPage()) {
                    try {
                        this.printHeaderBand();
                    }
                    catch (QueryException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String getPageFormat() {
        String format = this.bean.getReportLayout().getPageFormat();
        if ("A0".equals(format) || "A1".equals(format)) {
            format = "A2";
        }
        return format;
    }

    public Table getTable() {
        return this.table;
    }
}

