/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.exporter;

import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.nextreports.engine.Report;
import ro.nextreports.engine.band.Band;
import ro.nextreports.engine.band.BandElement;
import ro.nextreports.engine.band.Hyperlink;
import ro.nextreports.engine.band.HyperlinkBandElement;
import ro.nextreports.engine.band.ReportBandElement;
import ro.nextreports.engine.exporter.CellElement;
import ro.nextreports.engine.exporter.ExporterBean;
import ro.nextreports.engine.exporter.ResultExporter;
import ro.nextreports.engine.queryexec.QueryException;
import ro.nextreports.engine.util.StringUtil;

public class TxtExporter
extends ResultExporter {
    private PrintStream stream;
    private int[] columnWidth;
    public static final float PIXELS_PER_CHAR = 6.55f;
    private int defaultChars = Math.round((float)A4_PORTRAIT_PIXELS / 6.55f);
    private static final String lineSeparator = " \r\n";

    public TxtExporter(ExporterBean bean) {
        super(bean);
    }

    @Override
    protected void initExport() throws QueryException {
        this.stream = this.createPrintStream();
        this.columnWidth = this.getColumnCharacters();
    }

    @Override
    protected void finishExport() {
        this.stream.flush();
        if (!this.bean.isSubreport()) {
            this.stream.close();
        }
    }

    @Override
    protected void close() {
        if (!this.bean.isSubreport()) {
            this.stream.close();
        }
    }

    @Override
    protected void flush() {
        if (this.resultSetRow % 7500 == 0) {
            this.flushNow();
        }
    }

    @Override
    protected void flushNow() {
        this.stream.flush();
    }

    @Override
    protected Set<CellElement> getIgnoredCells(Band band) {
        return new HashSet<CellElement>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void exportCell(String bandName, BandElement bandElement, Object value, int gridRow, int row, int column, int cols, int rowSpan, int colSpan, boolean isImage) {
        if (bandElement instanceof HyperlinkBandElement) {
            Hyperlink hyperlink = ((HyperlinkBandElement)bandElement).getHyperlink();
            value = hyperlink.getText();
        } else if (bandElement instanceof ReportBandElement) {
            Report report = ((ReportBandElement)bandElement).getReport();
            ExporterBean eb = null;
            try {
                eb = this.getSubreportExporterBean(report);
                TxtExporter subExporter = new TxtExporter(eb);
                subExporter.export();
                value = subExporter.getSubreportData();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (eb != null && eb.getResult() != null) {
                    eb.getResult().close();
                }
            }
        }
        this.put(this.stream, StringUtil.getValueAsString(value, this.getPattern(bandElement), this.getReportLanguage()), column, colSpan, bandElement);
        if (column == cols - 1) {
            this.nl(this.stream);
        }
    }

    @Override
    protected void afterRowExport() {
    }

    @Override
    protected String getNullElement() {
        return null;
    }

    private int[] getColumnCharacters() {
        List<Band> bands = this.getReportLayout().getDocumentBands();
        int totalColumns = 0;
        for (Band band : bands) {
            int cols = band.getColumnCount();
            if (cols <= totalColumns) continue;
            totalColumns = cols;
        }
        int[] headerwidths = new int[totalColumns];
        if (totalColumns == 0) {
            return headerwidths;
        }
        int size = this.defaultChars / totalColumns;
        int totalWidth = 0;
        for (int i = 0; i < totalColumns; ++i) {
            headerwidths[i] = this.bean.getReportLayout().isUseSize() ? Math.round((float)this.bean.getReportLayout().getColumnsWidth().get(i).intValue() / 6.55f) : size;
            totalWidth += headerwidths[i];
        }
        return headerwidths;
    }

    private void put(PrintStream p, String s, int column, int colSpan, BandElement bandElement) {
        if (s == null) {
            this.put(p, "", column, colSpan, bandElement);
            return;
        }
        int size = 0;
        if (colSpan > 1) {
            for (int i = column; i < column + colSpan; ++i) {
                size += this.columnWidth[i];
            }
        } else {
            size = this.columnWidth[column];
        }
        if (bandElement != null && bandElement.getHorizontalAlign() == 4) {
            p.print(String.format("%" + size + "s", s));
        } else {
            p.print(String.format("%-" + size + "s", s));
        }
    }

    public void nl(PrintStream p) {
        p.print(lineSeparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSubreportData() {
        try {
            String string = this.subreportStream.toString("UTF-8");
            return string;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            String string = "";
            return string;
        }
        finally {
            this.stream.close();
        }
    }
}

