/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.exporter;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFFooter;
import org.apache.poi.hssf.usermodel.HSSFHeader;
import org.apache.poi.hssf.usermodel.HSSFHyperlink;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFRegionUtil;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import ro.nextreports.engine.ReleaseInfoAdapter;
import ro.nextreports.engine.band.Band;
import ro.nextreports.engine.band.BandElement;
import ro.nextreports.engine.band.Border;
import ro.nextreports.engine.band.ExpressionBandElement;
import ro.nextreports.engine.band.FieldBandElement;
import ro.nextreports.engine.band.HyperlinkBandElement;
import ro.nextreports.engine.band.ImageBandElement;
import ro.nextreports.engine.band.ImageColumnBandElement;
import ro.nextreports.engine.band.ReportBandElement;
import ro.nextreports.engine.band.VariableBandElement;
import ro.nextreports.engine.exporter.CellElement;
import ro.nextreports.engine.exporter.ExporterBean;
import ro.nextreports.engine.exporter.ResultExporter;
import ro.nextreports.engine.exporter.util.ExcelColorSupport;
import ro.nextreports.engine.exporter.util.XlsUtil;
import ro.nextreports.engine.exporter.util.variable.PageNoVariable;
import ro.nextreports.engine.exporter.util.variable.Variable;
import ro.nextreports.engine.exporter.util.variable.VariableFactory;
import ro.nextreports.engine.queryexec.QueryException;
import ro.nextreports.engine.util.PrefixSuffix;
import ro.nextreports.engine.util.StringUtil;

public class XlsExporter
extends ResultExporter {
    private static Log LOG = LogFactory.getLog(XlsExporter.class);
    private static float POINTS_FOR_PIXEL = 3686.4f / (float)XlsExporter.getDPI();
    private int prevSubreportFirstRow = -1;
    private int prevSubreportFirstColumn = 0;
    private int prevSubreportLastColumn = -1;
    private int addedPageRows = 0;
    private int page = 1;
    private int fragmentsize = 65000;
    private HSSFWorkbook wb;
    private HSSFSheet xlsSheet = null;
    private HSSFRow xlsRow = null;
    private List<XlsRegion> regions = new ArrayList<XlsRegion>();
    private HSSFPatriarch patriarch;
    private StringBuilder headerS = new StringBuilder();
    private StringBuilder footerS = new StringBuilder();
    private HSSFCellStyle subreportCellStyle;
    private Map<Integer, HSSFCellStyle> styles = new HashMap<Integer, HSSFCellStyle>();
    private Map<Integer, HSSFCellStyle> condStyles = new HashMap<Integer, HSSFCellStyle>();
    private Map<Integer, HSSFFont> fonts = new HashMap<Integer, HSSFFont>();
    private Map<Integer, HSSFFont> condFonts = new HashMap<Integer, HSSFFont>();
    private Border border;

    public XlsExporter(ExporterBean bean) {
        super(bean);
    }

    private XlsExporter(ExporterBean bean, HSSFCellStyle cellStyle) {
        super(bean);
        this.subreportCellStyle = cellStyle;
    }

    @Override
    protected void initExport() throws QueryException {
        if (this.hasTemplate()) {
            try {
                this.wb = new HSSFWorkbook(this.getTemplateInputStream());
            }
            catch (IOException e) {
                e.printStackTrace();
                LOG.error((Object)e.getMessage(), (Throwable)e);
                this.wb = new HSSFWorkbook();
            }
        } else {
            this.wb = new HSSFWorkbook();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finishExport() {
        String sheetName = this.bean.getReportLayout().getSheetNames();
        if (this.sheetNameContainsGroup(sheetName)) {
            String actualName = this.replaceSheetNameParam(sheetName);
            if (this.wb.getSheetName(this.page - 3).equals(actualName)) {
                this.wb.setSheetName(this.page - 2, String.valueOf(this.page - 1));
            } else {
                this.wb.setSheetName(this.page - 2, actualName);
            }
        }
        if (!this.bean.isSubreport()) {
            this.addRegions(this.xlsSheet, this.regions, this.wb);
            try {
                this.wb.write(this.getOut());
                this.getOut().flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.getOut().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void createSummaryInformation(String filePath, String title) {
        if (filePath == null) {
            return;
        }
        try {
            File poiFilesystem = new File(filePath);
            FileInputStream is = new FileInputStream(poiFilesystem);
            POIFSFileSystem poifs = new POIFSFileSystem((InputStream)is);
            ((InputStream)is).close();
            DirectoryNode dir = poifs.getRoot();
            SummaryInformation si = PropertySetFactory.newSummaryInformation();
            si.setTitle(title);
            si.setAuthor(ReleaseInfoAdapter.getCompany());
            si.setApplicationName("NextReports " + ReleaseInfoAdapter.getVersionNumber());
            si.setSubject("Created by NextReports Designer" + ReleaseInfoAdapter.getVersionNumber());
            si.setCreateDateTime(new java.util.Date());
            si.setKeywords(ReleaseInfoAdapter.getHome());
            si.write((DirectoryEntry)dir, "\u0005SummaryInformation");
            FileOutputStream out = new FileOutputStream(poiFilesystem);
            poifs.writeFilesystem((OutputStream)out);
            ((OutputStream)out).close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    protected void close() {
        if (!this.bean.isSubreport()) {
            try {
                this.getOut().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void flush() {
    }

    @Override
    protected void flushNow() {
    }

    @Override
    protected Set<CellElement> getIgnoredCells(Band band) {
        return new HashSet<CellElement>();
    }

    @Override
    protected void exportCell(String bandName, BandElement bandElement, Object value, int gridRow, int row, int column, int cols, int rowSpan, int colSpan, boolean isImage) {
        if ("PageHeader".equals(bandName)) {
            this.renderCellToHeaderFooter(this.headerS, bandName, bandElement, value, gridRow, row, column, cols, rowSpan, colSpan, isImage);
        } else if ("PageFooter".equals(bandName)) {
            this.renderCellToHeaderFooter(this.footerS, bandName, bandElement, value, gridRow, row, column, cols, rowSpan, colSpan, isImage);
        } else {
            int sheetRow = this.pageRow % this.fragmentsize;
            if (column == 0) {
                if (sheetRow == 0) {
                    if (this.page > 1) {
                        // empty if block
                    }
                    if (this.page == 1 || this.pageRow > 0) {
                        this.newPage();
                        this.pageRow = 0;
                    }
                }
                this.xlsRow = this.xlsSheet.createRow(sheetRow);
            }
            if (this.bean.getReportLayout().isUseSize()) {
                int width = (int)((float)this.bean.getReportLayout().getColumnsWidth().get(column).intValue() * POINTS_FOR_PIXEL);
                this.xlsSheet.setColumnWidth(column, width);
            }
            this.renderCell(bandElement, bandName, value, gridRow, sheetRow, column, rowSpan, colSpan, isImage);
        }
    }

    @Override
    protected void afterRowExport() {
        this.addRegions(this.xlsSheet, this.regions, this.wb);
    }

    @Override
    protected String getNullElement() {
        return "";
    }

    private HSSFCellStyle buildBandElementStyle(BandElement bandElement, Object value, int gridRow, int gridColumn, int colSpan) {
        Color color;
        Float val;
        Object val2;
        Map<String, Object> style = this.buildCellStyleMap(bandElement, value, gridRow, gridColumn, colSpan);
        HSSFCellStyle cellStyle = null;
        HSSFFont cellFont = null;
        int fontKey = -1;
        int styleKey = -1;
        boolean cacheFont = false;
        boolean cacheAllFont = false;
        boolean cacheStyle = false;
        boolean cacheAllStyle = false;
        if (this.modifiedStyle[gridRow][gridColumn] || this.bean.isSubreport()) {
            fontKey = this.getFontKey(style);
            if (fontKey != -1) {
                cellFont = this.condFonts.get(fontKey);
            }
            if (cellFont == null) {
                cellFont = this.wb.createFont();
                cacheFont = true;
            }
            if ((styleKey = this.getStyleKey(style, bandElement)) != -1) {
                cellStyle = this.condStyles.get(styleKey);
            }
            if (cellStyle == null) {
                cellStyle = this.wb.createCellStyle();
                cacheStyle = true;
            }
            this.modifiedStyle[gridRow][gridColumn] = false;
        } else {
            fontKey = this.getFontKey(style);
            if (fontKey != -1) {
                cellFont = this.fonts.get(fontKey);
            }
            if (cellFont == null && bandElement != null) {
                cellFont = this.wb.createFont();
                cacheAllFont = true;
            }
            if ((styleKey = this.getStyleKey(style, bandElement)) != -1) {
                cellStyle = this.styles.get(styleKey);
            }
            if (cellStyle == null) {
                cellStyle = this.wb.createCellStyle();
                cacheAllStyle = true;
            }
        }
        if (style.containsKey("font_family")) {
            val2 = (String)style.get("font_family");
            cellFont.setFontName((String)val2);
        }
        if (style.containsKey("font_size")) {
            val2 = (Float)style.get("font_size");
            cellFont.setFontHeightInPoints(((Float)val2).shortValue());
        }
        if (style.containsKey("font_color")) {
            val2 = (Color)style.get("font_color");
            cellFont.setColor(ExcelColorSupport.getNearestColor((Color)val2));
        }
        if (style.containsKey("font_style_key")) {
            if ("font_stylet_normal".equals(style.get("font_style_key"))) {
                cellFont.setBoldweight((short)400);
            }
            if ("font_style_bold".equals(style.get("font_style_key"))) {
                cellFont.setBoldweight((short)700);
            }
            if ("font_style_italic".equals(style.get("font_style_key"))) {
                cellFont.setItalic(true);
            }
            if ("font_style_bold_italic".equals(style.get("font_style_key"))) {
                cellFont.setBoldweight((short)700);
                cellFont.setItalic(true);
            }
        }
        if (cacheFont && fontKey != -1) {
            this.condFonts.put(fontKey, cellFont);
        }
        if (cacheAllFont && fontKey != -1) {
            this.fonts.put(fontKey, cellFont);
        }
        if (style.containsKey("bg_color")) {
            val2 = (Color)style.get("bg_color");
            cellStyle.setFillPattern((short)1);
            cellStyle.setFillForegroundColor(ExcelColorSupport.getNearestColor((Color)val2));
        }
        if (style.containsKey("halign")) {
            if ("halign_left".equals(style.get("halign"))) {
                cellStyle.setAlignment((short)1);
            }
            if ("halign_right".equals(style.get("halign"))) {
                cellStyle.setAlignment((short)3);
            }
            if ("halign_center".equals(style.get("halign"))) {
                cellStyle.setAlignment((short)2);
            }
        }
        if (style.containsKey("valign")) {
            if ("valign_top".equals(style.get("valign"))) {
                cellStyle.setVerticalAlignment((short)0);
            }
            if ("valign_middle".equals(style.get("valign"))) {
                cellStyle.setVerticalAlignment((short)1);
            }
            if ("valign_bottom".equals(style.get("valign"))) {
                cellStyle.setVerticalAlignment((short)2);
            }
        } else {
            cellStyle.setVerticalAlignment((short)1);
        }
        short left = 0;
        short right = 0;
        short top = 0;
        short bottom = 0;
        Color leftColor = Color.BLACK;
        Color rightColor = Color.BLACK;
        Color topColor = Color.BLACK;
        Color bottomColor = Color.BLACK;
        if (style.containsKey("border_left")) {
            val = (Float)style.get("border_left");
            left = val.shortValue();
            if (left == 1) {
                cellStyle.setBorderLeft((short)1);
            }
            if (left == 2) {
                cellStyle.setBorderLeft((short)2);
            }
            if (left == 3) {
                cellStyle.setBorderLeft((short)5);
            }
            leftColor = color = (Color)style.get("border_left_color");
            cellStyle.setLeftBorderColor(ExcelColorSupport.getNearestColor(color));
        }
        if (style.containsKey("border_right")) {
            val = (Float)style.get("border_right");
            right = val.shortValue();
            if (right == 1) {
                cellStyle.setBorderRight((short)1);
            }
            if (right == 2) {
                cellStyle.setBorderRight((short)2);
            }
            if (right == 3) {
                cellStyle.setBorderRight((short)5);
            }
            rightColor = color = (Color)style.get("border_right_color");
            cellStyle.setRightBorderColor(ExcelColorSupport.getNearestColor(color));
        }
        if (style.containsKey("border_top")) {
            val = (Float)style.get("border_top");
            top = val.shortValue();
            if (top == 1) {
                cellStyle.setBorderTop((short)1);
            }
            if (top == 2) {
                cellStyle.setBorderTop((short)2);
            }
            if (top == 3) {
                cellStyle.setBorderTop((short)5);
            }
            topColor = color = (Color)style.get("border_top_color");
            cellStyle.setTopBorderColor(ExcelColorSupport.getNearestColor(color));
        }
        if (style.containsKey("border_bottom")) {
            val = (Float)style.get("border_bottom");
            bottom = val.shortValue();
            if (bottom == 1) {
                cellStyle.setBorderBottom((short)1);
            }
            if (bottom == 2) {
                cellStyle.setBorderBottom((short)2);
            }
            if (bottom == 3) {
                cellStyle.setBorderBottom((short)5);
            }
            bottomColor = color = (Color)style.get("border_bottom_color");
            cellStyle.setBottomBorderColor(ExcelColorSupport.getNearestColor(color));
        }
        this.border = new Border(left, right, top, bottom);
        this.border.setLeftColor(leftColor);
        this.border.setRightColor(rightColor);
        this.border.setTopColor(topColor);
        this.border.setBottomColor(bottomColor);
        if (cellFont != null) {
            cellStyle.setFont(cellFont);
        }
        if (style.containsKey("pattern")) {
            String pattern = (String)style.get("pattern");
            HSSFDataFormat format = this.wb.createDataFormat();
            cellStyle.setDataFormat(format.getFormat(pattern));
        } else {
            cellStyle.setDataFormat((short)0);
        }
        if (bandElement != null) {
            cellStyle.setWrapText(bandElement.isWrapText());
        }
        cellStyle = this.updateSubreportBandElementStyle(cellStyle, bandElement, value, gridRow, gridColumn, colSpan);
        if (cacheStyle && styleKey != -1) {
            this.condStyles.put(styleKey, cellStyle);
        }
        if (cacheAllStyle && styleKey != -1) {
            this.styles.put(styleKey, cellStyle);
        }
        return cellStyle;
    }

    private HSSFCellStyle updateSubreportBandElementStyle(HSSFCellStyle cellStyle, BandElement bandElement, Object value, int gridRow, int gridColumn, int colSpan) {
        if (this.subreportCellStyle == null) {
            return cellStyle;
        }
        if (gridColumn == 0) {
            cellStyle.setBorderLeft(this.subreportCellStyle.getBorderLeft());
            cellStyle.setLeftBorderColor(this.subreportCellStyle.getLeftBorderColor());
        } else if (gridColumn + colSpan - 1 == this.bean.getReportLayout().getColumnCount() - 1) {
            cellStyle.setBorderRight(this.subreportCellStyle.getBorderRight());
            cellStyle.setRightBorderColor(this.subreportCellStyle.getRightBorderColor());
        }
        if (this.pageRow == 0) {
            cellStyle.setBorderTop(this.subreportCellStyle.getBorderTop());
            cellStyle.setTopBorderColor(this.subreportCellStyle.getTopBorderColor());
        } else if (this.pageRow + 1 == this.getRowsCount()) {
            cellStyle.setBorderBottom(this.subreportCellStyle.getBorderBottom());
            cellStyle.setBottomBorderColor(this.subreportCellStyle.getBottomBorderColor());
        }
        return cellStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void renderCell(BandElement bandElement, String bandName, Object value, int gridRow, int sheetRow, int sheetColumn, int rowSpan, int colSpan, boolean image) {
        if (bandElement instanceof ReportBandElement) {
            colSpan = 1;
        }
        cellStyle = this.buildBandElementStyle(bandElement, value, gridRow, sheetColumn, colSpan);
        if ("Header".equals(bandName) && gridRow == this.prevSubreportFirstRow && this.prevSubreportLastColumn != -1) {
            sheetColumn = this.prevSubreportLastColumn - this.prevSubreportFirstColumn - 1 + sheetColumn;
        }
        c = this.xlsRow.createCell(sheetColumn);
        if (image) {
            if (value == null || "".equals(value)) {
                c.setCellType(1);
                c.setCellValue((RichTextString)new HSSFRichTextString(XlsExporter.IMAGE_NOT_FOUND));
            } else {
                try {
                    ibe = (ImageBandElement)bandElement;
                    imageBytes = this.getImage((String)value, ibe.getWidth(), ibe.getHeight());
                    anchor = new HSSFClientAnchor(0, 0, 0, 0, (short)sheetColumn, sheetRow, (short)(sheetColumn + colSpan), sheetRow + rowSpan);
                    index = this.wb.addPicture(imageBytes, 5);
                    height = this.xlsRow.getHeight();
                    realImageHeight = this.getRealImageSize((String)value)[1];
                    if (ibe.isScaled()) {
                        realImageHeight = ibe.getHeight();
                    }
                    if ((imageHeight = (short)((double)((float)realImageHeight * XlsExporter.POINTS_FOR_PIXEL) / 2.5)) > height) {
                        this.xlsRow.setHeight(imageHeight);
                    }
                    picture = this.patriarch.createPicture(anchor, index);
                    picture.resize();
                    anchor.setAnchorType(2);
                }
                catch (Exception ex) {
                    c.setCellType(1);
                    c.setCellValue((RichTextString)new HSSFRichTextString(XlsExporter.IMAGE_NOT_LOADED));
                }
            }
            if (cellStyle != null) {
                c.setCellStyle(cellStyle);
            }
        } else {
            block51: {
                if (bandElement instanceof HyperlinkBandElement) {
                    hyp = ((HyperlinkBandElement)bandElement).getHyperlink();
                    link = new HSSFHyperlink(1);
                    link.setAddress(hyp.getUrl());
                    c.setHyperlink((Hyperlink)link);
                    c.setCellValue((RichTextString)new HSSFRichTextString(hyp.getText()));
                    c.setCellType(1);
                } else if (bandElement instanceof ReportBandElement) {
                    report = ((ReportBandElement)bandElement).getReport();
                    eb = null;
                    try {
                        eb = this.getSubreportExporterBean(report, true);
                        subExporter = new XlsExporter(eb, cellStyle);
                        subExporter.export();
                        subreportSheet = subExporter.getSubreportSheet();
                        if ("Header".equals(bandName) && gridRow == this.prevSubreportFirstRow) {
                            sheetColumn = this.prevSubreportLastColumn;
                            sheetRow -= this.addedPageRows;
                            this.pageRow -= this.addedPageRows;
                            this.addedPageRows = 0;
                        } else {
                            this.addedPageRows = subreportSheet.getLastRowNum();
                            this.pageRow += this.addedPageRows;
                            if (sheetColumn > 0) {
                                for (i = 0; i <= sheetColumn - 1; ++i) {
                                    cra = new CellRangeAddress(sheetRow, this.pageRow, i, i);
                                    this.regions.add(new XlsRegion(cra, null));
                                }
                            }
                        }
                        cols = XlsUtil.copyToSheet(this.xlsSheet, sheetRow, sheetColumn, subreportSheet);
                        this.addRegions(this.xlsSheet, subExporter.getSubreportRegions(), this.wb);
                        if (!"Header".equals(bandName)) ** GOTO lbl142
                        this.prevSubreportFirstRow = gridRow;
                        this.prevSubreportFirstColumn = sheetColumn;
                        this.prevSubreportLastColumn = sheetColumn + cols;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (eb != null && eb.getResult() != null) {
                            eb.getResult().close();
                        }
                    }
                } else if (bandElement instanceof ImageColumnBandElement) {
                    try {
                        icbe = (ImageColumnBandElement)bandElement;
                        v = StringUtil.getValueAsString(value, null);
                        if (StringUtil.BLOB.equals(v)) {
                            c.setCellType(1);
                            c.setCellValue((RichTextString)new HSSFRichTextString(StringUtil.BLOB));
                            break block51;
                        }
                        imageD = StringUtil.decodeImage(v);
                        imageBytes = this.getImage(imageD, icbe.getWidth(), icbe.getHeight());
                        anchor = new HSSFClientAnchor(0, 0, 0, 0, (short)sheetColumn, sheetRow, (short)(sheetColumn + colSpan), sheetRow + rowSpan);
                        index = this.wb.addPicture(imageBytes, 5);
                        height = this.xlsRow.getHeight();
                        realImageHeight = this.getRealImageSize(imageBytes)[1];
                        if (icbe.isScaled()) {
                            realImageHeight = icbe.getHeight();
                        }
                        if ((imageHeight = (short)((double)((float)realImageHeight * XlsExporter.POINTS_FOR_PIXEL) / 2.5)) > height) {
                            this.xlsRow.setHeight(imageHeight);
                        }
                        picture = this.patriarch.createPicture(anchor, index);
                        picture.resize();
                        anchor.setAnchorType(2);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        c.setCellType(1);
                        c.setCellValue((RichTextString)new HSSFRichTextString(XlsExporter.IMAGE_NOT_LOADED));
                    }
                } else if (value == null) {
                    c.setCellType(1);
                    c.setCellValue((RichTextString)new HSSFRichTextString(""));
                } else if (value instanceof Number) {
                    c.setCellType(0);
                    c.setCellValue(((Number)value).doubleValue());
                } else {
                    pattern = null;
                    if (bandElement instanceof FieldBandElement) {
                        fbe = (FieldBandElement)bandElement;
                        pattern = fbe.getPattern();
                    }
                    if (value instanceof Date || value instanceof Timestamp) {
                        date /* !! */  = value instanceof Date != false ? new java.util.Date(((Date)value).getTime()) : (Timestamp)value;
                        if (cellStyle != null) {
                            if (pattern == null) {
                                locale = Locale.getDefault();
                                pattern = ((SimpleDateFormat)DateFormat.getDateInstance(2, locale)).toPattern();
                            } else {
                                pattern = StringUtil.getI18nString(pattern, this.getReportLanguage());
                            }
                            cellStyle.setDataFormat(this.wb.createDataFormat().getFormat(pattern));
                        }
                        c.setCellValue((java.util.Date)date /* !! */ );
                    } else {
                        c.setCellType(1);
                        text = StringUtil.getValueAsString(value, pattern);
                        if (bandElement != null && bandElement.isWrapText()) {
                            if (text.contains("\\n") || text.contains("\n") || text.contains("\r") || text.contains("\r\n")) {
                                crLf = Character.toString('\r') + Character.toString('\n');
                                lines = this.countLines(text);
                                text = text.contains("\r\n") != false ? text.replaceAll("\r\n", crLf) : text.replaceAll("(\n)|(\r)|(\\\\n)", crLf);
                                c.setCellValue(text);
                                cellStyle.setWrapText(true);
                                this.xlsRow.setHeightInPoints((float)(lines * (cellStyle.getFont((Workbook)this.wb).getFontHeightInPoints() + 3)));
                            } else {
                                c.setCellValue((RichTextString)new HSSFRichTextString(text));
                            }
                        } else {
                            c.setCellValue((RichTextString)new HSSFRichTextString(text));
                        }
                    }
                }
            }
            if (cellStyle != null) {
                if (bandElement != null) {
                    cellStyle.setRotation(bandElement.getTextRotation());
                }
                if (!(bandElement instanceof ReportBandElement)) {
                    c.setCellStyle(cellStyle);
                }
            }
            if (rowSpan > 1 || colSpan > 1) {
                cra = new CellRangeAddress(sheetRow, sheetRow + rowSpan - 1, sheetColumn, sheetColumn + colSpan - 1);
                beBorder = bandElement.getBorder();
                if (this.hasRowRenderConditions(bandElement, gridRow, value)) {
                    beBorder = this.border;
                }
                this.regions.add(new XlsRegion(cra, beBorder));
            }
        }
    }

    private int countLines(String text) {
        Matcher m = Pattern.compile("(\n)|(\r)|(\r\n)|(\\\\n)").matcher(text);
        int lines = 1;
        while (m.find()) {
            ++lines;
        }
        return lines;
    }

    private void renderCellToHeaderFooter(StringBuilder result, String bandName, BandElement bandElement, Object value, int gridRow, int row, int column, int cols, int rowSpan, int colSpan, boolean isImage) {
        PrefixSuffix pf;
        if (this.newRow) {
            result.append("\r\n ");
        } else {
            result.append(" ");
        }
        boolean specialCell = false;
        if (bandElement instanceof VariableBandElement) {
            VariableBandElement vbe = (VariableBandElement)bandElement;
            Variable var = VariableFactory.getVariable(vbe.getVariable());
            if (var instanceof PageNoVariable) {
                specialCell = true;
                result.append("&P");
            }
        } else if (bandElement instanceof ExpressionBandElement && (pf = this.interpretPageNo(bandElement)) != null) {
            result.append(pf.getPrefix()).append(" &P ").append(pf.getSuffix());
            specialCell = true;
        }
        if (!specialCell) {
            result.append(value);
        }
    }

    private short getXlsBorderValue(int border) {
        if (border == 1) {
            return 1;
        }
        if (border == 2) {
            return 2;
        }
        if (border == 3) {
            return 5;
        }
        return 0;
    }

    private void addRegions(HSSFSheet xlsSheet, List<XlsRegion> regions, HSSFWorkbook wb) {
        int size = regions.size();
        for (int r = 0; r < size; ++r) {
            short xlsRightBorder;
            short xlsLeftBorder;
            short xlsTopBorder;
            XlsRegion xlsRegion = regions.get(r);
            CellRangeAddress region = xlsRegion.getCellRangeAddress();
            Border border = xlsRegion.getBorder();
            xlsSheet.addMergedRegion(region);
            if (border == null) continue;
            short xlsBottomBorder = this.getXlsBorderValue(border.getBottom());
            if (xlsBottomBorder > 0) {
                HSSFRegionUtil.setBorderBottom((int)xlsBottomBorder, (CellRangeAddress)region, (HSSFSheet)xlsSheet, (HSSFWorkbook)wb);
                HSSFRegionUtil.setBottomBorderColor((int)ExcelColorSupport.getNearestColor(border.getBottomColor()), (CellRangeAddress)region, (HSSFSheet)xlsSheet, (HSSFWorkbook)wb);
            }
            if ((xlsTopBorder = this.getXlsBorderValue(border.getTop())) > 0) {
                HSSFRegionUtil.setBorderTop((int)xlsTopBorder, (CellRangeAddress)region, (HSSFSheet)xlsSheet, (HSSFWorkbook)wb);
                HSSFRegionUtil.setTopBorderColor((int)ExcelColorSupport.getNearestColor(border.getTopColor()), (CellRangeAddress)region, (HSSFSheet)xlsSheet, (HSSFWorkbook)wb);
            }
            if ((xlsLeftBorder = this.getXlsBorderValue(border.getLeft())) > 0) {
                HSSFRegionUtil.setBorderLeft((int)xlsLeftBorder, (CellRangeAddress)region, (HSSFSheet)xlsSheet, (HSSFWorkbook)wb);
                HSSFRegionUtil.setLeftBorderColor((int)ExcelColorSupport.getNearestColor(border.getLeftColor()), (CellRangeAddress)region, (HSSFSheet)xlsSheet, (HSSFWorkbook)wb);
            }
            if ((xlsRightBorder = this.getXlsBorderValue(border.getRight())) <= 0) continue;
            HSSFRegionUtil.setBorderRight((int)xlsRightBorder, (CellRangeAddress)region, (HSSFSheet)xlsSheet, (HSSFWorkbook)wb);
            HSSFRegionUtil.setRightBorderColor((int)ExcelColorSupport.getNearestColor(border.getRightColor()), (CellRangeAddress)region, (HSSFSheet)xlsSheet, (HSSFWorkbook)wb);
        }
        regions.clear();
    }

    @Override
    protected void newPage() {
        this.addRegions(this.xlsSheet, this.regions, this.wb);
        if (this.hasTemplate()) {
            this.xlsSheet = this.wb.getSheetAt(this.bean.getReportLayout().getTemplateSheet() - 1);
        } else {
            String sheetName = this.replaceSheetNameParam(this.bean.getReportLayout().getSheetNames());
            if (sheetName == null || sheetName.isEmpty()) {
                sheetName = String.valueOf(this.page);
            }
            if (this.sheetNameContainsGroup(this.bean.getReportLayout().getSheetNames()) && this.page > 1) {
                this.xlsSheet = this.wb.createSheet(String.valueOf(this.page));
                this.wb.setSheetName(this.page - 2, sheetName);
            } else {
                this.xlsSheet = this.wb.createSheet(sheetName);
            }
        }
        this.xlsSheet.setMargin((short)0, (double)this.getInches(this.bean.getReportLayout().getPagePadding().getLeft()));
        this.xlsSheet.setMargin((short)1, (double)this.getInches(this.bean.getReportLayout().getPagePadding().getRight()));
        this.xlsSheet.setMargin((short)2, (double)this.getInches(this.bean.getReportLayout().getPagePadding().getTop()));
        this.xlsSheet.setMargin((short)3, (double)this.getInches(this.bean.getReportLayout().getPagePadding().getBottom()));
        if (this.bean.getReportLayout().getOrientation() == 1) {
            this.xlsSheet.getPrintSetup().setLandscape(true);
        }
        this.setPaperSize();
        this.patriarch = this.xlsSheet.createDrawingPatriarch();
        this.buildHeader();
        this.buildFooter();
        ++this.page;
        if (this.bean.getReportLayout().isHeaderOnEveryPage() && this.page > 2) {
            try {
                this.printHeaderBand();
            }
            catch (QueryException e) {
                e.printStackTrace();
            }
        }
    }

    private void setPaperSize() {
        String pageFormat = this.bean.getReportLayout().getPageFormat();
        int size = 0;
        if ("LETTER".equals(pageFormat)) {
            size = 1;
        } else if ("A3".equals(pageFormat)) {
            size = 8;
        } else if ("A4".equals(pageFormat)) {
            size = 9;
        } else if ("LEGAL".equals(pageFormat)) {
            size = 5;
        } else if ("LEDGER".equals(pageFormat)) {
            size = 4;
        } else if ("TABLOID".equals(pageFormat)) {
            size = 3;
        }
        if (size != 0) {
            this.xlsSheet.getPrintSetup().setPaperSize((short)size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildHeader() {
        if (this.bean.getReportLayout().getPageHeaderBand().getColumnCount() == 0) {
            return;
        }
        try {
            this.printPageHeaderBand();
            HSSFHeader header = this.xlsSheet.getHeader();
            header.setCenter(this.headerS.toString());
        }
        catch (QueryException ex) {
            ex.printStackTrace();
        }
        finally {
            this.headerS = new StringBuilder();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildFooter() {
        if (this.bean.getReportLayout().getPageFooterBand().getColumnCount() == 0) {
            return;
        }
        try {
            this.printPageFooterBand();
            HSSFFooter footer = this.xlsSheet.getFooter();
            footer.setCenter(this.footerS.toString());
        }
        catch (QueryException ex) {
            ex.printStackTrace();
        }
        finally {
            this.footerS = new StringBuilder();
        }
    }

    public float getInches(int pixels) {
        return (float)pixels / (float)XlsExporter.getDPI();
    }

    private int getFontKey(Map<String, Object> style) {
        Object val;
        int prime = 31;
        int hashCode = 1;
        if (style.containsKey("font_family")) {
            val = (String)style.get("font_family");
            hashCode = 31 * hashCode + ((String)val).hashCode();
        }
        if (style.containsKey("font_size")) {
            val = (Float)style.get("font_size");
            hashCode = 31 * hashCode + ((Float)val).hashCode();
        }
        if (style.containsKey("font_color")) {
            val = (Color)style.get("font_color");
            hashCode = 31 * hashCode + ((Color)val).hashCode();
        }
        if (style.containsKey("font_style_key")) {
            val = (String)style.get("font_style_key");
            hashCode = 31 * hashCode + ((String)val).hashCode();
        }
        return hashCode;
    }

    private int getStyleKey(Map<String, Object> style, BandElement bandElement) {
        Object val;
        int prime = 31;
        int hashCode = this.getFontKey(style);
        if (style.containsKey("bg_color")) {
            val = (Color)style.get("bg_color");
            hashCode = 31 * hashCode + ((Color)val).hashCode() * 3;
        }
        if (style.containsKey("halign")) {
            val = (String)style.get("halign");
            hashCode = 31 * hashCode + ((String)val).hashCode();
        }
        if (style.containsKey("valign")) {
            val = (String)style.get("valign");
            hashCode = 31 * hashCode + ((String)val).hashCode();
        }
        if (style.containsKey("border_left")) {
            val = Float.valueOf(((Float)style.get("border_left")).floatValue() * 23.0f);
            hashCode = 31 * hashCode + ((Float)val).hashCode();
        }
        if (style.containsKey("border_right")) {
            val = Float.valueOf(((Float)style.get("border_right")).floatValue() * 29.0f);
            hashCode = 31 * hashCode + ((Float)val).hashCode();
        }
        if (style.containsKey("border_top")) {
            val = Float.valueOf(((Float)style.get("border_top")).floatValue() * 31.0f);
            hashCode = 31 * hashCode + ((Float)val).hashCode();
        }
        if (style.containsKey("border_bottom")) {
            val = Float.valueOf(((Float)style.get("border_bottom")).floatValue() * 37.0f);
            hashCode = 31 * hashCode + ((Float)val).hashCode();
        }
        if (style.containsKey("border_left_color")) {
            val = (Color)style.get("border_left_color");
            hashCode = 31 * hashCode + ((Color)val).hashCode() * 5;
        }
        if (style.containsKey("border_right_color")) {
            val = (Color)style.get("border_right_color");
            hashCode = 31 * hashCode + ((Color)val).hashCode() * 7;
        }
        if (style.containsKey("border_top_color")) {
            val = (Color)style.get("border_top_color");
            hashCode = 31 * hashCode + ((Color)val).hashCode() * 11;
        }
        if (style.containsKey("border_bottom_color")) {
            val = (Color)style.get("border_bottom_color");
            hashCode = 31 * hashCode + ((Color)val).hashCode() * 13;
        }
        if (style.containsKey("pattern")) {
            val = (String)style.get("pattern");
            hashCode = 31 * hashCode + ((String)val).hashCode() * 17;
        }
        if (bandElement != null) {
            hashCode = 31 * hashCode + (bandElement.isWrapText() ? 19 : 41);
        }
        return hashCode;
    }

    public HSSFSheet getSubreportSheet() {
        return this.xlsSheet;
    }

    public List<XlsRegion> getSubreportRegions() {
        return this.regions;
    }

    private InputStream getTemplateInputStream() throws IOException {
        LOG.info((Object)(">>>>>>>>> Look for : " + this.bean.getReportLayout().getTemplateName()));
        InputStream is = this.getClass().getResourceAsStream("/" + this.bean.getReportLayout().getTemplateName());
        if (is == null) {
            LOG.error((Object)("Template '" + this.bean.getReportLayout().getTemplateName() + "' not found in classpath."));
            throw new IOException("Template '" + this.bean.getReportLayout().getTemplateName() + "' not found.");
        }
        LOG.info((Object)(">>>>>>>>> Found template: " + this.bean.getReportLayout().getTemplateName()));
        return is;
    }

    private boolean hasTemplate() {
        return this.bean.getReportLayout().getTemplateName() != null && !"".equals(this.bean.getReportLayout().getTemplateName().trim());
    }

    private String replaceSheetNameParam(String sheetName) {
        String actualName = sheetName;
        if (actualName == null) {
            actualName = String.valueOf(this.page);
        } else if (sheetName.contains("${NO}")) {
            actualName = StringUtil.replace(sheetName, "\\$\\{NO\\}", String.valueOf(this.page));
        } else if (sheetName.contains("${G")) {
            int startIndex = sheetName.indexOf("${");
            int endIndex = sheetName.indexOf("}");
            String group = sheetName.substring(startIndex + 2, endIndex);
            actualName = StringUtil.replace(sheetName, "\\$\\{" + group + "\\}", this.getCurrentValueForGroup(group));
            if (actualName.isEmpty()) {
                actualName = String.valueOf(this.page);
            }
        } else {
            String[] names;
            actualName = sheetName.contains(";") ? ((names = sheetName.split(";")).length < this.page ? String.valueOf(this.page) : names[this.page - 1]) : String.valueOf(this.page);
        }
        return actualName;
    }

    private boolean sheetNameContainsGroup(String sheetName) {
        if (sheetName == null) {
            return false;
        }
        return sheetName.contains("${G");
    }

    private class XlsRegion {
        private CellRangeAddress cra;
        private Border border;

        private XlsRegion(CellRangeAddress cra, Border border) {
            this.cra = cra;
            this.border = border;
        }

        public CellRangeAddress getCellRangeAddress() {
            return this.cra;
        }

        public Border getBorder() {
            return this.border;
        }
    }
}

