/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.exporter;

import com.thoughtworks.xstream.core.util.Base64Encoder;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import ro.nextreports.engine.ReleaseInfoAdapter;
import ro.nextreports.engine.Report;
import ro.nextreports.engine.band.Band;
import ro.nextreports.engine.band.BandElement;
import ro.nextreports.engine.band.ColumnBandElement;
import ro.nextreports.engine.band.ExpressionBandElement;
import ro.nextreports.engine.band.FunctionBandElement;
import ro.nextreports.engine.band.Hyperlink;
import ro.nextreports.engine.band.HyperlinkBandElement;
import ro.nextreports.engine.band.ImageBandElement;
import ro.nextreports.engine.band.ParameterBandElement;
import ro.nextreports.engine.band.ReportBandElement;
import ro.nextreports.engine.band.VariableBandElement;
import ro.nextreports.engine.exporter.CellElement;
import ro.nextreports.engine.exporter.ExporterBean;
import ro.nextreports.engine.exporter.ResultExporter;
import ro.nextreports.engine.queryexec.QueryException;
import ro.nextreports.engine.queryexec.QueryResult;
import ro.nextreports.engine.util.StringUtil;

public class XmlExporter
extends ResultExporter {
    private String space = "_x0020_";
    private static final String DOCUMENT_TAG = "document";
    private static final String RECORD_TAG = "record";
    private static final String IMAGE_TAG = "image";
    private static final String TEXT_TAG = "text";
    private static final String lineSeparator = " \r\n";
    private PrintStream stream;
    private int currentRow = this.resultSetRow;

    public XmlExporter(ExporterBean bean) {
        super(bean);
    }

    @Override
    protected void initExport() throws QueryException {
        this.stream = this.createPrintStream();
        if (!this.bean.isSubreport()) {
            this.stream.print("<?xml version=\"1.0\" standalone=\"yes\"?>");
            this.stream.print(lineSeparator);
            this.stream.print("<document>");
            this.stream.print(lineSeparator);
            this.stream.print(this.getMetaData());
        }
    }

    @Override
    protected void finishExport() {
        if (!this.bean.isSubreport()) {
            this.stream.print("</document>");
            this.stream.print(lineSeparator);
        }
        this.stream.flush();
        if (!this.bean.isSubreport()) {
            this.stream.close();
        }
    }

    @Override
    protected void close() {
        if (!this.bean.isSubreport()) {
            this.stream.close();
        }
    }

    @Override
    protected void flush() {
        if (this.resultSetRow % 7500 == 0) {
            this.flushNow();
        }
    }

    @Override
    protected void flushNow() {
        this.stream.flush();
    }

    @Override
    protected Set<CellElement> getIgnoredCells(Band band) {
        return new HashSet<CellElement>();
    }

    @Override
    protected void printRawRecord() throws QueryException {
        QueryResult qr = this.getResult();
        int columns = qr.getColumnCount();
        this.stream.print("\t<record>");
        this.stream.print(lineSeparator);
        for (int i = 0; i < columns; ++i) {
            String name = qr.getColumnName(i);
            Object value = qr.nextValue(name);
            name = name.replaceAll(" ", this.space);
            this.stream.print("\t\t<");
            this.stream.print(name);
            this.stream.print(">");
            this.stream.print(value);
            this.stream.print("</");
            this.stream.print(name);
            this.stream.print(">");
            this.stream.print(lineSeparator);
        }
        this.stream.print("\t</record>");
        this.stream.print(lineSeparator);
    }

    private String getMetaData() {
        StringBuilder sb = new StringBuilder();
        sb.append("\t<meta name=\"author\" content=\"").append(ReleaseInfoAdapter.getCompany()).append("\"/>").append(lineSeparator);
        sb.append("\t<meta name=\"creator\" content=\"").append("NextReports ").append(ReleaseInfoAdapter.getVersionNumber()).append("\"/>").append(lineSeparator);
        sb.append("\t<meta name=\"subject\" content=\"").append("Created by NextReports Designer ").append(ReleaseInfoAdapter.getVersionNumber()).append("\"/>").append(lineSeparator);
        sb.append("\t<meta name=\"date\" content=\"").append(new Date()).append("\"/>").append(lineSeparator);
        sb.append("\t<meta name=\"keywords\" content=\"").append(ReleaseInfoAdapter.getHome()).append("\"/>").append(lineSeparator);
        return sb.toString();
    }

    @Override
    protected void exportCell(String bandName, BandElement bandElement, Object value, int gridRow, int row, int column, int cols, int rowSpan, int colSpan, boolean isImage) {
        String val;
        if (this.bean.isRawPrint()) {
            return;
        }
        if (this.newRow) {
            this.stream.print("\t<record>");
            this.stream.print(lineSeparator);
        }
        if (isImage) {
            val = (String)value;
        } else {
            val = this.getStringValue(value, this.getPattern(bandElement));
            val = val.replaceAll("& ", "&amp; ");
            val = val.replaceAll("<", "&lt;");
            val = val.replaceAll(">", "&gt;");
            val = val.replaceAll("\"", "&quot;");
            val = val.replaceAll("'", "&apos;");
        }
        this.stream.print("\t\t");
        this.stream.print(this.getTag(bandName, row, column, val, rowSpan, colSpan, bandElement, isImage));
        this.stream.print(lineSeparator);
        if (column == cols - 1) {
            this.stream.print("\t</record>");
            this.stream.print(lineSeparator);
            if (colSpan == cols && rowSpan > 1) {
                for (int i = 0; i < rowSpan - 1; ++i) {
                    this.stream.print(this.getEmptyRow(colSpan));
                }
            }
        }
    }

    private String getStringValue(Object val, String pattern) {
        String v = StringUtil.getValueAsString(val, pattern, this.getReportLanguage());
        if (v == null) {
            return this.getNullElement();
        }
        return v;
    }

    @Override
    protected void afterRowExport() {
    }

    @Override
    protected String getNullElement() {
        return "";
    }

    private String getEmptyRow(int colSpan) {
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(RECORD_TAG).append(">").append(this.getNullElement()).append("</").append(RECORD_TAG).append(">").append(lineSeparator);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTag(String bandName, int i, int j, String value, int rowSpan, int colSpan, BandElement bandElement, boolean image) {
        if (bandElement == null) {
            return this.getNullElement();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTag(bandElement, true));
        String result = "";
        if (image) {
            if (value != null) {
                try {
                    byte[] imageBytes = this.getImage(value);
                    result = this.getBinaryDataForXml(imageBytes);
                }
                catch (Exception e) {}
            }
        } else if (bandElement instanceof HyperlinkBandElement) {
            Hyperlink hyperlink = ((HyperlinkBandElement)bandElement).getHyperlink();
            result = hyperlink.getUrl();
        } else if (bandElement instanceof ReportBandElement) {
            Report report = ((ReportBandElement)bandElement).getReport();
            ExporterBean eb = null;
            try {
                eb = this.getSubreportExporterBean(report);
                XmlExporter subExporter = new XmlExporter(eb);
                subExporter.export();
                result = subExporter.getSubreportData();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (eb != null && eb.getResult() != null) {
                    eb.getResult().close();
                }
            }
        } else {
            result = StringUtil.getValueAsString(value, null, this.getReportLanguage());
            if (result == null) {
                result = this.getNullElement();
            }
        }
        sb.append(result);
        sb.append(this.getTag(bandElement, false));
        return sb.toString();
    }

    private String getTag(BandElement be, boolean start) {
        StringBuilder sb = new StringBuilder();
        if (start) {
            sb.append("<");
        } else {
            sb.append("</");
        }
        String tagName = be instanceof ColumnBandElement ? ((ColumnBandElement)be).getColumn() : (be instanceof FunctionBandElement ? ((FunctionBandElement)be).getFunction() : (be instanceof ExpressionBandElement ? ((ExpressionBandElement)be).getExpressionName() : (be instanceof HyperlinkBandElement ? ((HyperlinkBandElement)be).getName() : (be instanceof ImageBandElement ? IMAGE_TAG : (be instanceof ParameterBandElement ? ((ParameterBandElement)be).getParameter() : (be instanceof VariableBandElement ? ((VariableBandElement)be).getVariable() : TEXT_TAG))))));
        tagName = tagName.replaceAll("& ", "&amp; ");
        tagName = tagName.replaceAll("<", "&lt;");
        tagName = tagName.replaceAll(">", "&gt;");
        tagName = tagName.replaceAll("\"", "&quot;");
        tagName = tagName.replaceAll("'", "&apos;");
        tagName = tagName.replaceAll(" ", this.space);
        sb.append(tagName);
        sb.append(">");
        return sb.toString();
    }

    public String getBinaryDataForXml(byte[] buffer) {
        StringBuffer hexData = new StringBuffer();
        Base64Encoder encoder = new Base64Encoder();
        return encoder.encode(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSubreportData() {
        try {
            String string = this.subreportStream.toString("UTF-8");
            return string;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            String string = "";
            return string;
        }
        finally {
            this.stream.close();
        }
    }
}

