/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.exporter.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.Color;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import ro.nextreports.engine.util.ColorUtil;

public class AlarmData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String color;
    private String text;
    private boolean shadow;

    public AlarmData() {
        this.color = ColorUtil.getHexColor(Color.WHITE);
        this.text = "";
        this.shadow = false;
    }

    public AlarmData(String color, String text) {
        this.color = color;
        this.text = text;
        this.shadow = false;
    }

    public String getColor() {
        return this.color;
    }

    public String getText() {
        return this.text;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean isShadow() {
        return this.shadow;
    }

    public void setShadow(boolean shadow) {
        this.shadow = shadow;
    }

    public String toString() {
        return this.text;
    }

    public String toJson() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        StringWriter writer = new StringWriter();
        try {
            mapper.writeValue((Writer)writer, (Object)this);
            return writer.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "Error : " + ex.getMessage();
        }
    }
}

