/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.exporter.util;

import java.awt.Color;
import java.util.Hashtable;
import org.apache.poi.hssf.util.HSSFColor;

public final class ExcelColorSupport {
    private static Hashtable triplets;

    private ExcelColorSupport() {
    }

    public static synchronized short getNearestColor(Color awtColor) {
        if (triplets == null) {
            triplets = HSSFColor.getTripletHash();
        }
        if (triplets == null || triplets.isEmpty()) {
            System.out.println("Unable to get triplet hashtable");
            return 8;
        }
        short color = 8;
        double minDiff = Double.MAX_VALUE;
        float[] hsb = Color.RGBtoHSB(awtColor.getRed(), awtColor.getGreen(), awtColor.getBlue(), null);
        float[] excelHsb = null;
        for (HSSFColor crtColor : triplets.values()) {
            short[] rgb = crtColor.getTriplet();
            excelHsb = Color.RGBtoHSB(rgb[0], rgb[1], rgb[2], excelHsb);
            double weight = 3.0 * (double)Math.abs(excelHsb[0] - hsb[0]) + (double)Math.abs(excelHsb[1] - hsb[1]) + (double)Math.abs(excelHsb[2] - hsb[2]);
            if (!(weight < minDiff)) continue;
            minDiff = weight;
            if (minDiff == 0.0) {
                return crtColor.getIndex();
            }
            color = crtColor.getIndex();
        }
        return color;
    }
}

