/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.exporter.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.nextreports.engine.queryexec.Query;
import ro.nextreports.engine.queryexec.QueryParameter;

public class ParametersBean {
    private Query query;
    private Map<String, QueryParameter> params;
    private Map<String, Object> paramValues;

    public ParametersBean(Query query, Map<String, QueryParameter> params, Map<String, Object> paramValues) {
        this.query = query;
        this.params = params;
        this.paramValues = paramValues;
    }

    public Query getQuery() {
        return this.query;
    }

    public Map<String, QueryParameter> getParams() {
        return this.params;
    }

    public Map<String, QueryParameter> getSubreportParams() {
        HashMap<String, QueryParameter> subreportsParams = new HashMap<String, QueryParameter>();
        for (QueryParameter qp : this.params.values()) {
            if (!qp.isSubreportParameter()) continue;
            subreportsParams.put(qp.getName(), qp);
        }
        return subreportsParams;
    }

    public Map<String, Object> getParamValues() {
        return this.paramValues;
    }

    public void addSubreportParameters(List<QueryParameter> parameters) {
        for (QueryParameter qp : parameters) {
            qp.setSubreportParameter(true);
            this.params.put(qp.getName(), qp);
        }
    }

    public void addNotFoundSubreportParameters(List<QueryParameter> parameters) {
        for (QueryParameter qp : parameters) {
            qp.setSubreportParameter(true);
            if (this.params.containsKey(qp.getName())) continue;
            this.params.put(qp.getName(), qp);
        }
    }

    public void overwriteSubreportParametersValues(Map<String, Object> values) {
        for (String paramName : values.keySet()) {
            this.paramValues.put(paramName, values.get(paramName));
        }
    }

    public void setParameterValue(String name, Object value) {
        this.paramValues.put(name, value);
    }
}

