/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.exporter.util;

public class RomanNumberConverter {
    private static final String[] LETTERS = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
    private static final int[] VALUES = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};

    public static String romanize(int value) {
        String roman = "";
        int n = value;
        for (int i = 0; i < LETTERS.length; ++i) {
            while (n >= VALUES[i]) {
                roman = roman + LETTERS[i];
                n -= VALUES[i];
            }
        }
        return roman;
    }

    public static int numberize(String roman) {
        int start = 0;
        int value = 0;
        for (int i = 0; i < LETTERS.length; ++i) {
            while (roman.startsWith(LETTERS[i], start)) {
                value += VALUES[i];
                start += LETTERS[i].length();
            }
        }
        return start == roman.length() ? value : -1;
    }

    public static boolean isRoman(String roman) {
        return roman.equals(RomanNumberConverter.romanize(RomanNumberConverter.numberize(roman)));
    }
}

