/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.exporter.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ro.nextreports.engine.i18n.I18nLanguage;

public class TableData
implements Serializable {
    private List<String> header;
    private List<List<Object>> data;
    private List<List<Map<String, Object>>> style;
    private I18nLanguage language;
    private List<String> pattern;
    private List<Integer> excludedColumns;
    public static int SEARCH_TO_TOP = 1;
    public static int SEARCH_ONLY = 2;

    public TableData() {
        this.header = new ArrayList<String>();
        this.data = new ArrayList<List<Object>>();
        this.style = new ArrayList<List<Map<String, Object>>>();
        this.pattern = new ArrayList<String>();
    }

    public TableData(List<String> header, List<List<Object>> data, List<List<Map<String, Object>>> style) {
        this.header = header;
        int size = header.size();
        for (int i = 0; i < size; ++i) {
            this.pattern.add(null);
        }
        this.data = data;
        this.style = style;
    }

    public I18nLanguage getLanguage() {
        return this.language;
    }

    public void setLanguage(I18nLanguage language) {
        this.language = language;
    }

    public List<String> getPattern() {
        return this.pattern;
    }

    public void setPattern(List<String> pattern) {
        this.pattern = pattern;
    }

    public List<String> getHeader() {
        return this.header;
    }

    public List<List<Object>> getData() {
        return this.data;
    }

    public List<List<Map<String, Object>>> getStyle() {
        return this.style;
    }

    public void setHeader(List<String> header) {
        this.header = header;
        this.pattern.clear();
        int size = header.size();
        for (int i = 0; i < size; ++i) {
            this.pattern.add(null);
        }
    }

    public void setData(List<List<Object>> data) {
        this.data = data;
    }

    public void setStyle(List<List<Map<String, Object>>> style) {
        this.style = style;
    }

    public List<Integer> getExcludedColumns() {
        return this.excludedColumns;
    }

    public void setExcludedColumns(List<Integer> excludedColumns) {
        this.excludedColumns = excludedColumns;
    }

    private void moveRowToPosition(int rowIndex, int position) {
        if (this.data != null && this.data.size() > rowIndex) {
            List<Object> rowToMove = this.data.get(rowIndex);
            this.data.remove(rowIndex);
            this.data.add(position, rowToMove);
            if (this.style != null) {
                List<Map<String, Object>> styleToMove = this.style.get(rowIndex);
                this.style.remove(rowIndex);
                this.style.add(position, styleToMove);
            }
        }
    }

    public void search(List<Object> tableFilter) {
        this.search(tableFilter, SEARCH_ONLY);
    }

    public void search(List<Object> tableFilter, int algorithm) {
        block6: {
            int position = 0;
            if (tableFilter == null || this.hasOnlyNullValues(tableFilter)) break block6;
            if (algorithm == SEARCH_TO_TOP) {
                int size = this.data.size();
                for (int i = 0; i < size; ++i) {
                    List<Object> row = this.data.get(i);
                    boolean found = true;
                    int no = tableFilter.size();
                    for (int j = 0; j < no; ++j) {
                        Object t = tableFilter.get(j);
                        if (t == null) continue;
                        Object o = row.get(j);
                        if (t == null || o != null && o.toString().toLowerCase().contains(t.toString().toLowerCase())) continue;
                        found = false;
                        break;
                    }
                    if (!found) continue;
                    this.moveRowToPosition(i, position);
                    ++position;
                }
            } else {
                Iterator<List<Object>> it = this.data.iterator();
                while (it.hasNext()) {
                    List<Object> row = it.next();
                    boolean kept = true;
                    int no = tableFilter.size();
                    for (int j = 0; j < no; ++j) {
                        Object o;
                        Object t = tableFilter.get(j);
                        if (t == null || (o = row.get(j)) != null && o.toString().toLowerCase().contains(t.toString().toLowerCase())) continue;
                        kept = false;
                        break;
                    }
                    if (kept) continue;
                    it.remove();
                }
            }
        }
    }

    private boolean hasOnlyNullValues(List<Object> list) {
        if (list == null) {
            return true;
        }
        boolean result = true;
        for (Object obj : list) {
            if (obj == null) continue;
            result = false;
            break;
        }
        return result;
    }
}

