/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.exporter.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import ro.nextreports.engine.exporter.util.CellRangeAddressWrapper;

public class XlsxUtil {
    private XlsxUtil() {
    }

    public static int copyToSheet(XSSFSheet parentSheet, int parentSheetRow, int parentSheetColumn, XSSFSheet sheet) {
        return XlsxUtil.copyToSheet(parentSheet, parentSheetRow, parentSheetColumn, sheet, true);
    }

    public static int copyToSheet(XSSFSheet parentSheet, int parentSheetRow, int parentSheetColumn, XSSFSheet sheet, boolean copyStyle) {
        int i;
        int maxColumnNum = 0;
        HashMap<Integer, CellStyle> styleMap = copyStyle ? new HashMap<Integer, CellStyle>() : null;
        for (i = sheet.getFirstRowNum(); i <= sheet.getLastRowNum(); ++i) {
            XSSFRow destRow;
            XSSFRow srcRow = sheet.getRow(i);
            if (parentSheetColumn > 0 && i == sheet.getFirstRowNum()) {
                destRow = parentSheet.getRow(parentSheetRow);
            } else {
                destRow = parentSheet.getRow(parentSheetRow + i);
                if (destRow == null) {
                    destRow = parentSheet.createRow(parentSheetRow + i);
                }
            }
            if (srcRow == null) continue;
            XlsxUtil.copyRow(sheet, parentSheet, parentSheetRow, parentSheetColumn, srcRow, destRow, styleMap);
            if (srcRow.getLastCellNum() <= maxColumnNum) continue;
            maxColumnNum = srcRow.getLastCellNum();
        }
        for (i = 0; i <= maxColumnNum; ++i) {
            parentSheet.setColumnWidth(i, sheet.getColumnWidth(i));
        }
        return maxColumnNum;
    }

    public static void copyRow(XSSFSheet srcSheet, XSSFSheet destSheet, int parentSheetRow, int parentSheetColumn, XSSFRow srcRow, XSSFRow destRow, Map<Integer, CellStyle> styleMap) {
        TreeSet<CellRangeAddressWrapper> mergedRegions = new TreeSet<CellRangeAddressWrapper>();
        destRow.setHeight(srcRow.getHeight());
        for (int j = srcRow.getFirstCellNum(); j <= srcRow.getLastCellNum(); ++j) {
            CellRangeAddress newMergedRegion;
            CellRangeAddressWrapper wrapper;
            XSSFCell oldCell = srcRow.getCell(j);
            if (oldCell == null) continue;
            XSSFCell newCell = destRow.createCell(parentSheetColumn + j);
            XlsxUtil.copyCell(oldCell, newCell, styleMap);
            CellRangeAddress mergedRegion = XlsxUtil.getMergedRegion(srcSheet, srcRow.getRowNum(), (short)oldCell.getColumnIndex());
            if (mergedRegion == null || !XlsxUtil.isNewMergedRegion(wrapper = new CellRangeAddressWrapper(newMergedRegion = new CellRangeAddress(parentSheetRow + mergedRegion.getFirstRow(), parentSheetRow + mergedRegion.getLastRow(), parentSheetColumn + mergedRegion.getFirstColumn(), parentSheetColumn + mergedRegion.getLastColumn())), mergedRegions)) continue;
            mergedRegions.add(wrapper);
            destSheet.addMergedRegion(wrapper.range);
        }
    }

    public static void copyCell(XSSFCell oldCell, XSSFCell newCell, Map<Integer, CellStyle> styleMap) {
        if (styleMap != null) {
            if (oldCell.getSheet().getWorkbook() == newCell.getSheet().getWorkbook()) {
                newCell.setCellStyle((CellStyle)oldCell.getCellStyle());
            } else {
                int stHashCode = oldCell.getCellStyle().hashCode();
                CellStyle newCellStyle = styleMap.get(stHashCode);
                if (newCellStyle == null) {
                    newCellStyle = newCell.getSheet().getWorkbook().createCellStyle();
                    newCellStyle.cloneStyleFrom((CellStyle)oldCell.getCellStyle());
                    styleMap.put(stHashCode, newCellStyle);
                }
                newCell.setCellStyle(newCellStyle);
            }
        }
        switch (oldCell.getCellType()) {
            case 1: {
                newCell.setCellValue(oldCell.getStringCellValue());
                break;
            }
            case 0: {
                newCell.setCellValue(oldCell.getNumericCellValue());
                break;
            }
            case 3: {
                newCell.setCellType(3);
                break;
            }
            case 4: {
                newCell.setCellValue(oldCell.getBooleanCellValue());
                break;
            }
            case 5: {
                newCell.setCellErrorValue(oldCell.getErrorCellValue());
                break;
            }
            case 2: {
                newCell.setCellFormula(oldCell.getCellFormula());
                break;
            }
        }
    }

    public static CellRangeAddress getMergedRegion(XSSFSheet sheet, int rowNum, short cellNum) {
        for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
            CellRangeAddress merged = sheet.getMergedRegion(i);
            if (!merged.isInRange(rowNum, (int)cellNum)) continue;
            return merged;
        }
        return null;
    }

    private static boolean isNewMergedRegion(CellRangeAddressWrapper newMergedRegion, Set<CellRangeAddressWrapper> mergedRegions) {
        return !mergedRegions.contains(newMergedRegion);
    }
}

