/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.exporter.util.function;

import java.util.ArrayList;
import java.util.List;
import ro.nextreports.engine.exporter.util.function.AverageFunction;
import ro.nextreports.engine.exporter.util.function.CountDistinctFunction;
import ro.nextreports.engine.exporter.util.function.CountFunction;
import ro.nextreports.engine.exporter.util.function.GFunction;
import ro.nextreports.engine.exporter.util.function.MaxFunction;
import ro.nextreports.engine.exporter.util.function.MinFunction;
import ro.nextreports.engine.exporter.util.function.NoopFunction;
import ro.nextreports.engine.exporter.util.function.SumFunction;

public class FunctionFactory {
    public static GFunction getFunction(String functionName) {
        if ("MIN".equalsIgnoreCase(functionName)) {
            return new MinFunction();
        }
        if ("MAX".equalsIgnoreCase(functionName)) {
            return new MaxFunction();
        }
        if ("AVERAGE".equalsIgnoreCase(functionName)) {
            return new AverageFunction();
        }
        if ("COUNT".equalsIgnoreCase(functionName)) {
            return new CountFunction();
        }
        if ("COUNT DISTINCT".equalsIgnoreCase(functionName)) {
            return new CountDistinctFunction();
        }
        if ("SUM".equalsIgnoreCase(functionName)) {
            return new SumFunction();
        }
        if ("NOOP".equalsIgnoreCase(functionName)) {
            return new NoopFunction();
        }
        throw new IllegalArgumentException("Function '" + functionName + "' is not defined!");
    }

    public static List<String> getAllFunctionNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("NOOP");
        names.addAll(FunctionFactory.getFunctionNames());
        return names;
    }

    public static List<String> getFunctionNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("SUM");
        names.add("MIN");
        names.add("MAX");
        names.add("AVERAGE");
        names.add("COUNT");
        names.add("COUNT DISTINCT");
        return names;
    }

    public static List<GFunction> getFunctions() {
        ArrayList<GFunction> functions = new ArrayList<GFunction>();
        for (String name : FunctionFactory.getAllFunctionNames()) {
            functions.add(FunctionFactory.getFunction(name));
        }
        return functions;
    }

    public static List<GFunction> getCountFunctions() {
        ArrayList<GFunction> functions = new ArrayList<GFunction>();
        functions.add(FunctionFactory.getFunction("COUNT"));
        functions.add(FunctionFactory.getFunction("COUNT DISTINCT"));
        return functions;
    }

    public static boolean isCountFunction(String functionName) {
        return "COUNT".equals(functionName) || "COUNT DISTINCT".equals(functionName) || "NOOP".equals(functionName);
    }
}

