/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.exporter.util.variable;

import java.util.ArrayList;
import java.util.List;
import ro.nextreports.engine.exporter.util.variable.DateVariable;
import ro.nextreports.engine.exporter.util.variable.GroupRowVariable;
import ro.nextreports.engine.exporter.util.variable.PageNoVariable;
import ro.nextreports.engine.exporter.util.variable.ProductVariable;
import ro.nextreports.engine.exporter.util.variable.ReportNameVariable;
import ro.nextreports.engine.exporter.util.variable.RowVariable;
import ro.nextreports.engine.exporter.util.variable.TotalPageNoVariable;
import ro.nextreports.engine.exporter.util.variable.UserVariable;
import ro.nextreports.engine.exporter.util.variable.Variable;

public class VariableFactory {
    public static List<Variable> getVariables() {
        ArrayList<Variable> list = new ArrayList<Variable>();
        list.add(new DateVariable());
        list.add(new GroupRowVariable());
        list.add(new PageNoVariable());
        list.add(new TotalPageNoVariable());
        list.add(new ProductVariable());
        list.add(new ReportNameVariable());
        list.add(new RowVariable());
        list.add(new UserVariable());
        return list;
    }

    public static List<String> getVariableNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Variable var : VariableFactory.getVariables()) {
            names.add(var.getName());
        }
        return names;
    }

    public static Variable getVariable(String name) {
        for (Variable var : VariableFactory.getVariables()) {
            if (!var.getName().equals(name)) continue;
            return var;
        }
        throw new IllegalArgumentException("Unknown variable : " + name);
    }
}

