/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.i18n;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import ro.nextreports.engine.i18n.I18nString;

public class I18nLanguage
implements Serializable {
    private static final long serialVersionUID = 4565906365057455638L;
    private String name;
    private boolean isDefault;
    private List<I18nString> i18nStrings;

    public I18nLanguage(String name, boolean isDefault) {
        this.name = name;
        this.isDefault = isDefault;
        this.i18nStrings = new ArrayList<I18nString>();
    }

    public List<I18nString> getI18nStrings() {
        Collections.sort(this.i18nStrings, new Comparator<I18nString>(){

            @Override
            public int compare(I18nString o1, I18nString o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        return this.i18nStrings;
    }

    public void setI18nStrings(List<I18nString> i18nStrings) {
        this.i18nStrings = i18nStrings;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.i18nStrings == null ? 0 : this.i18nStrings.hashCode());
        result = 31 * result + (this.isDefault ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        I18nLanguage other = (I18nLanguage)obj;
        if (this.i18nStrings == null ? other.i18nStrings != null : !this.i18nStrings.equals(other.i18nStrings)) {
            return false;
        }
        if (this.isDefault != other.isDefault) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "I18nLanguage [name=" + this.name + ", isDefault=" + this.isDefault + ", i18nStrings=" + this.i18nStrings + "]";
    }
}

