/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.querybuilder.sql;

import java.io.ObjectStreamException;
import ro.nextreports.engine.querybuilder.sql.ExpressionColumn;
import ro.nextreports.engine.querybuilder.sql.GroupByFunctionColumn;
import ro.nextreports.engine.querybuilder.sql.Table;
import ro.nextreports.engine.querybuilder.sql.output.Output;
import ro.nextreports.engine.querybuilder.sql.output.Outputable;
import ro.nextreports.engine.querybuilder.sql.output.ToStringer;

public class Column
implements Outputable {
    private static final long serialVersionUID = -5015360894655058500L;
    protected Table table;
    protected String name;
    protected String alias;
    protected boolean output = true;
    private boolean fKey;
    private boolean pKey;
    private boolean iKey;
    protected transient String type;
    private transient boolean useTableName;

    public Column(Table table, String name, String type) {
        this.table = table;
        this.name = name;
        this.type = type;
        this.useTableName = true;
    }

    public Column(Table table, String name, String alias, String type) {
        this.table = table;
        this.name = name;
        this.alias = alias;
        this.type = type;
        this.useTableName = true;
    }

    public Table getTable() {
        return this.table;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getQualifiedName() {
        return this.getTable().getQualifiedName().concat(".").concat(this.getName());
    }

    public boolean isOutput() {
        return this.output;
    }

    public void setOutput(boolean output) {
        this.output = output;
    }

    public boolean isfKey() {
        return this.fKey;
    }

    public void setfKey(boolean fKey) {
        this.fKey = fKey;
    }

    public boolean isiKey() {
        return this.iKey;
    }

    public void setiKey(boolean iKey) {
        this.iKey = iKey;
    }

    public boolean ispKey() {
        return this.pKey;
    }

    public void setpKey(boolean pKey) {
        this.pKey = pKey;
    }

    public boolean isUseTableName() {
        return this.useTableName;
    }

    public void setUseTableName(boolean useTableName) {
        this.useTableName = useTableName;
    }

    @Override
    public void write(Output out) {
        if (this.isUseTableName() && this.getTable() != null) {
            out.print(this.getTable().getQualifiedName());
            out.print('.');
        }
        if (this.getName().contains(" ") && this.table.getDialect() != null) {
            out.print(this.table.getDialect().getEscapedKeyWord(this.getName()));
        } else {
            out.print(this.getName());
        }
    }

    public String toString() {
        return ToStringer.toString(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(this.getClass() == o.getClass() || this instanceof ExpressionColumn || o instanceof ExpressionColumn || this instanceof GroupByFunctionColumn || o instanceof GroupByFunctionColumn)) {
            return false;
        }
        Column column = (Column)o;
        if (this.name != null ? !this.name.equals(column.name) : column.name != null) {
            return false;
        }
        return !(this.table != null ? !this.table.equals(column.table) : column.table != null);
    }

    public int hashCode() {
        int result = this.table != null ? this.table.hashCode() : 0;
        result = 29 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    private Object readResolve() throws ObjectStreamException {
        this.useTableName = true;
        return this;
    }
}

