/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.querybuilder.sql;

import java.util.ArrayList;
import java.util.List;
import ro.nextreports.engine.querybuilder.sql.Column;
import ro.nextreports.engine.querybuilder.sql.ExpressionColumn;
import ro.nextreports.engine.querybuilder.sql.output.Output;

public class GroupByFunctionColumn
extends Column {
    public static final String MIN = "Min";
    public static final String MAX = "Max";
    public static final String AVG = "Avg";
    public static final String COUNT = "Count";
    public static final String SUM = "Sum";
    private static final List<String> allFunctions = new ArrayList<String>();
    private String function;
    private boolean expression = false;

    public GroupByFunctionColumn(Column column, String function) {
        super(column.getTable(), column.getName(), column.getAlias());
        if (column instanceof ExpressionColumn || column instanceof GroupByFunctionColumn && ((GroupByFunctionColumn)column).isExpression()) {
            this.expression = true;
        }
        this.setFunction(function);
    }

    public String getFunction() {
        return this.function;
    }

    public static List<String> getAllFunctions() {
        return allFunctions;
    }

    public static boolean existsFunction(String function) {
        return allFunctions.contains(function);
    }

    @Override
    public void write(Output out) {
        if (this.function == null) {
            super.write(out);
            return;
        }
        out.print(this.function);
        out.print('(');
        super.write(out);
        out.print(')');
    }

    private void setFunction(String function) {
        if (!GroupByFunctionColumn.existsFunction(function)) {
            throw new IllegalArgumentException("Function '" + function + "' is not supported");
        }
        this.function = function;
    }

    public boolean isExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        if (!this.isExpression()) {
            throw new IllegalArgumentException("Cannot set expression on a non-expression column!");
        }
        this.name = expression;
    }

    @Override
    public boolean equals(Object o) {
        boolean result = super.equals(o);
        if (!result) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GroupByFunctionColumn that = (GroupByFunctionColumn)o;
        return !(this.function != null ? !this.function.equals(that.function) : that.function != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.function != null ? this.function.hashCode() : 0);
        return result;
    }

    static {
        allFunctions.add(MIN);
        allFunctions.add(MAX);
        allFunctions.add(AVG);
        allFunctions.add(COUNT);
        allFunctions.add(SUM);
    }
}

