/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.querybuilder.sql;

import java.util.Collection;
import java.util.Iterator;
import ro.nextreports.engine.querybuilder.sql.Column;
import ro.nextreports.engine.querybuilder.sql.Criteria;
import ro.nextreports.engine.querybuilder.sql.SelectQuery;
import ro.nextreports.engine.querybuilder.sql.Table;
import ro.nextreports.engine.querybuilder.sql.output.Output;

public class InCriteria
extends Criteria {
    private static final long serialVersionUID = 2956464999031614266L;
    private Column column;
    private String value;
    private SelectQuery subSelect;

    public InCriteria(Column column, Collection values) {
        this.column = column;
        StringBuffer v = new StringBuffer();
        Iterator it = values.iterator();
        boolean hasNext = it.hasNext();
        while (hasNext) {
            Object curr = it.next();
            hasNext = it.hasNext();
            if (curr instanceof Number) {
                v.append(curr);
            } else {
                v.append(this.quote(curr.toString()));
            }
            if (!hasNext) continue;
            v.append(',');
        }
        this.value = v.toString();
    }

    public InCriteria(Column column, String[] values) {
        this.column = column;
        StringBuffer v = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            v.append(this.quote(values[i]));
            if (i >= values.length - 1) continue;
            v.append(',');
        }
        this.value = v.toString();
    }

    public InCriteria(Column column, int[] values) {
        this.column = column;
        StringBuffer v = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            v.append(values[i]);
            if (i >= values.length - 1) continue;
            v.append(',');
        }
        this.value = v.toString();
    }

    public InCriteria(Column column, float[] values) {
        this.column = column;
        StringBuffer v = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            v.append(values[i]);
            if (i >= values.length - 1) continue;
            v.append(',');
        }
        this.value = v.toString();
    }

    public InCriteria(Column column, SelectQuery subSelect) {
        this.column = column;
        this.subSelect = subSelect;
    }

    public InCriteria(Column column, String subSelect) {
        this.column = column;
        this.value = subSelect;
    }

    public InCriteria(Table table, String columnname, Collection values) {
        this(table.getColumn(columnname), values);
    }

    public InCriteria(Table table, String columnname, float[] values) {
        this(table.getColumn(columnname), values);
    }

    public InCriteria(Table table, String columnname, int[] values) {
        this(table.getColumn(columnname), values);
    }

    public InCriteria(Table table, String columnname, SelectQuery subSelect) {
        this(table.getColumn(columnname), subSelect);
    }

    public InCriteria(Table table, String columnname, String subSelect) {
        this(table.getColumn(columnname), subSelect);
    }

    public InCriteria(Table table, String columnname, String[] values) {
        this(table.getColumn(columnname), values);
    }

    public Column getColumn() {
        return this.column;
    }

    @Override
    public void write(Output out) {
        out.print(this.column);
        out.println(" IN (");
        out.indent();
        if (this.subSelect != null) {
            this.subSelect.write(out);
        } else {
            out.print(this.value);
        }
        out.unindent();
        out.println();
        out.print(")");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InCriteria that = (InCriteria)o;
        if (this.column != null ? !this.column.equals(that.column) : that.column != null) {
            return false;
        }
        if (this.subSelect != null ? !this.subSelect.equals(that.subSelect) : that.subSelect != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.column != null ? this.column.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.subSelect != null ? this.subSelect.hashCode() : 0);
        return result;
    }
}

