/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.querybuilder.sql;

import ro.nextreports.engine.querybuilder.sql.Column;
import ro.nextreports.engine.querybuilder.sql.Criteria;
import ro.nextreports.engine.querybuilder.sql.JoinType;
import ro.nextreports.engine.querybuilder.sql.Operator;
import ro.nextreports.engine.querybuilder.sql.output.Output;

public class JoinCriteria
extends Criteria {
    private static final long serialVersionUID = 2688061568992497650L;
    private Column source;
    private Column destination;
    private String operator;
    private String joinType;

    public JoinCriteria(Column source, Column destination) {
        this(source, destination, "INNER JOIN", "=");
    }

    public JoinCriteria(Column source, Column destination, String joinType) {
        this(source, destination, joinType, "=");
    }

    public JoinCriteria(Column source, Column destination, String joinType, String operator) {
        this.source = source;
        this.destination = destination;
        this.joinType = joinType;
        this.operator = operator;
    }

    public Column getSource() {
        return this.source;
    }

    public Column getDestination() {
        return this.destination;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        if (!Operator.validOperator(operator)) {
            throw new IllegalArgumentException("Invalid operator " + operator + "!");
        }
        this.operator = operator;
    }

    public String getJoinType() {
        return this.joinType;
    }

    public void setJoinType(String joinType) {
        if (!JoinType.validType(joinType)) {
            throw new IllegalArgumentException("Invalid join type " + joinType + "!");
        }
        this.joinType = joinType;
    }

    @Override
    public void write(Output out) {
        if (JoinType.isOuter(this.joinType)) {
            return;
        }
        out.print(this.source);
        out.print(" ").print(this.operator).print(" ");
        out.print(this.destination);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinCriteria that = (JoinCriteria)o;
        if (this.destination != null ? !this.destination.equals(that.destination) : that.destination != null) {
            return false;
        }
        if (this.joinType != null ? !this.joinType.equals(that.joinType) : that.joinType != null) {
            return false;
        }
        if (this.operator != null ? !this.operator.equals(that.operator) : that.operator != null) {
            return false;
        }
        return !(this.source != null ? !this.source.equals(that.source) : that.source != null);
    }

    public int hashCode() {
        int result = this.source != null ? this.source.hashCode() : 0;
        result = 31 * result + (this.destination != null ? this.destination.hashCode() : 0);
        result = 31 * result + (this.operator != null ? this.operator.hashCode() : 0);
        result = 31 * result + (this.joinType != null ? this.joinType.hashCode() : 0);
        return result;
    }
}

