/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.querybuilder.sql;

import java.util.ArrayList;
import java.util.List;
import ro.nextreports.engine.querybuilder.sql.Column;
import ro.nextreports.engine.querybuilder.sql.Criteria;
import ro.nextreports.engine.querybuilder.sql.Operator;
import ro.nextreports.engine.querybuilder.sql.Table;
import ro.nextreports.engine.querybuilder.sql.output.Output;

public class MatchCriteria
extends Criteria {
    private static final long serialVersionUID = -7884631436540725937L;
    public static final String EQUALS = "=";
    public static final String NOT_EQUALS = "<>";
    public static final String GREATER = ">";
    public static final String GREATER_EQUALS = ">=";
    public static final String LESS = "<";
    public static final String LESS_EQUALS = "<=";
    public static final String LIKE = "LIKE";
    public static final String NOT_LIKE = "NOT LIKE";
    public static final String BETWEEN = "BETWEEN";
    public static final String AND = "AND";
    public static final String IN = "IN";
    public static final String NOT_IN = "NOT IN";
    public static final String IS_NULL = "IS NULL";
    public static final String IS_NOT_NULL = "IS NOT NULL";
    public static final String SEPARATOR = ",";
    private static final List<String> allOperators = new ArrayList<String>();
    private Column column;
    private String value;
    private String value2;
    private String operator;
    private boolean parameter;
    private boolean parameter2;

    public MatchCriteria(Column column, String value) {
        this(column, EQUALS, value);
    }

    public MatchCriteria(Column column, String operator, float value) {
        this(column, operator, String.valueOf(value));
    }

    public MatchCriteria(Column column, String operator, float value, float value2) {
        this(column, operator, String.valueOf(value), String.valueOf(value2));
    }

    public MatchCriteria(Column column, String operator, int value) {
        this(column, operator, String.valueOf(value));
    }

    public MatchCriteria(Column column, String operator, int value, int value2) {
        this(column, operator, String.valueOf(value), String.valueOf(value2));
    }

    public MatchCriteria(Column column, String operator, boolean value) {
        this(column, operator, String.valueOf(value));
    }

    public MatchCriteria(Column column, String operator, boolean value, boolean value2) {
        this(column, operator, String.valueOf(value), String.valueOf(value2));
    }

    public MatchCriteria(Table table, String columnName, String operator, boolean value) {
        this(table.getColumn(columnName), operator, value);
    }

    public MatchCriteria(Table table, String columnName, String operator, boolean value, boolean value2) {
        this(table.getColumn(columnName), operator, value, value2);
    }

    public MatchCriteria(Table table, String columnName, String operator, int value) {
        this(table.getColumn(columnName), operator, value);
    }

    public MatchCriteria(Table table, String columnName, String operator, int value, int value2) {
        this(table.getColumn(columnName), operator, value, value2);
    }

    public MatchCriteria(Table table, String columnName, String operator, float value) {
        this(table.getColumn(columnName), operator, value);
    }

    public MatchCriteria(Table table, String columnName, String operator, float value, float value2) {
        this(table.getColumn(columnName), operator, value, value2);
    }

    public MatchCriteria(Table table, String columnName, String operator, String value) {
        this(table.getColumn(columnName), operator, value);
    }

    public MatchCriteria(Table table, String columnName, String operator, String value, String value2) {
        this(table.getColumn(columnName), operator, value, value2);
    }

    public MatchCriteria(Column column, String operator, String value) {
        this.column = column;
        this.value = value;
        this.setOperator(operator);
    }

    public MatchCriteria(Column column, String operator, String value, String value2) {
        this.column = column;
        this.value = value;
        this.value2 = value2;
        this.setOperator(operator);
    }

    public boolean isParameter() {
        return this.parameter;
    }

    public void setParameter(boolean parameter) {
        this.parameter = parameter;
    }

    public boolean isParameter2() {
        return this.parameter2;
    }

    public void setParameter2(boolean parameter2) {
        this.parameter2 = parameter2;
    }

    public Column getColumn() {
        return this.column;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        if (this.value != null && this.value.startsWith("(") && this.value.endsWith(")")) {
            this.value = this.value.substring(1, this.value.length() - 1);
        }
        return this.value;
    }

    public void setValue2(String value2) {
        this.value2 = value2;
    }

    public String getValue2() {
        if (this.value2 != null && this.value2.startsWith("(") && this.value2.endsWith(")")) {
            this.value2 = this.value2.substring(1, this.value2.length() - 1);
        }
        return this.value2;
    }

    public static List getAllOperators() {
        return allOperators;
    }

    public static boolean existsOperator(String operator) {
        return allOperators.contains(operator);
    }

    @Override
    public void write(Output out) {
        out.print(this.column).print(' ').print(this.operator).print(' ').print(this.getFullValue());
    }

    public void setOperator(String operator) {
        if (!MatchCriteria.existsOperator(operator)) {
            throw new IllegalArgumentException("Operator '" + operator + "' is not supported");
        }
        this.operator = operator;
    }

    public String getFullValue() {
        StringBuilder sb = new StringBuilder();
        if (!this.value.startsWith("${")) {
            if (LIKE.equals(this.operator) || NOT_LIKE.equals(this.operator)) {
                if (!this.value.startsWith("'")) {
                    sb.append("'");
                }
                sb.append(this.value);
                if (!this.value.endsWith("'")) {
                    sb.append("'");
                }
            } else if (IN.equals(this.operator) || NOT_IN.equals(this.operator)) {
                if (!this.value.startsWith("(")) {
                    sb.append("(");
                }
                String[] values = this.value.split(SEPARATOR);
                int size = values.length;
                for (int i = 0; i < size; ++i) {
                    if ("java.lang.String".equals(this.column.getType())) {
                        sb.append("'");
                    }
                    sb.append(values[i]);
                    if (i >= size - 1) continue;
                    if ("java.lang.String".equals(this.column.getType())) {
                        sb.append("'");
                    }
                    sb.append(SEPARATOR);
                }
                if ("java.lang.String".equals(this.column.getType())) {
                    sb.append("'");
                }
                if (!this.value.endsWith(")")) {
                    sb.append(")");
                }
            } else if (BETWEEN.equals(this.operator)) {
                sb.append(this.value);
                sb.append(" ");
                sb.append(AND);
                sb.append(" ");
                sb.append(this.value2);
            } else {
                sb.append(this.value);
            }
        } else if (BETWEEN.equals(this.operator)) {
            sb.append(this.value);
            sb.append(" ");
            sb.append(AND);
            sb.append(" ");
            sb.append(this.value2);
        } else {
            sb.append(this.value);
        }
        return sb.toString();
    }

    public static String[] getOperatorValue(String value) {
        String[] result = new String[3];
        for (String op : allOperators) {
            int index = value.indexOf(op);
            if (index != 0) continue;
            result[0] = op;
            if (!Operator.isDoubleValue(op)) {
                result[1] = value.substring(op.length() + 1);
                break;
            }
            int andIndex = value.indexOf(" AND");
            result[1] = value.substring(op.length() + 1, andIndex);
            result[2] = value.substring(andIndex + AND.length() + 2);
            break;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchCriteria that = (MatchCriteria)o;
        if (this.column != null ? !this.column.equals(that.column) : that.column != null) {
            return false;
        }
        return !(this.getFullValue() != null ? !this.getFullValue().equals(that.getFullValue()) : that.getFullValue() != null);
    }

    public int hashCode() {
        int result = this.column != null ? this.column.hashCode() : 0;
        result = 31 * result + (this.getFullValue() != null ? this.getFullValue().hashCode() : 0);
        return result;
    }

    static {
        allOperators.add(EQUALS);
        allOperators.add(NOT_EQUALS);
        allOperators.add(GREATER_EQUALS);
        allOperators.add(GREATER);
        allOperators.add(LESS_EQUALS);
        allOperators.add(LESS);
        allOperators.add(LIKE);
        allOperators.add(NOT_LIKE);
        allOperators.add(BETWEEN);
        allOperators.add(IN);
        allOperators.add(NOT_IN);
        allOperators.add(IS_NULL);
        allOperators.add(IS_NOT_NULL);
    }
}

