/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.querybuilder.sql;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ro.nextreports.engine.querybuilder.sql.Column;
import ro.nextreports.engine.querybuilder.sql.Criteria;
import ro.nextreports.engine.querybuilder.sql.ExpressionColumn;
import ro.nextreports.engine.querybuilder.sql.GroupByFunctionColumn;
import ro.nextreports.engine.querybuilder.sql.JoinCriteria;
import ro.nextreports.engine.querybuilder.sql.JoinType;
import ro.nextreports.engine.querybuilder.sql.MatchCriteria;
import ro.nextreports.engine.querybuilder.sql.Order;
import ro.nextreports.engine.querybuilder.sql.Table;
import ro.nextreports.engine.querybuilder.sql.dialect.Dialect;
import ro.nextreports.engine.querybuilder.sql.output.Output;
import ro.nextreports.engine.querybuilder.sql.output.Outputable;
import ro.nextreports.engine.querybuilder.sql.output.ToStringer;
import ro.nextreports.engine.querybuilder.sql.util.CollectionUtil;
import ro.nextreports.engine.util.xstream.XStreamable;

public class SelectQuery
implements Outputable,
XStreamable {
    private static final long serialVersionUID = -2137979893531895771L;
    private static OrderIndexComparator orderIndexComparator = new OrderIndexComparator();
    private boolean distinct;
    private List<Column> columns = new ArrayList<Column>();
    private List<Criteria> criterias = new ArrayList<Criteria>();
    private List<Order> orders;
    private List<Column> groupByColumns;
    private LinkedList<LinkedList<Criteria>> orCriterias;
    private transient Dialect dialect;

    public SelectQuery() {
        LinkedList firstOr = new LinkedList();
        this.orCriterias = new LinkedList();
        this.orCriterias.add(firstOr);
        this.orders = new ArrayList<Order>();
        this.groupByColumns = new ArrayList<Column>();
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public void addColumn(Column column) {
        this.columns.add(column);
    }

    public void addColumn(Column column, int index) {
        this.addColumn(column);
        this.moveColumn(column, index);
    }

    public void addColumn(Table table, String columname) {
        this.addColumn(table.getColumn(columname));
    }

    public List<Column> getColumns(Table table) {
        ArrayList<Column> result = new ArrayList<Column>();
        for (Column column : this.columns) {
            if (!column.getTable().equals(table)) continue;
            result.add(column);
        }
        return result;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<ExpressionColumn> getExpressionColumn() {
        ArrayList<ExpressionColumn> list = new ArrayList<ExpressionColumn>();
        for (Column column : this.columns) {
            if (!(column instanceof ExpressionColumn)) continue;
            list.add((ExpressionColumn)column);
        }
        return list;
    }

    public boolean removeColumn(Column column) {
        return this.columns.remove(column);
    }

    public boolean removeColumnAndDependencies(Column column) {
        this.removeMatchCriteria(column);
        this.removeOrMatchCriteria(column, 0);
        this.removeGroupByColumn(column);
        this.removeOrder(column);
        return this.columns.remove(column);
    }

    public void changeColumn(Column oldColumn, Column newColumn) {
        CollectionUtil.changeItem(this.columns, oldColumn, newColumn);
    }

    public void moveColumn(Column oldColumn, int newIndex) {
        CollectionUtil.moveItem(this.columns, oldColumn, newIndex);
    }

    public int getColumnIndex(Column column) {
        return this.columns.indexOf(column);
    }

    public List listColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public int getColumnsCount() {
        return this.columns.size();
    }

    public void addCriteria(Criteria criteria) {
        this.criterias.add(criteria);
    }

    public MatchCriteria getMatchCriteria(Column column) {
        for (Criteria criteria : this.criterias) {
            MatchCriteria mc;
            if (!(criteria instanceof MatchCriteria) || !(mc = (MatchCriteria)criteria).getColumn().equals(column)) continue;
            return mc;
        }
        return null;
    }

    public List<MatchCriteria> getParameterMatchCriterias() {
        ArrayList<MatchCriteria> result = new ArrayList<MatchCriteria>();
        for (Criteria criteria : this.criterias) {
            MatchCriteria mc;
            if (!(criteria instanceof MatchCriteria) || !(mc = (MatchCriteria)criteria).isParameter()) continue;
            result.add(mc);
        }
        return result;
    }

    public void updateParameterMatchCriterias(List<MatchCriteria> pmcList) {
        for (MatchCriteria mc : pmcList) {
            MatchCriteria oldmc = this.getMatchCriteria(mc.getColumn());
            if (oldmc != null && mc.isParameter()) {
                oldmc.setParameter(true);
            }
            if (oldmc == null || !mc.isParameter2()) continue;
            oldmc.setParameter2(true);
        }
    }

    public void removeMatchCriterias(String tableAlias) {
        for (Column column : this.columns) {
            Table table = column.getTable();
            if (table == null || !table.getAlias().equals(tableAlias)) continue;
            this.removeMatchCriteria(column);
        }
    }

    public void removeMatchCriteria(Column column) {
        MatchCriteria criteria = this.getMatchCriteria(column);
        if (criteria != null) {
            this.removeCriteria(criteria);
        }
    }

    public boolean removeCriteria(Criteria criteria) {
        return this.criterias.remove(criteria);
    }

    public LinkedList<Criteria> getOrList(int position) {
        if (this.orCriterias.size() == 0) {
            LinkedList<Criteria> or = new LinkedList<Criteria>();
            this.orCriterias.add(or);
            return or;
        }
        LinkedList<Criteria> or = this.orCriterias.get(position);
        if (or == null) {
            or = new LinkedList();
            this.orCriterias.add(position, or);
        }
        return or;
    }

    public void addOrCriteria(Criteria criteria, int position) {
        LinkedList<Criteria> or = this.getOrList(position);
        or.add(criteria);
    }

    public MatchCriteria getOrMatchCriteria(Column column, int position) {
        LinkedList<Criteria> or = this.getOrList(position);
        for (Criteria criteria : or) {
            MatchCriteria mc;
            if (!(criteria instanceof MatchCriteria) || !(mc = (MatchCriteria)criteria).getColumn().equals(column)) continue;
            return mc;
        }
        return null;
    }

    public List<MatchCriteria> getOrParameterMatchCriterias(int position) {
        LinkedList<Criteria> or = this.getOrList(position);
        ArrayList<MatchCriteria> result = new ArrayList<MatchCriteria>();
        for (Criteria criteria : or) {
            MatchCriteria mc;
            if (!(criteria instanceof MatchCriteria) || !(mc = (MatchCriteria)criteria).isParameter()) continue;
            result.add(mc);
        }
        return result;
    }

    public void updateOrParameterMatchCriterias(List<MatchCriteria> pmcList, int position) {
        for (MatchCriteria mc : pmcList) {
            MatchCriteria oldmc = this.getOrMatchCriteria(mc.getColumn(), position);
            if (oldmc != null && mc.isParameter()) {
                oldmc.setParameter(true);
            }
            if (oldmc == null || !mc.isParameter2()) continue;
            oldmc.setParameter2(true);
        }
    }

    public void removeOrMatchCriterias(String tableAlias, int position) {
        for (Column column : this.columns) {
            Table table = column.getTable();
            if (table == null || !table.getAlias().equals(tableAlias)) continue;
            this.removeOrMatchCriteria(column, position);
        }
    }

    public void removeOrMatchCriteria(Column column, int position) {
        MatchCriteria criteria = this.getOrMatchCriteria(column, position);
        if (criteria != null) {
            this.removeOrCriteria(criteria, position);
        }
    }

    public boolean removeOrCriteria(Criteria criteria, int position) {
        LinkedList<Criteria> or = this.getOrList(position);
        return or.remove(criteria);
    }

    public void clear() {
        this.columns.clear();
        this.criterias.clear();
        this.orCriterias.clear();
        this.orders.clear();
        this.groupByColumns.clear();
        this.distinct = false;
    }

    public boolean containsCriteria(Criteria criteria) {
        return this.criterias.contains(criteria);
    }

    public void changeCriteria(Criteria oldCriteria, Criteria newCriteria) {
        CollectionUtil.changeItem(this.criterias, oldCriteria, newCriteria);
    }

    public List listCriterias() {
        return Collections.unmodifiableList(this.criterias);
    }

    public int getCriteriasCount() {
        return this.criterias.size();
    }

    public List<JoinCriteria> getInnerJoins() {
        ArrayList<JoinCriteria> joins = new ArrayList<JoinCriteria>();
        for (Criteria criteria : this.criterias) {
            JoinCriteria jc;
            if (!(criteria instanceof JoinCriteria) || JoinType.isOuter((jc = (JoinCriteria)criteria).getJoinType())) continue;
            joins.add(jc);
        }
        return joins;
    }

    public List<JoinCriteria> getJoins() {
        ArrayList<JoinCriteria> joins = new ArrayList<JoinCriteria>();
        for (Criteria criteria : this.criterias) {
            if (!(criteria instanceof JoinCriteria)) continue;
            joins.add((JoinCriteria)criteria);
        }
        return joins;
    }

    public List<Criteria> getNotJoins() {
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        for (Criteria criteria : this.criterias) {
            if (criteria instanceof JoinCriteria) continue;
            list.add(criteria);
        }
        return list;
    }

    public void addJoin(JoinCriteria join) {
        this.addCriteria(join);
    }

    public JoinCriteria addJoin(Column srcColumn, Column destColumn) {
        JoinCriteria jc = new JoinCriteria(srcColumn, destColumn);
        this.addCriteria(jc);
        return jc;
    }

    public void addJoin(Table srcTable, String srcColumnName, Table destTable, String destColumnname) {
        this.addCriteria(new JoinCriteria(srcTable.getColumn(srcColumnName), destTable.getColumn(destColumnname)));
    }

    public void addOrder(Order order) {
        this.orders.add(order);
    }

    public void addOrder(Column column, boolean ascending) {
        this.addOrder(new Order(column, ascending));
    }

    public void addOrder(Table table, String columnName, boolean ascending) {
        this.addOrder(new Order(table.getColumn(columnName), ascending));
    }

    public boolean removeOrder(Order order) {
        return this.orders.remove(order);
    }

    public boolean removeOrder(Column column) {
        return this.orders.remove(this.getOrder(column));
    }

    public List<Order> listOrders() {
        return Collections.unmodifiableList(this.orders);
    }

    public List<Order> getOrders() {
        return this.orders;
    }

    public void setOrders(List<Order> orders) {
        this.orders = orders;
    }

    public int getOrdersCount() {
        return this.orders.size();
    }

    public Order getOrder(Column column) {
        for (Order order : this.orders) {
            if (!order.getColumn().equals(column)) continue;
            return order;
        }
        return null;
    }

    public void addGroupByColumn(Column column) {
        this.groupByColumns.add(column);
    }

    public void addGroupByColumn(Column column, int index) {
        int size = this.groupByColumns.size();
        if (index > size) {
            for (int i = size; i < index; ++i) {
                this.groupByColumns.add(i, null);
            }
        }
        this.groupByColumns.add(index, column);
    }

    public boolean removeGroupByColumn(Column column) {
        int index = this.getGroupByColumnIndex(column);
        if (index != -1) {
            this.groupByColumns.set(index, null);
        }
        return true;
    }

    private List<Column> getNotNullGroupByColumns() {
        ArrayList<Column> list = new ArrayList<Column>();
        for (Column col : this.groupByColumns) {
            if (col == null) continue;
            list.add(col);
        }
        return list;
    }

    private int getGroupByColumnIndex(Column column) {
        if (column instanceof GroupByFunctionColumn) {
            GroupByFunctionColumn fc = (GroupByFunctionColumn)column;
            int size = this.groupByColumns.size();
            for (int i = 0; i < size; ++i) {
                Column col = this.groupByColumns.get(i);
                Table table = null;
                if (col != null) {
                    table = col.getTable();
                }
                if (!(table == null ? col != null && col.getName().equals(fc.getName()) : col != null && table.equals(fc.getTable()) && col.getName().equals(fc.getName()))) continue;
                return i;
            }
        } else {
            int size = this.groupByColumns.size();
            for (int i = 0; i < size; ++i) {
                Column col = this.groupByColumns.get(i);
                if (col == null || !(col.getTable() == null ? col != null && col.getName().equals(column.getName()) : col != null && col.getTable().equals(column.getTable()) && col.getName().equals(column.getName()))) continue;
                return i;
            }
        }
        return -1;
    }

    public List<Column> getGroupByColumns() {
        return this.groupByColumns;
    }

    public boolean hasNotNullGroupByColumn() {
        for (Column col : this.groupByColumns) {
            if (col == null) continue;
            return true;
        }
        return false;
    }

    public void setGroupByColumns(List<Column> groupByColumns) {
        this.groupByColumns = groupByColumns;
    }

    public void removeGroupByColumns(String tableAlias) {
        for (Column column : this.columns) {
            int index;
            Table table = column.getTable();
            if (table == null || !table.getAlias().equals(tableAlias) || (index = this.getGroupByColumnIndex(column)) == -1) continue;
            this.groupByColumns.set(index, null);
        }
    }

    public boolean containsGroupByColumn(Column column) {
        return this.groupByColumns.contains(column);
    }

    public void removeAllGroupByColumns() {
        this.groupByColumns.clear();
    }

    public String toString() {
        return ToStringer.toString(this);
    }

    @Override
    public void write(Output out) {
        if (this.columns.size() == 0) {
            return;
        }
        if (this.distinct) {
            out.println("SELECT DISTINCT");
        } else {
            out.println("SELECT");
        }
        out.indent();
        this.appendList(out, this.getOutputColumns(this.columns), ",", true);
        out.println();
        out.unindent();
        out.println("FROM");
        out.indent();
        this.appendList(out, this.findAllUsedTablesInFrom(), ",", false);
        out.println();
        out.unindent();
        int orSize = 0;
        if (this.orCriterias != null) {
            orSize = this.orCriterias.get(0).size();
        }
        List<JoinCriteria> innerJoins = this.getInnerJoins();
        List<Criteria> notJoins = this.getNotJoins();
        if (innerJoins.size() > 0) {
            out.println("WHERE");
            out.indent();
            this.appendList(out, innerJoins, " AND ", false);
            if (notJoins.size() > 0) {
                if (innerJoins.size() > 0) {
                    out.print(" AND ");
                    if (orSize > 0) {
                        out.println("(");
                        out.indent();
                    } else {
                        out.println();
                    }
                }
                if (orSize > 0) {
                    out.print("(");
                }
                this.appendList(out, notJoins, " AND ", false);
                if (orSize > 0) {
                    out.println(")");
                } else {
                    out.unindent();
                }
            } else {
                out.println();
            }
        } else if (notJoins.size() > 0) {
            out.println("WHERE");
            out.indent();
            if (orSize > 0) {
                out.print("(");
            }
            this.appendList(out, notJoins, " AND ", false);
            if (orSize > 0) {
                out.println(")");
            } else {
                out.unindent();
            }
        }
        if (orSize > 0) {
            if (this.criterias.size() == 0) {
                out.println("WHERE");
                out.indent();
            }
            if (notJoins.size() > 0) {
                out.println(" OR ");
                out.print("(");
            } else if (innerJoins.size() > 0) {
                out.println(" AND ");
                out.print("(");
            }
            this.appendList(out, this.orCriterias.get(0), " AND ", false);
            if (notJoins.size() > 0 || innerJoins.size() > 0) {
                out.println(")");
            }
            if (this.criterias.size() == 0) {
                out.unindent();
            }
        }
        if (notJoins.size() > 0) {
            if (innerJoins.size() > 0) {
                if (orSize > 0) {
                    out.unindent();
                    out.println(")");
                } else {
                    out.println();
                }
            } else {
                out.println();
            }
        }
        if (this.criterias.size() > 0 && orSize > 0) {
            out.unindent();
        }
        if (this.groupByColumns.size() > 0) {
            out.println("GROUP BY");
            out.indent();
            this.appendList(out, this.getNotNullGroupByColumns(), ",", false);
            out.println();
            out.unindent();
        }
        if (this.orders.size() > 0) {
            out.println("ORDER BY");
            out.indent();
            this.appendList(out, this.sortOrders(this.orders), ",", false);
            out.println();
            out.unindent();
        }
    }

    private void appendList(Output out, Collection collection, String separator, boolean areColumns) {
        Iterator it = collection.iterator();
        boolean hasNext = it.hasNext();
        while (hasNext) {
            Column column;
            String columnAlias;
            Outputable sqlToken = (Outputable)it.next();
            hasNext = it.hasNext();
            sqlToken.write(out);
            if (areColumns && (columnAlias = (column = (Column)sqlToken).getAlias()) != null) {
                out.print(" AS ");
                out.print("\"");
                out.print(columnAlias);
                out.print("\"");
            }
            if (!hasNext) continue;
            out.print(separator);
            out.println();
        }
    }

    private List<Column> getOutputColumns(List<Column> columns) {
        ArrayList<Column> result = new ArrayList<Column>();
        for (Column column : columns) {
            if (!column.isOutput()) continue;
            result.add(column);
        }
        return result;
    }

    private List<Table> findAllUsedTablesInFrom() {
        Table table;
        Table destTable;
        Table sourceTable;
        JoinCriteria joinCriteria;
        ArrayList<Table> allTables = new ArrayList<Table>();
        HashMap<Table, ArrayList<JoinCriteria>> sourceMap = new HashMap<Table, ArrayList<JoinCriteria>>();
        HashMap<Table, List<JoinCriteria>> destMap = new HashMap<Table, List<JoinCriteria>>();
        for (Outputable criteria : this.criterias) {
            try {
                joinCriteria = (JoinCriteria)criteria;
                sourceTable = joinCriteria.getSource().getTable();
                destTable = joinCriteria.getDestination().getTable();
                ArrayList<JoinCriteria> sourceList = (ArrayList<JoinCriteria>)sourceMap.get(sourceTable);
                ArrayList<JoinCriteria> destList = (ArrayList<JoinCriteria>)sourceMap.get(destTable);
                if (sourceList == null) {
                    sourceList = new ArrayList<JoinCriteria>();
                    sourceMap.put(sourceTable, sourceList);
                }
                sourceList.add(joinCriteria);
                if (destList == null) {
                    destList = new ArrayList<JoinCriteria>();
                    destMap.put(destTable, destList);
                }
                destList.add(joinCriteria);
            }
            catch (ClassCastException ex) {}
        }
        for (Column column : this.columns) {
            table = column.getTable();
            if (table != null) {
                table.setDialect(this.dialect);
            }
            if (!this.canAddTableToFromClause(table, destMap, allTables)) continue;
            table.setJoins((List)sourceMap.get(table));
            allTables.add(table);
        }
        for (Outputable criteria : this.criterias) {
            try {
                joinCriteria = (JoinCriteria)criteria;
                sourceTable = joinCriteria.getSource().getTable();
                destTable = joinCriteria.getDestination().getTable();
                if (this.canAddTableToFromClause(sourceTable, destMap, allTables)) {
                    sourceTable.setJoins((List)sourceMap.get(sourceTable));
                    allTables.add(sourceTable);
                }
                if (!this.canAddTableToFromClause(destTable, destMap, allTables)) continue;
                destTable.setJoins((List)destMap.get(destTable));
                allTables.add(destTable);
            }
            catch (ClassCastException ex) {}
        }
        for (Order order : this.orders) {
            table = order.getColumn().getTable();
            if (table != null) {
                table.setDialect(this.dialect);
            }
            if (!this.canAddTableToFromClause(table, destMap, allTables)) continue;
            allTables.add(table);
        }
        return allTables;
    }

    private boolean canAddTableToFromClause(Table table, Map<Table, List<JoinCriteria>> destMap, List<Table> allTables) {
        if (table == null || allTables.contains(table)) {
            return false;
        }
        if (destMap.get(table) != null && destMap.get(table).size() > 0) {
            List<JoinCriteria> list = destMap.get(table);
            for (JoinCriteria jc : list) {
                if (!JoinType.isOuter(jc.getJoinType())) continue;
                return false;
            }
        }
        return true;
    }

    private List<Order> sortOrders(List<Order> orders) {
        ArrayList<Order> sortedOrders = new ArrayList<Order>(orders);
        Collections.sort(sortedOrders, orderIndexComparator);
        return sortedOrders;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectQuery that = (SelectQuery)o;
        if (this.distinct != that.distinct) {
            return false;
        }
        if (this.columns != null ? !this.columns.equals(that.columns) : that.columns != null) {
            return false;
        }
        if (!(this.criterias == null || that.criterias == null || this.criterias.containsAll(that.criterias) && that.criterias.containsAll(this.criterias))) {
            return false;
        }
        if (this.groupByColumns != null ? !this.groupByColumns.equals(that.groupByColumns) : that.groupByColumns != null) {
            return false;
        }
        if (this.orCriterias != null ? !this.orCriterias.equals(that.orCriterias) : that.orCriterias != null) {
            return false;
        }
        return !(this.orders != null ? !this.orders.equals(that.orders) : that.orders != null);
    }

    public int hashCode() {
        int result = this.distinct ? 1 : 0;
        result = 31 * result + (this.columns != null ? this.columns.hashCode() : 0);
        result = 31 * result + (this.criterias != null ? this.criterias.hashCode() : 0);
        result = 31 * result + (this.orders != null ? this.orders.hashCode() : 0);
        result = 31 * result + (this.groupByColumns != null ? this.groupByColumns.hashCode() : 0);
        result = 31 * result + (this.orCriterias != null ? this.orCriterias.hashCode() : 0);
        return result;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.orCriterias == null) {
            LinkedList firstOr = new LinkedList();
            this.orCriterias = new LinkedList();
            this.orCriterias.add(firstOr);
        }
        if (this.groupByColumns == null) {
            this.groupByColumns = new ArrayList<Column>();
        }
        return this;
    }

    static class OrderIndexComparator
    implements Comparator {
        OrderIndexComparator() {
        }

        public int compare(Object objectA, Object objectB) {
            int indexB;
            Order orderA = (Order)objectA;
            Order orderB = (Order)objectB;
            int indexA = orderA.getIndex();
            if (indexA < (indexB = orderB.getIndex())) {
                return -1;
            }
            if (indexA > indexB) {
                return 1;
            }
            return 0;
        }
    }
}

