/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.querybuilder.sql;

import java.util.List;
import ro.nextreports.engine.querybuilder.sql.Column;
import ro.nextreports.engine.querybuilder.sql.JoinCriteria;
import ro.nextreports.engine.querybuilder.sql.JoinType;
import ro.nextreports.engine.querybuilder.sql.dialect.Dialect;
import ro.nextreports.engine.querybuilder.sql.output.Output;
import ro.nextreports.engine.querybuilder.sql.output.Outputable;
import ro.nextreports.engine.querybuilder.sql.output.ToStringer;

public class Table
implements Outputable {
    private static final long serialVersionUID = -7427248594197786883L;
    private String name;
    private String alias;
    private String schemaName;
    private transient Dialect dialect;
    private transient List<JoinCriteria> joins;

    public Table(String name) {
        this.name = name;
    }

    public Table(String name, String alias) {
        this.name = name;
        this.alias = alias;
    }

    public String getName() {
        return this.name;
    }

    public String getEscapedName() {
        if (this.dialect != null && this.dialect.isKeyWord(this.name)) {
            return this.dialect.getEscapedKeyWord(this.name);
        }
        return this.getName();
    }

    public String getAlias() {
        return this.alias;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public Column getColumn(String columnName) {
        return new Column(this, columnName, null);
    }

    public String getQualifiedName() {
        return this.alias != null ? this.alias : this.name;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public void setJoins(List<JoinCriteria> joins) {
        this.joins = joins;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Table)) {
            return false;
        }
        return this.getQualifiedName().equals(((Table)o).getQualifiedName());
    }

    public int hashCode() {
        return this.getQualifiedName() != null ? this.getQualifiedName().hashCode() : 0;
    }

    @Override
    public void write(Output out) {
        if (this.schemaName != null && !"".equals(this.schemaName) && !"%".equals(this.schemaName)) {
            out.print(this.getSchemaName());
            out.print(".");
        }
        String name = this.getName();
        if (this.dialect != null && this.dialect.isKeyWord(name)) {
            out.print(this.dialect.getEscapedKeyWord(name));
        } else {
            boolean hasSpaces = name.contains(" ");
            if (hasSpaces) {
                out.print("\"");
            }
            out.print(name);
            if (hasSpaces) {
                out.print("\"");
            }
        }
        if (this.alias != null) {
            out.print(' ');
            out.print(this.getAlias());
        }
        if (this.joins != null) {
            int i = 0;
            boolean needUnindent = false;
            for (JoinCriteria jc : this.joins) {
                Table destTable = jc.getDestination().getTable();
                String joinType = jc.getJoinType();
                if (JoinType.isOuter(joinType)) {
                    out.println();
                    if (i == 0) {
                        out.indent();
                        needUnindent = true;
                    }
                    out.print(joinType);
                    out.print(' ');
                    destTable.write(out);
                    out.print(" ON (");
                    jc.getSource().write(out);
                    out.print(" ");
                    out.print(jc.getOperator());
                    out.print(" ");
                    jc.getDestination().write(out);
                    out.print(")");
                }
                ++i;
            }
            if (needUnindent) {
                out.unindent();
            }
        }
    }

    public String toString() {
        return ToStringer.toString(this);
    }
}

