/*
 * Decompiled with CFR 0.152.
 */
package ro.nextreports.engine.querybuilder.sql.dialect;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ro.nextreports.engine.querybuilder.sql.dialect.ColumnTypeMatcher;
import ro.nextreports.engine.querybuilder.sql.dialect.Dialect;
import ro.nextreports.engine.querybuilder.sql.dialect.DialectException;

public abstract class AbstractDialect
implements Dialect {
    protected static final Log LOG = LogFactory.getLog(AbstractDialect.class);
    private List<ColumnTypeMatcher> columnTypeMatchers = new ArrayList<ColumnTypeMatcher>();
    private Map<String, Integer> jdbcTypes = new HashMap<String, Integer>();
    private Map<Integer, String> javaTypes = new HashMap<Integer, String>();
    protected String[] keywords = new String[0];

    public AbstractDialect() {
        LOG.info((Object)("Using dialect: " + this));
        this.setKeywords();
        this.registerDefaultJavaTypes();
    }

    @Override
    public final int getJdbcType(String type, int precision, int scale) throws DialectException {
        if (type == null || "null".equals(type)) {
            return 1111;
        }
        List<ColumnTypeMatcher> typeMatchers = this.matchType(type, this.columnTypeMatchers);
        if (typeMatchers.size() == 0) {
            throw new DialectException("Cannot match the type '" + type + "' to a jdbc type");
        }
        if (typeMatchers.size() == 1) {
            return this.jdbcTypes.get(typeMatchers.get(0).getColumnType());
        }
        List<ColumnTypeMatcher> precisionMatchers = this.matchPrecision(precision, typeMatchers);
        if (precisionMatchers.size() == 0) {
            throw new DialectException("Cannot match the precision '" + precision + "' to a jdbc type");
        }
        if (precisionMatchers.size() == 1) {
            return this.jdbcTypes.get(precisionMatchers.get(0).getColumnType());
        }
        List<ColumnTypeMatcher> scaleMatchers = this.matchScale(scale, typeMatchers);
        if (scaleMatchers.size() == 0) {
            throw new DialectException("Cannot match the scale '" + scale + "' to a jdbc type");
        }
        if (scaleMatchers.size() == 1) {
            return this.jdbcTypes.get(scaleMatchers.get(0).getColumnType());
        }
        return this.jdbcTypes.get(this.chooseOne(scaleMatchers).getColumnType());
    }

    @Override
    public final String getJavaType(String type, int precision, int scale) throws DialectException {
        return this.javaTypes.get(this.getJdbcType(type, precision, scale));
    }

    protected void registerColumnType(String columnType, int jdbcType) {
        this.columnTypeMatchers.add(new ColumnTypeMatcher(columnType));
        this.jdbcTypes.put(columnType, jdbcType);
    }

    @Override
    public boolean hasProcedureWithCursor() {
        return false;
    }

    @Override
    public boolean schemaBeforeCatalog() {
        return true;
    }

    protected void registerDefaultJavaTypes() {
        this.registerJavaType(-7, Boolean.class.getName());
        this.registerJavaType(-6, Byte.class.getName());
        this.registerJavaType(5, Short.class.getName());
        this.registerJavaType(1, String.class.getName());
        this.registerJavaType(12, String.class.getName());
        this.registerJavaType(91, Date.class.getName());
        this.registerJavaType(92, Time.class.getName());
        this.registerJavaType(93, Timestamp.class.getName());
        this.registerJavaType(8, Double.class.getName());
        this.registerJavaType(6, Float.class.getName());
        this.registerJavaType(4, Integer.class.getName());
        this.registerJavaType(-5, BigInteger.class.getName());
        this.registerJavaType(2, BigDecimal.class.getName());
        this.registerJavaType(3, BigDecimal.class.getName());
        this.registerJavaType(-2, byte[].class.getName());
        this.registerJavaType(-3, byte[].class.getName());
        this.registerJavaType(2004, String.class.getName());
        this.registerJavaType(2005, String.class.getName());
        this.registerJavaType(7, String.class.getName());
        this.registerJavaType(1111, Object.class.getName());
    }

    protected void registerJavaType(int jdbcType, String javaType) {
        this.javaTypes.put(jdbcType, javaType);
    }

    protected List<ColumnTypeMatcher> matchType(String type, List<ColumnTypeMatcher> columnTypeMatchers) {
        ArrayList<ColumnTypeMatcher> typeMatchers = new ArrayList<ColumnTypeMatcher>();
        for (ColumnTypeMatcher matcher : columnTypeMatchers) {
            if (!matcher.matchType(type)) continue;
            typeMatchers.add(matcher);
        }
        return typeMatchers;
    }

    protected List<ColumnTypeMatcher> matchPrecision(int precision, List<ColumnTypeMatcher> columnTypeMatchers) {
        ArrayList<ColumnTypeMatcher> precisionMatchers = new ArrayList<ColumnTypeMatcher>();
        for (ColumnTypeMatcher matcher : columnTypeMatchers) {
            if (!matcher.matchPrecision(precision)) continue;
            precisionMatchers.add(matcher);
        }
        return precisionMatchers;
    }

    protected List<ColumnTypeMatcher> matchScale(int scale, List<ColumnTypeMatcher> columnTypeMatchers) {
        ArrayList<ColumnTypeMatcher> scaleMatchers = new ArrayList<ColumnTypeMatcher>();
        for (ColumnTypeMatcher matcher : columnTypeMatchers) {
            if (!matcher.matchScale(scale)) continue;
            scaleMatchers.add(matcher);
        }
        return scaleMatchers;
    }

    protected ColumnTypeMatcher chooseOne(List<ColumnTypeMatcher> columnTypeMatchers) {
        return columnTypeMatchers.get(0);
    }

    @Override
    public boolean isKeyWord(String word) {
        if (word == null) {
            return false;
        }
        String wordUpper = word.toUpperCase();
        for (String keyword : this.keywords) {
            if (!keyword.equals(wordUpper)) continue;
            return true;
        }
        return false;
    }

    protected void setKeywords() {
    }

    @Override
    public String getEscapedKeyWord(String keyword) {
        return keyword;
    }

    @Override
    public String getCurrentTimestamp() throws DialectException {
        return this.getCurrentDate();
    }

    @Override
    public String getCurrentTime() throws DialectException {
        return this.getCurrentDate();
    }

    @Override
    public boolean needsHoldCursorsForPreparedStatement() {
        return false;
    }
}

